/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.document;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.JspOptions;
import com.ibm.ws.jsp.configuration.JspConfiguration;
import com.ibm.ws.jsp.translator.document.Jsp2Dom;
import com.ibm.ws.jsp.translator.visitor.xml.ParserFactory;
import com.ibm.ws.util.WSUtil;
import com.ibm.wsspi.jsp.context.JspCoreContext;
import com.ibm.wsspi.jsp.resource.JspInputSource;
import com.ibm.wsspi.webcontainer.util.ThreadContextHelper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class JspDocumentParser
extends DefaultHandler
implements LexicalHandler {
    private static final String LEXICAL_HANDLER_PROPERTY = "http://xml.org/sax/properties/lexical-handler";
    private static final String DTD_FOUND_MESSAGE = "dtd has been found";
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.translator.document.JspDocumentParser";
    protected Locator locator;
    protected int textLineNum = 0;
    protected int textColNum = 0;
    protected int lastLineNum = 1;
    protected int lastColNum = 1;
    protected Document document = null;
    protected JspCoreContext ctxt = null;
    protected SAXParser saxParser = null;
    protected Stack elementStack = new Stack();
    protected Stack directoryStack = null;
    protected Stack dependencyStack = null;
    protected List dependencyList = null;
    protected Map cdataJspIdMap = null;
    protected Map implicitTagLibMap = null;
    protected HashMap tagPrefixes = new HashMap();
    protected JspConfiguration jspConfiguration = null;
    protected JspOptions jspOptions = null;
    protected JspInputSource inputSource = null;
    protected String resolvedRelativeURL = null;
    protected String encodedRelativeURL = null;
    protected String encoding = null;
    protected Stack charsBuffers = new Stack();
    protected boolean inDTD = false;
    protected List preRootCommentList = new ArrayList();
    protected boolean pageEncodingSpecified = false;
    protected String jspPrefix = "jsp";
    protected boolean isValidating = false;
    protected boolean isBomPresent = false;
    protected boolean isEncodingSpecifiedInProlog = false;
    protected String sourceEnc = null;

    public JspDocumentParser(JspInputSource inputSource, String resolvedRelativeURL, JspCoreContext ctxt, JspConfiguration jspConfiguration, JspOptions jspOptions, Stack directoryStack, Stack dependencyStack, List dependencyList, Map cdataJspIdMap, Map implicitTagLibMap, boolean isBomPresent, boolean isEncodingSpecifiedInProlog, String sourceEnc) throws JspCoreException {
        this.inputSource = inputSource;
        this.ctxt = ctxt;
        this.directoryStack = directoryStack;
        this.dependencyStack = dependencyStack;
        this.dependencyList = dependencyList;
        this.cdataJspIdMap = cdataJspIdMap;
        this.implicitTagLibMap = implicitTagLibMap;
        this.jspConfiguration = jspConfiguration;
        this.jspOptions = jspOptions;
        this.resolvedRelativeURL = resolvedRelativeURL;
        this.isBomPresent = isBomPresent;
        this.isEncodingSpecifiedInProlog = isEncodingSpecifiedInProlog;
        this.sourceEnc = sourceEnc;
        try {
            this.encodedRelativeURL = URLEncoder.encode(resolvedRelativeURL, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new JspCoreException(e);
        }
        if (this.implicitTagLibMap != null && this.implicitTagLibMap.size() > 0) {
            this.tagPrefixes.putAll(implicitTagLibMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document parse(InputSource is) throws JspCoreException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "parse(InputSource is)", "is =[" + is + "]");
        }
        try {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "parse(InputSource is)", "getting new document...");
            }
            this.document = ParserFactory.newDocument(false, false);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "parse(InputSource is)", "got new document: [" + this.document + "]");
            }
        }
        catch (ParserConfigurationException e) {
            throw new JspCoreException(e);
        }
        this.elementStack.push(this.document);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "parse(InputSource is)", "about to call parse(false,is), is: [" + is + "]");
        }
        if (this.parse(false, is)) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "parse(InputSource is)", "about to call parse(true,is)), is: [" + is + "]");
            }
            InputStream is2 = null;
            try {
                is2 = this.getInputStream(this.inputSource);
                InputSource inputSource = new InputSource(is2);
                this.parse(true, inputSource);
            }
            finally {
                if (is2 != null) {
                    try {
                        is2.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return this.document;
    }

    protected boolean parse(boolean validating, InputSource is) throws JspCoreException {
        boolean reparseWithValidation;
        block15: {
            this.isValidating = validating;
            reparseWithValidation = false;
            ClassLoader oldLoader = ThreadContextHelper.getContextClassLoader();
            ThreadContextHelper.setClassLoader(JspDocumentParser.class.getClassLoader());
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "(boolean validating, InputSource is)", " validating: [" + validating + "] is: [" + is + "]");
            }
            try {
                SAXParserFactory saxFactory = SAXParserFactory.newInstance();
                saxFactory.setNamespaceAware(true);
                saxFactory.setValidating(validating);
                saxFactory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
                this.saxParser = saxFactory.newSAXParser();
                XMLReader xmlReader = this.saxParser.getXMLReader();
                xmlReader.setProperty(LEXICAL_HANDLER_PROPERTY, this);
                xmlReader.setErrorHandler(this);
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "(boolean validating, InputSource is)", " about to call ParserFactory.parseDocument");
                }
                ParserFactory.parseDocument(this.saxParser, is, (DefaultHandler)this);
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "(boolean validating, InputSource is)", " back from ParserFactory.parseDocument");
                }
            }
            catch (ParserConfigurationException e) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "(boolean validating, InputSource is)", " caught ParserConfigurationException e: [" + e.getMessage() + "]");
                }
                throw new JspCoreException(e);
            }
            catch (SAXException e) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "(boolean validating, InputSource is)", " caught SAXException e: [" + e.getMessage() + "]");
                }
                if (e.getMessage().equals(DTD_FOUND_MESSAGE)) {
                    reparseWithValidation = true;
                    break block15;
                }
                if (e.getCause() != null) {
                    throw new JspCoreException(this.buildLineNumberMessage(e.getCause().getLocalizedMessage()));
                }
                throw new JspCoreException(this.buildLineNumberMessage(e.getLocalizedMessage()));
            }
            catch (IOException e) {
                throw new JspCoreException(this.buildLineNumberMessage(e.getLocalizedMessage()));
            }
            finally {
                ThreadContextHelper.setClassLoader(oldLoader);
            }
        }
        return reparseWithValidation;
    }

    private InputStream getInputStream(JspInputSource jspInputSource) throws JspCoreException {
        InputStream is = null;
        try {
            is = jspInputSource.getInputStream();
        }
        catch (IOException e) {
            String msg = JspCoreException.getMsg("jsp.error.failed.to.find.resource", new Object[]{jspInputSource.getRelativeURL()});
            throw new JspCoreException(msg, new FileNotFoundException(msg));
        }
        return is;
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "startElement", "uri =[" + uri + "]");
            logger.logp(Level.FINER, CLASS_NAME, "startElement", "localName =[" + localName + "]");
            logger.logp(Level.FINER, CLASS_NAME, "startElement", "qName =[" + qName + "]");
            logger.logp(Level.FINER, CLASS_NAME, "startElement", "attrs =[" + attrs + "]");
            logger.logp(Level.FINER, CLASS_NAME, "startElement", "encoding =[" + this.encoding + "]");
            logger.logp(Level.FINER, CLASS_NAME, "startElement", "jspConfiguration.getPageEncoding() =[" + this.jspConfiguration.getPageEncoding() + "]");
        }
        if (this.encoding == null && this.sourceEnc != null) {
            this.encoding = this.sourceEnc;
            if (this.jspConfiguration.getPageEncoding() != null && (this.isEncodingSpecifiedInProlog || this.isBomPresent)) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "startElement", "comparing encodings configuration: =[" + this.jspConfiguration.getPageEncoding() + "] returned encoding: [" + this.encoding + "]");
                }
                if (!this.compareEncoding(this.jspConfiguration.getPageEncoding(), this.encoding)) {
                    throw new SAXException(JspCoreException.getMsg("jsp.error.encoding.mismatch.config.xml", new Object[]{this.jspConfiguration.getPageEncoding(), this.encoding}));
                }
            }
        }
        if (localName.equals("directive.include") && uri.equals("http://java.sun.com/JSP/Page")) {
            try {
                String attrLocalName;
                String includePath = null;
                boolean seenIncludePath = false;
                if (attrs.getLength() > 0 && !(attrLocalName = attrs.getLocalName(0)).equals("")) {
                    if (!attrLocalName.equals("file")) {
                        throw new JspCoreException("jsp.error.include.directive.attribute.invalid", new Object[]{attrLocalName});
                    }
                    includePath = attrs.getValue("file");
                    seenIncludePath = true;
                }
                if (!seenIncludePath || includePath.equals("")) {
                    throw new JspCoreException("jsp.error.static.include.value.missing");
                }
                this.insertInclude(includePath);
            }
            catch (JspCoreException e) {
                throw new SAXException(e.getLocalizedMessage());
            }
        }
        Node parentNode = (Node)this.elementStack.peek();
        if (this.charsBuffers.size() > 0) {
            CharacterBuffer chars = (CharacterBuffer)this.charsBuffers.peek();
            this.createJspTextElement(parentNode, chars.charsBuffer);
            chars.charsBuffer.delete(0, chars.charsBuffer.length());
            chars.clearNonWhiteSpaceFound();
        }
        StringBuffer attrNames = new StringBuffer();
        Element jspElement = this.document.createElementNS(uri, qName);
        for (int i = 0; i < attrs.getLength(); ++i) {
            if (attrs.getQName(i).startsWith("xmlns")) {
                jspElement.setAttribute(attrs.getQName(i), attrs.getValue(i));
                if (attrs.getValue(i).equals("http://java.sun.com/JSP/Page")) {
                    this.jspPrefix = attrs.getQName(i).substring(attrs.getQName(i).indexOf("xmlns:") + 6);
                    continue;
                }
                String thisPrefix = attrs.getQName(i).substring(attrs.getQName(i).indexOf("xmlns:") + 6);
                if (thisPrefix.equals("")) continue;
                this.tagPrefixes.put(thisPrefix, attrs.getValue(i));
                continue;
            }
            jspElement.setAttributeNS(attrs.getURI(i), attrs.getQName(i), attrs.getValue(i));
            if (!attrs.getURI(i).equals("")) {
                attrNames.append(attrs.getURI(i) + ":" + attrs.getQName(i) + "~");
                continue;
            }
            attrNames.append(attrs.getQName(i) + "~");
        }
        String jspId = null;
        jspId = !uri.equals("http://java.sun.com/JSP/Page") && attrNames.length() > 0 ? "{" + attrNames.toString() + "}" + this.encodedRelativeURL + "[" + this.lastLineNum + "," + this.lastColNum + "," + (this.locator.getLineNumber() - (this.lastLineNum - 1)) + "]" : this.encodedRelativeURL + "[" + this.lastLineNum + "," + this.lastColNum + "," + (this.locator.getLineNumber() - (this.lastLineNum - 1)) + "]";
        jspElement.setAttributeNS("http://java.sun.com/JSP/Page", "jsp:id", jspId);
        if (uri.equals("http://java.sun.com/JSP/Page") && localName.equals("directive.page") && jspElement.hasAttribute("pageEncoding")) {
            if (!this.pageEncodingSpecified) {
                this.pageEncodingSpecified = true;
                if (this.jspConfiguration.getPageEncoding() != null) {
                    if (!this.compareEncoding(this.jspConfiguration.getPageEncoding(), this.encoding)) {
                        throw new SAXException(JspCoreException.getMsg("jsp.error.encoding.mismatch.config.xml", new Object[]{this.jspConfiguration.getPageEncoding(), this.encoding}));
                    }
                    if (!this.compareEncoding(this.jspConfiguration.getPageEncoding(), jspElement.getAttribute("pageEncoding"))) {
                        throw new SAXException(JspCoreException.getMsg("jsp.error.encoding.mismatch.config.pageencoding", new Object[]{this.jspConfiguration.getPageEncoding(), jspElement.getAttribute("pageEncoding")}));
                    }
                }
                if (!this.compareEncoding(jspElement.getAttribute("pageEncoding"), this.encoding)) {
                    throw new SAXException(JspCoreException.getMsg("jsp.error.encoding.mismatch.pageencoding.xml", new Object[]{jspElement.getAttribute("pageEncoding"), this.encoding}));
                }
                if (this.jspConfiguration.getPageEncoding() == null) {
                    this.jspConfiguration.setPageEncoding(this.encoding);
                }
            } else {
                throw new SAXException(JspCoreException.getMsg("jsp.error.page.pageencoding.dup", new Object[]{this.resolvedRelativeURL}));
            }
        }
        parentNode.appendChild(jspElement);
        this.elementStack.push(jspElement);
        if (parentNode instanceof Document) {
            for (Element commentElement : this.preRootCommentList) {
                jspElement.appendChild(commentElement);
            }
            if (this.jspConfiguration.getPreludeList().size() > 0) {
                try {
                    this.insertImplictIncludes(this.jspConfiguration.getPreludeList());
                }
                catch (JspCoreException e) {
                    throw new SAXException(e.getLocalizedMessage());
                }
            }
        }
        this.lastLineNum = this.locator.getLineNumber();
        this.lastColNum = this.locator.getColumnNumber();
        this.charsBuffers.push(new CharacterBuffer());
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        Element e;
        Node n = (Node)this.elementStack.peek();
        boolean keepWhitespace = false;
        if (n instanceof Element && (e = (Element)n).getNamespaceURI() != null && e.getNamespaceURI().equals("http://java.sun.com/JSP/Page") && e.getLocalName().equals("text")) {
            keepWhitespace = true;
        }
        StringBuffer characters = new StringBuffer();
        this.textLineNum = this.locator.getLineNumber();
        this.textColNum = this.locator.getColumnNumber();
        CharacterBuffer chars = (CharacterBuffer)this.charsBuffers.peek();
        for (int i = 0; i < length; ++i) {
            characters.append(ch[start + i]);
            if (ch[start + i] == '\n' || ch[start + i] == ' ' || ch[start + i] == '\r' || ch[start + i] == '\t') continue;
            chars.setNonWhiteSpaceFound();
        }
        if (chars.isNonWhiteSpaceFound() || keepWhitespace) {
            chars.charsBuffer.append(characters);
        }
        this.lastLineNum = this.locator.getLineNumber();
        this.lastColNum = this.locator.getColumnNumber();
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        Node node = null;
        CharacterBuffer chars = (CharacterBuffer)this.charsBuffers.pop();
        if (uri.equals("http://java.sun.com/JSP/Page")) {
            if (localName.equals("declaration") || localName.equals("expression") || localName.equals("scriptlet")) {
                String jspText = chars.charsBuffer.toString();
                CDATASection cdata = this.document.createCDATASection(jspText);
                node = (Node)this.elementStack.pop();
                node.appendChild(cdata);
            } else if (!localName.equals("directive.include")) {
                node = this.getJspElement();
                this.createJspTextElement(node, chars.charsBuffer);
            }
        } else {
            node = this.getJspElement();
            this.createJspTextElement(node, chars.charsBuffer);
        }
        if (node != null && node.getParentNode() instanceof Document) {
            this.elementStack.push(node);
            if (this.jspConfiguration.getCodaList().size() > 0) {
                try {
                    this.insertImplictIncludes(this.jspConfiguration.getCodaList());
                }
                catch (JspCoreException e) {
                    throw new SAXException(e.getLocalizedMessage());
                }
            }
            this.elementStack.pop();
        }
        this.lastLineNum = this.locator.getLineNumber();
        this.lastColNum = this.locator.getColumnNumber();
        chars = null;
    }

    public void createJspTextElement(Node node, StringBuffer chars) {
        String jspText = chars.toString();
        if (chars.length() > 0) {
            CDATASection cdata = this.document.createCDATASection(jspText);
            node.appendChild(cdata);
            String jspId = this.encodedRelativeURL + "[" + this.textLineNum + "," + this.textColNum + "," + this.getLineCount(jspText) + "]";
            this.cdataJspIdMap.put(new Integer(cdata.hashCode()), jspId);
        }
    }

    public Node getJspElement() {
        Node node = (Node)this.elementStack.pop();
        if (node.hasChildNodes()) {
            Element jspElement = (Element)node;
            String jspId = jspElement.getAttributeNS("http://java.sun.com/JSP/Page", "id");
            jspId = jspId + "[" + this.lastLineNum + "," + this.lastColNum + "]";
            jspElement.setAttributeNS("http://java.sun.com/JSP/Page", "jsp:id", jspId);
        }
        return node;
    }

    public void comment(char[] buf, int offset, int len) throws SAXException {
        if (!this.inDTD) {
            // empty if block
        }
        this.lastLineNum = this.locator.getLineNumber();
        this.lastColNum = this.locator.getColumnNumber();
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startCDATA() throws SAXException {
    }

    public void endCDATA() throws SAXException {
        CharacterBuffer chars = (CharacterBuffer)this.charsBuffers.peek();
        chars.clearNonWhiteSpaceFound();
    }

    public void startEntity(String name) throws SAXException {
    }

    public void endEntity(String name) throws SAXException {
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.inDTD = true;
        if (!this.isValidating) {
            throw new SAXException(DTD_FOUND_MESSAGE);
        }
    }

    public void endDTD() throws SAXException {
        this.inDTD = false;
    }

    public void fatalError(SAXParseException e) throws SAXException {
        throw e;
    }

    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    private void insertInclude(String includePath) throws JspCoreException {
        String fullPath;
        if (!includePath.startsWith("/")) {
            int lastLocation = this.resolvedRelativeURL.lastIndexOf("/");
            includePath = lastLocation > 0 ? WSUtil.resolveURI((String)(this.resolvedRelativeURL.substring(0, lastLocation + 1) + includePath)) : WSUtil.resolveURI((String)("/" + includePath));
        }
        if (this.dependencyStack.contains(fullPath = this.ctxt.getRealPath(includePath))) {
            throw new JspCoreException("jsp.error.static.include.circular.dependency", new Object[]{fullPath});
        }
        this.dependencyStack.push(fullPath);
        if (this.inputSource.getAbsoluteURL().getProtocol().equals("file")) {
            this.dependencyList.add(includePath);
        }
        JspConfiguration includeConfiguration = this.jspConfiguration.getConfigManager().getConfigurationForStaticInclude(includePath, this.jspConfiguration);
        JspInputSource includePathInputSource = this.ctxt.getJspInputSourceFactory().copyJspInputSource(this.inputSource, includePath);
        HashMap mergedTagLibMap = new HashMap(this.implicitTagLibMap);
        mergedTagLibMap.putAll(this.tagPrefixes);
        Jsp2Dom jsp2Dom = new Jsp2Dom(includePathInputSource, this.ctxt, this.directoryStack, includeConfiguration, this.jspOptions, this.dependencyStack, this.dependencyList, this.cdataJspIdMap, mergedTagLibMap, true);
        Document includeDocument = jsp2Dom.getJspDocument();
        Node parentNode = (Node)this.elementStack.peek();
        if (includeDocument.getDocumentElement().getNamespaceURI() != null && includeDocument.getDocumentElement().getNamespaceURI().equals("http://java.sun.com/JSP/Page") && includeDocument.getDocumentElement().getLocalName().equals("root")) {
            for (int i = 0; i < includeDocument.getDocumentElement().getChildNodes().getLength(); ++i) {
                Integer nodeHashCode;
                Node nodeToBeCopied = includeDocument.getDocumentElement().getChildNodes().item(i);
                Node n = this.document.importNode(nodeToBeCopied, true);
                if (nodeToBeCopied.getNodeType() == 4 && this.cdataJspIdMap.containsKey(nodeHashCode = new Integer(nodeToBeCopied.hashCode()))) {
                    String jspId = (String)this.cdataJspIdMap.remove(nodeHashCode);
                    this.cdataJspIdMap.put(new Integer(n.hashCode()), jspId);
                }
                parentNode.appendChild(n);
            }
        } else {
            for (int i = 0; i < includeDocument.getChildNodes().getLength(); ++i) {
                Node n = this.document.importNode(includeDocument.getChildNodes().item(i), true);
                parentNode.appendChild(n);
            }
        }
        this.dependencyStack.pop();
    }

    private int getLineCount(String s) {
        int lineCount = 1;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != '\n') continue;
            ++lineCount;
        }
        return lineCount;
    }

    private boolean compareEncoding(String enc1, String enc2) {
        boolean equal = false;
        if (enc1.equals(enc2)) {
            equal = true;
        } else if (enc1.startsWith("UTF-16") && enc2.startsWith("UTF-16")) {
            equal = true;
        }
        return equal;
    }

    public String buildLineNumberMessage(String msg) {
        msg = this.resolvedRelativeURL + "(" + this.lastLineNum + "," + this.lastColNum + ") " + msg;
        return msg;
    }

    private void insertImplictIncludes(ArrayList implicitIncludeList) throws JspCoreException {
        for (String includePath : implicitIncludeList) {
            this.insertInclude(includePath);
        }
    }

    private class CharacterBuffer {
        StringBuffer charsBuffer = new StringBuffer();
        private boolean nonWhiteSpaceFound = false;

        private CharacterBuffer() {
        }

        public boolean isNonWhiteSpaceFound() {
            return this.nonWhiteSpaceFound;
        }

        public void setNonWhiteSpaceFound() {
            this.nonWhiteSpaceFound = true;
        }

        public void clearNonWhiteSpaceFound() {
            this.nonWhiteSpaceFound = false;
        }
    }
}

