/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.tools;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.ModuleFile;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.DeployedObject;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.models.config.applicationserver.ApplicationServer;
import com.ibm.websphere.models.config.applicationserver.webcontainer.WebContainer;
import com.ibm.websphere.models.config.process.Component;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.variables.VariableMap;
import com.ibm.websphere.models.config.variables.VariableSubstitutionEntry;
import com.ibm.websphere.resource.WASResourceImpl;
import com.ibm.ws.classloader.CompoundClassLoader;
import com.ibm.ws.classloader.Handler;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jsp.tools.JspBatchCBase;
import com.ibm.ws.jsp.tools.JspFileUtils;
import com.ibm.ws.jsp.utils.TagLibraryCacheInformation;
import com.ibm.ws.runtime.service.ComponentManager;
import com.ibm.ws.runtime.service.ComponentManagerFactory;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.RepositoryFactory;
import com.ibm.ws.runtime.service.VariableMapFactory;
import com.ibm.ws.runtime.service.impl.BundleContextMap;
import com.ibm.wsspi.runtime.component.WsComponentImpl;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import com.ibm.wsspi.webcontainer.util.EncodingUtils;
import com.ibm.wsspi.webcontainer.util.ThreadContextHelper;
import java.beans.beancontext.BeanContextServiceProvider;
import java.beans.beancontext.BeanContextServicesSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ReopenException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.SaveFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseConfigRegister;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.url.URLStreamHandlerService;

public class JspBatchCompiler
extends JspBatchCBase {
    private boolean compileToWebInf = true;
    private Map variables = new HashMap();
    private ServerEntry serverEntry = null;
    private String configRoot = null;
    private String configRootHidden = null;
    private String cell = null;
    private String cellHidden = null;
    private String node = null;
    private String nodeHidden = null;
    private String process = null;
    private String enterpriseApp = null;
    private String wasInstallRoot = null;
    private String appInstallRoot = null;
    private String userInstallRoot = null;
    private String wasTempDirectory = null;
    private String logLevel = null;
    private CommonarchiveFactory impl = null;
    protected ApplicationServer applicationServer = null;
    private Server serverProcess = null;
    private ApplicationDeployment appDeployment = null;
    private String earPath = null;
    private String warPath = null;
    private String extractToDirectoryBase = null;
    private String extractToDirectoryComplete = null;
    private File extractToDir = null;
    private String compileToDirectory = null;
    private String responseFile = null;
    private boolean compileInPlace = false;
    private boolean listApps = false;
    private ArrayList<EnterpriseAppInfo> enterpriseApplicationInfo = null;
    private String configURL = null;
    private String binariesURL = null;
    static final int EARFILE_TYPE = 1;
    static final int WARFILE_TYPE = 2;
    private static final String VARIABLE_CONFIG = "variables.xml";
    private static final String SERVERINDEX = "serverindex.xml";
    private static final String LISTAPPS = "-listApps";
    private String looseAppURL = null;
    protected static final String LOOSE_CONFIG_PROPERTY_NAME = "was.loose.config";

    public JspBatchCompiler(String[] args) {
        this.cmdArgs = args;
        BundleContext bundleContext = BundleContextMap.instance().get(this.getClass().getClassLoader());
        try {
            ServiceReference[] srs = bundleContext.getServiceReferences(URLStreamHandlerService.class.getName(), "(url.handler.protocol=wsjar)");
            if (srs == null) {
                Hashtable<String, String[]> properties = new Hashtable<String, String[]>();
                properties.put("url.handler.protocol", new String[]{"wsjar"});
                bundleContext.registerService(URLStreamHandlerService.class.getName(), (Object)new Handler(), properties);
            }
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
    }

    public boolean startup() {
        if (!this.parseCmdLine(this.cmdArgs)) {
            this.usage();
            return false;
        }
        if (this.initialize() > 0) {
            return false;
        }
        if (this.earPath != null) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.INFO)) {
                logger.logp(Level.INFO, "JspBatchCompiler", "startup", "about to run JspBatchCompiler for " + this.earPath);
            }
            if (this.runEarCompiler() > 0) {
                this.returnCode = 1;
            }
        } else if (this.warPath != null) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.INFO)) {
                logger.logp(Level.INFO, "JspBatchCompiler", "startup", "about to run JspBatchCompiler for " + this.warPath);
            }
            if (this.runWarCompiler() > 0) {
                this.returnCode = 1;
            }
        } else if (this.enterpriseApp != null) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.INFO)) {
                if (!this.listApps) {
                    logger.logp(Level.INFO, "JspBatchCompiler", "startup", "about to run JspBatchCompiler for " + this.enterpriseApp);
                } else {
                    logger.logp(Level.INFO, "JspBatchCompiler", "startup", "about to run JspBatchCompiler to list all deployed applications and their webmodules.");
                }
            }
            try {
                if (this.runBatchCompiler() > 0) {
                    this.returnCode = 1;
                }
            }
            catch (ComponentDisabledException e) {
                e.printStackTrace();
                this.returnCode = 1;
            }
        }
        if (this.returnCode == 0) {
            logger.logp(Level.CONFIG, "JspBatchCompiler", "startup", "jsp.batchcompiler.successfully.exiting");
        } else {
            logger.logp(Level.CONFIG, "JspBatchCompiler", "startup", "jsp.batchcompiler.exiting.with.errors");
        }
        return this.returnCode == 0;
    }

    protected int initialize() {
        int slashIndex;
        if (super.initialize() > 0) {
            this.returnCode = 1;
            return this.returnCode;
        }
        if (this.warPath != null || this.earPath != null) {
            this.impl = CommonarchiveFactoryImpl.getActiveFactory();
            if (this.extractToDirectoryBase == null) {
                this.compileInPlace = true;
                this.extractToDirectoryBase = System.getProperty("java.io.tmpdir");
            }
        } else if (this.enterpriseApp != null && (slashIndex = this.enterpriseApp.lastIndexOf(".ear/")) > 1) {
            this.enterpriseApp = this.enterpriseApp.substring(0, slashIndex);
        }
        return this.returnCode;
    }

    private int runBatchCompiler() throws ComponentDisabledException {
        boolean errors = false;
        logger.logp(Level.CONFIG, "JspBatchCompiler", "runBatchCompiler", "jsp.batchcompiler.initializing.server");
        BeanContextServiceProvider repository2 = (BeanContextServiceProvider)RepositoryFactory.createRepository((String)"ws-server", (String)this.configRoot, (String)this.cell, (String)this.node, (String)this.process);
        logger.logp(Level.FINER, "JspBatchCompiler", "runBatchCompiler", "repository: " + repository2);
        BeanContextServicesSupport bc = new BeanContextServicesSupport();
        logger.logp(Level.FINER, "JspBatchCompiler", "runBatchCompiler", "BeanContextServices: " + bc);
        bc.addService(Repository.class, repository2);
        logger.logp(Level.FINER, "JspBatchCompiler", "runBatchCompiler", "added repository service ");
        com.ibm.ws.runtime.service.VariableMap variableMap = VariableMapFactory.createVariableMap();
        bc.add(variableMap);
        try {
            variableMap.initialize((Object)bc);
        }
        catch (ComponentDisabledException e) {
            logger.logp(Level.SEVERE, "JspBatchCompiler", "runBatchCompiler", "jsp.batchcompiler.exception.caught.while.initializing.batchcompiler.service", e);
            errors = true;
        }
        catch (ConfigurationWarning e) {
            logger.logp(Level.SEVERE, "JspBatchCompiler", "runBatchCompiler", "jsp.batchcompiler.exception.caught.while.initializing.batchcompiler.service", e);
        }
        catch (ConfigurationError e) {
            logger.logp(Level.SEVERE, "JspBatchCompiler", "runBatchCompiler", "jsp.batchcompiler.exception.caught.while.initializing.batchcompiler.service", e);
            errors = true;
        }
        logger.logp(Level.FINER, "JspBatchCompiler", "runBatchCompiler", "added variableMap service ");
        this.readConfig((Repository)repository2);
        this.getApplicationServer((Repository)repository2);
        this.getWebContainer();
        logger.logp(Level.FINER, "JspBatchCompiler", "runBatchCompiler", "read config " + this.serverProcess);
        if (!errors && this.serverProcess != null) {
            ComponentManager cm = null;
            try {
                cm = ComponentManagerFactory.createComponentManager((String)"META-INF/ws-server-components.xml", (ClassLoader)ThreadContextHelper.getContextClassLoader());
                bc.addService(ComponentManager.class, (BeanContextServiceProvider)cm);
                logger.logp(Level.FINER, "JspBatchCompiler", "runBatchCompiler", "added componentmanager " + cm);
            }
            catch (ConfigurationError ce) {
                logger.logp(Level.SEVERE, "JspBatchCompiler", "runBatchCompiler", "jsp.batchcompiler.exception.caught.while.adding.componentmanager.service", ce);
                errors = true;
            }
            if (cm != null) {
                bc.add(this.serverProcess);
                logger.logp(Level.FINER, "JspBatchCompiler", "runBatchCompiler", "added o " + this.serverProcess);
                bc.add(this);
                logger.logp(Level.FINER, "JspBatchCompiler", "runBatchCompiler", "added batchC component ");
                logger.logp(Level.FINER, "JspBatchCompiler", "runBatchCompiler", "about to initialize batchC component ");
                this.initialize();
                logger.logp(Level.FINER, "JspBatchCompiler", "runBatchCompiler", "about to run JspBatchCompiler ");
                if (this.batchCompile() > 0) {
                    errors = true;
                }
            }
        } else {
            errors = true;
            logger.logp(Level.SEVERE, "JspBatchCompiler", "runBatchCompiler", "jsp.batchcompiler.unable.to.initialize.server");
        }
        if (errors) {
            this.returnCode = 1;
        }
        return this.returnCode;
    }

    private int runEarCompiler() {
        if (this.returnCode == 1) {
            return this.returnCode;
        }
        if (this.extractArchiveFile(this.earPath, this.earFile, 1) > 0) {
            this.returnCode = 1;
            return this.returnCode;
        }
        try {
            this.earFile = this.impl.openEARFile(this.extractToDirectoryComplete);
        }
        catch (OpenFailureException e) {
            logger.logp(Level.SEVERE, "JspBatchCompiler", "runEarCompiler", "jsp.batchcompiler.exception.caught.opening.earfile", e);
            this.returnCode = 1;
            return this.returnCode;
        }
        try {
            this.warFileList = this.earFile.getWARFiles();
            if (this.warFileList != null && this.warFileList.size() <= 0 && TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.CONFIG)) {
                logger.logp(Level.CONFIG, "JspBatchCompiler", "runEarCompiler", "No web modules found for EAR File " + this.earFile.getName());
            }
        }
        catch (Throwable throwable) {
            logger.logp(Level.SEVERE, "JspBatchCompiler", "runEarCompiler", "jsp.batchcompiler.exception.caught.getting.warfile.list", throwable);
            this.returnCode = 1;
            return this.returnCode;
        }
        this.getClassLoaderManager(null, null, false);
        this.warFileCount = 0;
        if (!this.compileAllWebModules) {
            this.warFileCount = 1;
        } else if (this.warFileList != null) {
            this.warFileCount = this.warFileList.size();
        }
        boolean foundWarFile = false;
        for (int i = 0; i < this.warFileCount; ++i) {
            foundWarFile = !this.compileAllWebModules ? this.getWarFile() : this.getWarFile(i);
            if (!foundWarFile) {
                logger.logp(Level.SEVERE, "JspBatchCompiler", "runEarCompiler", "jsp.batchcompiler.webmodule.not.found", this.webModuleName);
                this.returnCode = 1;
                continue;
            }
            if (!this.getClassLoader()) {
                this.returnCode = 1;
                continue;
            }
            this.webModuleURL = this.extractToDirectoryComplete + File.separator + this.webModuleName;
            int retCode = this.getConfigOptions();
            if (retCode > 0) {
                this.returnCode = retCode;
                continue;
            }
            this.tempDirectory = this.compileToDirectory != null ? this.compileToDirectory : this.webModuleURL + File.separator + "WEB-INF" + File.separator + "classes";
            this.displayVariables();
            retCode = this.compile(null);
            if (retCode <= 0) continue;
            this.returnCode = retCode;
        }
        if (this.earFile != null && this.earFile.isOpen()) {
            this.earFile.close();
        }
        if (this.returnCode == 0) {
            File tmpFile = new File(this.earPath);
            if (this.compileToDirectory == null && (tmpFile.isFile() || tmpFile.isDirectory() && !this.compileInPlace) && this.zipArchiveFile(this.earFile, 1) > 0) {
                this.returnCode = 1;
            }
        }
        return this.returnCode;
    }

    private int runWarCompiler() {
        if (this.returnCode == 1) {
            return this.returnCode;
        }
        if (this.extractArchiveFile(this.warPath, this.warFile, 2) > 0) {
            this.returnCode = 1;
            return this.returnCode;
        }
        try {
            this.warFile = this.impl.openWARFile(this.extractToDirectoryComplete);
        }
        catch (OpenFailureException e) {
            logger.logp(Level.SEVERE, "JspBatchCompiler", "runWarCompiler", "jsp.batchcompiler.exception.caught.opening.warfile", e);
            this.returnCode = 1;
            return this.returnCode;
        }
        this.webModuleURL = this.extractToDirectoryComplete;
        int retCode = this.getConfigOptions();
        if (retCode > 0) {
            this.returnCode = retCode;
        } else {
            this.tempDirectory = this.compileToDirectory != null ? this.compileToDirectory : this.webModuleURL + File.separator + "WEB-INF" + File.separator + "classes";
            this.displayVariables();
            retCode = this.compile(null);
            if (retCode > 0) {
                this.returnCode = retCode;
            }
            if (this.warFile != null && this.warFile.isOpen()) {
                this.warFile.close();
            }
            if (this.returnCode == 0) {
                File tmpFile = new File(this.warPath);
                if (this.compileToDirectory == null && (tmpFile.isFile() || tmpFile.isDirectory() && !this.compileInPlace) && this.zipArchiveFile(this.warFile, 2) > 0) {
                    this.returnCode = 1;
                }
            }
        }
        return this.returnCode;
    }

    protected int extractArchiveFile(String filePath, ModuleFile inFile, int fileType) {
        boolean exceptionCaught = false;
        Exception excep = null;
        try {
            File tmpFile = new File(filePath);
            if (!tmpFile.exists()) {
                if (fileType == 1) {
                    logger.logp(Level.SEVERE, "JspBatchCompiler", "extractArchiveFile", "jsp.batchcompiler.ear.path.does.not.exist", filePath);
                } else {
                    logger.logp(Level.SEVERE, "JspBatchCompiler", "extractArchiveFile", "jsp.batchcompiler.war.path.does.not.exist", filePath);
                }
                this.returnCode = 1;
                return this.returnCode;
            }
            inFile = fileType == 1 ? this.impl.openEARFile(filePath) : this.impl.openWARFile(filePath);
            File tmpBase = new File(this.extractToDirectoryBase);
            if (tmpBase.getCanonicalPath().startsWith(tmpFile.getCanonicalPath()) || tmpFile.getCanonicalPath().startsWith(tmpBase.getCanonicalPath())) {
                if (fileType == 1) {
                    logger.logp(Level.SEVERE, "JspBatchCompiler", "extractArchiveFile", "jsp.batchcompiler.extracttodir.must.not.overlap.with.ear.path");
                } else {
                    logger.logp(Level.SEVERE, "JspBatchCompiler", "extractArchiveFile", "jsp.batchcompiler.extracttodir.must.not.overlap.with.war.path");
                }
                this.returnCode = 1;
                return this.returnCode;
            }
            if (tmpFile.isDirectory() && this.compileInPlace) {
                this.extractToDirectoryBase = filePath;
                this.extractToDirectoryComplete = filePath;
            } else {
                this.extractToDirectoryComplete = !this.extractToDirectoryBase.endsWith(File.separator) ? this.extractToDirectoryBase + this.fileSep + inFile.getName() : this.extractToDirectoryBase + inFile.getName();
            }
            this.extractToDir = new File(this.extractToDirectoryBase);
            if (!this.extractToDir.exists()) {
                this.returnCode = 1;
                logger.logp(Level.SEVERE, "JspBatchCompiler", "extractArchiveFile", "jsp.batchcompiler.extracttodir.does.not.exist", this.extractToDir);
                return this.returnCode;
            }
            if (!this.extractToDir.canWrite()) {
                this.returnCode = 1;
                logger.logp(Level.SEVERE, "JspBatchCompiler", "extractArchiveFile", "jsp.batchcompiler.extracttodir.not.writable", this.extractToDir);
                return this.returnCode;
            }
            if (!this.extractToDir.isDirectory()) {
                this.returnCode = 1;
                logger.logp(Level.SEVERE, "JspBatchCompiler", "extractArchiveFile", "jsp.batchcompiler.extracttodir.not.a.directory", this.extractToDir);
                return this.returnCode;
            }
            this.extractToDir = new File(this.extractToDirectoryComplete);
            if (tmpFile.isFile() || tmpFile.isDirectory() && !this.compileInPlace) {
                if (this.extractToDir.exists()) {
                    logger.logp(Level.CONFIG, "JspBatchCompiler", "extractArchiveFile", "jsp.batchcompiler.removing.file", this.extractToDir);
                    if (this.extractToDir.isFile()) {
                        this.extractToDir.delete();
                    } else if (this.extractToDir.isDirectory()) {
                        JspFileUtils.deleteDirs(this.extractToDir, logger);
                    }
                }
                logger.logp(Level.CONFIG, "JspBatchCompiler", "extractArchiveFile", "jsp.batchcompiler.extracting", new Object[]{inFile.getName(), this.extractToDirectoryComplete});
                inFile.extractTo(this.extractToDirectoryComplete, 2);
                logger.logp(Level.CONFIG, "JspBatchCompiler", "extractArchiveFile", "jsp.batchcompiler.done.extracting");
            }
            inFile.close();
        }
        catch (OpenFailureException e) {
            exceptionCaught = true;
            excep = e;
        }
        catch (SaveFailureException e) {
            exceptionCaught = true;
            excep = e;
        }
        catch (IOException e) {
            exceptionCaught = true;
            excep = e;
        }
        if (exceptionCaught) {
            this.returnCode = 1;
            if (fileType == 1) {
                logger.logp(Level.SEVERE, "JspBatchCompiler", "extractArchiveFile", "jsp.batchcompiler.exception.caught.extracting.earfile", filePath);
                logger.logp(Level.SEVERE, "JspBatchCompiler", "extractArchiveFile", "exception:", excep);
            } else {
                logger.logp(Level.SEVERE, "JspBatchCompiler", "extractArchiveFile", "jsp.batchcompiler.exception.caught.extracting.warfile", filePath);
                logger.logp(Level.SEVERE, "JspBatchCompiler", "extractArchiveFile", "exception: ", excep);
            }
        }
        return this.returnCode;
    }

    protected int zipArchiveFile(ModuleFile inFile, int fileType) {
        boolean exceptionCaught = false;
        Exception excep = null;
        try {
            inFile = fileType == 1 ? this.impl.openEARFile(this.extractToDirectoryComplete) : this.impl.openWARFile(this.extractToDirectoryComplete);
            logger.logp(Level.CONFIG, "JspBatchCompiler", "zipArchiveFile", "jsp.batchcompiler.saving.zipfile", inFile.getAbsolutePath());
            inFile.save();
            inFile.close();
            logger.logp(Level.CONFIG, "JspBatchCompiler", "zipArchiveFile", "jsp.batchcompiler.done.saving");
        }
        catch (OpenFailureException e) {
            exceptionCaught = true;
            excep = e;
        }
        catch (ReopenException e) {
            exceptionCaught = true;
            excep = e;
        }
        catch (SaveFailureException e) {
            exceptionCaught = true;
            excep = e;
        }
        catch (FileNotFoundException e) {
            exceptionCaught = true;
            excep = e;
        }
        if (exceptionCaught) {
            this.returnCode = 1;
            logger.logp(Level.SEVERE, "JspBatchCompiler", "zipArchiveFile", "jsp.batchcompiler.exception.while.saving", excep);
        }
        return this.returnCode;
    }

    private int batchCompile() {
        Repository repository2;
        block35: {
            repository2 = (Repository)this.getService(Repository.class);
            if (repository2 == null) {
                logger.logp(Level.SEVERE, "JspBatchCompiler", "batchCompile", "jsp.batchcompiler.repository.not.available");
                this.returnCode = 1;
                return this.returnCode;
            }
            logger.logp(Level.CONFIG, "JspBatchCompiler", "batchCompile", "jsp.batchcompiler.reading.configfile");
            if (!this.addVarMaps(repository2)) {
                this.returnCode = 1;
                return this.returnCode;
            }
            if (!this.findServer(repository2)) {
                this.returnCode = 1;
                return this.returnCode;
            }
            if (this.findEnterpriseApp(repository2)) {
                try {
                    if (!this.listApps) {
                        this.earFile = (EARFile)this.getEarFile(this.binariesURL, this.looseAppURL);
                        this.warFileList = this.earFile.getWARFiles();
                        if (this.warFileList != null && this.warFileList.size() <= 0 && TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.CONFIG)) {
                            logger.logp(Level.CONFIG, "JspBatchCompiler", "batchCompile", "No web modules found for Enterprise Application " + this.enterpriseApp);
                        }
                        break block35;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.CONFIG)) {
                        logger.logp(Level.CONFIG, "JspBatchCompiler", "batchCompile", "Deployed Enterprise Applications and their Web Modules:");
                    }
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, "JspBatchCompiler", "batchCompile", "# of apps: " + this.enterpriseApplicationInfo.size());
                    }
                    for (EnterpriseAppInfo eai : this.enterpriseApplicationInfo) {
                        List wfl;
                        EARFile ef = (EARFile)this.getEarFile(eai.getBinariesURL(), eai.getLooseAppURL());
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.CONFIG)) {
                            logger.logp(Level.CONFIG, "JspBatchCompiler", "batchCompile", "   " + eai.getName());
                        }
                        if ((wfl = ef.getWARFiles()) != null && wfl.size() <= 0) {
                            if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.CONFIG)) continue;
                            logger.logp(Level.CONFIG, "JspBatchCompiler", "batchCompile", "      No web modules found for Enterprise Application " + eai.getName());
                            continue;
                        }
                        int warFileCount = wfl.size();
                        for (int j = 0; j < warFileCount; ++j) {
                            boolean foundWarFile = this.getWarFile(j, wfl);
                            if (!foundWarFile || !TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.CONFIG)) continue;
                            logger.logp(Level.CONFIG, "JspBatchCompiler", "batchCompile", "      " + this.warFile.getURI());
                        }
                    }
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.CONFIG)) {
                        logger.logp(Level.CONFIG, "JspBatchCompiler", "batchCompile", "   ");
                    }
                    this.warFile = null;
                    this.webModuleName = null;
                    this.warfileListIndex = -1;
                    return this.returnCode;
                }
                catch (Throwable throwable) {
                    logger.logp(Level.SEVERE, "JspBatchCompiler", "batchCompile", "jsp.batchcompiler.enterpriseapp.not.found", this.enterpriseApp);
                    this.returnCode = 1;
                }
            } else {
                logger.logp(Level.SEVERE, "JspBatchCompiler", "batchCompile", "jsp.batchcompiler.enterpriseapp.not.found", this.enterpriseApp);
                this.returnCode = 1;
            }
        }
        if (this.returnCode == 1) {
            return this.returnCode;
        }
        logger.logp(Level.FINE, "JspBatchCompiler", "batchCompile", "about to call getClassLoaderManager  this.appDeployment: [" + this.appDeployment + "]");
        this.getClassLoaderManager(this.appDeployment, this.applicationServer, true);
        this.warFileCount = 0;
        if (!this.compileAllWebModules) {
            this.warFileCount = 1;
        } else if (this.warFileList != null) {
            this.warFileCount = this.warFileList.size();
        }
        logger.logp(Level.CONFIG, "JspBatchCompiler", "batchCompile", "jsp.batchcompiler.finished.reading.configfile");
        this.tagLibConfigArray = TagLibraryCacheInformation.loadTagLibraryCacheInfo();
        boolean foundWarFile = false;
        logger.logp(Level.FINE, "JspBatchCompiler", "batchCompile", "about to call getLibraryPaths with appDeployment: [" + this.appDeployment + "]");
        Map<String, Map<String, ?>> libraries = this.getLibraryPaths(this.appDeployment);
        Map<String, ?> libraryPaths = libraries.get("pathsMap");
        Map<String, ?> isolatedSharedLibraryPaths = libraries.get("libraryClassloaders");
        logger.logp(Level.FINE, "JspBatchCompiler", "batchCompile", "about to call getServerLibraryPaths with applicationServer: [" + this.applicationServer + "]");
        ArrayList serverLibraryPaths = this.getServerLibraryPaths(this.applicationServer);
        for (int i = 0; i < this.warFileCount; ++i) {
            foundWarFile = !this.compileAllWebModules ? this.getWarFile() : this.getWarFile(i);
            if (!foundWarFile) {
                logger.logp(Level.SEVERE, "JspBatchCompiler", "batchCompile", "jsp.batchcompiler.webmodule.not.found", this.webModuleName);
                this.returnCode = 1;
                continue;
            }
            if (!this.getClassLoader()) {
                this.returnCode = 1;
                continue;
            }
            ModuleFile moduleFile = (ModuleFile)this.warFileList.get(this.warfileListIndex);
            try {
                this.webModuleURL = moduleFile.getAbsolutePath();
                this.webModuleConfigURL = this.looseAppURL == null ? this.configURL + File.separator + this.webModuleName : moduleFile.getBinariesPath();
            }
            catch (FileNotFoundException fex) {
                fex.printStackTrace();
            }
            this.tempDirectory = this.wasTempDirectory;
            this.tempDirectory = this.tempDirectory + File.separator + this.node + File.separator + this.process.replace(' ', '_') + File.separator + this.enterpriseApp.replace(' ', '_') + File.separator + this.webModuleName.replace(' ', '_');
            int retCode = this.getConfigOptions();
            if (retCode > 0) {
                this.returnCode = retCode;
                continue;
            }
            if (this.compileToWebInf) {
                this.tempDirectory = this.webModuleURL + File.separator + "WEB-INF" + File.separator + "classes";
            } else if (this.compileToDirectory != null) {
                this.tempDirectory = this.compileToDirectory;
            }
            this.displayVariables();
            ArrayList<String> l = new ArrayList<String>();
            CompoundClassLoader[] isolatedsharedLibraries = (CompoundClassLoader[])isolatedSharedLibraryPaths.get(this.warFile.getURI());
            if (isolatedsharedLibraries != null) {
                logger.logp(Level.FINE, "JspBatchCompiler", "batchCompile", "about to process isolatedsharedLibraries: [" + isolatedsharedLibraries + "] isolatedsharedLibraries.length [" + isolatedsharedLibraries.length + "]");
                for (int j = 0; j < isolatedsharedLibraries.length; ++j) {
                    logger.logp(Level.FINE, "JspBatchCompiler", "batchCompile", "isolatedsharedLibraries[j] [" + isolatedsharedLibraries[j] + "]");
                    StringTokenizer paths = new StringTokenizer(isolatedsharedLibraries[j].getClassPath(), File.pathSeparator);
                    while (paths.hasMoreTokens()) {
                        String path = paths.nextToken();
                        if (!path.endsWith(".jar")) continue;
                        l.add(path);
                        logger.logp(Level.FINE, "JspBatchCompiler", "batchCompile", "added isolatedsharedLibraries paths [" + path + "]");
                    }
                }
            }
            Iterator iterator = serverLibraryPaths.iterator();
            logger.logp(Level.FINE, "JspBatchCompiler", "batchCompile", "about to process serverLibraryPaths: [" + serverLibraryPaths + "] serverLibraryPaths.size() [" + serverLibraryPaths.size() + "]");
            while (iterator.hasNext()) {
                String[] serverLib = (String[])iterator.next();
                logger.logp(Level.FINE, "JspBatchCompiler", "batchCompile", "serverLib [" + serverLib + "] serverLib.length [" + serverLib.length + "]");
                for (int j = 0; j < serverLib.length; ++j) {
                    logger.logp(Level.FINE, "JspBatchCompiler", "batchCompile", "serverLib[j] [" + serverLib[j] + "]");
                    if (!serverLib[j].endsWith(".jar")) continue;
                    l.add(serverLib[j]);
                    logger.logp(Level.FINE, "JspBatchCompiler", "batchCompile", "added serverLib[j]");
                }
            }
            String[] sharedLibraries = (String[])libraryPaths.get(this.warFile.getURI());
            logger.logp(Level.FINE, "JspBatchCompiler", "batchCompile", "about to process sharedLibraries: [" + sharedLibraries + "] sharedLibraries.length [" + sharedLibraries.length + "]");
            for (int j = 0; j < sharedLibraries.length; ++j) {
                logger.logp(Level.FINE, "JspBatchCompiler", "batchCompile", "sharedLibraries[j] [" + sharedLibraries[j] + "]");
                if (!sharedLibraries[j].endsWith(".jar")) continue;
                l.add(sharedLibraries[j]);
                logger.logp(Level.FINE, "JspBatchCompiler", "batchCompile", "added sharedLibraries[j] " + sharedLibraries[j] + "]");
            }
            logger.logp(Level.FINE, "JspBatchCompiler", "batchCompile", "l.size: [" + l.size() + "]");
            String[] sharedLibraryJars = new String[l.size()];
            sharedLibraryJars = l.toArray(sharedLibraryJars);
            logger.logp(Level.FINE, "JspBatchCompiler", "batchCompile", "sharedLibraryJars.length: [" + sharedLibraryJars.length + "]");
            retCode = this.compile(sharedLibraryJars);
            if (retCode <= 0) continue;
            this.returnCode = retCode;
        }
        this.releaseService(repository2);
        return this.returnCode;
    }

    protected void getApplicationServer(Repository repository2) throws ComponentDisabledException {
        this.applicationServer = null;
        ConfigRoot cfgRoot = repository2.getConfigRoot();
        WASResourceImpl resource = null;
        try {
            resource = (WASResourceImpl)cfgRoot.getResource(4, "server.xml");
        }
        catch (Exception e) {
            throw new ComponentDisabledException();
        }
        EList contents = resource.getContents();
        for (Object contentObject2 : contents) {
            if (!(contentObject2 instanceof Server)) continue;
            EList components = ((Server)contentObject2).getComponents();
            for (Object contentObject2 : components) {
                if (!(contentObject2 instanceof ApplicationServer)) continue;
                logger.logp(Level.FINE, "JspBatchCompiler", "getApplicationServer", "found ApplicationServer: [" + (ApplicationServer)contentObject2 + "]");
                this.applicationServer = (ApplicationServer)contentObject2;
            }
        }
    }

    protected void getWebContainer() {
        if (this.applicationServer != null) {
            EList components = this.applicationServer.getComponents();
            Iterator componentsIter = components.iterator();
            Component webConConfig = null;
            while (componentsIter.hasNext() && webConConfig == null) {
                Object contentObject = componentsIter.next();
                logger.logp(Level.FINE, "JspBatchCompiler", "getWebContainer", "found object: [" + contentObject + "]");
                if (!(contentObject instanceof WebContainer)) continue;
                webConConfig = (WebContainer)contentObject;
                logger.logp(Level.FINE, "JspBatchCompiler", "getWebContainer", "found WebContainer: [" + webConConfig + "]");
            }
            if (webConConfig != null) {
                for (Property p : webConConfig.getProperties()) {
                    this.webConProperties.put(p.getName().toLowerCase(), p.getValue());
                    logger.logp(Level.FINE, "JspBatchCompiler", "getWebContainer", "found webcon property: [" + p.getName().toLowerCase() + "] value: [" + p.getValue() + "]");
                }
            }
        }
    }

    protected void readConfig(Repository repository2) {
        try {
            Resource res = repository2.getConfigRoot().getResource(4, "server.xml");
            EList resContents = res.getContents();
            this.serverProcess = null;
            for (int i = 0; this.serverProcess == null && i < resContents.size(); ++i) {
                Object o = resContents.get(i);
                if (!(o instanceof Server)) continue;
                this.serverProcess = (Server)o;
                logger.logp(Level.SEVERE, "JspBatchCompiler", "readConfig", "serverProcess: [" + this.serverProcess + "]");
            }
            if (this.serverProcess == null) {
                logger.logp(Level.SEVERE, "JspBatchCompiler", "readConfig", "jsp.batchcompiler.rootdomain.not.found");
            }
        }
        catch (Throwable t) {
            logger.logp(Level.SEVERE, "JspBatchCompiler", "readConfig", "jsp.batchcompiler.error.reading.configuration", new Object[]{t.getClass().getName(), t.getMessage()});
        }
    }

    protected boolean addVarMaps(Repository repository2) {
        ConfigRoot cRoot = repository2.getConfigRoot();
        try {
            this.addVariableMap(cRoot.getResource(0, VARIABLE_CONFIG));
            this.addVariableMap(cRoot.getResource(3, VARIABLE_CONFIG));
        }
        catch (Exception e) {
            logger.logp(Level.WARNING, "JspBatchCompiler", "addVarMaps", "jsp.batchcompiler.error.adding.variable.map", new Object[]{e.getMessage()});
        }
        if (this.wasInstallRoot == null || this.appInstallRoot == null || this.userInstallRoot == null || this.wasTempDirectory == null) {
            return false;
        }
        this.wasInstallRoot = this.expandVariable(this.wasInstallRoot);
        this.appInstallRoot = this.expandVariable(this.appInstallRoot);
        this.userInstallRoot = this.expandVariable(this.userInstallRoot);
        this.wasTempDirectory = this.expandVariable(this.wasTempDirectory);
        return true;
    }

    protected void addVariableMap(Resource r) {
        EList extent = r.getContents();
        for (int i = 0; i < extent.size(); ++i) {
            VariableMap varMap = (VariableMap)extent.get(i);
            EList varMapEntries = varMap.getEntries();
            for (int j = 0; j < varMapEntries.size(); ++j) {
                VariableSubstitutionEntry vse = (VariableSubstitutionEntry)varMapEntries.get(j);
                this.variables.put(vse.getSymbolicName(), vse.getValue());
                if (vse.getSymbolicName().equals("WAS_INSTALL_ROOT")) {
                    this.wasInstallRoot = vse.getValue();
                }
                if (vse.getSymbolicName().equals("APP_INSTALL_ROOT")) {
                    this.appInstallRoot = vse.getValue();
                }
                if (vse.getSymbolicName().equals("USER_INSTALL_ROOT")) {
                    this.userInstallRoot = vse.getValue();
                }
                if (!vse.getSymbolicName().equals("WAS_TEMP_DIR")) continue;
                this.wasTempDirectory = vse.getValue();
            }
        }
    }

    protected boolean findServer(Repository repository2) {
        boolean serverFound = false;
        try {
            Resource r;
            try {
                r = repository2.getConfigRoot().getResource(3, SERVERINDEX);
            }
            catch (Exception e) {
                throw new ConfigurationError("Error loading serverindex.xml", e);
            }
            EList list = ((ServerIndex)r.getContents().get(0)).getServerEntries();
            for (int i = 0; i < list.size(); ++i) {
                this.serverEntry = (ServerEntry)list.get(i);
                if (!this.serverEntry.getServerName().equals(this.process)) continue;
                serverFound = true;
                break;
            }
        }
        catch (Throwable t) {
            logger.logp(Level.SEVERE, "JspBatchCompiler", "findServer", "jsp.batchcompiler.error.while.finding.server", t);
            return false;
        }
        return serverFound;
    }

    protected boolean findEnterpriseApp(Repository repository2) {
        boolean enterpriseAppFound = false;
        if (this.listApps) {
            this.enterpriseApplicationInfo = new ArrayList();
        }
        try {
            ConfigRoot cRoot = repository2.getConfigRoot();
            EList apps = this.serverEntry.getDeployedApplications();
            Resource r = null;
            for (int j = 0; j < apps.size(); ++j) {
                cRoot.setValue(1, (String)apps.get(j));
                r = cRoot.getResource(1, "deployment.xml");
                String tempName = (String)apps.get(j);
                if (tempName == null) continue;
                int slashIndex = tempName.lastIndexOf(".ear/");
                if (slashIndex > 1) {
                    tempName = tempName.substring(0, slashIndex);
                }
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.INFO) && !this.listApps) {
                    logger.logp(Level.INFO, "JspBatchCompiler", "findEnterpriseApp", "Found Enterprise Application [" + tempName + "]");
                }
                this.appDeployment = null;
                this.binariesURL = null;
                this.looseAppURL = null;
                this.metadataFromBinaries = false;
                this.configURL = null;
                if (!tempName.equals(this.enterpriseApp) && !this.listApps) continue;
                Deployment deployment = (Deployment)r.getContents().get(0);
                DeployedObject dobj = deployment.getDeployedObject();
                if (dobj instanceof ApplicationDeployment) {
                    this.appDeployment = (ApplicationDeployment)dobj;
                }
                if (this.appDeployment == null) continue;
                this.binariesURL = this.appDeployment.getBinariesURL();
                this.binariesURL = this.expandVariable(this.binariesURL);
                this.looseAppURL = this.getLooseAppURL(this.appDeployment);
                if (this.looseAppURL != null) {
                    this.looseAppURL = this.expandVariable(this.looseAppURL);
                }
                this.metadataFromBinaries = this.appDeployment.isUseMetadataFromBinaries();
                this.configURL = cRoot.getAbsolutePath(1, "");
                this.configURL = this.expandVariable(this.configURL);
                enterpriseAppFound = true;
                if (this.listApps) {
                    this.enterpriseApplicationInfo.add(new EnterpriseAppInfo(this.binariesURL, this.looseAppURL, this.configURL, tempName));
                    continue;
                }
                break;
            }
        }
        catch (Throwable t) {
            logger.logp(Level.SEVERE, "JspBatchCompiler", "findEnterpriseApp", "jsp.batchcompiler.error.while.finding.enterpriseapp", t);
            return false;
        }
        return enterpriseAppFound;
    }

    protected String getLooseAppURL(ApplicationDeployment deployment) {
        EList useProperties = deployment.getProperties();
        Iterator propertyIterator = useProperties.iterator();
        String useURL = null;
        while (useURL == null && propertyIterator.hasNext()) {
            Property nextProperty = (Property)propertyIterator.next();
            String nextPropertyName = nextProperty.getName();
            if (nextPropertyName == null || !nextPropertyName.equals(LOOSE_CONFIG_PROPERTY_NAME)) continue;
            useURL = nextProperty.getValue();
        }
        return useURL;
    }

    protected ModuleFile getEarFile(String archive, String looseArchive) throws Throwable {
        if (looseArchive != null) {
            LooseConfigRegister.singleton().addLooseMapping(archive, looseArchive);
        }
        CommonarchiveFactory archiveFactory = (CommonarchiveFactory)EPackage.Registry.INSTANCE.getEPackage("http:///com/ibm/etools/commonarchive.ecore").getEFactoryInstance();
        ArchiveOptions archiveOptions = new ArchiveOptions();
        archiveOptions.setIsReadOnly(true);
        archiveOptions.setUseJavaReflection(false);
        this.earFile = archiveFactory.openEARFile(archiveOptions, archive);
        this.earFile.getDeploymentDescriptor();
        this.earFile.getBindings();
        this.earFile.getExtensions();
        return this.earFile;
    }

    protected int getConfigOptions() {
        int retCode = super.getConfigOptions();
        if (retCode > 0) {
            this.returnCode = retCode;
            return this.returnCode;
        }
        if (this.options.getOutputDir() != null) {
            if (this.warPath != null || this.earPath != null) {
                logger.logp(Level.CONFIG, "JspBatchCompiler", "getConfigOptions", "jsp.batchcompiler.ignoring.scratchdir", this.options.getOutputDir().toString());
            } else {
                this.tempDirectory = this.options.getOutputDir().toString();
                this.tempDirectory = this.tempDirectory + File.separator + this.node + File.separator + this.process.replace(' ', '_') + File.separator + this.enterpriseApp.replace(' ', '_') + File.separator + this.webModuleName.replace(' ', '_');
            }
        }
        if (this.removeTempDir) {
            this.tempDirToRemove = this.tempDirectory;
        }
        return 0;
    }

    public static void main(String[] args) {
        JspBatchCompiler batchc = new JspBatchCompiler(args);
        if (batchc.startup()) {
            System.exit(0);
        } else {
            System.exit(1);
        }
    }

    private boolean parseCmdLine(String[] args) {
        String localCompilerOptions = null;
        try {
            String key;
            Properties overrides = new Properties();
            String value = null;
            for (int i = 0; i < args.length; ++i) {
                int j;
                key = args[i].toLowerCase();
                if (key.equalsIgnoreCase("-jspcompileclasspath") && ((j = i) + 1 >= args.length || j + 1 < args.length && args[j + 1].startsWith("-"))) {
                    value = new String("");
                    overrides.setProperty(key, value);
                    continue;
                }
                if (++i >= args.length) continue;
                value = args[i];
                overrides.setProperty(key, value);
            }
            this.responseFile = overrides.getProperty("-response.file");
            if (this.responseFile != null) {
                Properties prop = new Properties();
                prop.load(new FileInputStream(this.responseFile));
                Enumeration<?> propNames = prop.propertyNames();
                Properties fromFile = new Properties();
                while (propNames.hasMoreElements()) {
                    key = (String)propNames.nextElement();
                    value = prop.getProperty(key);
                    key = key.toLowerCase();
                    fromFile.setProperty(key, value);
                }
                if (!overrides.isEmpty()) {
                    fromFile.putAll((Map<?, ?>)overrides);
                }
                overrides = fromFile;
            }
            value = null;
            key = null;
            Enumeration<?> enumer = overrides.propertyNames();
            while (enumer.hasMoreElements()) {
                key = (String)enumer.nextElement();
                value = overrides.getProperty(key).trim();
                if (!key.equalsIgnoreCase("-jspcompileclasspath") && value.equals("") || key.equals("-response.file")) continue;
                if ("-ear.path".equalsIgnoreCase(key)) {
                    this.earPath = value;
                    continue;
                }
                if ("-war.path".equalsIgnoreCase(key)) {
                    this.warPath = value;
                    continue;
                }
                if ("-enterpriseapp.name".equalsIgnoreCase(key)) {
                    this.enterpriseApp = value;
                    continue;
                }
                if ("-webmodule.name".equalsIgnoreCase(key)) {
                    this.webModuleName = value;
                    continue;
                }
                if ("-profileName".equals(key)) continue;
                if ("-filename".equalsIgnoreCase(key)) {
                    this.filename = value;
                    continue;
                }
                if ("-config.root".equalsIgnoreCase(key)) {
                    this.configRoot = value;
                    continue;
                }
                if ("-cell.name".equalsIgnoreCase(key)) {
                    this.cell = value;
                    continue;
                }
                if ("-node.name".equalsIgnoreCase(key)) {
                    this.node = value;
                    continue;
                }
                if ("-config.root.hidden".equalsIgnoreCase(key)) {
                    this.configRootHidden = value;
                    continue;
                }
                if ("-cell.name.hidden".equalsIgnoreCase(key)) {
                    this.cellHidden = value;
                    continue;
                }
                if ("-node.name.hidden".equalsIgnoreCase(key)) {
                    this.nodeHidden = value;
                    continue;
                }
                if ("-server.name".equalsIgnoreCase(key)) {
                    this.process = value;
                    continue;
                }
                if ("-translate".equalsIgnoreCase(key)) {
                    this.translateJsps = "true".equalsIgnoreCase(value);
                    continue;
                }
                if ("-compile".equalsIgnoreCase(key)) {
                    this.compileJsps = "true".equalsIgnoreCase(value);
                    continue;
                }
                if ("-removeTempDir".equalsIgnoreCase(key)) {
                    this.removeTempDir = "true".equalsIgnoreCase(value);
                    continue;
                }
                if ("-recurse".equalsIgnoreCase(key)) {
                    this.recurse = "true".equalsIgnoreCase(value);
                    continue;
                }
                if ("-keepgenerated".equalsIgnoreCase(key)) {
                    this.keepgenerated = Boolean.valueOf(value);
                    continue;
                }
                if ("-usejdkcompiler".equalsIgnoreCase(key)) {
                    this.useJDKCompiler = Boolean.valueOf(value);
                    continue;
                }
                if ("-verbose".equalsIgnoreCase(key)) {
                    this.verbose = Boolean.valueOf(value);
                    continue;
                }
                if ("-usePageTagPool".equalsIgnoreCase(key)) {
                    this.usePageTagPool = Boolean.valueOf(value);
                    continue;
                }
                if ("-useThreadTagPool".equalsIgnoreCase(key)) {
                    this.useThreadTagPool = Boolean.valueOf(value);
                    continue;
                }
                if ("-deprecation".equalsIgnoreCase(key)) {
                    this.deprecation = Boolean.valueOf(value);
                    continue;
                }
                if ("-javaEncoding".equalsIgnoreCase(key)) {
                    this.javaEncoding = value;
                    continue;
                }
                if ("-compileWithAssert".equalsIgnoreCase(key)) {
                    this.compileWithAssert = Boolean.valueOf(value);
                    continue;
                }
                if ("-jdkSourceLevel".equalsIgnoreCase(key)) {
                    this.jdkSourceLevel = value;
                    continue;
                }
                if ("-jspCompileClasspath".equalsIgnoreCase(key)) {
                    this.jspCompileClasspath = value;
                    continue;
                }
                if ("-classloader.parentFirst".equalsIgnoreCase(key)) {
                    this.classloaderParentFirst = "true".equalsIgnoreCase(value);
                    continue;
                }
                if ("-classloader.singleWarClassloader".equalsIgnoreCase(key)) {
                    this.classloaderSingleWarClassloader = "true".equalsIgnoreCase(value);
                    continue;
                }
                if ("-compileToWebInf".equalsIgnoreCase(key)) {
                    this.compileToWebInf = "true".equalsIgnoreCase(value);
                    continue;
                }
                if ("-forceCompilation".equalsIgnoreCase(key)) {
                    this.forceCompilation = "true".equalsIgnoreCase(value);
                    continue;
                }
                if ("-trackDependencies".equalsIgnoreCase(key)) {
                    this.trackDependencies = Boolean.valueOf(value);
                    continue;
                }
                if ("-createDebugClassfiles".equalsIgnoreCase(key)) {
                    this.createDebugClassfiles = "true".equalsIgnoreCase(value);
                    continue;
                }
                if ("-keepGeneratedclassfiles".equalsIgnoreCase(key)) {
                    this.keepGeneratedclassfiles = "true".equalsIgnoreCase(value);
                    continue;
                }
                if ("-log.level".equalsIgnoreCase(key)) {
                    this.logLevel = value;
                    continue;
                }
                if ("-extractToDir".equalsIgnoreCase(key)) {
                    this.extractToDirectoryBase = value;
                    continue;
                }
                if ("-compileToDir".equalsIgnoreCase(key)) {
                    this.compileToDirectory = value;
                    continue;
                }
                if ("-additional.classpath".equalsIgnoreCase(key)) {
                    this.additionalClasspath = value;
                    continue;
                }
                if ("-useJikes".equalsIgnoreCase(key)) {
                    this.useJikes = Boolean.valueOf(value);
                    continue;
                }
                if ("-useFullPackageNames".equalsIgnoreCase(key)) {
                    this.useFullPackageNames = Boolean.valueOf(value);
                    continue;
                }
                if ("-jsp.file.extensions".equalsIgnoreCase(key)) {
                    this.jspFileExtensions = value;
                    continue;
                }
                if ("-compilerOptions".equalsIgnoreCase(key)) {
                    localCompilerOptions = value;
                    continue;
                }
                if ("-userepeatint".equalsIgnoreCase(key)) {
                    this.useRepeatInt = Boolean.valueOf(value);
                    continue;
                }
                if ("-usescriptvardupinit".equalsIgnoreCase(key)) {
                    this.useScriptVarDupInit = Boolean.valueOf(value);
                    continue;
                }
                if ("-allowjspoutputelementmismatch".equalsIgnoreCase(key)) {
                    this.allowJspOutputElementMismatch = Boolean.valueOf(value);
                    continue;
                }
                if ("-allowtaglibprefixredefinition".equalsIgnoreCase(key)) {
                    this.allowTaglibPrefixRedefinition = Boolean.valueOf(value);
                    continue;
                }
                if ("-allowtaglibprefixusebeforedefinition".equalsIgnoreCase(key)) {
                    this.allowTaglibPrefixUseBeforeDefinition = Boolean.valueOf(value);
                    continue;
                }
                if ("-allowunmatchedendtag".equalsIgnoreCase(key)) {
                    this.allowUnmatchedEndTag = Boolean.valueOf(value);
                    continue;
                }
                if ("-useiterationeval".equalsIgnoreCase(key)) {
                    this.useIterationEval = Boolean.valueOf(value);
                    continue;
                }
                if ("-useCDataTrim".equalsIgnoreCase(key)) {
                    this.useCDataTrim = Boolean.valueOf(value);
                    continue;
                }
                if ("-disableURLEncodingForParamTag".equalsIgnoreCase(key)) {
                    this.disableURLEncodingForParamTag = Boolean.valueOf(value);
                    continue;
                }
                if ("-evalQuotedAndEscapedExpression".equalsIgnoreCase(key)) {
                    this.evalQuotedAndEscapedExpression = Boolean.valueOf(value);
                    continue;
                }
                if ("-convertexpression".equalsIgnoreCase(key)) {
                    this.convertExpression = Boolean.valueOf(value);
                    continue;
                }
                if ("-allowNullParentInTagFile".equalsIgnoreCase(key)) {
                    this.allowNullParentInTagFile = Boolean.valueOf(value);
                    continue;
                }
                logger.logp(Level.SEVERE, "JspBatchCompiler", "parseCmdLine", "jsp.batchcompiler.unknown.argument", key);
                return false;
            }
        }
        catch (FileNotFoundException e) {
            logger.logp(Level.SEVERE, "JspBatchCompiler", "parseCmdLine", "jsp.batchcompiler.exception.while.processing.arguments.filenotfound", new Object[]{this.responseFile, e.getMessage()});
            return false;
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, "JspBatchCompiler", "parseCmdLine", "jsp.batchcompiler.exception.while.processing.arguments", e);
            return false;
        }
        if (this.logLevel != null) {
            if (this.logLevel.equals("SEVERE")) {
                logger.setLevel(Level.SEVERE);
                consoleHandler.setLevel(Level.SEVERE);
                if (myHandler != null) {
                    myHandler.setLevel(Level.SEVERE);
                }
            } else if (this.logLevel.equals("WARNING")) {
                logger.setLevel(Level.WARNING);
                consoleHandler.setLevel(Level.WARNING);
                if (myHandler != null) {
                    myHandler.setLevel(Level.WARNING);
                }
            } else if (this.logLevel.equals("INFO")) {
                logger.setLevel(Level.INFO);
                consoleHandler.setLevel(Level.INFO);
                if (myHandler != null) {
                    myHandler.setLevel(Level.INFO);
                }
            } else if (this.logLevel.equals("CONFIG")) {
                logger.setLevel(Level.CONFIG);
                consoleHandler.setLevel(Level.CONFIG);
                if (myHandler != null) {
                    myHandler.setLevel(Level.CONFIG);
                }
            } else if (this.logLevel.equals("FINE")) {
                logger.setLevel(Level.FINE);
                consoleHandler.setLevel(Level.FINE);
                if (myHandler != null) {
                    myHandler.setLevel(Level.FINE);
                }
            } else if (this.logLevel.equals("FINER")) {
                logger.setLevel(Level.FINER);
                consoleHandler.setLevel(Level.FINER);
                if (myHandler != null) {
                    myHandler.setLevel(Level.FINER);
                }
            } else if (this.logLevel.equals("FINEST")) {
                logger.setLevel(Level.FINEST);
                consoleHandler.setLevel(Level.FINEST);
                if (myHandler != null) {
                    myHandler.setLevel(Level.FINEST);
                }
            } else if (this.logLevel.equals("OFF")) {
                logger.setLevel(Level.OFF);
            } else {
                logger.logp(Level.WARNING, "JspBatchCompiler", "parseCmdLine", "jsp.batchcompiler.using.default.log.level", new Object[]{this.logLevel, defaultLogLevel});
            }
        }
        if (localCompilerOptions != null) {
            this.compilerOptions = new ArrayList();
            StringTokenizer st = new StringTokenizer(localCompilerOptions, " ");
            while (st.hasMoreTokens()) {
                this.compilerOptions.add(st.nextToken());
            }
        }
        int argcount = 0;
        if (this.earPath != null) {
            ++argcount;
        }
        if (this.warPath != null) {
            ++argcount;
        }
        if (this.enterpriseApp != null) {
            ++argcount;
        }
        if (argcount == 0) {
            logger.logp(Level.SEVERE, "JspBatchCompiler", "parseCmdLine", "jsp.batchcompiler.must.supply.ear.path.or.war.path.or.enterpriseapp");
            return false;
        }
        if (argcount > 1) {
            logger.logp(Level.SEVERE, "JspBatchCompiler", "parseCmdLine", "jsp.batchcompiler.must.supply.only.one.of.ear.path.or.war.path.or.enterpriseapp");
            return false;
        }
        if (this.removeTempDir && this.enterpriseApp == null) {
            logger.logp(Level.SEVERE, "JspBatchCompiler", "parseCmdLine", "jsp.batchcompiler.if.removetempdir.true.enterpriseapp.must.be.given");
            return false;
        }
        if (!this.translateJsps && !this.removeTempDir) {
            logger.logp(Level.SEVERE, "JspBatchCompiler", "parseCmdLine", "jsp.batchcompiler.if.translatejsps.false.removetempdir.must.be.true");
            return false;
        }
        if (this.compileToDirectory != null && this.compileToWebInf) {
            logger.logp(Level.WARNING, "JspBatchCompiler", "parseCmdLine", "jsp.batchcompiler.compiletowebinf.being.ignored.because.compiletodir.given", this.compileToDirectory);
            this.compileToWebInf = false;
        }
        if (this.enterpriseApp != null && this.enterpriseApp.equalsIgnoreCase(LISTAPPS)) {
            this.listApps = true;
        }
        if (this.javaEncoding != null && !EncodingUtils.isCharsetSupported(this.javaEncoding)) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.INFO)) {
                logger.logp(Level.INFO, "JspBatchCompiler", "parseCmdLine", "Invalid value for javaEncoding [" + this.javaEncoding + "]. Defaulting to UTF-8.");
            }
            this.javaEncoding = "UTF-8";
        }
        if (this.compileWithAssert != null && this.compileWithAssert.booleanValue()) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.INFO)) {
                logger.logp(Level.INFO, "JspBatchCompiler", "parseCmdLine", "compileWithAssert is deprecated.  Use jdkSourceLevel with value of '14' instead. ");
            }
            if (this.jdkSourceLevel == null) {
                this.jdkSourceLevel = "14";
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.INFO)) {
                    logger.logp(Level.INFO, "JspBatchCompiler", "parseCmdLine", "Setting jdkSourceLevel to '14' because compileWithAssert is true.");
                }
            } else if (this.jdkSourceLevel.equals("13")) {
                this.jdkSourceLevel = "14";
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.INFO)) {
                    logger.logp(Level.INFO, "JspBatchCompiler", "parseCmdLine", "jdkSourceLevel was set to '13'.  Setting jdkSourceLevel to '14' because compileWithAssert is true.");
                }
            } else if (this.jdkSourceLevel.equals("15") && TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.INFO)) {
                logger.logp(Level.INFO, "JspBatchCompiler", "parseCmdLine", "jdkSourceLevel is set to '15' and compileWithAssert is 'true'.  Leaving jdkSourceLevel at higher '15' level.");
            }
        }
        if (!(this.jdkSourceLevel == null || this.jdkSourceLevel.equals("13") || this.jdkSourceLevel.equals("14") || this.jdkSourceLevel.equals("15"))) {
            this.jdkSourceLevel = null;
        }
        if (this.earPath != null) {
            if (this.compileToDirectory == null) {
                this.compileToWebInf = true;
            }
            if (this.webModuleName == null) {
                this.webModuleName = WEBMODULE_COMPILEALL;
            }
            return true;
        }
        if (this.warPath != null) {
            if (this.compileToDirectory == null) {
                this.compileToWebInf = true;
            }
            if (this.webModuleName != null) {
                logger.logp(Level.WARNING, "JspBatchCompiler", "parseCmdLine", "jsp.batchcompiler.webmodule.name.being.ignored.because.war.path.given", this.webModuleName);
                this.webModuleName = null;
            }
            return true;
        }
        if (this.configRoot == null) {
            this.configRoot = this.configRootHidden;
        }
        if (this.cell == null) {
            this.cell = this.cellHidden;
        }
        if (this.node == null) {
            this.node = this.nodeHidden;
        }
        if (this.enterpriseApp != null && this.configRoot != null) {
            logger.logp(Level.CONFIG, "JspBatchCompiler", "parseCmdLine", "\n");
            if (this.cell == null) {
                logger.logp(Level.CONFIG, "JspBatchCompiler", "parseCmdLine", "jsp.batchcompiler.using.default.cell.name", "BaseApplicationServerCell");
                this.cell = "BaseApplicationServerCell";
            }
            if (this.node == null) {
                logger.logp(Level.CONFIG, "JspBatchCompiler", "parseCmdLine", "jsp.batchcompiler.using.default.node.name", "DefaultNode");
                this.node = "DefaultNode";
            }
            if (this.process == null) {
                logger.logp(Level.CONFIG, "JspBatchCompiler", "parseCmdLine", "jsp.batchcompiler.using.default.server.name", "server1");
                this.process = "server1";
            }
            if (this.webModuleName == null && !this.listApps) {
                logger.logp(Level.CONFIG, "JspBatchCompiler", "parseCmdLine", "jsp.batchcompiler.compiling.all.webmodules");
                this.webModuleName = WEBMODULE_COMPILEALL;
            }
            if (this.extractToDirectoryBase != null) {
                logger.logp(Level.CONFIG, "JspBatchCompiler", "parseCmdLine", "jsp.batchcompiler.ignoring.extracttodir", this.extractToDirectoryBase);
            }
            logger.logp(Level.CONFIG, "JspBatchCompiler", "parseCmdLine", "\n");
            return true;
        }
        return false;
    }

    protected String expandVariable(String string) throws IllegalArgumentException {
        com.ibm.ws.runtime.service.VariableMap variableMap = null;
        try {
            variableMap = (com.ibm.ws.runtime.service.VariableMap)WsServiceRegistry.getService((Object)this, com.ibm.ws.runtime.service.VariableMap.class);
            logger.logp(Level.FINE, "JspBatchCompiler", "expandVariable", "variableMap: [" + variableMap + "] string to expand: [" + string + "]");
            String expandedString = variableMap.expand(string);
            logger.logp(Level.FINE, "JspBatchCompiler", "expandVariable", "expanded string: [" + expandedString + "]");
            return expandedString;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)WsComponentImpl.class.getName(), (String)"365", (Object)this);
            return null;
        }
    }

    private void usage() {
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "\n");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "Usage:");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "JspBatchCompiler");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                -ear.path <path> | -war.path <path> |");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                    -enterpriseapp.name <name|-listApps> (\"-listApps\" lists deployed applications and their web modules)");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-response.file <filename>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-webmodule.name <name>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-filename <jsp name | directory name>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-recurse <true|false]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-config.root <path>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-cell.name <name>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-node.name <name>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-server.name <name>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-profileName <name>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-extractToDir <path>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-compileToDir <path>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-compileToWebInf <true|false>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-translate <true|false>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-compile <true|false>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-removeTempDir <true|false>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-forceCompilation <true|false>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-useFullPackageNames <true|false>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-trackDependencies <true|false>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-createDebugClassfiles <true|false>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-keepgenerated <true|false>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-keepGeneratedclassfiles <true|false>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-usePageTagPool <true|false>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-useThreadTagPool <true|false>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-classloader.parentFirst <true|false>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-classloader.singleWarClassloader <true|false>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-additional.classpath <classpath to additional jars and classes>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-jspCompileClasspath <classpath to WAS public API jars; or no value at all>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-verbose <true|false>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-deprecation <true|false>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-javaEncoding <encoding>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-jdkSourceLevel <13 | 14 | 15>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-useJDKCompiler <true|false>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-useRepeatInt <true|false>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-allowJspOutputElementMismatch <true|false>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-allowTaglibPrefixRedefinition <true|false>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-allowTaglibPrefixUseBeforeDefinition <true|false>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-allowUnmatchedEndTag <true|false>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-useIterationEval <true|false>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-useScriptVarDupInit <true|false>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-useCDataTrim <true|false>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-disableURLEncodingForParamTag <true|false>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-compilerOptions <space-separated list of java compiler options>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-useJikes <true|false>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-evalQuotedAndEscapedExpression <true|false>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-jsp.file.extensions <file extensions to process>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                [-log.level <SEVERE | WARNING | INFO | CONFIG | FINE | FINER | FINEST | OFF>]");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", " ");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                *** See batchcompiler.properties.default in {WAS_ROOT}/properties for more information. ***");
        logger.logp(Level.CONFIG, "JspBatchCompiler", "usage", "                *** See JspCBuild.xml in {WAS_ROOT}/properties for information about the public WebSphere Ant task JspC. ***");
    }

    public String toString() {
        String separatorString = System.getProperty("line.separator");
        String retString = null;
        if (this.earPath != null) {
            retString = separatorString + "jsp.batchcompiler.earPath =              [" + this.earPath + "]" + separatorString + "jsp.batchcompiler.earFile.name =         [" + this.earFile.getName() + "]" + separatorString + "jsp.batchcompiler.webmodulename =        [" + this.webModuleName + "]" + separatorString + "jsp.batchcompiler.webmoduleURL =         [" + this.webModuleURL + "]" + separatorString + "jsp.batchcompiler.extractToDir =         [" + this.extractToDirectoryBase + "]" + separatorString + "classloader.parentFirst =                [" + this.classloaderParentFirst + "]" + separatorString + "classloader.singleWarClassloader =       [" + this.classloaderSingleWarClassloader + "]" + separatorString;
        } else if (this.warPath != null) {
            retString = separatorString + "jsp.batchcompiler.warPath =              [" + this.warPath + "]" + separatorString + "jsp.batchcompiler.warFile.name =         [" + this.warFile.getName() + "]" + separatorString + "jsp.batchcompiler.extractToDir =         [" + this.extractToDirectoryBase + "]" + separatorString + "jsp.batchcompiler.webmoduleURL =         [" + this.webModuleURL + "]" + separatorString;
        } else if (this.enterpriseApp != null) {
            retString = separatorString + "jsp.batchcompiler.config.root =        [" + this.configRoot + "]" + separatorString + "jsp.batchcompiler.cellname =           [" + this.cell + "]" + separatorString + "jsp.batchcompiler.nodename =           [" + this.node + "]" + separatorString + "jsp.batchcompiler.servername =         [" + this.process + "]" + separatorString + "jsp.batchcompiler.enterpriseappname =  [" + this.enterpriseApp + "]" + separatorString + "jsp.batchcompiler.webmodulename =      [" + this.webModuleName + "]" + separatorString + "install.root =                         [" + this.wasInstallRoot + "]" + separatorString + "app.install.root =                     [" + this.appInstallRoot + "]" + separatorString + "config.url =                           [" + this.configURL + "]" + separatorString + "binaries.url =                         [" + this.binariesURL + "]" + separatorString + "loose.app.url =                        [" + this.looseAppURL + "]" + separatorString + "webmodule.url =                        [" + this.webModuleURL + "]" + separatorString + "metadata.from.binaries =               [" + this.metadataFromBinaries + "]" + separatorString + "classloader.parentFirst =              [" + this.classloaderParentFirst + "]" + separatorString + "classloader.singleWarClassloader =     [" + this.classloaderSingleWarClassloader + "]" + separatorString + "removeTempDir =                        [" + this.removeTempDir + "]" + separatorString;
        }
        retString = retString.concat("response file:                         [" + this.responseFile + "]" + separatorString + "classfiles will be compiled to:        [" + this.tempDirectory + "]" + separatorString + "jspFileName =                          [" + this.filename + "]" + separatorString + "recurse =                              [" + this.recurse + "]" + separatorString + "verbose =                              [" + this.options.isVerbose() + "]" + separatorString + "translate =                            [" + this.translateJsps + "]" + separatorString + "compile =                              [" + this.compileJsps + "]" + separatorString + "deprecation =                          [" + this.options.isDeprecation() + "]" + separatorString + "javaEncoding =                         [" + this.options.getJavaEncoding() + "]" + separatorString + "jdkSourceLevel =                       [" + this.options.getJdkSourceLevel() + "]" + separatorString + "useJDKCompiler =                       [" + this.options.isUseJDKCompiler() + "]" + separatorString + "useRepeatInt =                         [" + this.options.isUseRepeatInt() + "]" + separatorString + "useScriptVarDupInit =                  [" + this.options.isUseScriptVarDupInit() + "]" + separatorString + "allowJspOutputElementMismatch =        [" + this.options.isAllowJspOutputElementMismatch() + "]" + separatorString + "allowTaglibPrefixRedefinition =        [" + this.options.isAllowTaglibPrefixRedefinition() + "]" + separatorString + "allowTaglibPrefixUseBeforeDefinition = [" + this.options.isAllowTaglibPrefixUseBeforeDefinition() + "]" + separatorString + "allowUnmatchedEndTag =                 [" + this.options.isAllowUnmatchedEndTag() + "]" + separatorString + "useIterationEval =                     [" + this.options.isUseIterationEval() + "]" + separatorString + "useCDataTrim =      \t\t              [" + this.options.isUseCDataTrim() + "]" + separatorString + "disableURLEncodingForParamTag =        [" + this.options.isDisableURLEncodingForParamTag() + "]" + separatorString + "compilerOptions =                      " + this.compilerOptions + separatorString + "keepgenerated =                        [" + this.options.isKeepGenerated() + "]" + separatorString + "keepGeneratedclassfiles =              [" + this.keepGeneratedclassfiles + "]" + separatorString + "usePageTagPool =                       [" + this.options.isUsePageTagPool() + "]" + separatorString + "useThreadTagPool =                     [" + this.options.isUseThreadTagPool() + "]" + separatorString + "compileToWebInf =                      [" + this.compileToWebInf + "]" + separatorString + "createDebugClassfiles =                [" + this.createDebugClassfiles + "]" + separatorString + "forceCompilation =                     [" + this.forceCompilation + "]" + separatorString + "trackDependencies =                    [" + this.options.isTrackDependencies() + "]" + separatorString + "useJikes =                             [" + this.options.isUseJikes() + "]" + separatorString + "useFullPackageNames =                  [" + this.options.isUseFullPackageNames() + "]" + separatorString + "jsp.file.extensions =                  [" + this.fullJspFileExtensions + "]" + separatorString + "additionalClasspath =                  [" + this.additionalClasspath + "]" + separatorString + "jspCompileClasspath =                  [" + this.options.getJspCompileClasspath() + "]" + separatorString + "evalQuotedAndEscapedExpression =       [" + this.options.isEvalQuotedAndEscapedExpression() + "]" + separatorString + "convertExpression =                    [" + this.options.isConvertExpression() + "]" + separatorString + "");
        return retString;
    }

    public String getName() {
        return "JspBatchCompiler";
    }

    public String getState() {
        return null;
    }

    public void initialize(Object config) throws ComponentDisabledException, ConfigurationWarning, ConfigurationError {
    }

    public void destroy() {
    }

    public void start() throws RuntimeError, RuntimeWarning {
    }

    public void stop() {
    }

    private class EnterpriseAppInfo {
        private String binariesURL = null;
        private String looseAppURL = null;
        private String configURL = null;
        private String name = null;

        public EnterpriseAppInfo(String binariesURL, String looseAppURL, String configURL, String name) {
            this.binariesURL = binariesURL;
            this.looseAppURL = looseAppURL;
            this.configURL = configURL;
            this.name = name;
            if (TraceComponent.isAnyTracingEnabled() && JspBatchCBase.logger.isLoggable(Level.FINE)) {
                JspBatchCBase.logger.logp(Level.FINE, "EnterpriseAppInfo", "EnterpriseAppInfo", "New EnterpriseAppInfo.  binariesURL: [" + this.binariesURL + "] looseAppURL: [" + this.looseAppURL + "] configURL: [" + this.configURL + "] name: [" + this.name + "]  ");
            }
        }

        public String getBinariesURL() {
            return this.binariesURL;
        }

        public String getLooseAppURL() {
            return this.looseAppURL;
        }

        public String getConfigURL() {
            return this.configURL;
        }

        public String getName() {
            return this.name;
        }
    }
}

