/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.tags.ard;

import com.ibm.websphere.servlet.context.IBMServletContext;
import com.ibm.websphere.webcontainer.async.AsyncRequestDispatcherConfig;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jsp.util.JspMessages;
import com.ibm.wsspi.ard.AsyncRequestDispatcherConfigImpl;
import com.ibm.wsspi.ard.JspAsyncRequestDispatcher;
import com.ibm.wsspi.ard.JspFragmentResponse;
import com.ibm.wsspi.ard.exception.ARDException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;

public class ARDHelper {
    private static final String JSP_ARD_NOT_A_FRAGMENT_RESPONSE = "jsp.ard.notAFragmentResponse";
    private static final String JSP_ARD_NULL_FRAGMENT_RESPONSE = "jsp.ard.nullFragmentResponse";
    private static final String DEFAULT_CONFIG_NAME = "ardConfig";
    private static final String REQUEST = "request";
    private static final String SESSION = "session";
    private static final String APPLICATION = "application";
    protected static Logger logger = Logger.getLogger("com.ibm.ws.jsp");

    static IBMServletContext getIBMServletContext(String context, PageContext pageContext) throws JspTagException {
        IBMServletContext ibmSC;
        if (context == null) {
            ibmSC = (IBMServletContext)pageContext.getServletContext();
        } else {
            if (!context.startsWith("/")) {
                context = "/" + context;
            }
            ibmSC = (IBMServletContext)pageContext.getServletContext().getContext(context);
        }
        if (ibmSC == null) {
            throw new JspTagException(JspMessages.getMessage("jsp.ard.badContext", new Object[]{context}));
        }
        return ibmSC;
    }

    static JspAsyncRequestDispatcher getAsyncRequestDispatcherAfterConfigured(IBMServletContext ibmSC, String url, PageContext pageContext, boolean hasConfigInTag, String executionTimeoutEncoding, String executionTimeoutMessage, int executionTimeoutOverride, int expirationTimeoutOverride, String rejectedEncoding, String rejectedMessage, boolean retriable, boolean transferState, boolean useDefaultJavascript) {
        JspAsyncRequestDispatcher ard = (JspAsyncRequestDispatcher)ibmSC.getAsyncRequestDispatcher(url);
        if (ard != null) {
            AsyncRequestDispatcherConfigImpl ardConfig = (AsyncRequestDispatcherConfigImpl)pageContext.getAttribute(DEFAULT_CONFIG_NAME, 2);
            if (hasConfigInTag) {
                ardConfig = ARDHelper.generateConfig(ardConfig, executionTimeoutEncoding, executionTimeoutMessage, executionTimeoutOverride, expirationTimeoutOverride, rejectedEncoding, rejectedMessage, retriable, transferState, useDefaultJavascript);
            }
            if (ardConfig != null) {
                ard.setAsyncRequestDispatcherConfig((AsyncRequestDispatcherConfig)ardConfig);
            }
        }
        return ard;
    }

    static AsyncRequestDispatcherConfigImpl generateConfig(AsyncRequestDispatcherConfigImpl config, String executionTimeoutEncoding, String executionTimeoutMessage, int executionTimeoutOverride, int expirationTimeoutOverride, String rejectedEncoding, String rejectedMessage, boolean retriable, boolean transferState, boolean useDefaultJavascript) {
        AsyncRequestDispatcherConfigImpl newConfig = null;
        if (config == null) {
            newConfig = new AsyncRequestDispatcherConfigImpl();
        } else {
            try {
                newConfig = (AsyncRequestDispatcherConfigImpl)config.clone();
            }
            catch (CloneNotSupportedException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jsp.tags.ard.ARDHelper", (String)"137");
                newConfig = new AsyncRequestDispatcherConfigImpl();
            }
        }
        if (executionTimeoutMessage != null) {
            newConfig.setExecutionTimeoutMessage(executionTimeoutMessage, executionTimeoutEncoding);
        }
        if (executionTimeoutOverride != -1) {
            newConfig.setExecutionTimeoutOverride(executionTimeoutOverride);
        }
        if (expirationTimeoutOverride != -1) {
            newConfig.setExpirationTimeoutOverride(expirationTimeoutOverride);
        }
        if (rejectedMessage != null) {
            newConfig.setRejectedMessage(rejectedMessage, rejectedEncoding);
        }
        newConfig.setRetriable(retriable);
        newConfig.setTransferState(transferState);
        newConfig.setUseDefaultJavascript(useDefaultJavascript);
        return newConfig;
    }

    static void insertFragment(PageContext pageContext, String var, int scope, boolean blocking) throws JspException, ARDException {
        try {
            Object objectFrag = pageContext.getAttribute(var, scope);
            if (objectFrag != null) {
                if (!(objectFrag instanceof JspFragmentResponse)) {
                    String exceptionText = JspMessages.getMessage(JSP_ARD_NOT_A_FRAGMENT_RESPONSE);
                    ARDException ardE = new ARDException(exceptionText);
                    FFDCFilter.processException((Throwable)ardE, (String)"com.ibm.ws.jsp.tags.ard.ARDHelper", (String)"147");
                    throw ardE;
                }
            } else {
                String exceptionText = JspMessages.getMessage(JSP_ARD_NULL_FRAGMENT_RESPONSE);
                ARDException ardE = new ARDException(exceptionText);
                FFDCFilter.processException((Throwable)ardE, (String)"com.ibm.ws.jsp.tags.ard.ARDHelper", (String)"153");
                throw ardE;
            }
            JspFragmentResponse frag = (JspFragmentResponse)objectFrag;
            ARDHelper.doInsert(frag, (HttpServletRequest)pageContext.getRequest(), (HttpServletResponse)pageContext.getResponse(), new PrintWriter(pageContext.getOut()), blocking);
        }
        catch (IOException ioE) {
            FFDCFilter.processException((Throwable)ioE, (String)"com.ibm.ws.jsp.tags.ard.ARDHelper", (String)"157");
            throw new ARDException((Throwable)ioE);
        }
        catch (ARDException ardE) {
            throw ardE;
        }
        catch (ServletException sE) {
            FFDCFilter.processException((Throwable)sE, (String)"com.ibm.ws.jsp.tags.ard.ARDHelper", (String)"160");
            throw new ARDException((Throwable)sE);
        }
    }

    static void doInsert(JspFragmentResponse frag, HttpServletRequest req, HttpServletResponse resp, PrintWriter out, boolean blocking) throws IOException, ServletException {
        if (blocking) {
            frag.insertFragmentBlockingFromJsp(req, resp, out);
        } else {
            frag.insertFragmentFromJsp(req, resp, out);
        }
    }

    public static int getScope(String scope) {
        int ret = 1;
        if (REQUEST.equalsIgnoreCase(scope)) {
            ret = 2;
        } else if (SESSION.equalsIgnoreCase(scope)) {
            ret = 3;
        } else if (APPLICATION.equalsIgnoreCase(scope)) {
            ret = 4;
        }
        return ret;
    }
}

