/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.taglib;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wsspi.jsp.resource.JspInputSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.tagext.FunctionInfo;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagFileInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import javax.servlet.jsp.tagext.TagLibraryValidator;
import javax.servlet.jsp.tagext.TagVariableInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagLibraryInfoImpl
extends TagLibraryInfo {
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.taglib.TagLibraryInfoImpl";
    private static String TSX_URI = "http://websphere.ibm.com/tags/tsx";
    private static String JSX_URI = "http://websphere.ibm.com/tags/jsx";
    protected String tldOriginatorId = "";
    protected JspInputSource inputSource = null;
    protected Class tlvClass = null;
    protected Map tlvInitParams = null;
    protected HashMap<String, TagLibraryInfoImpl> tagLibMap = null;

    public TagLibraryInfoImpl(String tldOriginatorId, JspInputSource inputSource) {
        super("", "");
        this.tldOriginatorId = tldOriginatorId;
        this.inputSource = inputSource;
    }

    protected TagLibraryInfoImpl(String prefix, String uri, String tldOriginatorId, JspInputSource inputSource) {
        super(prefix, uri);
        this.tldOriginatorId = tldOriginatorId;
        this.inputSource = inputSource;
    }

    public String getTldFilePath() {
        return this.inputSource.getRelativeURL();
    }

    public long getLoadedTimestamp() {
        return this.inputSource.getLastModified();
    }

    public JspInputSource getInputSource() {
        return this.inputSource;
    }

    void setPrefixString(String prefix) {
        this.prefix = prefix;
    }

    void setURI(String uri) {
        this.uri = uri;
    }

    void setInfoString(String info) {
        this.info = info;
    }

    void setReliableURN(String urn) {
        this.urn = urn;
    }

    void setRequiredVersion(String version) {
        this.jspversion = version;
    }

    void setShortName(String shortname) {
        this.shortname = shortname;
    }

    void setTlibversion(String tlibversion) {
        this.tlibversion = tlibversion;
    }

    void setTags(List tagList) {
        this.tags = new TagInfo[tagList.size()];
        if (tagList.size() > 0) {
            this.tags = tagList.toArray(this.tags);
        }
    }

    void setTags(TagInfo[] tags) {
        this.tags = tags;
    }

    void setTagFiles(List tagFileList) {
        this.tagFiles = new TagFileInfo[tagFileList.size()];
        if (tagFileList.size() > 0) {
            this.tagFiles = tagFileList.toArray(this.tagFiles);
        }
    }

    void setTagFiles(TagFileInfo[] tagFiles) {
        this.tagFiles = tagFiles;
    }

    void setFunctions(List functionList) {
        this.functions = new FunctionInfo[functionList.size()];
        if (functionList.size() > 0) {
            this.functions = functionList.toArray(this.functions);
        }
    }

    void setFunctions(FunctionInfo[] functions) {
        this.functions = functions;
    }

    void setTabLibraryValidator(Class tlvClass, Map tlvInitParams) {
        this.tlvClass = tlvClass;
        this.tlvInitParams = tlvInitParams;
    }

    public TagLibraryValidator getTagLibraryValidator() {
        TagLibraryValidator tlv = null;
        if (this.tlvClass != null) {
            try {
                tlv = (TagLibraryValidator)this.tlvClass.newInstance();
                if (this.tlvInitParams != null) {
                    tlv.setInitParameters(this.tlvInitParams);
                } else {
                    tlv.setInitParameters(new HashMap<String, Object>());
                }
            }
            catch (IllegalAccessException e) {
                logger.logp(Level.WARNING, CLASS_NAME, "getTagLibraryValidator", "Illegal access of tag library validator [" + tlv.getClass() + "]", e);
            }
            catch (InstantiationException e) {
                logger.logp(Level.WARNING, CLASS_NAME, "getTagLibraryValidator", "Failed to instantiate tag library validator [" + tlv.getClass() + "]", e);
            }
        }
        return tlv;
    }

    public String getTlibversion() {
        return this.tlibversion;
    }

    public TagLibraryInfoImpl copy(String prefix) {
        TagLibraryInfoImpl tli = new TagLibraryInfoImpl(prefix, this.uri, this.tldOriginatorId, this.inputSource);
        tli.setInfoString(this.info);
        tli.setReliableURN(this.urn);
        tli.setRequiredVersion(this.jspversion);
        tli.setShortName(this.shortname);
        tli.setTlibversion(this.tlibversion);
        tli.setTags(this.tags);
        tli.setTagFiles(this.tagFiles);
        tli.setFunctions(this.functions);
        tli.setTabLibraryValidator(this.tlvClass, this.tlvInitParams);
        tli.setTagLibMap(this.tagLibMap);
        return tli;
    }

    public String getOriginatorId() {
        return this.tldOriginatorId;
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append("TagLibraryInfo name [");
        if (this.shortname != null) {
            sb.append(this.shortname);
        }
        sb.append("] info [");
        if (this.info != null) {
            sb.append(this.info);
        }
        sb.append("] urn [");
        if (this.urn != null) {
            sb.append(this.urn);
        }
        sb.append("] jspversion [");
        if (this.jspversion != null) {
            sb.append(this.jspversion);
        }
        sb.append("] tlibversion [");
        if (this.tlibversion != null) {
            sb.append(this.tlibversion);
        }
        sb.append("]\n");
        if (this.tags != null) {
            for (i = 0; i < this.tags.length; ++i) {
                this.tagToString(sb, this.tags[i]);
            }
        }
        if (this.tagFiles != null) {
            for (i = 0; i < this.tagFiles.length; ++i) {
                sb.append("tagFile name [");
                if (this.tagFiles[i].getName() != null) {
                    sb.append(this.tagFiles[i].getName());
                }
                sb.append("] path [");
                if (this.tagFiles[i].getPath() != null) {
                    sb.append(this.tagFiles[i].getPath());
                }
                sb.append("]\n");
                if (this.tagFiles[i].getTagInfo() == null) continue;
                this.tagToString(sb, this.tagFiles[i].getTagInfo());
            }
        }
        if (this.functions != null) {
            for (i = 0; i < this.functions.length; ++i) {
                sb.append("function name [");
                if (this.functions[i].getName() != null) {
                    sb.append(this.functions[i].getName());
                }
                sb.append("] class [");
                if (this.functions[i].getFunctionClass() != null) {
                    sb.append(this.functions[i].getFunctionClass());
                }
                sb.append("] signature [");
                if (this.functions[i].getFunctionSignature() != null) {
                    sb.append(this.functions[i].getFunctionSignature());
                }
                sb.append("]\n");
            }
        }
        return sb.toString();
    }

    private void tagToString(StringBuffer sb, TagInfo tag) {
        sb.append("tag tagName [");
        if (tag.getTagName() != null) {
            sb.append(tag.getTagName());
        }
        sb.append("] tagClassName [");
        if (tag.getTagClassName() != null) {
            sb.append(tag.getTagClassName());
        }
        sb.append("] bodycontent [");
        if (tag.getBodyContent() != null) {
            sb.append(tag.getBodyContent());
        }
        sb.append("] info [");
        if (tag.getInfoString() != null) {
            sb.append(tag.getInfoString());
        }
        sb.append("] displayName [");
        if (tag.getDisplayName() != null) {
            sb.append(tag.getDisplayName());
        }
        sb.append("] smallIcon [");
        if (tag.getSmallIcon() != null) {
            sb.append(tag.getSmallIcon());
        }
        sb.append("] largeIcon [");
        if (tag.getLargeIcon() != null) {
            sb.append(tag.getLargeIcon());
        }
        sb.append("] dynamicAttributes [");
        sb.append(tag.hasDynamicAttributes());
        sb.append("]\n");
        if (tag.getAttributes() != null) {
            TagAttributeInfo[] attributes = tag.getAttributes();
            TagLibraryInfoImpl.printTagAttributeInfo(sb, attributes);
        }
        if (tag.getTagVariableInfos() != null) {
            TagVariableInfo[] variables = tag.getTagVariableInfos();
            TagLibraryInfoImpl.printTagVariableInfo(sb, variables);
        }
    }

    public static void printTagVariableInfo(StringBuffer sb, TagVariableInfo[] variables) {
        if (variables != null) {
            for (int j = 0; j < variables.length; ++j) {
                sb.append("variable nameGiven [");
                if (variables[j].getNameGiven() != null) {
                    sb.append(variables[j].getNameGiven());
                }
                sb.append("] nameFromAttribute [");
                if (variables[j].getNameFromAttribute() != null) {
                    sb.append(variables[j].getNameFromAttribute());
                }
                sb.append("] className [");
                if (variables[j].getClassName() != null) {
                    sb.append(variables[j].getClassName());
                }
                sb.append("] declare [");
                sb.append(variables[j].getDeclare());
                sb.append("] scope [");
                sb.append(variables[j].getScope());
                sb.append("]\n");
            }
        }
    }

    public static void printTagAttributeInfo(StringBuffer sb, TagAttributeInfo[] attributes) {
        if (attributes != null) {
            for (int j = 0; j < attributes.length; ++j) {
                sb.append("attribute name [");
                if (attributes[j].getName() != null) {
                    sb.append(attributes[j].getName());
                }
                sb.append("] type [");
                if (attributes[j].getTypeName() != null) {
                    sb.append(attributes[j].getTypeName());
                }
                sb.append("] requestTime [");
                sb.append(attributes[j].canBeRequestTime());
                sb.append("] fragment [");
                sb.append(attributes[j].isFragment());
                sb.append("] required [");
                sb.append(attributes[j].isRequired());
                sb.append("] isDeferredMethod [");
                sb.append(attributes[j].isDeferredMethod());
                sb.append("] isDeferredValue [");
                sb.append(attributes[j].isDeferredValue());
                sb.append("] ExpectedTypeName [");
                sb.append(attributes[j].getExpectedTypeName());
                sb.append("] MethodSignature [");
                sb.append(attributes[j].getMethodSignature());
                sb.append("]\n");
            }
        }
    }

    public void setTagLibMap(HashMap<String, TagLibraryInfoImpl> tlibMap) {
        this.tagLibMap = tlibMap;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "setTagLibMap", "setTagLibMap:tlibMap =[" + tlibMap + "]");
        }
    }

    @Override
    public TagLibraryInfo[] getTagLibraryInfos() {
        if (this.tagLibMap != null) {
            ArrayList<TagLibraryInfoImpl> coll = new ArrayList<TagLibraryInfoImpl>();
            Set<String> keys = this.tagLibMap.keySet();
            Iterator<String> itr = keys.iterator();
            TagLibraryInfoImpl item = null;
            String uri = null;
            while (itr.hasNext()) {
                uri = itr.next();
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "getTagLibraryInfos", "getTagLibraryInfos tagLibMap uri=[" + uri + "]");
                }
                if (uri.equals(TSX_URI) || uri.equals(JSX_URI)) continue;
                item = this.tagLibMap.get(uri);
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "getTagLibraryInfos", "getTagLibraryInfos tagLibMap item to add to list=[" + item.uri + "]");
                }
                coll.add(item);
            }
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "getTagLibraryInfos", "getTagLibraryInfos:tlibMap after removing jsx and tsx=[" + coll.toString() + "]");
            }
            return coll.toArray(new TagLibraryInfo[0]);
        }
        return null;
    }
}

