/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsf.util;

import com.ibm.ws.jsf.JSFConstants;
import com.ibm.ws.jsf.configuration.FacesConfigParser;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.servlet.ServletContext;

public class FacesConfigUtil {
    private static Logger log = Logger.getLogger("com.ibm.ws.jsf");
    private static final String CLASS_NAME = "com.ibm.ws.jsf.util.FacesConfigUtil";
    private static final Object lock = new Object();
    private static FacesConfigParser serverConfigParser = null;
    private static String[] factoryNames = new String[]{"javax.faces.application.ApplicationFactory", "javax.faces.context.FacesContextFactory", "javax.faces.lifecycle.LifecycleFactory", "javax.faces.render.RenderKitFactory"};

    public static void createDefaultJSFFactories() {
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "createDefaultJSFFactories", "Creating default JSF factories");
        }
        String applicationFactoryString = "com.sun.faces.application.ApplicationFactoryImpl";
        FactoryFinder.setFactory("javax.faces.application.ApplicationFactory", applicationFactoryString);
        String facesContextFactoryString = "com.sun.faces.context.FacesContextFactoryImpl";
        FactoryFinder.setFactory("javax.faces.context.FacesContextFactory", facesContextFactoryString);
        String lifecycleFactoryString = "com.sun.faces.lifecycle.LifecycleFactoryImpl";
        FactoryFinder.setFactory("javax.faces.lifecycle.LifecycleFactory", lifecycleFactoryString);
        String renderKitFactoryString = "com.sun.faces.renderkit.RenderKitFactoryImpl";
        FactoryFinder.setFactory("javax.faces.render.RenderKitFactory", renderKitFactoryString);
    }

    public static void parseJSFConfiguration(ServletContext context) {
        if (System.getSecurityManager() != null) {
            final ServletContext localContext = context;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    FacesConfigUtil._parseJSFConfiguration(localContext);
                    return null;
                }
            });
        } else {
            FacesConfigUtil._parseJSFConfiguration(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _parseJSFConfiguration(ServletContext context) throws FacesException {
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "_parseJSFConfiguration", "Request for JSF configuration for webmodule [" + context.getServletContextName() + "]. Loading JSF configuration.");
        }
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "_parseJSFConfiguration", "Parsing server configuration for webmodule [" + context.getServletContextName() + "]");
        }
        FacesConfigParser facesConfigParser = null;
        log.logp(Level.FINEST, CLASS_NAME, "_parseJSFConfiguration", "Entering synch block for obtaining server configuration");
        Object object = lock;
        synchronized (object) {
            log.logp(Level.FINEST, CLASS_NAME, "_parseJSFConfiguration", "Inside synch block for obtaining server configuration");
            FacesConfigParser localServerConfigParser = FacesConfigUtil.parseJSFServerConfig();
            try {
                facesConfigParser = (FacesConfigParser)localServerConfigParser.clone();
            }
            catch (CloneNotSupportedException e) {
                String servletContextName = context.getServletContextName();
                String message = "Failed to clone FacesConfigParser object for webmodule [" + servletContextName + "]";
                if (log.isLoggable(Level.SEVERE)) {
                    log.logp(Level.SEVERE, CLASS_NAME, "_parseJSFConfiguration", message, e);
                }
                throw new FacesException(message, e);
            }
        }
        log.logp(Level.FINEST, CLASS_NAME, "_parseJSFConfiguration", "Exited synch block for obtaining server configuration");
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "_parseJSFConfiguration", "Parsing application configuration for webmodule [" + context.getServletContextName() + "]");
        }
        facesConfigParser.recreateParser(context);
        FacesConfigUtil.parseJSFApplicationConfig(facesConfigParser, context);
        try {
            facesConfigParser.initializeConfiguration(context);
        }
        catch (FacesException e) {
            if (log.isLoggable(Level.SEVERE)) {
                log.logp(Level.SEVERE, CLASS_NAME, "_parseJSFConfiguration", "Failed to initialize configuration for webmodule [" + context.getServletContextName() + "]", e);
            }
            throw e;
        }
        facesConfigParser = null;
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "_parseJSFConfiguration", "Verifying factories for webmodule [" + context.getServletContextName() + "]");
        }
        FacesConfigUtil.verifyFactories();
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "_parseJSFConfiguration", "Completed processing configuration for webmodule [" + context.getServletContextName() + "]");
        }
    }

    private static void verifyFactories() throws FacesException {
        int len = factoryNames.length;
        for (int i = 0; i < len; ++i) {
            try {
                FactoryFinder.getFactory(factoryNames[i]);
                continue;
            }
            catch (Exception e) {
                throw new FacesException(e);
            }
        }
    }

    private static void parseJSFApplicationConfig(FacesConfigParser facesConfigParser, ServletContext context) {
        Iterator resources;
        URL url = null;
        try {
            LinkedList<URL> list = new LinkedList<URL>();
            Enumeration<URL> items = Util.getCurrentLoader(FacesConfigUtil.class).getResources("META-INF/faces-config.xml");
            while (items.hasMoreElements()) {
                list.add(0, items.nextElement());
            }
            resources = list.iterator();
        }
        catch (IOException e) {
            String message = null;
            try {
                message = MessageUtils.getExceptionMessageString("com.sun.faces.CANT_PARSE_FILE", "/META-INF/faces-config.xml");
            }
            catch (Exception ee) {
                message = "Can't parse configuration file:/META-INF/faces-config.xml";
            }
            log.logp(Level.SEVERE, CLASS_NAME, "parseJSFApplicationConfig", message, e);
            throw new FacesException(message, e);
        }
        while (resources.hasNext()) {
            url = (URL)resources.next();
            try {
                facesConfigParser.parse(url);
            }
            catch (Exception e) {
                String message = null;
                try {
                    message = MessageUtils.getExceptionMessageString("com.sun.faces.CANT_PARSE_FILE", url.toExternalForm());
                }
                catch (Exception ee) {
                    message = "Can't parse configuration file:" + url.toExternalForm();
                }
                log.logp(Level.SEVERE, CLASS_NAME, "parseJSFApplicationConfig", message, e);
                throw new FacesException(message, e);
            }
        }
        String paths = context.getInitParameter("javax.faces.CONFIG_FILES");
        if (paths != null) {
            paths = paths.trim();
            while (paths.length() > 0) {
                String path;
                int comma = paths.indexOf(",");
                if (comma >= 0) {
                    path = paths.substring(0, comma).trim();
                    paths = paths.substring(comma + 1).trim();
                } else {
                    path = paths.trim();
                    paths = "";
                }
                if (path.length() < 1) break;
                try {
                    url = context.getResource(path);
                    facesConfigParser.parse(url);
                }
                catch (Exception e) {
                    String message = null;
                    try {
                        message = MessageUtils.getExceptionMessageString("com.sun.faces.CANT_PARSE_FILE", path);
                    }
                    catch (Exception ee) {
                        message = "Can't parse configuration file:" + path;
                    }
                    log.logp(Level.SEVERE, CLASS_NAME, "parseJSFApplicationConfig", message, e);
                    throw new FacesException(message, e);
                }
            }
        }
        try {
            url = context.getResource("/WEB-INF/faces-config.xml");
            if (url != null) {
                facesConfigParser.parse(url);
            }
        }
        catch (Exception e) {
            String message = null;
            try {
                message = MessageUtils.getExceptionMessageString("com.sun.faces.CANT_PARSE_FILE", url.toExternalForm());
            }
            catch (Exception ee) {
                message = "Can't parse configuration file:" + url.toExternalForm();
            }
            log.logp(Level.SEVERE, CLASS_NAME, "parseJSFApplicationConfig", message, e);
            throw new FacesException(message, e);
        }
    }

    private static FacesConfigParser parseJSFServerConfig() {
        if (serverConfigParser != null) {
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "parseJSFServerConfig", "Already parsed JSF server configuration return current instance of configuration");
            }
            return serverConfigParser;
        }
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "parseJSFServerConfig", "Start parsing of global config");
        }
        long startTime = System.currentTimeMillis();
        serverConfigParser = FacesConfigUtil.readSerializedConfig();
        assert (null != serverConfigParser);
        long endTime = System.currentTimeMillis();
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "parseJSFServerConfig", "End parsing of global config:  parse time =[" + (endTime - startTime) + "]");
        }
        return serverConfigParser;
    }

    private static FacesConfigParser readSerializedConfig() {
        try {
            URL configURL = Util.getCurrentLoader(FacesConfigUtil.class).getResource(JSFConstants.SERIALIZED_CONFIG);
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "readSerializedConfig", "reading in serialized config for " + configURL);
            }
            InputStream in = configURL.openStream();
            ObjectInputStream s = new ObjectInputStream(in);
            return (FacesConfigParser)s.readObject();
        }
        catch (Exception e) {
            if (log.isLoggable(Level.SEVERE)) {
                log.logp(Level.SEVERE, CLASS_NAME, "readSerializedConfig", "Failed to read serialized FacesConfigParser object", e);
            }
            return null;
        }
    }
}

