/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.utils;

import com.ibm.ws.install.configmanager.actionengine.Parameter;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterPassingUtils {
    private static final String S_EQUALS = "=";
    private static final String S_PARAMETER_PREFIX = "parameter.";
    private static final String S_START_VARIABLE = "${";
    private static final String S_END_VARIABLE = "}";
    private static final Logger LOGGER = LoggerFactory.createLogger(ParameterPassingUtils.class);
    private static final String S_CLASS_NAME = ParameterPassingUtils.class.getName();

    public static String[] retrieveParametersAsArray(boolean fRemovePrefix) {
        return ParameterPassingUtils.convertMapToParameterArray(ParameterPassingUtils.retrieveParametersAsAMap(fRemovePrefix));
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, String> retrieveParametersAsAMap(boolean fRemovePrefix) {
        Hashtable<String, String> mapOfParameters = new Hashtable<String, String>();
        Properties props = System.getProperties();
        for (String string : props.keySet()) {
            void var4_4;
            if (!string.startsWith(S_PARAMETER_PREFIX)) continue;
            String sProperty = props.getProperty(string);
            if (fRemovePrefix) {
                String string2 = ParameterPassingUtils.removeParameterPrefix(string);
            }
            mapOfParameters.put((String)var4_4, sProperty);
        }
        return mapOfParameters;
    }

    /*
     * WARNING - void declaration
     */
    public static Properties retrieveParametersAsProperties(boolean fRemovePrefix) {
        Properties propParameters = new Properties();
        Properties props = System.getProperties();
        for (String string : props.keySet()) {
            void var4_4;
            if (!string.startsWith(S_PARAMETER_PREFIX)) continue;
            String sProperty = props.getProperty(string);
            if (fRemovePrefix) {
                String string2 = ParameterPassingUtils.removeParameterPrefix(string);
            }
            propParameters.put((Object)var4_4, sProperty);
        }
        return propParameters;
    }

    public static String retrieveParameter(String sKey) {
        Properties props = System.getProperties();
        if (!sKey.startsWith(S_PARAMETER_PREFIX)) {
            return props.getProperty(S_PARAMETER_PREFIX + sKey);
        }
        return props.getProperty(sKey);
    }

    public static void setParametersIntoSystemProperties(List<Parameter> listParams) {
        if (!listParams.isEmpty()) {
            for (Parameter paramThis : listParams) {
                System.setProperty(ParameterPassingUtils.appendParameterPrefix(paramThis.getKey()), ParameterPassingUtils.substituteVariablesFromSystemProperties(paramThis.getValue()));
            }
        }
    }

    public static String[] convertMapToParameterArray(Map<String, String> map) {
        String[] saParams = new String[map.size()];
        int i = 0;
        for (String sKey : map.keySet()) {
            String sValue = map.get(sKey);
            saParams[i] = sKey + S_EQUALS + sValue;
            ++i;
        }
        return saParams;
    }

    private static String substituteVariablesFromSystemProperties(String sInput) {
        return ParameterPassingUtils.substituteVariablesFromProperties(sInput, System.getProperties());
    }

    private static String substituteVariablesFromProperties(String sInput, Properties props) {
        LOGGER.logp(Level.FINEST, S_CLASS_NAME, "substituteVariablesFromProperties", "string = " + sInput);
        boolean fDone = false;
        while (!fDone) {
            fDone = true;
            int nStartIndex = sInput.indexOf(S_START_VARIABLE);
            LOGGER.logp(Level.FINEST, S_CLASS_NAME, "substituteVariablesFromProperties", "startIndex = " + nStartIndex);
            if (nStartIndex < 0) continue;
            int nEndIndex = sInput.indexOf(S_END_VARIABLE, nStartIndex);
            LOGGER.logp(Level.FINEST, S_CLASS_NAME, "substituteVariablesFromProperties", "endIndex = " + nEndIndex);
            if (nEndIndex < 0) continue;
            String sKey = sInput.substring(nStartIndex + S_START_VARIABLE.length(), nEndIndex + 1 - S_END_VARIABLE.length());
            LOGGER.logp(Level.FINEST, S_CLASS_NAME, "substituteVariablesFromProperties", "key = " + sKey);
            String sValue = props.getProperty(sKey);
            LOGGER.logp(Level.FINEST, S_CLASS_NAME, "substituteVariablesFromProperties", "value = " + sValue);
            if (sValue == null) continue;
            String sTempString = sInput.substring(0, nStartIndex) + sValue;
            if (sInput.length() > nEndIndex + 1) {
                sTempString = sTempString + sInput.substring(nEndIndex + 1);
            }
            sInput = sTempString;
            LOGGER.logp(Level.FINEST, S_CLASS_NAME, "substituteVariablesFromProperties", "string (updated) = " + sInput);
            fDone = false;
        }
        return sInput;
    }

    private static String removeParameterPrefix(String sKey) {
        if (sKey.startsWith(S_PARAMETER_PREFIX)) {
            return sKey.substring(S_PARAMETER_PREFIX.length());
        }
        return sKey;
    }

    private static String appendParameterPrefix(String sKey) {
        if (!sKey.startsWith(S_PARAMETER_PREFIX)) {
            return S_PARAMETER_PREFIX + sKey;
        }
        return sKey;
    }
}

