/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.actionengine.ant.utils;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.utils.ResourceBundleUtils;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class ResourceBundleAntTask
extends Task {
    private String m_sResourceBundleName = null;
    private String m_sResourceBundleKey = null;
    private String m_sProperty = null;
    private String m_sParam = null;
    private String m_sErrorMessage = new String();
    private static final Logger LOGGER = LoggerFactory.createLogger(ResourceBundleAntTask.class);
    private static final String S_CLASS_NAME = ResourceBundleAntTask.class.getName();
    private static final String S_NO_RESOURCEBUNDLENAME = "Resource name for the property that holds the result must be specified";
    private static final String S_NO_RESOURCEBUNDLEKEY = "Resource key name for the property that holds the result must be specified";
    private static final String S_NO_PARAM = "Parameter for the property that holds the result must be specified";
    private static final String S_NO_PROPERTY = "Property name for the property that holds the result must be specified";

    public void init() throws BuildException {
        LOGGER.entering(ResourceBundleAntTask.class.getName(), "init");
        super.init();
        this.m_sResourceBundleName = null;
        this.m_sResourceBundleKey = null;
        this.m_sProperty = null;
        this.m_sParam = null;
        LOGGER.exiting(ResourceBundleAntTask.class.getName(), "init");
    }

    public void execute() throws BuildException {
        LOGGER.entering(ResourceBundleAntTask.class.getName(), "execute");
        super.execute();
        if (!this.doAllParamsCheckOutOk()) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "execute", "Incorrect parameters specified for the ResourceBundleAntTask");
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "execute", "Error location is: " + this.getLocation().toString());
            throw new BuildException(this.m_sErrorMessage, this.getLocation());
        }
        String sResult = null;
        ResourceBundleUtils.setResourceBundleName(this.m_sResourceBundleName);
        sResult = this.m_sParam.equals("") ? ResourceBundleUtils.getLocaleString(this.m_sResourceBundleKey) : ResourceBundleUtils.getLocaleString(this.m_sResourceBundleKey, this.m_sParam);
        this.getProject().setNewProperty(this.m_sProperty, sResult);
        LOGGER.exiting(ResourceBundleAntTask.class.getName(), "execute");
    }

    public void setProperty(String sProperty) {
        LOGGER.entering(ResourceBundleAntTask.class.getName(), "setProperty");
        this.m_sProperty = sProperty;
        LOGGER.exiting(ResourceBundleAntTask.class.getName(), "setProperty");
    }

    public void setResourceBundleName(String sResourceBundleName) {
        LOGGER.entering(ResourceBundleAntTask.class.getName(), "setResourceBundleName");
        this.m_sResourceBundleName = sResourceBundleName;
        LOGGER.exiting(ResourceBundleAntTask.class.getName(), "setResourceBundleName");
    }

    public void setResourceBundleKey(String sResourceBundleKey) {
        LOGGER.entering(ResourceBundleAntTask.class.getName(), "setResourceBundleKey");
        this.m_sResourceBundleKey = sResourceBundleKey;
        LOGGER.exiting(ResourceBundleAntTask.class.getName(), "setResourceBundleKey");
    }

    public void setParam(String sParam) {
        LOGGER.entering(ResourceBundleAntTask.class.getName(), "setParam");
        this.m_sParam = sParam;
        LOGGER.exiting(ResourceBundleAntTask.class.getName(), "setParam");
    }

    private boolean doAllParamsCheckOutOk() {
        LOGGER.entering(ResourceBundleAntTask.class.getName(), "doAllParamsCheckOutOk");
        if (this.m_sResourceBundleName == null) {
            this.m_sErrorMessage = S_NO_RESOURCEBUNDLENAME;
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "doAllParamsCheckOutOk", "Param check failed, error message is: " + this.m_sErrorMessage);
            LOGGER.exiting(ResourceBundleAntTask.class.getName(), "doAllParamsCheckOutOk");
            return false;
        }
        if (this.m_sResourceBundleKey == null) {
            this.m_sErrorMessage = S_NO_RESOURCEBUNDLEKEY;
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "doAllParamsCheckOutOk", "Param check failed, error message is: " + this.m_sErrorMessage);
            LOGGER.exiting(ResourceBundleAntTask.class.getName(), "doAllParamsCheckOutOk");
            return false;
        }
        if (this.m_sParam == null) {
            this.m_sErrorMessage = S_NO_PARAM;
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "doAllParamsCheckOutOk", "Param check failed, error message is: " + this.m_sErrorMessage);
            LOGGER.exiting(ResourceBundleAntTask.class.getName(), "doAllParamsCheckOutOk");
            return false;
        }
        if (this.m_sProperty == null) {
            this.m_sErrorMessage = S_NO_PROPERTY;
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "doAllParamsCheckOutOk", "Param check failed, error message is: " + this.m_sErrorMessage);
            LOGGER.exiting(ResourceBundleAntTask.class.getName(), "doAllParamsCheckOutOk");
            return false;
        }
        LOGGER.exiting(ResourceBundleAntTask.class.getName(), "doAllParamsCheckOutOk");
        return true;
    }
}

