/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.actionengine.ant.utils;

import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import java.io.File;
import java.util.Vector;
import java.util.logging.Logger;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;

public class FileSetUtils {
    private static final Logger LOGGER = LoggerFactory.createLogger(FileSetUtils.class);

    public static Vector getAllFilesInTheseFileSets(Vector vfilesets, Project projectThis) {
        LOGGER.entering(FileSetUtils.class.getName(), "getAllFilesInTheseFileSets");
        Vector vsFilePaths = new Vector();
        try {
            for (int i = 0; i < vfilesets.size(); ++i) {
                FileSet filesetThis = (FileSet)vfilesets.elementAt(i);
                vsFilePaths.addAll(FileSetUtils.getAllFilesInThisFileSet(filesetThis, projectThis));
            }
        }
        catch (Exception e) {
            LogUtils.logException(LOGGER, e);
        }
        LOGGER.exiting(FileSetUtils.class.getName(), "getAllFilesInTheseFileSets");
        return vsFilePaths;
    }

    public static Vector getAllFilesInThisFileSet(FileSet filesetThis, Project projectThis) {
        LOGGER.entering(FileSetUtils.class.getName(), "getAllFilesInThisFileSet");
        Vector<String> vsPaths = new Vector<String>();
        try {
            DirectoryScanner directoryscannerThis = filesetThis.getDirectoryScanner(projectThis);
            String[] asFileNames = directoryscannerThis.getIncludedFiles();
            for (int i = 0; i < asFileNames.length; ++i) {
                String sFilePathThis = directoryscannerThis.getBasedir() + File.separator + asFileNames[i];
                vsPaths.add(sFilePathThis);
            }
        }
        catch (Exception e) {
            LogUtils.logException(LOGGER, e);
        }
        LOGGER.exiting(FileSetUtils.class.getName(), "getAllFilesInThisFileSet");
        return vsPaths;
    }
}

