/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.actionengine.ant.utils;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class FileNameAntTask
extends Task {
    private String m_sPath = null;
    private String m_sProperty = null;
    private String m_sErrorMessage = new String();
    private static final Logger LOGGER = LoggerFactory.createLogger(FileNameAntTask.class);
    private static final String S_CLASS_NAME = FileNameAntTask.class.getName();
    private static final String S_NO_PATH = "Path must be specified";
    private static final String S_NO_PROPERTY = "Property name for the property that holds the result must be specified";

    public void init() throws BuildException {
        LOGGER.entering(this.getClass().getName(), "init");
        super.init();
        this.m_sPath = null;
        this.m_sProperty = null;
        LOGGER.exiting(this.getClass().getName(), "init");
    }

    public void execute() throws BuildException {
        LOGGER.entering(this.getClass().getName(), "execute");
        super.execute();
        if (!this.doAllParamsCheckOutOk()) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "execute", "Incorrect parameters specified for the FileNameAntTask");
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "execute", "Error location is: " + this.getLocation().toString());
            throw new BuildException(this.m_sErrorMessage, this.getLocation());
        }
        String sResult = new File(this.m_sPath).getName();
        this.getProject().setNewProperty(this.m_sProperty, sResult);
        LOGGER.exiting(this.getClass().getName(), "execute");
    }

    public void setPath(String sPath) {
        LOGGER.entering(this.getClass().getName(), "setPath");
        this.m_sPath = sPath;
        LOGGER.exiting(this.getClass().getName(), "setPath");
    }

    public void setProperty(String sProperty) {
        LOGGER.entering(this.getClass().getName(), "setProperty");
        this.m_sProperty = sProperty;
        LOGGER.exiting(this.getClass().getName(), "setProperty");
    }

    private boolean doAllParamsCheckOutOk() {
        LOGGER.entering(this.getClass().getName(), "doAllParamsCheckOutOk");
        if (this.m_sPath == null) {
            this.m_sErrorMessage = S_NO_PATH;
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "doAllParamsCheckOutOk", "Param check failed, error message is: " + this.m_sErrorMessage);
            LOGGER.exiting(this.getClass().getName(), "doAllParamsCheckOutOk");
            return false;
        }
        if (this.m_sProperty == null) {
            this.m_sErrorMessage = S_NO_PROPERTY;
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "doAllParamsCheckOutOk", "Param check failed, error message is: " + this.m_sErrorMessage);
            LOGGER.exiting(this.getClass().getName(), "doAllParamsCheckOutOk");
            return false;
        }
        LOGGER.exiting(this.getClass().getName(), "doAllParamsCheckOutOk");
        return true;
    }
}

