/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.actionengine.ant.utils;

import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class DefineHTMLCharSetTask
extends Task {
    private String m_sProperty = null;
    private String m_sErrorMessage = new String();
    private static final String S_LOCALE_ZH_TW = "zh_TW";
    private static final String S_LOCALE_ZH_CN = "zh_CN";
    private static final String S_LOCALE_JA_JP = "ja_JP";
    private static final String S_LOCALE_KO_KR = "ko_KR";
    private static final String S_LOCALE_RU_RU = "ru_RU";
    private static final String S_LOCALE_PL_PL = "pl_PL";
    private static final String S_LOCALE_CS_CZ = "cs_CZ";
    private static final String S_LOCALE_HU_HU = "hu_HU";
    private static final String S_LOCALE_EL_GR = "gl_GR";
    private static final String S_LOCALE_TR_TR = "tr_TR";
    private static final String S_LOCALE_AR_DZ = "ar_DZ";
    private static final String S_LOCALE_AR_BH = "ar_BH";
    private static final String S_LOCALE_AR_EG = "ar_EG";
    private static final String S_LOCALE_AR_JO = "ar_JO";
    private static final String S_LOCALE_AR_KW = "ar_KW";
    private static final String S_LOCALE_AR_LB = "ar_LB";
    private static final String S_LOCALE_AR_MA = "ar_MA";
    private static final String S_LOCALE_AR_OM = "ar_OM";
    private static final String S_LOCALE_AR_QA = "ar_QA";
    private static final String S_LOCALE_AR_SA = "ar_SA";
    private static final String S_LOCALE_AR_SY = "ar_SY";
    private static final String S_LOCALE_AR_TN = "ar_TN";
    private static final String S_LOCALE_AR_AE = "ar_AE";
    private static final String S_LOCALE_AR_YE = "ar_YE";
    private static final String S_LOCALE_HE_IL = "he_IL";
    private static final String S_LOCALE_UK_UA = "uk_UA";
    private static final String S_LOCALE_TH_TH = "th_TH";
    private static final String S_LOCALE_SK_SK = "sk_SK";
    private static final String S_LOCALE_SL_SI = "sl_SI";
    private static final String S_LOCALE_RO_RO = "ro_RO";
    private static final String S_LOCALE_LV_LV = "lv_LV";
    private static final String S_LOCALE_LT_LT = "lt_LT";
    private static final String S_LOCALE_MK_MK = "mk_MK";
    private static final String S_LOCALE_ET_EE = "et_EE";
    private static final String S_LOCALE_BE_BY = "be_BY";
    private static final String S_LOCALE_BG_BG = "bg_BG";
    private static final String S_LOCALE_HR_HR = "hr_HR";
    private static final String S_CHARSET_BIG5 = "big5";
    private static final String S_CHARSET_EUCTW = "euc-tw";
    private static final String S_CHARSET_GB2312 = "gb2312";
    private static final String S_CHARSET_SHIFTJIS = "shift_jis";
    private static final String S_CHARSET_EUCJP = "euc-jp";
    private static final String S_CHARSET_EUCKR = "euc-kr";
    private static final String S_CHARSET_ISO88591 = "iso-8859-1";
    private static final String S_CHARSET_UTF8 = "utf8";
    private static final String S_CHARSET_UTF_8 = "utf-8";
    private static final String S_CHARSET_WINDOWS1250 = "windows-1250";
    private static final String S_CHARSET_WINDOWS1251 = "windows-1251";
    private static final String S_CHARSET_WINDOWS1254 = "windows-1254";
    private static final String S_CHARSET_WINDOWS1257 = "windows-1257";
    private static final String S_CHARSET_ISO88595 = "iso-8859-5";
    private static final String S_CHARSET_ISO88596 = "iso-8859-6";
    private static final String S_CHARSET_ISO88597 = "iso-8859-7";
    private static final String S_CHARSET_ISO885915 = "iso-8859-15";
    private static final String S_CHARSET_TIS620 = "TIS-620";
    private static final String S_JAVA_FILE_ENCODING_PROPERTY = "file.encoding";
    private static final String S_NO_PROPERTY = "Property name for the property that holds the result must be specified";
    private static final Logger LOGGER = LoggerFactory.createLogger(DefineHTMLCharSetTask.class);
    private static final String S_CLASS_NAME = DefineHTMLCharSetTask.class.getName();

    public void init() throws BuildException {
        super.init();
        LOGGER.entering(DefineHTMLCharSetTask.class.getName(), "init");
        super.init();
        this.m_sProperty = null;
        LOGGER.exiting(DefineHTMLCharSetTask.class.getName(), "init");
    }

    public void execute() throws BuildException {
        LOGGER.entering(DefineHTMLCharSetTask.class.getName(), "execute");
        super.execute();
        if (!this.doAllParamsCheckOutOk()) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "execute", "Incorrect parameters specified for the DetectLocaleTask");
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "execute", "Error location is: " + this.getLocation().toString());
            throw new BuildException(this.m_sErrorMessage, this.getLocation());
        }
        String sResult = this.defineCharSet();
        this.getProject().setNewProperty(this.m_sProperty, sResult);
        LOGGER.exiting(DefineHTMLCharSetTask.class.getName(), "execute");
    }

    public String defineCharSet() {
        String sLocale = Locale.getDefault().toString();
        String sEncoding = System.getProperty(S_JAVA_FILE_ENCODING_PROPERTY).toLowerCase();
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "defineCharSet", "Detected locale is: " + sLocale);
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "defineCharSet", "Detected file encoding is: " + sEncoding);
        if (sEncoding.equals(S_CHARSET_UTF8) || sEncoding.equals(S_CHARSET_UTF_8)) {
            return S_CHARSET_UTF_8;
        }
        if (sLocale.equals(S_LOCALE_ZH_TW)) {
            if (sEncoding.equals(S_CHARSET_EUCTW)) {
                return S_CHARSET_EUCTW;
            }
            return S_CHARSET_BIG5;
        }
        if (sLocale.equals(S_LOCALE_ZH_CN)) {
            return S_CHARSET_GB2312;
        }
        if (sLocale.equals(S_LOCALE_JA_JP)) {
            if (sEncoding.equals(S_CHARSET_EUCJP)) {
                return S_CHARSET_EUCJP;
            }
            return S_CHARSET_SHIFTJIS;
        }
        if (sLocale.equals(S_LOCALE_KO_KR)) {
            return S_CHARSET_EUCKR;
        }
        if (sLocale.equals(S_LOCALE_PL_PL) || sLocale.equals(S_LOCALE_CS_CZ) || sLocale.equals(S_LOCALE_HU_HU) || sLocale.equals(S_LOCALE_RO_RO) || sLocale.equals(S_LOCALE_HR_HR) || sLocale.equals(S_LOCALE_SL_SI) || sLocale.equals(S_LOCALE_SK_SK)) {
            return S_CHARSET_WINDOWS1250;
        }
        if (sLocale.equals(S_LOCALE_MK_MK) || sLocale.equals(S_LOCALE_RU_RU) || sLocale.equals(S_LOCALE_BG_BG)) {
            return S_CHARSET_WINDOWS1251;
        }
        if (sLocale.equals(S_LOCALE_TR_TR)) {
            return S_CHARSET_WINDOWS1254;
        }
        if (sLocale.equals(S_LOCALE_LV_LV) || sLocale.equals(S_LOCALE_LT_LT)) {
            return S_CHARSET_WINDOWS1257;
        }
        if (sLocale.equals(S_LOCALE_EL_GR)) {
            return S_CHARSET_ISO88597;
        }
        if (sLocale.equals(S_LOCALE_ET_EE)) {
            return S_CHARSET_ISO885915;
        }
        if (sLocale.equals(S_LOCALE_TH_TH)) {
            return S_CHARSET_TIS620;
        }
        if (sLocale.equals(S_LOCALE_UK_UA) || sLocale.equals(S_LOCALE_BE_BY)) {
            return S_CHARSET_ISO88595;
        }
        if (sLocale.equals(S_LOCALE_AR_DZ) || sLocale.equals(S_LOCALE_AR_BH) || sLocale.equals(S_LOCALE_AR_EG) || sLocale.equals(S_LOCALE_AR_JO) || sLocale.equals(S_LOCALE_AR_KW) || sLocale.equals(S_LOCALE_AR_LB) || sLocale.equals(S_LOCALE_AR_MA) || sLocale.equals(S_LOCALE_AR_OM) || sLocale.equals(S_LOCALE_AR_QA) || sLocale.equals(S_LOCALE_AR_SA) || sLocale.equals(S_LOCALE_AR_SY) || sLocale.equals(S_LOCALE_AR_TN) || sLocale.equals(S_LOCALE_AR_AE) || sLocale.equals(S_LOCALE_AR_YE) || sLocale.equals(S_LOCALE_HE_IL)) {
            return S_CHARSET_ISO88596;
        }
        return S_CHARSET_ISO88591;
    }

    public void setProperty(String sProperty) {
        LOGGER.entering(DefineHTMLCharSetTask.class.getName(), "setProperty");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "setProperty", "Incoming property name set to: " + sProperty);
        this.m_sProperty = sProperty;
        LOGGER.exiting(DefineHTMLCharSetTask.class.getName(), "setProperty");
    }

    private boolean doAllParamsCheckOutOk() {
        LOGGER.entering(DefineHTMLCharSetTask.class.getName(), "doAllParamsCheckOutOk");
        if (this.m_sProperty == null) {
            this.m_sErrorMessage = S_NO_PROPERTY;
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "doAllParamsCheckOutOk", "Param check failed, error message is: " + this.m_sErrorMessage);
            LOGGER.exiting(DefineHTMLCharSetTask.class.getName(), "doAllParamsCheckOutOk");
            return false;
        }
        LOGGER.exiting(DefineHTMLCharSetTask.class.getName(), "doAllParamsCheckOutOk");
        return true;
    }
}

