/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager.actionengine.ant.utils;

import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildLogger;

public class ANTLogToCmtLogAdapter
implements BuildLogger {
    private static final Hashtable HASHTABLE_ANT_TO_CMT_LOG_LEVELS = new Hashtable();
    private static final Logger LOGGER = LoggerFactory.createLogger(ANTLogToCmtLogAdapter.class);
    private static final String S_CLASS_NAME = ANTLogToCmtLogAdapter.class.getName();
    private static final String S_SPACER = " - ";
    private static final String S_BUILD_STARTED = "Build started.";
    private static final String S_BUILD_STOPPED = "Build stopped - ";
    private static final String S_SUCCESS = "SUCCESS";
    private static final String S_FAILURE = "FAILURE";
    private static final String S_TARGET_STARTED = "Target started for: ";
    private static final String S_TARGET_STOPPED = "Target stopped for: ";
    private static final String S_TASK_STARTED = "Task started for: ";
    private static final String S_TASK_STOPPED = "Task stopped for: ";

    public void setMessageOutputLevel(int nLogLevel) {
    }

    public void setOutputPrintStream(PrintStream printstream) {
    }

    public void setEmacsMode(boolean fEmacsModeFlag) {
    }

    public void setErrorPrintStream(PrintStream printstream) {
    }

    public void buildStarted(BuildEvent buildevent) {
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "buildStarted", S_BUILD_STARTED);
    }

    public void buildFinished(BuildEvent buildevent) {
        String sSuccessCode = this.getBuildEventStatus(buildevent);
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "buildFinished", S_BUILD_STOPPED + sSuccessCode);
    }

    public void targetStarted(BuildEvent buildevent) {
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "targetStarted", S_TARGET_STARTED + buildevent.getTarget().getName());
    }

    public void targetFinished(BuildEvent buildevent) {
        String sSuccessCode = this.getBuildEventStatus(buildevent);
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "targetFinished", S_TARGET_STOPPED + buildevent.getTarget().getName() + S_SPACER + sSuccessCode);
        if (sSuccessCode.equals(S_FAILURE)) {
            LogUtils.logException(LOGGER, buildevent.getException());
        }
    }

    public void taskStarted(BuildEvent buildevent) {
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "taskStarted", S_TASK_STARTED + buildevent.getTask().getTaskName());
    }

    public void taskFinished(BuildEvent buildevent) {
        String sSuccessCode = this.getBuildEventStatus(buildevent);
        LOGGER.logp(Level.FINE, S_CLASS_NAME, "taskFinished", S_TASK_STOPPED + buildevent.getTask().getTaskName() + S_SPACER + sSuccessCode);
        if (sSuccessCode.equals(S_FAILURE)) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "taskFinished", S_TASK_STOPPED + buildevent.getTask().getTaskName() + S_SPACER + sSuccessCode);
        }
    }

    private String getBuildEventStatus(BuildEvent buildevent) {
        Throwable e = buildevent.getException();
        String sSuccessCode = S_SUCCESS;
        if (e != null) {
            sSuccessCode = S_FAILURE;
        }
        return sSuccessCode;
    }

    public void messageLogged(BuildEvent buildevent) {
        Level levelThis = (Level)HASHTABLE_ANT_TO_CMT_LOG_LEVELS.get(new Integer(buildevent.getPriority()));
        if (levelThis == null) {
            levelThis = Level.INFO;
        }
        LOGGER.log(levelThis, buildevent.getMessage());
    }

    static {
        HASHTABLE_ANT_TO_CMT_LOG_LEVELS.put(new Integer(4), Level.FINE);
        HASHTABLE_ANT_TO_CMT_LOG_LEVELS.put(new Integer(0), Level.SEVERE);
        HASHTABLE_ANT_TO_CMT_LOG_LEVELS.put(new Integer(2), Level.INFO);
        HASHTABLE_ANT_TO_CMT_LOG_LEVELS.put(new Integer(3), Level.FINER);
        HASHTABLE_ANT_TO_CMT_LOG_LEVELS.put(new Integer(1), Level.WARNING);
    }
}

