/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.configmanager;

import com.ibm.ws.install.configmanager.ConfigManagerActionListener;
import com.ibm.ws.install.configmanager.ConfigManagerConstants;
import com.ibm.ws.install.configmanager.actionengine.ActionArgument;
import com.ibm.ws.install.configmanager.actionengine.ConfigAction;
import com.ibm.ws.install.configmanager.actionengine.DefaulterConfigAction;
import com.ibm.ws.install.configmanager.actionengine.ValidatorConfigAction;
import com.ibm.ws.install.configmanager.launcher.ArgumentValueFetcher;
import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.utils.ClassPathModifier;
import com.ibm.ws.install.configmanager.utils.DefaultValueManager;
import com.ibm.ws.install.configmanager.utils.SystemPropertiesUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigManager {
    private final boolean m_fInitializeResult;
    private boolean m_fAllActionsExecutedSuccessfully = false;
    private Vector m_vcaAllActionsSorted = null;
    private Vector m_vcaOptionalActions = null;
    private Vector<ConfigAction> m_vcaSuccessActionsSorted = new Vector();
    private Vector<ConfigAction> m_vcaFailedActionsSorted = new Vector();
    private String[] m_asOmittedActions = null;
    private String[] m_disabledActions = null;
    private static Vector<ConfigManagerActionListener> m_vcmal = new Vector();
    private static Vector<ConfigAction> m_vcaNestedFailedConfigActions = new Vector();
    private static final String S_LIB = "lib";
    private static final String S_DEFAULT_ACTION_REGISTRY = "actionRegistry.xml";
    private static final Logger LOGGER = LoggerFactory.createLogger(ConfigManager.class);
    private static final String S_CLASS_NAME = ConfigManager.class.getName();

    private ConfigManager() {
        LOGGER.entering(ConfigManager.class.getName(), "ConfigManager");
        String sConfigRepositoryPath = ArgumentValueFetcher.getArgumentValue("WS_CMT_CONF_DIR");
        this.m_fInitializeResult = this.initialize(sConfigRepositoryPath);
        if (!this.m_fInitializeResult) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "ConfigManager", "Config manager initialization failed");
        }
        LOGGER.exiting(ConfigManager.class.getName(), "ConfigManager");
    }

    public static List getAllFailedConfigActionsFromNestedRuns() {
        LOGGER.entering(ConfigManager.class.getName(), "getAllFailedConfigActionsFromNestedRuns");
        LOGGER.exiting(ConfigManager.class.getName(), "getAllFailedConfigActionsFromNestedRuns");
        return m_vcaNestedFailedConfigActions;
    }

    public static List getRequiredArgumentsList(String sConfigRepositoryPath) {
        LOGGER.entering(ConfigManager.class.getName(), "getRequiredArgumentsList");
        System.setProperty("WS_CMT_CONF_DIR", sConfigRepositoryPath);
        ArrayList<ActionArgument> listAnticipatedArguments = new ArrayList<ActionArgument>();
        for (ConfigAction ca : new ConfigManager().m_vcaAllActionsSorted) {
            for (ActionArgument aa : ca.getActionArgumentList()) {
                if (!aa.isRequired()) continue;
                listAnticipatedArguments.add(aa);
            }
        }
        LOGGER.exiting(ConfigManager.class.getName(), "getRequiredArgumentsList");
        return listAnticipatedArguments;
    }

    public static List getOptionalArgumentsList(String sConfigRepositoryPath) {
        LOGGER.entering(ConfigManager.class.getName(), "getOptionalArgumentsList");
        System.setProperty("WS_CMT_CONF_DIR", sConfigRepositoryPath);
        ArrayList<ActionArgument> listAnticipatedArguments = new ArrayList<ActionArgument>();
        for (ConfigAction ca : new ConfigManager().m_vcaAllActionsSorted) {
            for (ActionArgument aa : ca.getActionArgumentList()) {
                if (aa.isRequired() || listAnticipatedArguments.contains(aa)) continue;
                listAnticipatedArguments.add(aa);
            }
        }
        LOGGER.exiting(ConfigManager.class.getName(), "getOptionalArgumentsList");
        return listAnticipatedArguments;
    }

    public static List getOptionalConfigActionsList(String sConfigRepositoryPath) {
        LOGGER.entering(ConfigManager.class.getName(), "getOptionalConfigActionsList");
        String sDefaultActionRegistry = sConfigRepositoryPath + File.separator + S_DEFAULT_ACTION_REGISTRY;
        LOGGER.exiting(ConfigManager.class.getName(), "getOptionalConfigActionsList");
        return ConfigManager.getOptionalConfigActionsList(sConfigRepositoryPath, sDefaultActionRegistry);
    }

    public static List getOptionalConfigActionsList(String sConfigRepositoryPath, String sActionRegistryPath) {
        LOGGER.entering(ConfigManager.class.getName(), "getOptionalConfigActionsList");
        System.setProperty("WS_CMT_CONF_DIR", sConfigRepositoryPath);
        System.setProperty("WS_CMT_ACTION_REGISTRY", sActionRegistryPath);
        Vector vcaReturnableOptionalActions = new ConfigManager().m_vcaOptionalActions;
        LOGGER.exiting(ConfigManager.class.getName(), "getOptionalConfigActionsList");
        return vcaReturnableOptionalActions;
    }

    public static List getRequiredConfigActionsList(String sConfigRepositoryPath) {
        LOGGER.entering(ConfigManager.class.getName(), "getRequiredConfigActionsList");
        String sDefaultActionRegistry = sConfigRepositoryPath + File.separator + S_DEFAULT_ACTION_REGISTRY;
        LOGGER.exiting(ConfigManager.class.getName(), "getRequiredConfigActionsList");
        return ConfigManager.getRequiredConfigActionsList(sConfigRepositoryPath, sDefaultActionRegistry);
    }

    public static List getRequiredConfigActionsList(String sConfigRepositoryPath, String sActionRegistryPath) {
        LOGGER.entering(ConfigManager.class.getName(), "getRequiredConfigActionsList");
        System.setProperty("WS_CMT_CONF_DIR", sConfigRepositoryPath);
        System.setProperty("WS_CMT_ACTION_REGISTRY", sActionRegistryPath);
        Vector vcaReturnableOptionalActions = (Vector)ConfigAction.createRequiredActions(new ConfigManager().m_vcaAllActionsSorted);
        LOGGER.exiting(ConfigManager.class.getName(), "getRequiredConfigActionsList");
        return vcaReturnableOptionalActions;
    }

    public static Hashtable<String, DefaulterConfigAction> getDefaulterHashtable(String sConfigRepositoryPath) {
        LOGGER.entering(ConfigManager.class.getName(), "getDefaulterHashtable");
        System.setProperty("WS_CMT_CONF_DIR", sConfigRepositoryPath);
        Vector vAllActionsSorted = new ConfigManager().m_vcaAllActionsSorted;
        Hashtable<String, DefaulterConfigAction> hashtableDefaulters = ConfigManager.createDefaulterHashtable(vAllActionsSorted);
        LOGGER.exiting(ConfigManager.class.getName(), "getDefaulterHashtable");
        return hashtableDefaulters;
    }

    public static Hashtable<String, List<ValidatorConfigAction>> getValidatorHashtable(String sConfigRepositoryPath) {
        LOGGER.entering(ConfigManager.class.getName(), "getValidatorHashtable");
        System.setProperty("WS_CMT_CONF_DIR", sConfigRepositoryPath);
        Vector vAllActionsSorted = new ConfigManager().m_vcaAllActionsSorted;
        Hashtable<String, List<ValidatorConfigAction>> hashtableValidators = ConfigManager.createValidatorHashtable(vAllActionsSorted);
        LOGGER.exiting(ConfigManager.class.getName(), "getValidatorHashtable");
        return hashtableValidators;
    }

    public static int launch() {
        LOGGER.entering(ConfigManager.class.getName(), "launch");
        ConfigManager cm = new ConfigManager();
        if (!cm.getInitializeResult()) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "launch", "ConfigManager Initialization Failed");
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "launch", "Returning with return code: " + ConfigManagerConstants.AS_RETURN_CODES[1]);
            LOGGER.exiting(ConfigManager.class.getName(), "launch");
            return 1;
        }
        if (!cm.executeActions()) {
            if (cm.m_vcaFailedActionsSorted != null) {
                m_vcaNestedFailedConfigActions.addAll(cm.m_vcaFailedActionsSorted);
            }
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "launch", "ConfigManager action execution failed on a fatal action");
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "launch", "Returning with return code: " + ConfigManagerConstants.AS_RETURN_CODES[1]);
            LOGGER.exiting(ConfigManager.class.getName(), "launch");
            return 1;
        }
        if (cm.didAllActionsExecuteSuccessfully()) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "launch", "No errors were encountered while executing the repository actions");
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "launch", "Returning with return code: " + ConfigManagerConstants.AS_RETURN_CODES[0]);
            LOGGER.exiting(ConfigManager.class.getName(), "launch");
            return 0;
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "launch", "There were some errors encountered while executing the repository actions, but none were fatal");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "launch", "Information about actions that failed, follows");
        cm.dumpNonFatalFailedActionsInfoToLogFile();
        if (cm.m_vcaFailedActionsSorted != null) {
            m_vcaNestedFailedConfigActions.addAll(cm.m_vcaFailedActionsSorted);
        }
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "launch", "Returning with return code: " + ConfigManagerConstants.AS_RETURN_CODES[2]);
        LOGGER.exiting(ConfigManager.class.getName(), "launch");
        return 2;
    }

    public static void addConfigManagerActionListener(ConfigManagerActionListener cmalThis) {
        LOGGER.entering(ConfigManager.class.getName(), "addConfigManagerActionListener");
        m_vcmal.add(cmalThis);
        LOGGER.exiting(ConfigManager.class.getName(), "addConfigManagerActionListener");
    }

    public static void removeConfigManagerActionListener(ConfigManagerActionListener cmalThis) {
        LOGGER.entering(ConfigManager.class.getName(), "removeConfigManagerActionListener");
        m_vcmal.remove(cmalThis);
        LOGGER.exiting(ConfigManager.class.getName(), "removeConfigManagerActionListener");
    }

    public static void reset() {
        LOGGER.entering(ConfigManager.class.getName(), "reset");
        LOGGER.exiting(ConfigManager.class.getName(), "reset");
        m_vcaNestedFailedConfigActions = new Vector();
    }

    public void dumpNonFatalFailedActionsInfoToLogFile() {
        LOGGER.entering(ConfigManager.class.getName(), "dumpNonFatalFailedActions");
        for (int i = 0; i < this.m_vcaFailedActionsSorted.size(); ++i) {
            ConfigAction caThis = this.m_vcaFailedActionsSorted.elementAt(i);
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "dumpNonFatalFailedActionsInfoToLogFile", "This action failed to execute: " + caThis.getActionPath());
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "dumpNonFatalFailedActionsInfoToLogFile", "To manually apply this action, please execute this command: " + caThis.getActionManualCommand());
        }
        LOGGER.exiting(ConfigManager.class.getName(), "dumpNonFatalFailedActions");
    }

    public boolean initialize(String sConfigRepositoryPath) {
        LOGGER.entering(ConfigManager.class.getName(), "initialize");
        this.m_vcaAllActionsSorted = (Vector)ConfigAction.createActionsSorted(sConfigRepositoryPath);
        this.m_vcaOptionalActions = (Vector)ConfigAction.createOptionalActions(this.m_vcaAllActionsSorted);
        this.m_asOmittedActions = this.createOmittedActions();
        this.m_disabledActions = this.getDisabledActions();
        if (this.m_vcaAllActionsSorted == null) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "initialize", "Failed to locate any config actions, most probably the action registry file is corrupt");
            LOGGER.exiting(ConfigManager.class.getName(), "initialize");
            return false;
        }
        if (!this.validateOmittedActionsAreOptional(this.m_vcaOptionalActions, this.m_asOmittedActions)) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "initialize", "Validation of omitted actions failed in ConfigManager.initialize()");
            LOGGER.exiting(ConfigManager.class.getName(), "initialize");
            return false;
        }
        if (!this.validateDisabledActionsExist(this.m_vcaAllActionsSorted, this.m_disabledActions)) {
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "initialize", "Validation of disabled actions failed in ConfigManager.initialize()");
            LOGGER.exiting(ConfigManager.class.getName(), "initialize");
        }
        this.m_vcaAllActionsSorted = this.removeOmittedActions(this.m_vcaAllActionsSorted, this.m_asOmittedActions);
        this.m_vcaAllActionsSorted = this.removeDisabledActions(this.m_vcaAllActionsSorted, this.m_disabledActions);
        if (!this.setupClassPath()) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "initialize", "Classpath setup failed in ConfigManager.initialize()");
            LOGGER.exiting(ConfigManager.class.getName(), "initialize");
            return false;
        }
        if (!this.performSanityCheck()) {
            LOGGER.logp(Level.SEVERE, S_CLASS_NAME, "initialize", "Sanity check failed in ConfigManager.initialize()");
            LOGGER.exiting(ConfigManager.class.getName(), "initialize");
            return false;
        }
        LOGGER.exiting(ConfigManager.class.getName(), "initialize");
        return true;
    }

    public boolean executeActions() {
        LOGGER.entering(ConfigManager.class.getName(), "executeActions");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "executeActions", "List of all actions found in the repository: " + this.m_vcaAllActionsSorted.toString());
        Properties propertiesSystemPropsBeforeDefaulting = this.setDefaultValuesIfApplicable();
        boolean fResult = this.executeAllActionsFound();
        this.restoreSystemProperties(propertiesSystemPropsBeforeDefaulting);
        LOGGER.exiting(ConfigManager.class.getName(), "executeActions");
        return fResult;
    }

    public boolean didAllActionsExecuteSuccessfully() {
        LOGGER.entering(ConfigManager.class.getName(), "didAllActionsExecuteSuccessfully");
        LOGGER.exiting(ConfigManager.class.getName(), "didAllActionsExecuteSuccessfully");
        return this.m_fAllActionsExecutedSuccessfully;
    }

    protected boolean getInitializeResult() {
        return this.m_fInitializeResult;
    }

    private String[] createOmittedActions() {
        LOGGER.entering(ConfigManager.class.getName(), "createOmittedActions");
        LOGGER.exiting(ConfigManager.class.getName(), "createOmittedActions");
        return ArgumentValueFetcher.getArgumentValues("omitAction");
    }

    private String[] getDisabledActions() {
        LOGGER.entering(ConfigManager.class.getName(), "getDisabledActions");
        String[] sa = new String[]{};
        String s = System.getProperty("WS_CMT_DISABLED_ACTIONS");
        if (s != null && s.length() > 0) {
            sa = s.split(";");
        }
        LOGGER.exiting(ConfigManager.class.getName(), "getDisabledActions");
        return sa;
    }

    private static Hashtable<String, DefaulterConfigAction> createDefaulterHashtable(Vector allConfigActions) {
        LOGGER.entering(ConfigManager.class.getName(), "createDefaulterHashtable");
        Hashtable<String, DefaulterConfigAction> hashtableDefaulters = new Hashtable<String, DefaulterConfigAction>();
        for (ConfigAction ca : allConfigActions) {
            for (ActionArgument aa : ca.getActionArgumentList()) {
                DefaulterConfigAction dca = aa.getDefaulter();
                if (dca == null) continue;
                if (new File(dca.getActionPath()).exists()) {
                    hashtableDefaulters.put(aa.getKey(), dca);
                    continue;
                }
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "createDefaulterHashtable", "Cannot locate " + dca.getActionPath() + " but execution can continue");
            }
        }
        LOGGER.exiting(ConfigManager.class.getName(), "createDefaulterHashtable");
        return hashtableDefaulters;
    }

    private static Hashtable<String, List<ValidatorConfigAction>> createValidatorHashtable(Vector allConfigActions) {
        LOGGER.entering(ConfigManager.class.getName(), "createValidatorHashtable");
        Hashtable<String, List<ValidatorConfigAction>> hashtableValidators = new Hashtable<String, List<ValidatorConfigAction>>();
        for (ConfigAction ca : allConfigActions) {
            for (ActionArgument aa : ca.getActionArgumentList()) {
                List<ValidatorConfigAction> validatorList = aa.getValidatorList();
                Vector<ValidatorConfigAction> vvca_existingValidatorList = new Vector<ValidatorConfigAction>();
                for (ValidatorConfigAction vca : validatorList) {
                    if (new File(vca.getActionPath()).exists()) {
                        vvca_existingValidatorList.add(vca);
                        continue;
                    }
                    LOGGER.logp(Level.WARNING, S_CLASS_NAME, "createValidatorHashtable", "Cannot locate " + vca.getActionPath() + " but execution can continue");
                }
                if (vvca_existingValidatorList == null || vvca_existingValidatorList.size() <= 0) continue;
                if (hashtableValidators.containsKey(aa.getKey())) {
                    List<ValidatorConfigAction> listCombinedValidatorList = hashtableValidators.get(aa.getKey());
                    listCombinedValidatorList.addAll(vvca_existingValidatorList);
                    hashtableValidators.put(aa.getKey(), listCombinedValidatorList);
                    continue;
                }
                hashtableValidators.put(aa.getKey(), vvca_existingValidatorList);
            }
        }
        LOGGER.exiting(ConfigManager.class.getName(), "createValidatorHashtable");
        return hashtableValidators;
    }

    private Vector removeOmittedActions(Vector vcaAllActions, String[] asOmittedActions) {
        LOGGER.entering(ConfigManager.class.getName(), "removeOmittedActions");
        if (vcaAllActions == null || asOmittedActions == null) {
            LOGGER.exiting(ConfigManager.class.getName(), "removeOmittedActions");
            return vcaAllActions;
        }
        block0: for (int i = 0; i < vcaAllActions.size(); ++i) {
            for (int j = 0; j < asOmittedActions.length; ++j) {
                ConfigAction caTempConfigAction = (ConfigAction)vcaAllActions.elementAt(i);
                if (asOmittedActions[j] == null || !asOmittedActions[j].equals(caTempConfigAction.getActionName()) && !asOmittedActions[j].equals(caTempConfigAction.getActionAlias())) continue;
                vcaAllActions.remove(i);
                LOGGER.logp(Level.INFO, S_CLASS_NAME, "removeOmittedActions", "Optional action " + caTempConfigAction.getActionName() + " has been omitted.");
                --i;
                continue block0;
            }
        }
        LOGGER.exiting(ConfigManager.class.getName(), "removeOmittedActions");
        return vcaAllActions;
    }

    private Vector removeDisabledActions(Vector vcaAllActions, String[] disabledActions) {
        return this.removeOmittedActions(vcaAllActions, disabledActions);
    }

    private boolean validateOmittedActionsAreOptional(Vector vcaOptionalActions, String[] asOmittedActions) {
        LOGGER.entering(ConfigManager.class.getName(), "validateOmittedActionsAreOptional");
        for (int i = 0; i < asOmittedActions.length; ++i) {
            boolean fOmitedActionIsOptional = false;
            for (int j = 0; j < vcaOptionalActions.size(); ++j) {
                ConfigAction caTempConfigAction = (ConfigAction)vcaOptionalActions.elementAt(j);
                if (asOmittedActions[i] == null || !asOmittedActions[i].equals(caTempConfigAction.getActionName()) && !asOmittedActions[i].equals(caTempConfigAction.getActionAlias())) continue;
                fOmitedActionIsOptional = true;
            }
            if (fOmitedActionIsOptional) continue;
            for (int k = 0; k < this.m_vcaAllActionsSorted.size(); ++k) {
                ConfigAction caExaminedConfigAction = (ConfigAction)this.m_vcaAllActionsSorted.elementAt(k);
                if (asOmittedActions[i] == null || !asOmittedActions[i].equals(caExaminedConfigAction.getActionName()) && !asOmittedActions[i].equals(caExaminedConfigAction.getActionAlias())) continue;
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "validateOmittedActionsAreOptional", "Omitted action " + asOmittedActions[i] + " is not an optional action.");
                return false;
            }
        }
        LOGGER.exiting(ConfigManager.class.getName(), "validateOmittedActionsAreOptional");
        return true;
    }

    private boolean validateDisabledActionsExist(Vector vcaAllActions, String[] disabledActions) {
        LOGGER.entering(ConfigManager.class.getName(), "validateDisabledActionsExist");
        for (int i = 0; i < disabledActions.length; ++i) {
            boolean found = false;
            String da = disabledActions[i];
            for (int j = 0; j < vcaAllActions.size(); ++j) {
                ConfigAction ca = (ConfigAction)vcaAllActions.elementAt(j);
                if (!da.equals(ca.getActionAlias())) continue;
                found = true;
                break;
            }
            if (found) continue;
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "validateDisabledActionsExist", "Disabled action " + da + " not found.");
        }
        LOGGER.exiting(ConfigManager.class.getName(), "validateDisabledActionsExist");
        return true;
    }

    private void restoreSystemProperties(Properties propertiesSystemProps) {
        LOGGER.entering(ConfigManager.class.getName(), "restoreSystemProperties");
        SystemPropertiesUtils.resetSystemProperties(propertiesSystemProps);
        LOGGER.exiting(ConfigManager.class.getName(), "restoreSystemProperties");
    }

    private boolean performSanityCheck() {
        LOGGER.entering(ConfigManager.class.getName(), "performSanityCheck");
        if (ArgumentValueFetcher.getArgumentValue("WS_CMT_CONF_DIR") == null) {
            LOGGER.logp(Level.WARNING, S_CLASS_NAME, "performSanityCheck", "Config repository location could not be located");
            LOGGER.exiting(ConfigManager.class.getName(), "performSanityCheck");
            return false;
        }
        LOGGER.exiting(ConfigManager.class.getName(), "performSanityCheck");
        return true;
    }

    private boolean executeAllActionsFound() {
        LOGGER.entering(ConfigManager.class.getName(), "executeAllActionsFound");
        this.m_fAllActionsExecutedSuccessfully = true;
        for (int i = 0; i < this.m_vcaAllActionsSorted.size(); ++i) {
            ConfigAction caThis = (ConfigAction)this.m_vcaAllActionsSorted.elementAt(i);
            ConfigManager.broadcastActionLaunch(caThis.getActionName(), i, this.m_vcaAllActionsSorted.size());
            if (!caThis.executeAction()) {
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "executeAllActionsFound", "Configuration action failed: " + caThis.toString());
                this.m_fAllActionsExecutedSuccessfully = false;
                this.m_vcaFailedActionsSorted.add(caThis);
                if (!caThis.isActionFailureFatalToConfiguration()) continue;
                LOGGER.logp(Level.WARNING, S_CLASS_NAME, "executeAllActionsFound", "Fatal configuration action failed: " + caThis.toString());
                LOGGER.exiting(ConfigManager.class.getName(), "executeAllActionsFound");
                return false;
            }
            LOGGER.logp(Level.INFO, S_CLASS_NAME, "executeAllActionsFound", "Configuration action succeeded: " + caThis.toString());
            this.m_vcaSuccessActionsSorted.add(caThis);
        }
        LOGGER.exiting(ConfigManager.class.getName(), "executeAllActionsFound");
        return true;
    }

    private Properties setDefaultValuesIfApplicable() {
        LOGGER.entering(ConfigManager.class.getName(), "setDefaultValuesIfApplicable");
        List<String> listArgumentsToDefault = this.findArgumentsToDefault();
        Hashtable hashtableDefaultedValues = new Hashtable();
        if (listArgumentsToDefault.size() > 0) {
            Hashtable<String, DefaulterConfigAction> hashtableDefaulters = ConfigManager.createDefaulterHashtable(this.m_vcaAllActionsSorted);
            DefaultValueManager dvmCurrent = new DefaultValueManager(hashtableDefaulters);
            hashtableDefaultedValues = dvmCurrent.getDefaultValues(listArgumentsToDefault, new Hashtable());
        }
        LOGGER.exiting(ConfigManager.class.getName(), "setDefaultValuesIfApplicable");
        return SystemPropertiesUtils.setArgumentsIntoSystemProperties(hashtableDefaultedValues);
    }

    private List<String> findArgumentsToDefault() {
        LOGGER.entering(ConfigManager.class.getName(), "findArgumentsToDefault");
        Vector<String> listArgumentsToDefault = new Vector<String>();
        for (int j = 0; j < this.m_vcaAllActionsSorted.size(); ++j) {
            ConfigAction caThis = (ConfigAction)this.m_vcaAllActionsSorted.elementAt(j);
            List listActionArguments = caThis.getActionArgumentList();
            for (int i = 0; i < listActionArguments.size(); ++i) {
                String sDefaultedValue;
                ActionArgument aaCurrentArgument = (ActionArgument)listActionArguments.get(i);
                String sArgumentKey = aaCurrentArgument.getKey();
                if (ArgumentValueFetcher.getArgumentValue(sArgumentKey, false) != null || !aaCurrentArgument.isRequired() || (sDefaultedValue = ArgumentValueFetcher.getArgumentValue(sArgumentKey)) == null || sDefaultedValue.equals("")) continue;
                listArgumentsToDefault.add(sArgumentKey);
            }
        }
        LOGGER.exiting(ConfigManager.class.getName(), "findArgumentsToDefault");
        return listArgumentsToDefault;
    }

    private boolean setupClassPath() {
        LOGGER.entering(ConfigManager.class.getName(), "setupClassPath");
        try {
            this.addIJCLibDirectoryToClassPath();
        }
        catch (IOException e) {
            LogUtils.logException(LOGGER, e);
            LOGGER.exiting(ConfigManager.class.getName(), "setupClassPath");
            return false;
        }
        LOGGER.exiting(ConfigManager.class.getName(), "setupClassPath");
        return true;
    }

    private void addIJCLibDirectoryToClassPath() throws IOException {
        LOGGER.entering(ConfigManager.class.getName(), "addIJCLibDirectoryToClassPath");
        String sPre_IJC_LIB = ArgumentValueFetcher.getArgumentValue("PRE_IJC_LIB");
        if (sPre_IJC_LIB != null && sPre_IJC_LIB.trim().length() > 0 && new File(sPre_IJC_LIB).exists()) {
            ClassPathModifier.addAllJARsInDirectoryToClassPath(sPre_IJC_LIB);
        }
        String sActionRepositoryPath = ArgumentValueFetcher.getArgumentValue("WS_CMT_CONF_DIR");
        String sPathToTheIJCLibFolderInRepository = new File(sActionRepositoryPath, S_LIB).getAbsolutePath();
        ClassPathModifier.addAllJARsInDirectoryToClassPath(sPathToTheIJCLibFolderInRepository);
        String sPost_IJC_LIB = ArgumentValueFetcher.getArgumentValue("POST_IJC_LIB");
        if (sPost_IJC_LIB != null && sPost_IJC_LIB.trim().length() > 0 && new File(sPost_IJC_LIB).exists()) {
            ClassPathModifier.addAllJARsInDirectoryToClassPath(sPost_IJC_LIB);
        }
        LOGGER.exiting(ConfigManager.class.getName(), "addIJCLibDirectoryToClassPath");
    }

    public static void broadcastActionLaunch(String sActionName, int nActionNumber, int nTotalActions) {
        LOGGER.entering(ConfigManager.class.getName(), "broadcastActionLaunch");
        for (int i = 0; i < m_vcmal.size(); ++i) {
            ConfigManagerActionListener cmalThis = m_vcmal.elementAt(i);
            cmalThis.actionLaunched(sActionName, nActionNumber, nTotalActions);
        }
        LOGGER.exiting(ConfigManager.class.getName(), "broadcastActionLaunch");
    }
}

