/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbpersistence.utilpm;

import com.ibm.ws.ffdc.FFDCFilter;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.LinkedList;
import java.util.Set;

public class ResourcePool {
    private LinkedList resourceSet = null;
    private LinkedList setList = null;
    private boolean useSoftReferences = false;
    private ReferenceQueue rq;
    private int clusterSize;

    public ResourcePool() {
        this.initialize(false, 0, 0.0f, false, 0);
    }

    public ResourcePool(boolean bl) {
        this.initialize(false, 0, 0.0f, bl, 0);
    }

    public ResourcePool(boolean bl, int n) {
        this.initialize(false, 0, 0.0f, bl, n);
    }

    public void clear() {
        if (this.setList != null) {
            this.setList.clear();
            this.setList.add(new SoftReference(new LinkedList()));
        } else {
            this.resourceSet.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getResource(long l) {
        Object object;
        long l2 = 0L;
        long l3 = 0L;
        if (l > 0L) {
            l2 = System.currentTimeMillis() + l;
            l3 = l / 100L;
        }
        if (this.useSoftReferences) {
            object = null;
            while ((object = (SoftReference)this.rq.poll()) != null) {
                if (this.setList != null) {
                    this.setList.remove(object);
                    continue;
                }
                this.resourceSet.remove(object);
            }
        }
        do {
            ResourcePool resourcePool = this;
            synchronized (resourcePool) {
                object = this.tryGet();
            }
            if (object != null || l == 0L) {
                return object;
            }
            try {
                Thread.sleep(l3);
                l3 *= 2L;
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.ejbpersistence.utilpm.ResourcePool.getResource", (String)"186", (Object)this);
                l3 *= 2L;
            }
        } while (System.currentTimeMillis() < l2);
        return null;
    }

    public Object getResourceUnsynched() {
        long l = 0L;
        long l2 = 0L;
        if (this.useSoftReferences) {
            SoftReference softReference = null;
            while ((softReference = (SoftReference)this.rq.poll()) != null) {
                if (this.setList != null) {
                    this.setList.remove(softReference);
                    continue;
                }
                this.resourceSet.remove(softReference);
            }
        }
        return this.tryGet();
    }

    private void initialize(boolean bl, int n, float f, boolean bl2, int n2) {
        this.useSoftReferences = bl2;
        if (this.useSoftReferences) {
            this.rq = new ReferenceQueue();
        }
        if (n2 > 1) {
            this.setList = new LinkedList();
            this.clusterSize = n2;
            this.setList.add(new SoftReference(new LinkedList()));
        } else {
            this.resourceSet = new LinkedList();
        }
    }

    public synchronized void releaseResource(Object object) {
        this.releaseResourceUnsynched(object);
    }

    public void releaseResourceUnsynched(Object softReference) {
        if (this.setList != null) {
            LinkedList linkedList = (LinkedList)((SoftReference)this.setList.getFirst()).get();
            if (linkedList.size() >= this.clusterSize) {
                LinkedList linkedList2 = (LinkedList)((SoftReference)this.setList.getLast()).get();
                if (linkedList2.isEmpty()) {
                    SoftReference softReference2 = (SoftReference)this.setList.removeLast();
                    this.setList.addFirst(softReference2);
                    linkedList = (LinkedList)softReference2.get();
                } else {
                    linkedList = new LinkedList();
                    this.setList.addFirst(new SoftReference(linkedList));
                }
            }
            linkedList.add(softReference);
        } else {
            if (this.useSoftReferences) {
                softReference = new SoftReference<Object>(softReference);
            }
            this.resourceSet.add(softReference);
        }
    }

    public int size() {
        Object object;
        int n = 0;
        if (this.useSoftReferences) {
            object = null;
            while ((object = (SoftReference)this.rq.poll()) != null) {
                this.resourceSet.remove(object);
            }
        }
        if (this.setList != null) {
            object = this.setList.listIterator();
            Set set = null;
            while (object.hasNext()) {
                set = (Set)object.next();
                n += set.size();
            }
        } else {
            n = this.resourceSet.size();
        }
        return n;
    }

    private Object tryGet() {
        Object var1_2;
        if (this.setList != null) {
            LinkedList linkedList = (LinkedList)((SoftReference)this.setList.getFirst()).get();
            if (linkedList.isEmpty()) {
                this.setList.addLast(this.setList.removeFirst());
                linkedList = (LinkedList)((SoftReference)this.setList.getFirst()).get();
            }
            var1_2 = linkedList.isEmpty() ? null : linkedList.removeFirst();
        } else if (this.resourceSet.isEmpty()) {
            var1_2 = null;
        } else {
            var1_2 = this.resourceSet.removeFirst();
            if (this.useSoftReferences) {
                var1_2 = ((SoftReference)var1_2).get();
            }
        }
        return var1_2;
    }
}

