/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Ffdc;
import com.ibm.ffdc.Manager;
import com.ibm.ws.ejbcontainer.util.BridgeTargetClassAdapter;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Map;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BridgeMethodUtil {
    private static final String CLASS_NAME = BridgeMethodUtil.class.getName();
    private static final TraceComponent tc = Tr.register(CLASS_NAME, "EJBContainer", "com.ibm.ejs.container.container");
    private final ClassLoader ivClassLoader;
    private final String ivResName;
    private Map<String, Method> ivBridgeTargetMap = null;

    public BridgeMethodUtil(Class<?> implClass) {
        this.ivClassLoader = implClass.getClassLoader();
        this.ivResName = implClass.getName().replace('.', '/') + ".class";
    }

    private BridgeMethodUtil() {
        this.ivClassLoader = null;
        this.ivResName = null;
    }

    public Method getBridgeTarget(Method[] implMethods, Method bridgeMethod) throws IllegalArgumentException {
        Method target;
        block10: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "getBridgeTarget for bridge method: " + bridgeMethod.toString());
            }
            if (!bridgeMethod.isBridge()) {
                throw new IllegalArgumentException("bridgeMethod argument is invalid. The " + bridgeMethod.toString() + " is NOT a bridge method.");
            }
            String key = BridgeTargetClassAdapter.getKeyForBridgeTargetMap(bridgeMethod);
            Method method = target = this.ivBridgeTargetMap == null ? null : this.ivBridgeTargetMap.get(key);
            if (target == null) {
                String targetMethodName = bridgeMethod.getName();
                int numBridgeArgs = bridgeMethod.getParameterTypes().length;
                for (Method method2 : implMethods) {
                    if (method2.isBridge() || !method2.getName().equals(targetMethodName) || method2.getParameterTypes().length != numBridgeArgs) continue;
                    if (target == null) {
                        target = method2;
                        continue;
                    }
                    target = null;
                    break;
                }
                if (target == null && this.ivBridgeTargetMap == null) {
                    try {
                        InputStream fis = this.ivClassLoader.getResourceAsStream(this.ivResName);
                        ClassReader cr = new ClassReader(fis);
                        ClassWriter cv = new ClassWriter(true);
                        BridgeTargetClassAdapter classAdapter = new BridgeTargetClassAdapter(cv, implMethods);
                        cr.accept((ClassVisitor)classAdapter, false);
                        this.ivBridgeTargetMap = classAdapter.getBridgeMethodTargetMap();
                        target = this.ivBridgeTargetMap.get(key);
                        fis.close();
                    }
                    catch (Throwable t) {
                        Ffdc ffdc = Manager.Ffdc.getFfdc(t, (Object)this, CLASS_NAME + ".getBridgeTarget", "187");
                        if (!ffdc.isLoggable()) break block10;
                        ffdc.log(new Object[]{this, implMethods, bridgeMethod});
                    }
                }
            }
        }
        if (target == null) {
            throw new IllegalArgumentException("The implementation class did not contain bridge method: " + bridgeMethod.toString() + ". Perhaps class file is not the result of javac from JDK 5 or later.");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getBridgeTarget returning bridge target method: " + target.toString());
        }
        return target;
    }
}

