/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.ssl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.ssl.SSLConfigChangeEvent;
import com.ibm.websphere.ssl.SSLConfigChangeListener;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ssl.JSSEProviderFactory;
import com.ibm.ws.ssl.config.ManagementScopeManager;
import com.ibm.ws.ssl.config.SSLConfig;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.ws.ssl.config.ThreadManager;
import com.ibm.ws.ssl.core.TraceNLSHelper;
import java.net.URLStreamHandler;
import java.security.Permission;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;

public class JSSEHelper {
    private static final TraceComponent tc = Tr.register(JSSEHelper.class, "SSL", "com.ibm.ws.ssl.resources.ssl");
    private static JSSEHelper thisClass = null;
    private static final WebSphereRuntimePermission GET_SSLCONFIG = new WebSphereRuntimePermission("getSSLConfig");
    private static final WebSphereRuntimePermission SET_SSLCONFIG = new WebSphereRuntimePermission("setSSLConfig");
    public static final String DIRECTION_INBOUND = "inbound";
    public static final String DIRECTION_OUTBOUND = "outbound";
    public static final String DIRECTION_UNKNOWN = "unknown";
    public static final String ENDPOINT_IIOP = "IIOP";
    public static final String ENDPOINT_HTTP = "HTTP";
    public static final String ENDPOINT_SIP = "SIP";
    public static final String ENDPOINT_JMS = "JMS";
    public static final String ENDPOINT_BUS_CLIENT = "BUS_CLIENT";
    public static final String ENDPOINT_BUS_TO_WEBSPHERE_MQ = "BUS_TO_WEBSPHERE_MQ";
    public static final String ENDPOINT_BUS_TO_BUS = "BUS_TO_BUS";
    public static final String ENDPOINT_CLIENT_TO_WEBSPHERE_MQ = "CLIENT_TO_WEBSPHERE_MQ";
    public static final String ENDPOINT_LDAP = "LDAP";
    public static final String ENDPOINT_ADMIN_SOAP = "ADMIN_SOAP";
    public static final String ENDPOINT_ADMIN_IPC = "ADMIN_IPC";
    public static final String CONNECTION_INFO_DIRECTION = "com.ibm.ssl.direction";
    public static final String CONNECTION_INFO_ENDPOINT_NAME = "com.ibm.ssl.endPointName";
    public static final String CONNECTION_INFO_REMOTE_HOST = "com.ibm.ssl.remoteHost";
    public static final String CONNECTION_INFO_REMOTE_PORT = "com.ibm.ssl.remotePort";
    public static final String CONNECTION_INFO_CERT_MAPPING_HOST = "com.ibm.ssl.certMappingHost";
    public static final String CONNECTION_INFO_IS_WEB_CONTAINER_INBOUND = "com.ibm.ssl.isWebContainerInbound";

    public static JSSEHelper getInstance() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance");
        }
        if (thisClass == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating new instance of JSSEHelper.");
            }
            thisClass = new JSSEHelper();
            if (!SSLConfigManager.getInstance().isServerProcess()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Attempting to initialize client configuration, if not already done.");
                }
                SSLConfigManager.getInstance().initializeClientSSL();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance", thisClass);
        }
        return thisClass;
    }

    public void setSSLPropertiesOnThread(Properties properties) {
        SSLConfig sSLConfig;
        String string;
        Object object;
        if (tc.isEntryEnabled()) {
            object = "Clearing thread properties.";
            if (properties != null) {
                object = properties != null && properties.getProperty("com.ibm.ssl.alias") != null ? "Setting thread properties: " + properties.getProperty("com.ibm.ssl.alias") : "Setting thread properties: " + properties.toString();
            }
            Tr.entry(tc, "setSSLPropertiesOnThread", new Object[]{object});
        }
        if ((object = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SET_SSLCONFIG.toString());
            }
            ((SecurityManager)object).checkPermission((Permission)SET_SSLCONFIG);
        }
        if (properties != null && (string = properties.getProperty("com.ibm.ssl.alias")) != null && (sSLConfig = SSLConfigManager.getInstance().getSSLConfig(string)) == null && (sSLConfig = new SSLConfig(properties)) != null) {
            try {
                SSLConfigManager.getInstance().addSSLConfigToMap(string, sSLConfig);
            }
            catch (Exception exception) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "The following exception occurred in setSSLPropertiesOnThread().", new Object[]{exception});
                }
                Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.websphere.ssl.JSSEHelper.setSSLPropertiesOnThread", "303", new Object[]{this});
            }
        }
        ThreadManager.getInstance().setPropertiesOnThread(properties);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSSLPropertiesOnThread");
        }
    }

    public Properties getSSLPropertiesOnThread() {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSSLPropertiesOnThread");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + GET_SSLCONFIG.toString());
            }
            securityManager.checkPermission((Permission)GET_SSLCONFIG);
        }
        Properties properties = ThreadManager.getInstance().getPropertiesOnThread();
        if (tc.isEntryEnabled()) {
            String string = "Thread properties are NULL.";
            if (properties != null) {
                string = properties != null && properties.getProperty("com.ibm.ssl.alias") != null ? "Found thread properties: " + properties.getProperty("com.ibm.ssl.alias") : "Found thread properties: " + properties.toString();
            }
            Tr.entry(tc, "getSSLPropertiesOnThread", new Object[]{string});
        }
        return properties;
    }

    public Properties getProperties(String string) throws SSLException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperties", new Object[]{string});
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + GET_SSLCONFIG.toString());
            }
            securityManager.checkPermission((Permission)GET_SSLCONFIG);
        }
        try {
            Properties properties;
            if (string != null && string.length() > 0 && (properties = SSLConfigManager.getInstance().getProperties(string)) != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getProperties -> direct");
                }
                return properties;
            }
        }
        catch (Exception exception) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "The following exception occurred in getProperties().", new Object[]{exception});
            }
            Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.websphere.ssl.JSSEHelper.getProperties", "408", new Object[]{this});
            if (exception instanceof SSLException) {
                throw (SSLException)exception;
            }
            throw new SSLException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProperties -> null");
        }
        return null;
    }

    public SSLContext getSSLContext(Map map, Properties properties) throws SSLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSSLContext", new Object[]{map});
        }
        if (properties != null) {
            SSLConfig sSLConfig = new SSLConfig(properties);
            String string = properties.getProperty("com.ibm.ssl.contextProvider");
            if (string == null) {
                string = "IBMJSSE2";
            }
            SSLContext sSLContext = null;
            try {
                sSLContext = JSSEProviderFactory.getInstance((String)string).getSSLContext(map, sSLConfig);
            }
            catch (Exception exception) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "The following exception occurred getting the SSLContext.", new Object[]{exception});
                }
                Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.websphere.ssl.JSSEHelper.getSSLContext", "452", new Object[]{this});
                if (exception instanceof SSLException) {
                    throw (SSLException)exception;
                }
                throw new SSLException(exception.getMessage(), exception);
            }
            if (sSLContext == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The SSLContext is null.  Throwing exception.");
                }
                throw new SSLException("The SSLContext returned is null.  Validate the Properties passed in.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSSLContext");
            }
            return sSLContext;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SSL client config properties are missing. The property 'com.ibm.SSL.ConfigURL' may not be set properly.");
        }
        String string = TraceNLSHelper.getInstance().getString("ssl.no.properties.error.CWPKI0315E", "SSL configuration properites are null. Could be a problem parsing the SSL client configuraton.");
        throw new SSLException(string);
    }

    public URLStreamHandler getURLStreamHandler(Properties properties) throws SSLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getURLStreamHandler");
        }
        try {
            SSLConfig sSLConfig = new SSLConfig(properties);
            String string = sSLConfig.getProperty("com.ibm.ssl.contextProvider");
            if (string == null) {
                string = "IBMJSSE2";
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getURLStreamHandler");
            }
            return JSSEProviderFactory.getInstance((String)string).getURLStreamHandler(sSLConfig);
        }
        catch (Exception exception) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "The following exception occurred getting the SSLContext.", new Object[]{exception});
            }
            Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.websphere.ssl.JSSEHelper.getSSLContext", "495", new Object[]{this});
            if (exception instanceof SSLException) {
                throw (SSLException)exception;
            }
            throw new SSLException(exception.getMessage(), exception);
        }
    }

    public SSLServerSocketFactory getSSLServerSocketFactory(Properties properties) throws SSLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSSLServerSocketFactory");
        }
        try {
            SSLConfig sSLConfig = new SSLConfig(properties);
            String string = sSLConfig.getProperty("com.ibm.ssl.contextProvider");
            if (string == null) {
                string = "IBMJSSE2";
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSSLServerSocketFactory");
            }
            return JSSEProviderFactory.getInstance((String)string).getSSLServerSocketFactory(sSLConfig);
        }
        catch (Exception exception) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "The following exception occurred in getSSLServerSocketFactory().", new Object[]{exception});
            }
            Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.websphere.ssl.JSSEHelper.getSSLServerSocketFactory", "538", new Object[]{this});
            if (exception instanceof SSLException) {
                throw (SSLException)exception;
            }
            throw new SSLException(exception);
        }
    }

    public SSLSocketFactory getSSLSocketFactory(Map map, Properties properties) throws SSLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSSLSocketFactory");
        }
        try {
            SSLConfig sSLConfig = new SSLConfig(properties);
            String string = sSLConfig.getProperty("com.ibm.ssl.contextProvider");
            if (string == null) {
                string = "IBMJSSE2";
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSSLSocketFactory");
            }
            return JSSEProviderFactory.getInstance((String)string).getSSLSocketFactory(map, sSLConfig);
        }
        catch (Exception exception) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "The following exception occurred in getSSLSocketFactory().", new Object[]{exception});
            }
            Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.websphere.ssl.JSSEHelper.getSSLSocketFactory", "579", new Object[]{this});
            if (exception instanceof SSLException) {
                throw (SSLException)exception;
            }
            throw new SSLException(exception);
        }
    }

    public SSLContext getSSLContext(String string, Map map, SSLConfigChangeListener sSLConfigChangeListener) throws SSLException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSSLContext", new Object[]{string, map, sSLConfigChangeListener});
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + GET_SSLCONFIG.toString());
            }
            securityManager.checkPermission((Permission)GET_SSLCONFIG);
        }
        try {
            SSLConfig sSLConfig = (SSLConfig)this.getProperties(string, map, sSLConfigChangeListener);
            if (sSLConfig != null) {
                SSLContext sSLContext;
                String string2 = sSLConfig.getProperty("com.ibm.ssl.contextProvider");
                if (string2 == null) {
                    string2 = "IBMJSSE2";
                }
                if ((sSLContext = JSSEProviderFactory.getInstance((String)string2).getSSLContext(map, sSLConfig)) != null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getSSLContext");
                    }
                    return sSLContext;
                }
                throw new SSLException("SSLContext could not be created from specified SSL properties.");
            }
            throw new SSLException("SSLContext could not be created due to null SSL properties.");
        }
        catch (Exception exception) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "The following exception occurred in getSSLContext().", new Object[]{exception});
            }
            Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.websphere.ssl.JSSEHelper.getSSLContext", "704", new Object[]{this});
            if (exception instanceof SSLException) {
                throw (SSLException)exception;
            }
            throw new SSLException(exception);
        }
    }

    public URLStreamHandler getURLStreamHandler(String string, Map map, SSLConfigChangeListener sSLConfigChangeListener) throws SSLException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getURLStreamHandler", new Object[]{string, map, sSLConfigChangeListener});
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + GET_SSLCONFIG.toString());
            }
            securityManager.checkPermission((Permission)GET_SSLCONFIG);
        }
        URLStreamHandler uRLStreamHandler = null;
        try {
            Properties properties = this.getProperties(string, map, sSLConfigChangeListener);
            String string2 = "IBMJSSE2";
            if (properties != null && (string2 = properties.getProperty("com.ibm.ssl.contextProvider")) == null) {
                string2 = "IBMJSSE2";
            }
            uRLStreamHandler = JSSEProviderFactory.getInstance((String)string2).getURLStreamHandler((SSLConfig)properties);
        }
        catch (Exception exception) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "The following exception occurred in getURLStreamHandler().", new Object[]{exception});
            }
            Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.websphere.ssl.JSSEHelper.getURLStreamHandler", "766", new Object[]{this});
            if (exception instanceof SSLException) {
                throw (SSLException)exception;
            }
            throw new SSLException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getURLStreamHandler");
        }
        return uRLStreamHandler;
    }

    public SSLSocketFactory getSSLSocketFactory(String string, Map map, SSLConfigChangeListener sSLConfigChangeListener) throws SSLException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSSLSocketFactory", new Object[]{string, map, sSLConfigChangeListener});
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + GET_SSLCONFIG.toString());
            }
            securityManager.checkPermission((Permission)GET_SSLCONFIG);
        }
        SSLSocketFactory sSLSocketFactory = null;
        try {
            SSLConfig sSLConfig = (SSLConfig)this.getProperties(string, map, sSLConfigChangeListener);
            String string2 = sSLConfig.getProperty("com.ibm.ssl.contextProvider");
            if (string2 == null) {
                string2 = "IBMJSSE2";
            }
            sSLSocketFactory = JSSEProviderFactory.getInstance((String)string2).getSSLSocketFactory(map, sSLConfig);
        }
        catch (Exception exception) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "The following exception occurred in getSSLSocketFactory().", new Object[]{exception});
            }
            Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.websphere.ssl.JSSEHelper.getSSLSocketFactory", "825", new Object[]{this});
            if (exception instanceof SSLException) {
                throw (SSLException)exception;
            }
            throw new SSLException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSSLSocketFactory");
        }
        return sSLSocketFactory;
    }

    public SSLServerSocketFactory getSSLServerSocketFactory(String string, Map map, SSLConfigChangeListener sSLConfigChangeListener) throws SSLException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSSLServerSocketFactory", new Object[]{string, map, sSLConfigChangeListener});
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + GET_SSLCONFIG.toString());
            }
            securityManager.checkPermission((Permission)GET_SSLCONFIG);
        }
        SSLServerSocketFactory sSLServerSocketFactory = null;
        try {
            SSLConfig sSLConfig = (SSLConfig)this.getProperties(string, map, sSLConfigChangeListener);
            String string2 = sSLConfig.getProperty("com.ibm.ssl.contextProvider");
            if (string2 == null) {
                string2 = "IBMJSSE2";
            }
            sSLServerSocketFactory = JSSEProviderFactory.getInstance((String)string2).getSSLServerSocketFactory(sSLConfig);
        }
        catch (Exception exception) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "The following exception occurred in getSSLServerSocketFactory().", new Object[]{exception});
            }
            Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.websphere.ssl.JSSEHelper.getSSLServerSocketFactory", "883", new Object[]{this});
            if (exception instanceof SSLException) {
                throw (SSLException)exception;
            }
            throw new SSLException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSSLServerSocketFactory");
        }
        return sSLServerSocketFactory;
    }

    public Properties getProperties(String string, Map map, SSLConfigChangeListener sSLConfigChangeListener) throws SSLException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperties", new Object[]{string, map, sSLConfigChangeListener});
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + GET_SSLCONFIG.toString());
            }
            securityManager.checkPermission((Permission)GET_SSLCONFIG);
        }
        try {
            Object object;
            Properties properties = this.getSSLPropertiesOnThread();
            if (properties != null) {
                SSLConfig sSLConfig = new SSLConfig(properties);
                if (sSLConfigChangeListener != null) {
                    String string2 = sSLConfig.getProperty("com.ibm.ssl.alias");
                    if (string2 == null) {
                        string2 = string;
                    }
                    this.registerEvent(sSLConfigChangeListener, string2, (Properties)sSLConfig, "thread", map);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getProperties -> programmatic");
                }
                return sSLConfig;
            }
            SSLConfig sSLConfig = (SSLConfig)SSLConfigManager.getInstance().getPropertiesFromDynamicSelectionInfo(map);
            if (sSLConfig != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getProperties -> dynamic");
                }
                if (sSLConfigChangeListener != null) {
                    String string3 = sSLConfig.getProperty("com.ibm.ssl.alias");
                    if (string3 == null) {
                        string3 = string;
                    }
                    this.registerEvent(sSLConfigChangeListener, string3, (Properties)sSLConfig, "dynamic", map);
                }
                return sSLConfig;
            }
            if (string != null && string.length() > 0 && (object = SSLConfigManager.getInstance().getProperties(string)) != null) {
                object = SSLConfigManager.getInstance().determineIfCSIv2SettingsApply((Properties)object, map);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getProperties -> direct");
                }
                if (sSLConfigChangeListener != null) {
                    this.registerEvent(sSLConfigChangeListener, string, (Properties)object, "direct", map);
                }
                return object;
            }
            if (SSLConfigManager.getInstance().isServerProcess() && (object = ManagementScopeManager.getInstance().getConfigAndCertAliasesFromGroups(map)) != null) {
                Properties properties2;
                String string4 = null;
                String string5 = null;
                StringTokenizer stringTokenizer = new StringTokenizer((String)object, ",");
                String[] stringArray = new String[stringTokenizer.countTokens()];
                int n = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    stringArray[n++] = stringTokenizer.nextToken();
                }
                if (stringArray != null && stringArray.length == 2) {
                    string4 = stringArray[0];
                    string5 = stringArray[1];
                } else if (stringArray != null && stringArray.length == 1) {
                    string4 = stringArray[0];
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "configAlias: " + string4 + ", certAlias: " + string5);
                }
                if (string4 != null && (properties2 = SSLConfigManager.getInstance().getProperties(string4)) != null) {
                    if (string5 != null) {
                        properties2 = (Properties)properties2.clone();
                    }
                    if (string5 != null && map != null) {
                        String string6 = (String)map.get(CONNECTION_INFO_DIRECTION);
                        if (string6 != null && string6.equals(DIRECTION_INBOUND)) {
                            properties2.setProperty("com.ibm.ssl.keyStoreServerAlias", string5);
                        } else if (string6 != null && string6.equals(DIRECTION_OUTBOUND)) {
                            properties2.setProperty("com.ibm.ssl.keyStoreClientAlias", string5);
                        }
                    } else if (string5 != null) {
                        properties2.setProperty("com.ibm.ssl.keyStoreServerAlias", string5);
                        properties2.setProperty("com.ibm.ssl.keyStoreClientAlias", string5);
                    }
                    properties2 = SSLConfigManager.getInstance().determineIfCSIv2SettingsApply(properties2, map);
                    if (sSLConfigChangeListener != null) {
                        this.registerEvent(sSLConfigChangeListener, string4, properties2, "scoped", map);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getProperties -> group");
                    }
                    return properties2;
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getProperties -> default");
            }
            return SSLConfigManager.getInstance().getDefaultSSLConfig();
        }
        catch (Exception exception) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "The following exception occurred in getSSLContext().", new Object[]{exception});
            }
            Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.websphere.ssl.JSSEHelper.getSSLContext", "1059", new Object[]{this});
            throw new SSLException(exception);
        }
    }

    private void registerEvent(SSLConfigChangeListener sSLConfigChangeListener, String string, Properties properties, String string2, Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerEvent", new Object[]{sSLConfigChangeListener, string, string2});
        }
        if (sSLConfigChangeListener != null) {
            SSLConfigChangeEvent sSLConfigChangeEvent = new SSLConfigChangeEvent(string, properties, string2, map);
            SSLConfigManager.getInstance().registerSSLConfigChangeListener(sSLConfigChangeListener, sSLConfigChangeEvent);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerEvent");
        }
    }

    public void registerSSLConfigChangeListener(String string, Map map, SSLConfigChangeListener sSLConfigChangeListener) throws SSLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerSSLConfigChangeListener", new Object[]{string, map, sSLConfigChangeListener});
        }
        this.getProperties(string, map, sSLConfigChangeListener);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerSSLConfigChangeListener");
        }
    }

    public void deregisterSSLConfigChangeListener(SSLConfigChangeListener sSLConfigChangeListener) throws SSLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deregisterSSLConfigChangeListener", new Object[]{sSLConfigChangeListener});
        }
        SSLConfigManager.getInstance().deregisterSSLConfigChangeListener(sSLConfigChangeListener);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deregisterSSLConfigChangeListener");
        }
    }

    public boolean doesSSLConfigExist(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doesSSLConfigExist", new Object[]{string});
        }
        if (string == null) {
            throw new IllegalArgumentException("sslAliasName is null.");
        }
        boolean bl = false;
        Properties properties = SSLConfigManager.getInstance().getProperties(string);
        if (properties != null) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doesSSLConfigExist -> " + bl);
        }
        return bl;
    }

    public void loadClientSSLPropertiesFromURL(String string, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseClientSSLPropertiesURL", new Object[]{string});
        }
        if (string == null) {
            throw new IllegalArgumentException("configURL is null.");
        }
        if (string != null && string.indexOf("soap.client.props") != -1) {
            SSLConfigManager.getInstance().parseConfigURL(ENDPOINT_ADMIN_SOAP, string, bl);
        } else if (string != null && string.indexOf("sas.client.props") != -1) {
            SSLConfigManager.getInstance().parseConfigURL(ENDPOINT_IIOP, string, bl);
        } else {
            SSLConfigManager.getInstance().parseSSLConfigURL(string, bl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseClientSSLPropertiesURL");
        }
    }

    public void reinitializeClientDefaultSSLProperties() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reinitializeClientDefaultSSLProperties");
        }
        SSLConfigManager.getInstance().reinitializeClientSSL();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reinitializeClientDefaultSSLProperties");
        }
    }

    public void validateSSLProperties(Properties properties) throws SSLException {
        SSLConfig sSLConfig = new SSLConfig(properties);
        try {
            sSLConfig.validateSSLConfig();
        }
        catch (Exception exception) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "The following exception occurred validating the SSL properties.", new Object[]{exception});
            }
            Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.websphere.ssl.JSSEHelper.validateSSLProperties", "1208", new Object[]{this});
            if (exception instanceof SSLException) {
                throw (SSLException)exception;
            }
            throw new SSLException(exception.getMessage(), exception);
        }
    }

    public Map getInboundConnectionInfo() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInboundConnectionInfo");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInboundConnectionInfo");
        }
        return ThreadManager.getInstance().getInboundConnectionInfo();
    }

    public void setInboundConnectionInfo(Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setInboundConnectionInfo");
        }
        ThreadManager.getInstance().setInboundConnectionInfo(map);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setInboundConnectionInfo");
        }
    }

    public Map getOutboundConnectionInfo() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOutboundConnectionInfo");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOutboundConnectionInfo");
        }
        return ThreadManager.getInstance().getOutboundConnectionInfo();
    }

    public void setOutboundConnectionInfo(Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setOutboundConnectionInfo");
        }
        ThreadManager.getInstance().setOutboundConnectionInfo(map);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setOutboundConnectionInfo");
        }
    }
}

