/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.servlet.response;

import com.ibm.websphere.servlet.response.DateHeaderField;
import com.ibm.websphere.servlet.response.HeaderField;
import com.ibm.websphere.servlet.response.HeaderFieldNames;
import com.ibm.websphere.servlet.response.IntHeaderField;
import com.ibm.websphere.servlet.response.NilHeaderField;
import com.ibm.websphere.servlet.response.StringHeaderField;
import java.io.Serializable;
import java.util.Enumeration;
import javax.servlet.http.HttpServletResponse;

class StoredHeader
implements Serializable {
    private static final long serialVersionUID = 3905521588232138806L;
    private HeaderField _field = NilHeaderField.instance();
    private int _size;

    public Enumeration getHeaderNames() {
        return new HeaderFieldNames(this._field);
    }

    public String getHeader(String name) {
        HeaderField f = this.getHeaderField(name);
        if (f != null) {
            return f.getStringValue();
        }
        return null;
    }

    public int getIntHeader(String name) {
        HeaderField f = this.getHeaderField(name);
        if (f != null) {
            return f.getIntValue();
        }
        return -1;
    }

    public long getDateHeader(String name) {
        HeaderField f = this.getHeaderField(name);
        if (f != null) {
            return f.getDateValue();
        }
        return -1L;
    }

    public boolean containsHeader(String name) {
        return this.getHeaderField(name) != null;
    }

    public synchronized void setHeader(String name, String value) {
        HeaderField f = this.getHeaderField(name);
        if (f != null) {
            f.setStringValue(value);
        } else {
            this._field = new StringHeaderField(name, value, this._field);
            ++this._size;
        }
    }

    public synchronized void setIntHeader(String name, int value) {
        HeaderField f = this.getHeaderField(name);
        if (f != null) {
            f.setIntValue(value);
        } else {
            this._field = new IntHeaderField(name, value, this._field);
            ++this._size;
        }
    }

    public synchronized void setDateHeader(String name, long value) {
        HeaderField f = this.getHeaderField(name);
        if (f != null) {
            f.setDateValue(value);
        } else {
            this._field = new DateHeaderField(name, value, this._field);
            ++this._size;
        }
    }

    public int getSize() {
        return this._size;
    }

    public void transferHeader(HttpServletResponse resp) {
        this._field.transferHeader(resp);
    }

    private HeaderField getHeaderField(String name) {
        String lName = name.toLowerCase();
        HeaderField f = this._field;
        while (!f.isNil()) {
            if (f.getName().toLowerCase().equals(lName)) {
                return f;
            }
            if (f.hasMoreFields()) {
                f = f.getNextField();
                continue;
            }
            return null;
        }
        return null;
    }
}

