/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.rsadapter;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.appprofile.accessintent.AccessIntent;
import com.ibm.websphere.ce.cm.DuplicateKeyException;
import com.ibm.websphere.ce.cm.StaleConnectionException;
import com.ibm.websphere.rsadapter.GenericDataStoreHelper;
import com.ibm.ws.rsadapter.AdapterUtil;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.resource.ResourceException;

public class DerbyDataStoreHelper
extends GenericDataStoreHelper {
    private static final TraceComponent tc = Tr.register(DerbyDataStoreHelper.class, "RRA", "com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    protected static final TraceComponent derbyTc = Tr.register("com.ibm.ws.derby.logwriter", "WAS.database", null);
    protected HashMap derbyErrorMap = new HashMap(13);
    private HashMap userNewMap = null;
    private static final int HASHSIZE = 13;

    public DerbyDataStoreHelper(Properties properties) {
        super(properties);
        this.addInitialMaps();
        this.dshMd.setGetTypeMapSupport(false);
        this.dshMd.setHelperType(19);
        this.dshMd.setDatabaseDefaultIsolationLevel(4, this.customDefinedWasDefaultIsoLevel);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "the Derby metadata is :", this.dshMd);
            Tr.debug(tc, "done constructing Derby helper", this);
        }
    }

    private void addInitialMaps() {
        this.derbyErrorMap.put("23505", DuplicateKeyException.class);
        this.derbyErrorMap.put("23500", DuplicateKeyException.class);
        this.derbyErrorMap.put("23L01", DuplicateKeyException.class);
        this.derbyErrorMap.put(new Integer(40000), StaleConnectionException.class);
        this.derbyErrorMap.put(new Integer(45000), StaleConnectionException.class);
        this.derbyErrorMap.put(new Integer(50000), StaleConnectionException.class);
    }

    public void doStatementCleanup(PreparedStatement preparedStatement) throws SQLException {
        preparedStatement.setCursorName(null);
        preparedStatement.setFetchDirection(1000);
        preparedStatement.setMaxFieldSize(0);
        preparedStatement.setMaxRows(0);
    }

    public final Class findMappingClass(SQLException sQLException) {
        Object var2_2 = null;
        String string = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findMappingClass for: " + sQLException);
        }
        if (tc.isEventEnabled()) {
            Tr.event(tc, "the DataStoreHelper is: ", this);
        }
        if (sQLException != null) {
            if (this.userNewMap != null) {
                var2_2 = this.userNewMap.get(new Integer(sQLException.getErrorCode()));
                if (var2_2 != null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "findMappingClass return: ", var2_2);
                    }
                    return var2_2;
                }
                string = sQLException.getSQLState();
                if (string != null && (var2_2 = this.userNewMap.get(string)) != null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "findMappingClass return: ", var2_2);
                    }
                    return var2_2;
                }
            }
            if (this.derbyErrorMap != null) {
                var2_2 = this.derbyErrorMap.get(new Integer(sQLException.getErrorCode()));
                if (var2_2 != null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "findMappingClass: return ", var2_2);
                    }
                    return var2_2;
                }
                string = sQLException.getSQLState();
                if (string != null) {
                    var2_2 = this.derbyErrorMap.get(string);
                }
            }
            if (var2_2 == null) {
                SQLException sQLException2 = sQLException.getNextException();
                if (sQLException2 != null && sQLException2 != sQLException) {
                    return this.findMappingClass(sQLException2);
                }
                return super.findMappingClass(sQLException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findMappingClass: return ", var2_2);
        }
        return var2_2;
    }

    public int getIsolationLevel(AccessIntent accessIntent) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getIsolationLevel, intent: ", accessIntent);
        }
        int n = this.dshMd.getDatabaseDefaultIsolationLevel();
        if (accessIntent != null) {
            if (accessIntent.getConcurrencyControl() == 2) {
                n = 2;
            } else if (accessIntent.getAccessType() == 2) {
                n = 4;
            } else {
                int n2 = accessIntent.getPessimisticUpdateLockHint();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The hint_value is: ", new Integer(n2));
                }
                switch (n2) {
                    case 2: 
                    case 3: {
                        n = 4;
                        break;
                    }
                    case 1: {
                        n = 2;
                        break;
                    }
                    case 4: {
                        n = 8;
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getIsolationLevel, return:", AdapterUtil.getIsolationLevelString((int)n));
        }
        return n;
    }

    public int getResultSetConcurrency(AccessIntent accessIntent) throws ResourceException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getResultSetConcurrency, return:ResultSet.CONCUR_READ_ONLY, intent:", accessIntent);
        }
        return 1007;
    }

    public final void setUserDefinedMap(Map map) {
        this.userNewMap = new HashMap(map);
    }
}

