/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.resource;

import com.ibm.websphere.resource.WASResourceFactoryRegistryImpl;
import com.ibm.websphere.resource.WASResourceImpl;
import com.ibm.websphere.resource.WASResourceSetImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.wst.common.internal.emf.resource.CompatibilityResourceFactory;

public class WASResourceFactoryImpl
extends CompatibilityResourceFactory {
    public static WASResourceFactoryImpl INSTANCE;

    public Resource createResource(URI uri) {
        return new WASResourceImpl(uri);
    }

    public static void register() {
        boolean debugEnabled = WASResourceSetImpl.debug;
        if (debugEnabled) {
            WASResourceFactoryImpl.debug("Registration of WAS factory extensions ...");
        }
        WASResourceFactoryImpl.register("xmi", INSTANCE);
        WASResourceFactoryImpl.register("xml", INSTANCE);
        WASResourceFactoryImpl.register("ecore", new EcoreResourceFactoryImpl());
        if (debugEnabled) {
            WASResourceFactoryImpl.debug("Registration of WAS factory extensions ... complete");
        }
    }

    public static void register(String extension2, Resource.Factory factory) {
        WASResourceFactoryRegistryImpl.INSTANCE.getExtensionToFactoryMap().put(extension2, factory);
        if (WASResourceSetImpl.debug) {
            WASResourceFactoryImpl.debug("Registered [ " + extension2 + " ] to factory [ " + factory.getClass().getName() + " ]");
        }
    }

    public static void debug(String text) {
        System.out.println("WASRSI: " + WASResourceFactoryImpl.class.getName() + ": " + text);
    }

    static {
        if (WASResourceSetImpl.debug) {
            WASResourceFactoryImpl.debug("Class Initialization");
        }
        INSTANCE = new WASResourceFactoryImpl();
    }
}

