/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.product.utils;

import com.ibm.websphere.product.WASProduct;
import com.ibm.websphere.product.filters.PTFFilenameFilter;
import com.ibm.websphere.product.history.filters.PTFAppliedFilenameFilter;
import com.ibm.websphere.product.history.filters.PTFDriverFilenameFilter;
import com.ibm.websphere.product.utils.EventHistoryInfo;
import com.ibm.websphere.product.utils.HistoryInfoEntityResolver;
import com.ibm.websphere.product.utils.SimpleXMLParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class HistoryInfoGenerator {
    public static final int N_XSL_ID_MAINTENANCE_HISTORY = 10;
    public static final int N_XSL_ID_MAINTENANCE_DRIVER = 20;
    public static final int N_XSL_ID_MAINTENANCE_APPLIED = 30;
    public static final int N_XSL_ID_MAINTENANCE_ID = 40;
    private static String S_BACKUP_DIR_PATH = null;
    private static String S_UPDATE_LOG_DIR_PATH = null;
    private static final String S_XSL_LIB = "xsl_lib";
    private static final String S_XSl_SELECTED = "XSL selected: ";
    private static final String S_SLASH = "/";
    private static final String S_YES = "yes";
    private static final String S_INDENT_AMOUNT = "{http://xml.apache.org/xslt}indent-amount";
    private static final String S_N_INDENT_AMOUNT = "4";
    private static final String S_EMPTY = "";
    private static final String S_FILENAME_MAINTENANCE_HISTORY = "MAINTENANCE_HISTORY.xsl";
    private static final String S_FILENAME_MAINTENANCE_DRIVER = "MAINTENANCE_DRIVER.xsl";
    private static final String S_FILENAME_MAINTENANCE_APPLIED = "MAINTENANCE_APPLIED.xsl";
    private static final String S_FILENAME_MAINTENANCE_ID = "MAINTENANCE_ID.xsl";
    private static final String S_DOT = ".";
    private static final String S_MAINTENANCE_DRIVER_FILE_EXT = "ptfDriver";
    private static final String S_MAINTENANCE_DRIVER_ELEMENT_NAME = "ptf-driver";
    private static final String S_MAINTENANCE_ID_NAME = "id";
    private static final String S_MAINTENANCE_DRIVER_APPLIED_DTD_FILENAME = "applied.dtd";
    private static final String S_MAINTENANCE_ID_DTD_FILENAME = "update.dtd";
    private static final String S_MAINTENANCE_APPLIED_FILE_EXT = "ptfApplied";
    private static final String S_MAINTENANCE_APPLIED_ELEMENT_NAME = "ptf-applied";
    private static final String S_MAINTENANCE_APPLIED_ID_NAME = "ptf-id";
    private static final String S_MAINTENANCE_ID_FILE_EXT = "ptf";
    private static final String S_MAINTENANCE_ID_ELEMENT_NAME = "ptf";
    private static final String S_WAS_LIB_DIR_NAME = "lib";
    private static final String S_WAS_PRODUCT_FILENAME = "wasproduct.jar";
    private static final String S_WAS_PLUGIN_DIR_NAME = "plugins";
    private static final String S_RUNTIME_BUNDLE_FILENAME = "com.ibm.ws.runtime.jar";
    private static final String S_MAINTENANCE_HISTORY_XML_FILENAME = "maintenanceHistory.xml";
    private static final String S_TEMP_FILENAME = "temp";
    private static final String S_TEMP_DRIVER_XML_FILENAME = "temp.ptfDriver";
    private static final String S_TEMP_APPLIED_XML_FILENAME = "temp.ptfApplied";
    private static final String S_TEMP_ID_XML_FILENAME = "temp.ptf";
    private static final String S_WAS_INSTALL_ROOT = "was.install.root";
    private static final String S_NIF_HISTORY_XML_FILENAME = "NIFHistory.xml";
    private static final String S_UPDATE_DIR_NAME = "update";
    private static final String S_CLONE_NIFHISTORY_FILE_NAME = "NIFHistory.xml.clone.xml";
    private static final String S_WAS_INSTALLED_AS_MAINTENANCE_ATTRIBUTE_VALUE = "wasinstalledasmaintenance";
    private static final String S_NAME_ATTRIBUTE = "name";
    private static final String S_VALUE_ATTRIBUTE = "value";
    private static Document m_documentSingleton = null;

    public static void transformHistoryXmls(String sBackupDirName, String sLogDirName, String sHistoryDirName, String sVersionDirName) throws TransformerException, IOException, ParserConfigurationException, SAXException {
        S_BACKUP_DIR_PATH = sBackupDirName;
        S_UPDATE_LOG_DIR_PATH = sLogDirName + File.separator + S_UPDATE_DIR_NAME;
        LinkedHashMap<Integer, String> lhmOutputFileName = new LinkedHashMap<Integer, String>();
        Integer iXslId = new Integer(0);
        String sEventHistoryFullPath = sHistoryDirName + File.separator + "event.history";
        File fileEventHistory = new File(sEventHistoryFullPath);
        if (fileEventHistory.exists()) {
            fileEventHistory.delete();
        }
        File[] ptfDriverFilesUnderHistoryDir = new File(sHistoryDirName).listFiles(new PTFDriverFilenameFilter());
        for (int i = 0; i < ptfDriverFilesUnderHistoryDir.length; ++i) {
            ptfDriverFilesUnderHistoryDir[i].delete();
        }
        File[] ptfAppliedFilesUnderHistoryDir = new File(sHistoryDirName).listFiles(new PTFAppliedFilenameFilter());
        for (int i = 0; i < ptfAppliedFilesUnderHistoryDir.length; ++i) {
            ptfAppliedFilesUnderHistoryDir[i].delete();
        }
        File[] ptfFilesUnderVersionDir = new File(sVersionDirName).listFiles(new PTFFilenameFilter());
        for (int i = 0; i < ptfFilesUnderVersionDir.length; ++i) {
            ptfFilesUnderVersionDir[i].delete();
        }
        String sMaintenanceHistoryXmlFullPath = null;
        String sNIFHistoryXmlFullPath = sBackupDirName + File.separator + S_NIF_HISTORY_XML_FILENAME;
        if (sBackupDirName.endsWith("nif" + File.separator + "backup")) {
            sMaintenanceHistoryXmlFullPath = sNIFHistoryXmlFullPath;
        } else if (sBackupDirName.endsWith(S_UPDATE_DIR_NAME + File.separator + "backup") && !new File(sMaintenanceHistoryXmlFullPath = sBackupDirName + File.separator + S_MAINTENANCE_HISTORY_XML_FILENAME).exists()) {
            sMaintenanceHistoryXmlFullPath = sNIFHistoryXmlFullPath;
        }
        if (!new File(sMaintenanceHistoryXmlFullPath).exists()) {
            return;
        }
        File fileNIFHistory = null;
        File fileCloneNIFHistory = null;
        if (sMaintenanceHistoryXmlFullPath.equals(sNIFHistoryXmlFullPath)) {
            sMaintenanceHistoryXmlFullPath = sHistoryDirName + File.separator + S_CLONE_NIFHISTORY_FILE_NAME;
            try {
                fileNIFHistory = new File(sNIFHistoryXmlFullPath);
                fileCloneNIFHistory = new File(sMaintenanceHistoryXmlFullPath);
                SimpleXMLParser sxpNIFHistory = new SimpleXMLParser(fileNIFHistory);
                m_documentSingleton = sxpNIFHistory.getDocument();
                if (m_documentSingleton.getDocumentElement().hasChildNodes()) {
                    HistoryInfoGenerator.removeFullInstallPakInfoFromDocument();
                    HistoryInfoGenerator.saveDocument(m_documentSingleton, fileCloneNIFHistory);
                }
                m_documentSingleton = null;
            }
            catch (Exception e) {
                System.err.println("The history xml file is not in xml format.");
                return;
            }
        }
        lhmOutputFileName.put(new Integer(10), sEventHistoryFullPath);
        String sTempDriverFullPath = sHistoryDirName + File.separator + S_TEMP_DRIVER_XML_FILENAME;
        lhmOutputFileName.put(new Integer(20), sTempDriverFullPath);
        String sTempAppliedFullPath = sHistoryDirName + File.separator + S_TEMP_APPLIED_XML_FILENAME;
        lhmOutputFileName.put(new Integer(30), sTempAppliedFullPath);
        String sTempIdFullPath = sVersionDirName + File.separator + S_TEMP_ID_XML_FILENAME;
        lhmOutputFileName.put(new Integer(40), sTempIdFullPath);
        String sOutputFileName = S_EMPTY;
        int nXslId = 0;
        Iterator it = lhmOutputFileName.keySet().iterator();
        EventHistoryInfo eventhistoryinfoThis = null;
        while (it.hasNext()) {
            iXslId = (Integer)it.next();
            nXslId = iXslId;
            sOutputFileName = (String)lhmOutputFileName.get(iXslId);
            try {
                HistoryInfoGenerator.transformXML(sMaintenanceHistoryXmlFullPath, sOutputFileName, nXslId);
            }
            catch (TransformerException te) {
                String msg = sMaintenanceHistoryXmlFullPath + ", " + sOutputFileName;
                throw new TransformerException(msg, te);
            }
            catch (IOException ioe) {
                String msg = sOutputFileName;
                throw new IOException(msg);
            }
            if (nXslId != 10) {
                HistoryInfoGenerator.breakFilesAccordingToElementName((String)lhmOutputFileName.get(iXslId), nXslId, eventhistoryinfoThis.getInstalledMaintenanceSet(), sVersionDirName);
                new File(sOutputFileName).delete();
                continue;
            }
            eventhistoryinfoThis = new EventHistoryInfo(new File(sOutputFileName), sVersionDirName);
        }
        if (fileCloneNIFHistory != null) {
            fileCloneNIFHistory.delete();
        }
    }

    private static void transformXML(String sInputFileFullPath, String sOutputFileFullPath, int nXslId) throws TransformerException, FileNotFoundException, IOException {
        String sXSLFileName = S_EMPTY;
        switch (nXslId) {
            case 10: {
                sXSLFileName = "xsl_lib/MAINTENANCE_HISTORY.xsl";
                break;
            }
            case 20: {
                sXSLFileName = "xsl_lib/MAINTENANCE_DRIVER.xsl";
                break;
            }
            case 30: {
                sXSLFileName = "xsl_lib/MAINTENANCE_APPLIED.xsl";
                break;
            }
            case 40: {
                sXSLFileName = "xsl_lib/MAINTENANCE_ID.xsl";
            }
        }
        ClassLoader currentClassLoader = HistoryInfoGenerator.class.getClassLoader();
        InputStream inputStreamFromClassLoader = currentClassLoader.getResourceAsStream(sXSLFileName);
        if (inputStreamFromClassLoader == null) {
            String sXSLClassPath = System.getProperty(S_WAS_INSTALL_ROOT) + File.separator + S_WAS_LIB_DIR_NAME + File.separator + S_WAS_PRODUCT_FILENAME;
            String sRuntimeBundleClassPath = System.getProperty(S_WAS_INSTALL_ROOT) + File.separator + S_WAS_PLUGIN_DIR_NAME + File.separator + S_RUNTIME_BUNDLE_FILENAME;
            if (!new File(sXSLClassPath).exists() && !new File(sXSLClassPath = sRuntimeBundleClassPath).exists()) {
                System.err.println("Runtime.jar doesn't exist under plugin dir.");
                return;
            }
            URL[] url = new URL[]{new File(sXSLClassPath).toURL()};
            URLClassLoader urlclassloader = new URLClassLoader(url);
            inputStreamFromClassLoader = urlclassloader.getResourceAsStream(sXSLFileName);
            if (inputStreamFromClassLoader == null) {
                System.err.println("Cannot load XSL files from " + sXSLClassPath);
                return;
            }
        }
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer(new StreamSource(inputStreamFromClassLoader));
        transformer.setOutputProperty("indent", S_YES);
        transformer.setOutputProperty(S_INDENT_AMOUNT, S_N_INDENT_AMOUNT);
        transformer.setParameter("fileseparator", File.separator);
        transformer.setParameter("logdirpath", S_UPDATE_LOG_DIR_PATH);
        transformer.setParameter("backupdirpath", S_BACKUP_DIR_PATH);
        FileOutputStream fosOutputFile = new FileOutputStream(sOutputFileFullPath);
        transformer.transform(new StreamSource(sInputFileFullPath), new StreamResult(fosOutputFile));
        fosOutputFile.close();
    }

    private static void breakFilesAccordingToElementName(String sSourceFilename, int nXslId, HashSet hashsetInstalledMaintenance, String sVersionDirPath) throws ParserConfigurationException, SAXException, IOException {
        File fileSourceFile;
        String sSourceFileExt = S_EMPTY;
        String sIdName = S_EMPTY;
        String sDTDFileName = S_EMPTY;
        switch (nXslId) {
            case 20: {
                sSourceFileExt = S_MAINTENANCE_DRIVER_FILE_EXT;
                sIdName = S_MAINTENANCE_ID_NAME;
                sDTDFileName = S_MAINTENANCE_DRIVER_APPLIED_DTD_FILENAME;
                break;
            }
            case 30: {
                sSourceFileExt = S_MAINTENANCE_APPLIED_FILE_EXT;
                sIdName = S_MAINTENANCE_APPLIED_ID_NAME;
                sDTDFileName = S_MAINTENANCE_DRIVER_APPLIED_DTD_FILENAME;
                break;
            }
            case 40: {
                sSourceFileExt = "ptf";
                sIdName = S_MAINTENANCE_ID_NAME;
                sDTDFileName = S_MAINTENANCE_ID_DTD_FILENAME;
            }
        }
        if (nXslId != 10 && (fileSourceFile = new File(sSourceFilename)) != null && fileSourceFile.exists()) {
            String sDTDDirPath = WASProduct.getDTDDirName(sVersionDirPath);
            HistoryInfoEntityResolver hierThis = new HistoryInfoEntityResolver(sDTDDirPath);
            SimpleXMLParser sxpSourceFile = null;
            try {
                sxpSourceFile = new SimpleXMLParser(fileSourceFile, true, (EntityResolver)hierThis);
            }
            catch (ParserConfigurationException e) {
                String sMsg = sSourceFilename;
                throw new ParserConfigurationException(sMsg);
            }
            catch (SAXException e) {
                String sMsg = sSourceFilename;
                throw new SAXException(sMsg);
            }
            catch (IOException e) {
                String sMsg = sSourceFilename;
                throw new IOException(sMsg);
            }
            Element elementDoc = sxpSourceFile.getDocument().getDocumentElement();
            Vector vNodesAvailable = SimpleXMLParser.getChildElements(elementDoc);
            LinkedHashMap<String, Node> nodesFilesToBeCreated = new LinkedHashMap<String, Node>();
            for (int i = 0; i < vNodesAvailable.size(); ++i) {
                Node nodeThis = (Node)vNodesAvailable.get(i);
                String sId = SimpleXMLParser.getNodeAttributeValue(nodeThis, sIdName);
                if (hashsetInstalledMaintenance == null || hashsetInstalledMaintenance.isEmpty() || !hashsetInstalledMaintenance.contains(sId) || !nodeThis.hasChildNodes()) continue;
                nodesFilesToBeCreated.put(sId, nodeThis);
            }
            Iterator itNodesFilesToBeCreated = nodesFilesToBeCreated.entrySet().iterator();
            while (itNodesFilesToBeCreated.hasNext()) {
                Node thisNode = (Node)itNodesFilesToBeCreated.next().getValue();
                String IdThisNode = SimpleXMLParser.getNodeAttributeValue(thisNode, sIdName);
                Document sourceDoc = sxpSourceFile.getDocument();
                DOMImplementation domiSource = sourceDoc.getImplementation();
                DocumentType docTypeSource = sourceDoc.getDoctype();
                String sQualifyName = thisNode.getNodeName();
                String sPublicId = docTypeSource.getPublicId();
                String sSystemId = docTypeSource.getSystemId();
                DocumentType docTypeTarget = domiSource.createDocumentType(sQualifyName, sPublicId, sSystemId);
                Document targetDoc = domiSource.createDocument(docTypeTarget.getNamespaceURI(), sQualifyName, docTypeTarget);
                Element targetDocElement = targetDoc.getDocumentElement();
                NamedNodeMap nodeAttributes = thisNode.getAttributes();
                for (int i = 0; i < nodeAttributes.getLength(); ++i) {
                    String attributeName = nodeAttributes.item(i).getNodeName();
                    String attributeValue = nodeAttributes.item(i).getNodeValue();
                    targetDocElement.setAttribute(attributeName, attributeValue);
                }
                DocumentFragment sourceDocFragment = sourceDoc.createDocumentFragment();
                Vector childNodesFromThisNode = SimpleXMLParser.getChildElements(thisNode);
                for (int i = 0; i < childNodesFromThisNode.size(); ++i) {
                    sourceDocFragment.appendChild((Node)childNodesFromThisNode.get(i));
                }
                DocumentFragment docFragementToBeImported = (DocumentFragment)targetDoc.importNode(sourceDocFragment, true);
                targetDocElement.appendChild(docFragementToBeImported);
                String sTargetFileName = new File(sSourceFilename).getParent() + File.separator + IdThisNode + S_DOT + sSourceFileExt;
                File fileTargetFile = new File(sTargetFileName);
                try {
                    HistoryInfoGenerator.saveDocument(targetDoc, fileTargetFile, sDTDFileName, true, "UTF-8");
                }
                catch (IOException e) {
                    String sMsg = sTargetFileName;
                    throw new IOException(sMsg);
                }
            }
        }
    }

    private static void removeFullInstallPakInfoFromDocument() {
        Vector vnodesMaintenanceEntries = new Vector();
        Vector<Node> vnodesMaintenanceEntriesToBeRemoved = new Vector<Node>();
        Element elementNIFRegistryRoot = m_documentSingleton.getDocumentElement();
        vnodesMaintenanceEntries.addAll(SimpleXMLParser.getChildElements(elementNIFRegistryRoot));
        Iterator iteratorMaintenanceEntries = vnodesMaintenanceEntries.iterator();
        while (iteratorMaintenanceEntries.hasNext()) {
            Vector vnodesUnderThisMaintenance = new Vector();
            Node nodeThisMaintenance = (Node)iteratorMaintenanceEntries.next();
            vnodesUnderThisMaintenance.addAll(SimpleXMLParser.getChildElements(nodeThisMaintenance));
            Iterator iteratorUnderThisMaintenance = vnodesUnderThisMaintenance.iterator();
            boolean fRemoveThisMaintenance = true;
            while (iteratorUnderThisMaintenance.hasNext()) {
                Node nodeThisParam = (Node)iteratorUnderThisMaintenance.next();
                String sParamName = SimpleXMLParser.getNodeAttributeValue(nodeThisParam, S_NAME_ATTRIBUTE);
                if (!sParamName.equals(S_WAS_INSTALLED_AS_MAINTENANCE_ATTRIBUTE_VALUE)) continue;
                String sIsWASInstalledAsMaintenance = SimpleXMLParser.getNodeAttributeValue(nodeThisParam, S_VALUE_ATTRIBUTE);
                if (!sIsWASInstalledAsMaintenance.equalsIgnoreCase("true")) break;
                fRemoveThisMaintenance = false;
                break;
            }
            if (fRemoveThisMaintenance) {
                vnodesMaintenanceEntriesToBeRemoved.add(nodeThisMaintenance);
                continue;
            }
            fRemoveThisMaintenance = false;
        }
        SimpleXMLParser.deleteChildNodes(elementNIFRegistryRoot, vnodesMaintenanceEntriesToBeRemoved);
    }

    private static void saveDocument(Document document, File fileTo) throws IOException {
        HistoryInfoGenerator.saveDocument(document, fileTo, null, false, null);
    }

    private static void saveDocument(Document document, File fileTo, String sDTDFileName, boolean bOmitXmlDeclaration, String encodingValue) throws IOException {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            FileOutputStream outputStream = new FileOutputStream(fileTo);
            DOMSource domsource = new DOMSource(document);
            StreamResult streamresult = new StreamResult(outputStream);
            transformer.setOutputProperty("indent", S_YES);
            transformer.setOutputProperty(S_INDENT_AMOUNT, S_N_INDENT_AMOUNT);
            if (sDTDFileName != null) {
                transformer.setOutputProperty("doctype-system", sDTDFileName);
            }
            if (bOmitXmlDeclaration) {
                transformer.setOutputProperty("omit-xml-declaration", S_YES);
            }
            if (encodingValue != null) {
                transformer.setOutputProperty("encoding", encodingValue);
            }
            transformer.transform(domsource, streamresult);
            ((OutputStream)outputStream).close();
            return;
        }
        catch (TransformerConfigurationException e) {
            throw new IOException(e.getMessage());
        }
        catch (TransformerException e) {
            throw new IOException(e.getMessage());
        }
    }
}

