/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.pmi;

import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.ws.pmi.stat.StatsConfigHelper;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;

public class PmiDataInfo
implements Serializable,
PmiConstants {
    private static final long serialVersionUID = -1609400918066043034L;
    private int id;
    private String name;
    private int type = -1;
    private String description = null;
    private String category = "all";
    private String unit = "unit.none";
    private int level = -1;
    private boolean resettable = true;
    private boolean aggregatable = true;
    private boolean zosAggregatable = true;
    private boolean onRequest = false;
    private String statSet = "all";
    private String platform = "all";
    private String submoduleName = null;
    private String participation = null;
    private String comment = null;
    private ArrayList dependencyList = null;

    public PmiDataInfo(int n) {
        this.id = n;
    }

    public PmiDataInfo(int n, String string, int n2, int n3, String string2) {
        this.id = n;
        this.name = string;
        this.type = n2;
        this.level = n3;
        this.description = string2;
        if (n2 == 4) {
            this.unit = "unit.ms";
        }
    }

    public PmiDataInfo(int n, String string, String string2, String string3, int n2, int n3, boolean bl) {
        this.id = n;
        this.name = string;
        this.unit = string2;
        this.description = string3;
        this.type = n2;
        this.level = n3;
        this.resettable = bl;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setType(int n) {
        this.type = n;
        if (this.level == -1) {
            switch (n) {
                case 1: 
                case 2: 
                case 3: {
                    this.level = 1;
                    break;
                }
                case 4: {
                    this.level = 3;
                    this.unit = "unit.ms";
                    break;
                }
                case 5: {
                    this.level = 7;
                    break;
                }
                case 15: {
                    this.level = 15;
                    break;
                }
            }
        }
    }

    public void setParticipation(String string) {
        this.participation = string;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setUnit(String string) {
        this.unit = string;
    }

    public void setCategory(String string) {
        this.category = string;
    }

    public void setLevel(int n) {
        this.level = n;
    }

    public void setStatisticSet(String string) {
        this.statSet = string;
    }

    public void setPlatform(String string) {
        this.platform = string;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public void setResettable(boolean bl) {
        this.resettable = bl;
    }

    public void setAggregatable(boolean bl) {
        this.aggregatable = bl;
    }

    public void setZosAggregatable(boolean bl) {
        this.zosAggregatable = bl;
    }

    public void setOnRequest(boolean bl) {
        this.onRequest = bl;
    }

    public void setSubmoduleName(String string) {
        this.submoduleName = string;
    }

    public void addDependency(int n) {
        if (this.dependencyList == null) {
            this.dependencyList = new ArrayList(2);
        }
        this.dependencyList.add(new Integer(n));
    }

    public ArrayList getDependency() {
        return this.dependencyList;
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public int getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUnit() {
        return this.unit;
    }

    public String getCategory() {
        return this.category;
    }

    public String getParticipation() {
        return this.participation;
    }

    public int getLevel() {
        return this.level;
    }

    public String getStatisticSet() {
        return this.statSet;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean isResettable() {
        return this.resettable;
    }

    public boolean isAggregatable() {
        return this.aggregatable;
    }

    public boolean isZosAggregatable() {
        return this.zosAggregatable;
    }

    public boolean isAvailableInPlatform(String string) {
        if (this.platform.equals("all")) {
            return true;
        }
        return this.platform.equals(string);
    }

    public boolean isUpdateOnRequest() {
        return this.onRequest;
    }

    public String getSubmoduleName() {
        return this.submoduleName;
    }

    void print(PrintWriter printWriter) {
        printWriter.println("id:" + this.id);
        printWriter.println("name:" + this.name);
        printWriter.println("type:" + this.type);
        printWriter.println("participation:" + this.participation);
        printWriter.println("level:" + this.level);
        printWriter.println("description:" + this.description);
        printWriter.println("comment:" + this.comment);
        printWriter.println("resettable:" + this.resettable);
        printWriter.println("submoduleName:" + this.submoduleName);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{name=").append(this.name);
        stringBuffer.append(", ID=").append(this.id);
        stringBuffer.append(", type=").append(StatsConfigHelper.getStatsType((int)this.type));
        stringBuffer.append(", description=").append(this.description);
        stringBuffer.append(", unit=").append(this.unit);
        stringBuffer.append(", level=").append(StatsConfigHelper.getLevelString((int)this.level));
        stringBuffer.append(", statisticSet=").append(this.statSet);
        stringBuffer.append(", resettable=").append(this.resettable);
        stringBuffer.append(", aggregatable=").append(this.aggregatable);
        stringBuffer.append(", zosAggregatable=").append(this.zosAggregatable);
        if (this.submoduleName != null) {
            stringBuffer.append(", submoduleName:").append(this.submoduleName);
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public PmiDataInfo copy() {
        PmiDataInfo pmiDataInfo = new PmiDataInfo(this.id);
        if (this.name != null) {
            pmiDataInfo.name = new String(this.name);
        }
        if (this.description != null) {
            pmiDataInfo.description = new String(this.description);
        }
        if (this.unit != null) {
            pmiDataInfo.unit = new String(this.unit);
        }
        pmiDataInfo.category = this.category;
        pmiDataInfo.type = this.type;
        pmiDataInfo.level = this.level;
        pmiDataInfo.resettable = this.resettable;
        pmiDataInfo.aggregatable = this.aggregatable;
        pmiDataInfo.zosAggregatable = this.zosAggregatable;
        pmiDataInfo.onRequest = this.onRequest;
        pmiDataInfo.statSet = this.statSet;
        pmiDataInfo.platform = this.platform;
        pmiDataInfo.submoduleName = this.submoduleName;
        pmiDataInfo.participation = this.participation;
        pmiDataInfo.comment = this.comment;
        pmiDataInfo.dependencyList = this.dependencyList;
        return pmiDataInfo;
    }
}

