/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.models.base.serialization;

import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.XMLSave;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;

public abstract class PMEXMLResourceImpl
extends XMLResourceImpl {
    protected String defaultNamespacePrefix;

    public PMEXMLResourceImpl(URI uri) {
        super(uri);
    }

    public String getDefaultNamespacePrefix() {
        return this.defaultNamespacePrefix != null ? this.defaultNamespacePrefix : "";
    }

    public EObject getRootChild(String childFeatureName) {
        EObject rootObject = this.getRootObject();
        if (rootObject == null) {
            return null;
        }
        EClass rootObjectEClass = rootObject.eClass();
        EStructuralFeature childFeature = rootObjectEClass.getEStructuralFeature(childFeatureName);
        EObject secondLevelObject = (EObject)rootObject.eGet(childFeature);
        return secondLevelObject;
    }

    public EObject getRootObject() {
        if (this.contents.isEmpty()) {
            return null;
        }
        EObject documentRoot = (EObject)this.getContents().get(0);
        EStructuralFeature rootFeature = this.getRootFeature();
        EObject rootObject = (EObject)documentRoot.eGet(rootFeature);
        return rootObject;
    }

    public void setDefaultNamespacePrefix(String namespacePrefix) {
        this.defaultNamespacePrefix = namespacePrefix;
    }

    public void setRootChild(String childFeatureName, EObject eObject) {
        EObject rootObject;
        EList contents = this.getContents();
        EObject documentRoot = null;
        if (contents.isEmpty()) {
            documentRoot = this.createDocumentRoot();
            contents.add(documentRoot);
        }
        if ((rootObject = this.getRootObject()) == null) {
            String rootClassName = this.getRootClassName();
            rootObject = this.createRootObject(rootClassName);
            EStructuralFeature rootFeature = this.getRootFeature();
            documentRoot.eSet(rootFeature, rootObject);
        }
        EClass rootObjectEClass = rootObject.eClass();
        EStructuralFeature childFeature = rootObjectEClass.getEStructuralFeature(childFeatureName);
        rootObject.eSet(childFeature, eObject);
    }

    protected EObject createDocumentRoot() {
        final EPackage pkg = this.getEPackage();
        EFactoryImpl factory = new EFactoryImpl(){

            public EPackage getEPackage() {
                return pkg;
            }
        };
        EClass documentRootEClass = this.getDocumentRootClass();
        EObject documentRoot = factory.create(documentRootEClass);
        Map defaultSaveOptions = this.getDefaultSaveOptions();
        ExtendedMetaData extendedMetaData = (ExtendedMetaData)defaultSaveOptions.get("EXTENDED_META_DATA");
        EReference xmlnsPrefixMapFeature = extendedMetaData.getXMLNSPrefixMapFeature(documentRootEClass);
        EMap prefixMap = (EMap)documentRoot.eGet(xmlnsPrefixMapFeature);
        String defaultNamespaceURI = this.getDefaultNamespaceURI();
        String defaultPrefix = this.getDefaultNamespacePrefix();
        prefixMap.put(defaultPrefix, defaultNamespaceURI);
        EReference xsiSchemaLocationFeature = extendedMetaData.getXSISchemaLocationMapFeature(documentRootEClass);
        EMap xsiSchemaLocationMap = (EMap)documentRoot.eGet(xsiSchemaLocationFeature);
        String schemaLocationURI = this.getSchemaLocationURI();
        xsiSchemaLocationMap.put(defaultNamespaceURI, schemaLocationURI);
        return documentRoot;
    }

    protected EObject createRootObject(String className) {
        final EPackage pkg = this.getEPackage();
        EFactoryImpl factory = new EFactoryImpl(){

            public EPackage getEPackage() {
                return pkg;
            }
        };
        EClass dynamicEClass = this.getDynamicClass(className);
        EObject rootObject = factory.create(dynamicEClass);
        return rootObject;
    }

    protected abstract XMLHelper createXMLHelper();

    protected abstract XMLLoad createXMLLoad();

    protected abstract XMLSave createXMLSave();

    protected abstract String getDefaultNamespaceURI();

    protected EClass getDocumentRootClass() {
        EClass documentRootClass = this.getDynamicClass("DocumentRoot");
        return documentRootClass;
    }

    protected EClass getDynamicClass(String name) {
        EPackage pkg = this.getEPackage();
        EClass rootEClass = (EClass)pkg.getEClassifier(name);
        return rootEClass;
    }

    protected abstract EPackage getEPackage();

    protected abstract String getRootClassName();

    protected EStructuralFeature getRootFeature() {
        EClass documentRootEClass = this.getDocumentRootClass();
        String rootFeatureName = this.getRootFeatureName();
        EStructuralFeature rootFeature = documentRootEClass.getEStructuralFeature(rootFeatureName);
        return rootFeature;
    }

    protected abstract String getRootFeatureName();

    protected abstract String getSchemaLocationURI();
}

