/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.configservice.tasks;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.AppManagementProxy;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.configservice.ConfigServiceProxy;
import com.ibm.websphere.management.exception.AppRefException;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.exception.InvalidRAScopeException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class UninstallRARTask {
    private final String DOMAIN = "WebSphere";
    private final int CELL_LEVEL = 1;
    private final int NODE_LEVEL = 2;
    private final int SERVER_LEVEL = 3;
    private static TraceComponent tc = Tr.register(UninstallRARTask.class, "management", "com.ibm.ws.management.resources.configservice");
    private ConfigService configService;

    public UninstallRARTask(ConfigService configService) {
        this.configService = configService;
    }

    public List uninstallResourceAdapter(Session session, ObjectName objectName, Hashtable hashtable) throws ConfigServiceException, ConnectorException {
        Object object;
        Object object2;
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "uninstallResourceAdapter", new Object[]{session, objectName, hashtable});
        }
        AdminClient adminClient = null;
        AdminService adminService = null;
        if (this.configService instanceof ConfigServiceProxy) {
            ConfigServiceProxy configServiceProxy = (ConfigServiceProxy)this.configService;
            adminClient = configServiceProxy.getAdminClient();
        } else {
            adminService = AdminServiceFactory.getAdminService();
            if (adminService == null) {
                String string = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0036E", new Object[]{"uninstallResourceAdapter"}, null);
                throw new UnsupportedOperationException(string);
            }
        }
        boolean bl = false;
        String string = (String)hashtable.get("force");
        if (string != null) {
            bl = true;
        }
        String string2 = (String)this.configService.getAttribute(session, objectName, "archivePath");
        Properties properties = ConfigServiceHelper.getObjectLocation(objectName);
        String string3 = properties.getProperty("server");
        String string4 = properties.getProperty("node");
        String string5 = properties.getProperty("cell");
        String string6 = "Cell";
        if (string3 != null) {
            string6 = "Server";
            String string7 = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0040E", new Object[]{ConfigServiceHelper.getDisplayName(objectName), string6}, null);
            throw new InvalidRAScopeException(string6, string7);
        }
        if (string4 == null) {
            String string8 = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0040E", new Object[]{ConfigServiceHelper.getDisplayName(objectName), string6}, null);
            throw new InvalidRAScopeException(string6, string8);
        }
        String string9 = null;
        ObjectName objectName2 = null;
        ObjectName objectName3 = null;
        ObjectName objectName4 = null;
        objectName4 = this.configService.getRelationship(session, objectName, "parent")[0];
        objectName3 = this.configService.getRelationship(session, objectName4, "parent")[0];
        ObjectName[] objectNameArray = this.configService.getRelationship(session, objectName3, "J2CResourceAdapter");
        for (int i = 0; i < objectNameArray.length; ++i) {
            objectName2 = objectNameArray[i];
            string9 = (String)this.configService.getAttribute(session, objectName2, "archivePath");
            if (!string9.equals(string2)) continue;
            if (bl) {
                Tr.warning(tc, "ADMG0038W", "Cell");
                continue;
            }
            String string10 = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0041E", new Object[]{ConfigServiceHelper.getDisplayName(objectName)}, null);
            throw new InvalidRAScopeException(ConfigServiceHelper.getDisplayName(objectName), string10);
        }
        ArrayList<ObjectName> arrayList = new ArrayList<ObjectName>();
        ArrayList<String> arrayList2 = new ArrayList<String>(20);
        ArrayList<String> arrayList3 = new ArrayList<String>(10);
        objectNameArray = this.configService.getRelationship(session, objectName4, "J2CResourceAdapter");
        for (int i = 0; i < objectNameArray.length; ++i) {
            objectName2 = objectNameArray[i];
            string9 = (String)this.configService.getAttribute(session, objectName2, "archivePath");
            if (!string9.equals(string2)) continue;
            arrayList.add(objectName2);
        }
        ObjectName[] objectNameArray2 = this.configService.getRelationship(session, objectName4, "Server");
        if (objectNameArray2 != null) {
            ObjectName objectName5 = null;
            for (int i = 0; i < objectNameArray2.length; ++i) {
                objectName5 = objectNameArray2[i];
                this.checkRAinObject(session, objectName5, arrayList, string2);
            }
        }
        for (n = 0; n < arrayList.size(); ++n) {
            ObjectName objectName6;
            Object var24_34 = null;
            object2 = null;
            object2 = (ObjectName)arrayList.get(n);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "raObj=" + object2);
            }
            if ((object = (String)this.configService.getAttribute(session, (ObjectName)object2, "archivePath")) == null || bl) continue;
            String string11 = null;
            ObjectName[] objectNameArray3 = null;
            List list = null;
            List list2 = null;
            try {
                objectNameArray3 = this.configService.getRelationship(session, (ObjectName)object2, "J2CConnectionFactory");
            }
            catch (Exception exception) {
                Tr.warning(tc, "ADMG0039W", new Object[]{"J2CConnectionFactory", object2});
            }
            AttributeList attributeList = null;
            try {
                attributeList = this.configService.getAttributes(session, (ObjectName)object2, new String[]{"j2cAdminObjects"}, false);
                list = (List)ConfigServiceHelper.getAttributeValue(attributeList, "j2cAdminObjects");
            }
            catch (Exception exception) {
                Tr.warning(tc, "ADMG0039W", new Object[]{"J2CAdminObject", object2});
            }
            try {
                attributeList = this.configService.getAttributes(session, (ObjectName)object2, new String[]{"j2cActivationSpec"}, false);
                list2 = (List)ConfigServiceHelper.getAttributeValue(attributeList, "j2cActivationSpec");
            }
            catch (Exception exception) {
                Tr.warning(tc, "ADMG0039W", new Object[]{"J2CActivationSpec", object2});
            }
            if (objectNameArray3 != null) {
                for (int i = 0; i < objectNameArray3.length; ++i) {
                    objectName6 = objectNameArray3[i];
                    string11 = (String)this.configService.getAttribute(session, objectName6, "jndiName");
                    arrayList2.add(string11);
                }
            }
            if (list2 != null) {
                for (int i = 0; i < list2.size(); ++i) {
                    objectName6 = (ObjectName)list2.get(i);
                    string11 = (String)this.configService.getAttribute(session, objectName6, "jndiName");
                    arrayList2.add(string11);
                }
            }
            if (list == null) continue;
            for (int i = 0; i < list.size(); ++i) {
                objectName6 = (ObjectName)list.get(i);
                string11 = (String)this.configService.getAttribute(session, objectName6, "jndiName");
                arrayList2.add(string11);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "jndiList=" + arrayList2);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            ObjectName objectName7 = (ObjectName)arrayList.get(n);
            object2 = objectName7.getKeyProperty("_Websphere_Config_Data_Id");
            object = ConfigServiceHelper.getDisplayName(objectName7);
            arrayList3.add((String)object + "(" + (String)object2 + ")");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "mList=" + arrayList3);
        }
        Hashtable hashtable2 = new Hashtable(5);
        String string12 = "WebSphere:cell=" + string5 + ",node=" + string4;
        if (!bl) {
            try {
                object2 = null;
                object2 = adminClient != null ? AppManagementProxy.getJMXProxyForClient(adminClient) : AppManagementProxy.getLocalProxy();
                hashtable2 = object2.searchJNDIReferences(arrayList2, string12, null, null);
            }
            catch (Exception exception) {
                Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.websphere.management.configservice.tasks.uninstallRARTask", "434", new Object[]{this});
                throw new ConfigServiceException(exception);
            }
            if (!hashtable2.isEmpty()) {
                throw new AppRefException(arrayList3, hashtable2);
            }
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            try {
                object = (ObjectName)arrayList.get(i);
                this.configService.deleteConfigData(session, (ObjectName)object);
                continue;
            }
            catch (Exception exception) {
                Manager.Ffdc.log((Throwable)exception, (Object)this, "com.ibm.websphere.management.configservice.tasks.uninstallRARTask", "460", new Object[]{this});
                throw new ConfigServiceException(exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "uninstallResourceAdapter", arrayList3);
        }
        return arrayList3;
    }

    private String cleanString(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanString");
        }
        if (string.startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanString");
        }
        return string;
    }

    void checkRAinObject(Session session, ObjectName objectName, List list, String string) throws ConfigServiceException, ConnectorException {
        try {
            ObjectName[] objectNameArray = this.configService.getRelationship(session, objectName, "J2CResourceAdapter");
            ObjectName objectName2 = null;
            String string2 = null;
            for (int i = 0; i < objectNameArray.length; ++i) {
                objectName2 = objectNameArray[i];
                string2 = (String)this.configService.getAttribute(session, objectName2, "archivePath");
                if (!string.equals(string2)) continue;
                list.add(objectName2);
            }
        }
        catch (ConfigServiceException configServiceException) {
            Manager.Ffdc.log((Throwable)configServiceException, (Object)this, "com.ibm.websphere.management.configservice.tasks.uninstallRARTask", "646", new Object[]{this});
            throw configServiceException;
        }
        catch (ConnectorException connectorException) {
            Manager.Ffdc.log((Throwable)connectorException, (Object)this, "com.ibm.websphere.management.configservice.tasks.uninstallRARTask", "649", new Object[]{this});
            throw connectorException;
        }
    }
}

