/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management;

import com.ibm.ISecurityUtilityImpl.RealmSecurityName;
import com.ibm.ISecurityUtilityImpl.StringBytesConversion;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.exception.InvalidAdminClientTypeException;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.callback.NonPromptCallbackHandler;
import com.ibm.websphere.security.auth.callback.WSCcacheCallBackHandlerImpl;
import com.ibm.websphere.security.auth.callback.WSGUICallbackHandlerImpl;
import com.ibm.websphere.security.auth.callback.WSStdinCallbackHandlerImpl;
import com.ibm.ws.management.AdminDataHolder;
import com.ibm.ws.management.connector.NullConnector;
import com.ibm.ws.management.util.DebugUtils;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.SSLConfig;
import java.awt.GraphicsEnvironment;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationHandler;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.swing.JFrame;

public abstract class AdminClientFactory {
    private static final String bundleName = "com.ibm.ws.management.resources.connector";
    private static TraceComponent tc = Tr.register(AdminClientFactory.class, "Admin", "com.ibm.ws.management.resources.connector");
    private static final TraceNLS connectorNLS = TraceNLS.getTraceNLS("com.ibm.ws.management.resources.connector");
    private static final String SOAP_PROXY_CLASS = "com.ibm.ws.management.connector.soap.SOAPConnectorClient";
    private static final String RMI_PROXY_CLASS = "com.ibm.ws.management.connector.rmi.RMIConnectorClient";
    private static final String JSR160RMI_PROXY_CLASS = "com.ibm.ws.management.connector.jsr160rmi.JSR160RMIConnectorClient";
    private static final String IPC_PROXY_CLASS = "com.ibm.ws.management.connector.ipc.IPCConnectorClient";
    private static final String ADMIN_CLIENT_IMPL_CLASS = "com.ibm.ws.management.AdminClientImpl";
    private static final String ADMIN_SERVICE_PROXY_CLASS = "com.ibm.ws.management.connector.AdminServiceProxy";
    private static WebSphereRuntimePermission adminPermission = new WebSphereRuntimePermission("AdminPermission");
    private static Class thisClass = AdminClientFactory.class;
    private static Hashtable cachedClients = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static AdminClient createAdminClient(Properties var0) throws ConnectorException {
        if (AdminClientFactory.tc.isEntryEnabled()) {
            Tr.entry(AdminClientFactory.tc, "createAdminClient");
        }
        if (AdminClientFactory.tc.isDebugEnabled()) {
            Tr.debug(AdminClientFactory.tc, "Properties passed to createAdminClient");
        }
        AdminClientFactory.showDebugInfo((Properties)var0);
        var1_1 = null;
        if (SecurityContext.isServerProcess() && (var2_2 = System.getSecurityManager()) != null) {
            var2_2.checkPermission((Permission)AdminClientFactory.adminPermission);
        }
        if ((var2_2 = (String)var0.get("type")) == null) {
            if (AdminClientFactory.tc.isEntryEnabled()) {
                Tr.exit(AdminClientFactory.tc, "createAdminClient");
            }
            throw new InvalidAdminClientTypeException();
        }
        var3_3 = null;
        var4_4 = AdminClientFactory.getCacheKey((String)var2_2, (Properties)var0);
        var5_5 = AdminClientFactory.cachedClients;
        synchronized (var5_5) {
            var1_1 = (AdminClient)AdminClientFactory.cachedClients.get(var4_4);
        }
        if (var1_1 != null) {
            if (AdminClientFactory.tc.isDebugEnabled()) {
                Tr.debug(AdminClientFactory.tc, "Cached admin client found");
            }
            try {
                var5_5 = (String)var0.get("username");
                var6_9 = (String)var0.get("password");
                if (!SecurityContext.isServerProcess() && ("RMI".equalsIgnoreCase((String)var2_2) || "JSR160RMI".equalsIgnoreCase((String)var2_2)) && var5_5 != null && var5_5.trim().length() > 0 && var6_9 != null && var6_9.trim().length() > 0) {
                    var7_12 = SubjectHelper.createBasicAuthSubject(null, (String)var5_5, (String)var6_9);
                    SecurityContext.getContextManager().setInvocationSubject(var7_12);
                    var1_1.getConnectorProperties().put("username", var5_5);
                    var1_1.getConnectorProperties().put("password", var6_9);
                }
                var1_1.isAlive();
                if (AdminClientFactory.tc.isEntryEnabled()) {
                    Tr.exit(AdminClientFactory.tc, "createAdminClient - in cache");
                }
                return var1_1;
            }
            catch (Exception var5_6) {
                if (AdminClientFactory.tc.isDebugEnabled()) {
                    Tr.debug(AdminClientFactory.tc, "invalid cached client, try to recreate", var5_6);
                }
                var6_10 = AdminClientFactory.cachedClients;
                synchronized (var6_10) {
                    AdminClientFactory.cachedClients.remove(var4_4);
                }
                var1_1 = null;
            }
        }
        var5_7 = false;
        if (var2_2.equalsIgnoreCase("NULL")) {
            var1_1 = AdminClientFactory.createNullConnectorClient((Properties)var0);
        } else if (var2_2.equalsIgnoreCase("SOAP")) {
            var6_10 = null;
            if (!new Boolean(var0.getProperty("isInternal")).booleanValue()) {
                var7_13 = var0.getProperty("com.ibm.SOAP.ConfigURL");
                if (var7_13 == null) {
                    var7_13 = System.getProperty("com.ibm.SOAP.ConfigURL");
                }
                if (var7_13 == null) {
                    var8_23 = System.getProperty("user.install.root");
                    if (var8_23 == null) {
                        var8_23 = System.getProperty("was.install.root");
                    }
                    var7_13 = "file:" + (String)var8_23 + "/properties/soap.client.props";
                }
                if (var7_13 != null) {
                    var8_23 = var7_13;
                    var6_10 = (Properties)com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedAction((String)var8_23){
                        final /* synthetic */ String val$url;
                        {
                            this.val$url = string;
                        }

                        public Object run() {
                            Properties properties = AdminClientFactory.loadPropertiesFromFile(this.val$url);
                            return properties;
                        }
                    });
                }
            }
            if ((var7_13 = var0.getProperty("securityEnabled")) == null && var6_10 != null) {
                var7_13 = var6_10.getProperty("securityEnabled");
                var8_23 = var6_10.getProperty("com.ibm.ssl.alias");
                if (var8_23 != null) {
                    var6_10.setProperty("sslConfig", (String)var8_23);
                }
                if (var8_23 == null) {
                    var6_10.setProperty("sslConfig", "ADMIN_SOAP");
                }
                if (AdminClientFactory.tc.isDebugEnabled()) {
                    Tr.debug(AdminClientFactory.tc, "soap ssl alias: " + (String)var8_23);
                }
            }
            if (var6_10 != null) {
                var6_10.putAll((Map<?, ?>)var0);
                var0 = var6_10;
            }
            var8_23 = (Properties)var0.clone();
            var5_7 = new Boolean(var7_13);
            if (var5_7) {
                var8_23.remove("securityEnabled");
            } else {
                var8_23.setProperty("securityEnabled", "true");
            }
            try {
                var9_27 = Class.forName("com.ibm.ws.management.connector.soap.SOAPConnectorClient");
                var10_33 = Class.forName("com.ibm.ws.management.AdminClientImpl");
                var11_37 = new Class[]{Properties.class};
                var12_41 = var9_27.getConstructor(var11_37);
                try {
                    if (AdminClientFactory.tc.isDebugEnabled()) {
                        Tr.debug(AdminClientFactory.tc, "Before 1st attempt to new up com.ibm.ws.management.connector.soap.SOAPConnectorClient");
                    }
                    AdminClientFactory.showDebugInfo((Properties)var0);
                    var13_47 = (InvocationHandler)var12_41.newInstance(new Object[]{var0});
                }
                catch (Exception var14_53) {
                    block176: {
                        var15_58 = AdminClientFactory.getAltCacheKey(var4_4);
                        var16_63 = AdminClientFactory.cachedClients;
                        synchronized (var16_63) {
                            var1_1 = (AdminClient)AdminClientFactory.cachedClients.get(var15_58);
                        }
                        if (var1_1 != null) {
                            if (AdminClientFactory.tc.isDebugEnabled()) {
                                Tr.debug(AdminClientFactory.tc, "Alternate cached admin client found");
                            }
                            try {
                                var1_1.isAlive();
                                if (AdminClientFactory.tc.isEntryEnabled()) {
                                    Tr.exit(AdminClientFactory.tc, "createAdminClient - alternate in cache");
                                }
                                return var1_1;
                            }
                            catch (Throwable var16_64) {
                                if (!AdminClientFactory.tc.isDebugEnabled()) break block176;
                                Tr.debug(AdminClientFactory.tc, "Alternate cached admin client is not available", var16_64);
                            }
                        }
                    }
                    if (AdminClientFactory.tc.isDebugEnabled()) {
                        Tr.debug(AdminClientFactory.tc, "Try to new up the com.ibm.ws.management.connector.soap.SOAPConnectorClient instance again using alternative Properties after the 1st attempt failed with", var14_53);
                    }
                    var3_3 = var14_53;
                    AdminClientFactory.showDebugInfo((Properties)var8_23);
                    var13_47 = (InvocationHandler)var12_41.newInstance(new Object[]{var8_23});
                    v0 = var5_7 = var5_7 == false;
                }
                if (!SecurityContext.isServerProcess() && var5_7) {
                    var14_54 = (String)var0.get("username");
                    var15_58 = (String)var0.get("password");
                    var16_63 = (String)var0.get("loginsource");
                    var17_69 = (String)var0.get("authTarget");
                    var18_71 = (String)var0.get("krb5Ccache");
                    var19_73 = (String)var0.get("krb5Config");
                    var20_75 = (String)var0.get("krb5Service");
                    var21_78 = (String)var0.get("krb5RefreshingTicket");
                    if (AdminClientFactory.tc.isDebugEnabled()) {
                        Tr.debug(AdminClientFactory.tc, "authTarget: " + var17_69);
                        Tr.debug(AdminClientFactory.tc, "User: " + (String)var14_54);
                        Tr.debug(AdminClientFactory.tc, "krb5Ccache: " + var18_71);
                        Tr.debug(AdminClientFactory.tc, "krb5Config: " + var19_73);
                        Tr.debug(AdminClientFactory.tc, "krb5Config: " + var20_75);
                        Tr.debug(AdminClientFactory.tc, "krb5RefreshingTicket: " + var21_78);
                    }
                    if (var17_69 == null || var17_69.length() == 0 || var17_69.equalsIgnoreCase("BasicAuth")) {
                        if (var14_54 != null && var14_54.length() > 0 && var15_58 != null && var15_58.length() > 0) {
                            var22_80 = SubjectHelper.createBasicAuthSubject(null, (String)var14_54, (String)var15_58);
                            AdminDataHolder.setData((Object)"wsSubject", (Object)var22_80);
                            if (AdminClientFactory.tc.isDebugEnabled()) {
                                Tr.debug(AdminClientFactory.tc, "Saving the Subject for Soap connector. ValueNull:" + (var22_80 == null));
                            }
                        } else if (var16_63 != null && (var16_63.equals("stdin") || var16_63.equals("prompt"))) {
                            block177: {
                                if (AdminClientFactory.tc.isDebugEnabled()) {
                                    Tr.debug(AdminClientFactory.tc, "About to login using JAAS");
                                }
                                var22_81 = null;
                                var23_84 = null;
                                var24_86 = ContextManagerFactory.getInstance().getDefaultRealm();
                                try {
                                    var22_81 = AdminClientFactory.jaas_login(var17_69, (String)var16_63, (String)var14_54, (String)var15_58, var24_86, var18_71, var19_73);
                                    if (var22_81 == null) break block177;
                                    AdminDataHolder.setData((Object)"wsSubject", (Object)var22_81);
                                    var23_84 = SubjectHelper.getWSCredentialFromSubject((Subject)var22_81);
                                    var14_54 = var23_84.getSecurityName();
                                    if (var14_54.startsWith(ContextManagerFactory.getInstance().getDefaultRealm())) {
                                        var14_54 = RealmSecurityName.getSecurityName((String)var14_54);
                                        if (AdminClientFactory.tc.isDebugEnabled()) {
                                            Tr.debug(AdminClientFactory.tc, "New username: " + (String)var14_54);
                                        }
                                    }
                                    var15_58 = StringBytesConversion.getConvertedString((byte[])var23_84.getCredentialToken());
                                    var0.put("username", var14_54);
                                    var0.put("password", var15_58);
                                    var8_23.put("username", var14_54);
                                    var8_23.put("password", var15_58);
                                    var25_91 = var9_27.getDeclaredMethod("setUserAndPwd", new Class[]{String.class, String.class});
                                    var25_91.invoke((Object)var13_47, new Object[]{var14_54, var15_58});
                                }
                                catch (WSLoginFailedException var25_93) {
                                    if (AdminClientFactory.tc.isDebugEnabled()) {
                                        Tr.debug(AdminClientFactory.tc, "WSLoginFailedException occurred: ", new Object[]{var25_93});
                                    }
                                    Manager.Ffdc.log((Throwable)var25_93, (Object)AdminClientFactory.thisClass, "com.ibm.websphere.management.AdminClientFactory.createAdminClient", "469");
                                }
                                catch (Exception var25_94) {
                                    if (AdminClientFactory.tc.isDebugEnabled()) {
                                        Tr.debug(AdminClientFactory.tc, "Exception occurred during JAAS login: ", new Object[]{var25_94});
                                    }
                                    Manager.Ffdc.log((Throwable)var25_94, (Object)AdminClientFactory.thisClass, "com.ibm.websphere.management.AdminClientFactory.createAdminClient", "473");
                                }
                            }
                            if (AdminClientFactory.tc.isDebugEnabled()) {
                                Tr.debug(AdminClientFactory.tc, "Saving the wscredential for Soap connector. ValueNull:" + (var23_84 == null));
                            }
                        }
                    }
                }
                var11_37[0] = InvocationHandler.class;
                var14_54 = var10_33.getConstructor(var11_37);
                var1_1 = (AdminClient)var14_54.newInstance(new Object[]{var13_47});
                if (var0.getProperty("username") != null && var0.getProperty("password") != null) {
                    var1_1.getConnectorProperties().setProperty("username", var0.getProperty("username"));
                    var1_1.getConnectorProperties().setProperty("password", var0.getProperty("password"));
                }
                if (AdminClientFactory.tc.isDebugEnabled()) {
                    Tr.debug(AdminClientFactory.tc, "soap client props now = " + DebugUtils.createPropertiesMaskPlainTextPassword((Properties)var1_1.getConnectorProperties()));
                }
                if (!AdminClientFactory.tc.isDebugEnabled()) ** GOTO lbl513
                Tr.debug(AdminClientFactory.tc, "SOAPConnectorClient is created");
            }
            catch (Exception var9_28) {
                if (AdminClientFactory.tc.isEntryEnabled()) {
                    Tr.exit(AdminClientFactory.tc, "createAdminClient - failed", var9_28);
                }
                if (var3_3 != null) {
                    var9_29 = var3_3;
                }
                throw new ConnectorException(AdminClientFactory.connectorNLS.getFormattedMessage("ADMC0016E", new Object[]{var0.getProperty("host"), var0.getProperty("port")}, "Could not create SOAP Connector to connect to host {0} at port {1}"), var9_29);
            }
        } else if (var2_2.equalsIgnoreCase("RMI")) {
            var5_7 = new Boolean(var0.getProperty("securityEnabled"));
            var6_10 = (Properties)var0.clone();
            if (var5_7) {
                var6_10.remove("securityEnabled");
            } else {
                var6_10.setProperty("securityEnabled", "true");
            }
            try {
                block178: {
                    var7_14 = Class.forName("com.ibm.ws.management.connector.rmi.RMIConnectorClient");
                    var8_24 = Class.forName("com.ibm.ws.management.AdminClientImpl");
                    var9_30 = new Class[]{Properties.class};
                    var10_34 = var7_14.getConstructor(var9_30);
                    try {
                        if (AdminClientFactory.tc.isDebugEnabled()) {
                            Tr.debug(AdminClientFactory.tc, "Before 1st attempt to create connector instance...");
                        }
                        AdminClientFactory.showDebugInfo((Properties)var0);
                        var11_38 = var10_34.newInstance(new Object[]{var0});
                    }
                    catch (Exception var12_42) {
                        if (AdminClientFactory.tc.isDebugEnabled()) {
                            Tr.debug(AdminClientFactory.tc, "try alternative connector properties after receiving the following exception", var12_42);
                        }
                        var3_3 = var12_42;
                        AdminClientFactory.showDebugInfo((Properties)var6_10);
                        var11_38 = var10_34.newInstance(new Object[]{var6_10});
                        var5_7 = var5_7 == false;
                    }
                    var9_30[0] = Class.forName("com.ibm.ws.management.connector.AdminServiceProxy");
                    var12_43 = var8_24.getConstructor(var9_30);
                    var1_1 = (AdminClient)var12_43.newInstance(new Object[]{var11_38});
                    try {
                        if (!SecurityContext.isServerProcess() && ContextManagerFactory.getInstance().isCellSecurityEnabled()) {
                            if (AdminClientFactory.tc.isDebugEnabled()) {
                                Tr.debug(AdminClientFactory.tc, "trying to get security user/pw info from rmi connector if security is enabled");
                            }
                            if ((var13_48 = ContextManagerFactory.getInstance().getInvocationSubject()) == null) {
                                var13_48 = ContextManagerFactory.getInstance().getOwnSubject();
                            }
                            if (var13_48 != null) {
                                if (AdminClientFactory.tc.isDebugEnabled()) {
                                    Tr.debug(AdminClientFactory.tc, "subject is not null");
                                }
                                var14_55 = null;
                                var14_55 = SubjectHelper.getWSCredentialFromSubject((Subject)var13_48);
                                if (var14_55 != null) {
                                    var15_59 = var14_55.getSecurityName();
                                    if (var15_59.startsWith(ContextManagerFactory.getInstance().getDefaultRealm())) {
                                        var15_59 = RealmSecurityName.getSecurityName((String)var15_59);
                                        if (AdminClientFactory.tc.isDebugEnabled()) {
                                            Tr.debug(AdminClientFactory.tc, "RMI New username: " + var15_59);
                                        }
                                    }
                                    var16_65 = StringBytesConversion.getConvertedString((byte[])var14_55.getCredentialToken());
                                    var1_1.getConnectorProperties().setProperty("username", var15_59);
                                    var1_1.getConnectorProperties().setProperty("password", var16_65);
                                }
                            }
                        }
                        if (AdminClientFactory.tc.isDebugEnabled()) {
                            Tr.debug(AdminClientFactory.tc, "rmi client props now = " + DebugUtils.createPropertiesMaskPlainTextPassword((Properties)var1_1.getConnectorProperties()));
                        }
                    }
                    catch (Exception var13_49) {
                        if (!AdminClientFactory.tc.isDebugEnabled()) break block178;
                        Tr.debug(AdminClientFactory.tc, "exception while trying to get security user/pw info from rmi connector", var13_49);
                    }
                }
                if (!AdminClientFactory.tc.isDebugEnabled()) ** GOTO lbl513
                Tr.debug(AdminClientFactory.tc, "RMIConnectorClient is created");
            }
            catch (Exception var7_15) {
                Manager.Ffdc.log((Throwable)var7_15, (Object)AdminClientFactory.thisClass, "com.ibm.websphere.management.AdminClientFactory.createAdminClient", "267");
                if (AdminClientFactory.tc.isEntryEnabled()) {
                    Tr.exit(AdminClientFactory.tc, "createAdminClient - failed", var7_15);
                }
                if (var3_3 != null) {
                    var7_16 = var3_3;
                }
                throw new ConnectorException(AdminClientFactory.connectorNLS.getFormattedMessage("ADMC0017E", new Object[]{var0.getProperty("host"), var0.getProperty("port")}, "Could not create RMI Connector to connect to host {0} at port {1}"), var7_16);
            }
        } else if (var2_2.equalsIgnoreCase("JSR160RMI")) {
            var5_7 = new Boolean(var0.getProperty("securityEnabled"));
            if (var2_2.equalsIgnoreCase("RMI")) {
                var0.setProperty("JNDI", "/jndi/RMIConnector");
                var0.setProperty("type", "RMI");
            }
            var6_10 = (Properties)var0.clone();
            if (var5_7) {
                var6_10.remove("securityEnabled");
            } else {
                var6_10.setProperty("securityEnabled", "true");
            }
            try {
                block179: {
                    var7_17 = Class.forName("com.ibm.ws.management.connector.jsr160rmi.JSR160RMIConnectorClient");
                    var8_25 = Class.forName("com.ibm.ws.management.AdminClientImpl");
                    var9_31 = new Class[]{Properties.class};
                    var10_35 = var7_17.getConstructor(var9_31);
                    try {
                        if (AdminClientFactory.tc.isDebugEnabled()) {
                            Tr.debug(AdminClientFactory.tc, "Before 1st attempt to create connector instance...");
                        }
                        AdminClientFactory.showDebugInfo((Properties)var0);
                        var11_39 = var10_35.newInstance(new Object[]{var0});
                    }
                    catch (Exception var12_44) {
                        if (AdminClientFactory.tc.isDebugEnabled()) {
                            Tr.debug(AdminClientFactory.tc, "try alternative connector properties after receiving the exception", var12_44);
                            var13_50 = new PrintStream(new ByteArrayOutputStream());
                            var12_44.printStackTrace((PrintStream)var13_50);
                            Tr.debug(AdminClientFactory.tc, var13_50.toString());
                        }
                        var3_3 = var12_44;
                        AdminClientFactory.showDebugInfo((Properties)var6_10);
                        var11_39 = var10_35.newInstance(new Object[]{var6_10});
                        var5_7 = var5_7 == false;
                    }
                    var9_31[0] = Class.forName("com.ibm.ws.management.connector.AdminServiceProxy");
                    var12_45 = var8_25.getConstructor(var9_31);
                    var1_1 = (AdminClient)var12_45.newInstance(new Object[]{var11_39});
                    try {
                        if (!SecurityContext.isServerProcess() && ContextManagerFactory.getInstance().isCellSecurityEnabled()) {
                            if (AdminClientFactory.tc.isDebugEnabled()) {
                                Tr.debug(AdminClientFactory.tc, "trying to get security user/pw info from JSR160RMI connector if security is enabled");
                            }
                            if ((var13_50 = ContextManagerFactory.getInstance().getInvocationSubject()) == null) {
                                var13_50 = ContextManagerFactory.getInstance().getOwnSubject();
                            }
                            if (var13_50 != null) {
                                if (AdminClientFactory.tc.isDebugEnabled()) {
                                    Tr.debug(AdminClientFactory.tc, "subject is not null");
                                }
                                var14_56 = null;
                                var14_56 = SubjectHelper.getWSCredentialFromSubject((Subject)var13_50);
                                if (var14_56 != null) {
                                    var15_60 = var14_56.getSecurityName();
                                    if (var15_60.startsWith(ContextManagerFactory.getInstance().getDefaultRealm())) {
                                        var15_60 = RealmSecurityName.getSecurityName((String)var15_60);
                                        if (AdminClientFactory.tc.isDebugEnabled()) {
                                            Tr.debug(AdminClientFactory.tc, "JSR160RMI New username: " + var15_60);
                                        }
                                    }
                                    var16_66 = StringBytesConversion.getConvertedString((byte[])var14_56.getCredentialToken());
                                    var1_1.getConnectorProperties().setProperty("username", var15_60);
                                    var1_1.getConnectorProperties().setProperty("password", var16_66);
                                }
                            }
                        }
                        if (AdminClientFactory.tc.isDebugEnabled()) {
                            Tr.debug(AdminClientFactory.tc, "JSR160RMI client props now = " + DebugUtils.createPropertiesMaskPlainTextPassword((Properties)var1_1.getConnectorProperties()));
                        }
                    }
                    catch (Exception var13_51) {
                        if (!AdminClientFactory.tc.isDebugEnabled()) break block179;
                        Tr.debug(AdminClientFactory.tc, "exception while trying to get security user/pw info from JSR160RMI connector", var13_51);
                    }
                }
                if (!AdminClientFactory.tc.isDebugEnabled()) ** GOTO lbl513
                Tr.debug(AdminClientFactory.tc, "JSR160RMIConnectorClient is created");
            }
            catch (Exception var7_18) {
                Manager.Ffdc.log((Throwable)var7_18, (Object)AdminClientFactory.thisClass, "com.ibm.websphere.management.AdminClientFactory.createAdminClient", "275");
                if (AdminClientFactory.tc.isEntryEnabled()) {
                    Tr.exit(AdminClientFactory.tc, "createAdminClient - failed", var7_18);
                }
                if (var3_3 != null) {
                    var7_19 = var3_3;
                }
                throw new ConnectorException(AdminClientFactory.connectorNLS.getFormattedMessage("ADMC0017E", new Object[]{var0.getProperty("host"), var0.getProperty("port")}, "Could not create RMI Connector to connect to host {0} at port {1}"), var7_19);
            }
        } else if (var2_2.equalsIgnoreCase("IPC")) {
            var6_10 = null;
            var7_20 = SecurityContext.isServerProcess();
            if (!var7_20) {
                var8_26 = var0.getProperty("com.ibm.IPC.ConfigURL");
                if (var8_26 == null) {
                    var8_26 = System.getProperty("com.ibm.IPC.ConfigURL");
                }
                if (var8_26 == null) {
                    var9_32 = System.getProperty("user.install.root");
                    if (var9_32 == null) {
                        var9_32 = System.getProperty("was.install.root");
                    }
                    var8_26 = "file:" + var9_32 + "/properties/ipc.client.props";
                }
                if (var8_26 != null) {
                    var9_32 = var8_26;
                    var6_10 = (Properties)com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            Properties properties = AdminClientFactory.loadPropertiesFromFile(var9_32);
                            return properties;
                        }
                    });
                }
            }
            if (var6_10 != null) {
                var6_10.putAll((Map<?, ?>)var0);
                var0 = var6_10;
            }
            var5_7 = new Boolean(var0.getProperty("securityEnabled"));
            var8_26 = (String)var0.get("authTarget");
            var9_32 = (String)var0.get("krb5Ccache");
            var10_36 = (String)var0.get("krb5Config");
            var11_40 = (String)var0.get("krb5Service");
            var12_46 = (String)var0.get("krb5RefreshingTicket");
            var13_52 = var0.getProperty("username");
            var14_57 = var0.getProperty("password");
            if (!var7_20) {
                if (var13_52 != null && var13_52.length() > 0 && var14_57 != null && var14_57.length() > 0) {
                    if (!var5_7) {
                        var5_7 = true;
                        var0.setProperty("securityEnabled", String.valueOf(var5_7));
                    }
                } else if (var5_7) {
                    var5_7 = false;
                    var0.setProperty("securityEnabled", String.valueOf(var5_7));
                }
            }
            try {
                block181: {
                    var15_61 = Class.forName("com.ibm.ws.management.connector.ipc.IPCConnectorClient");
                    var16_67 = Class.forName("com.ibm.ws.management.AdminClientImpl");
                    var17_70 = new Class[]{Properties.class};
                    var18_72 = var15_61.getConstructor(var17_70);
                    try {
                        if (AdminClientFactory.tc.isDebugEnabled()) {
                            Tr.debug(AdminClientFactory.tc, "Before 1st attempt to new up com.ibm.ws.management.connector.ipc.IPCConnectorClient");
                        }
                        AdminClientFactory.showDebugInfo((Properties)var0);
                        var19_74 = var18_72.newInstance(new Object[]{var0});
                        if (AdminClientFactory.tc.isDebugEnabled()) {
                            Tr.debug(AdminClientFactory.tc, "IPCConnectorClient instance constructed: " + var19_74);
                        }
                    }
                    catch (Exception var20_76) {
                        block180: {
                            var21_79 /* !! */  = AdminClientFactory.getAltCacheKey(var4_4);
                            var22_82 = AdminClientFactory.cachedClients;
                            synchronized (var22_82) {
                                var1_1 = (AdminClient)AdminClientFactory.cachedClients.get(var21_79 /* !! */ );
                            }
                            if (var1_1 != null) {
                                if (AdminClientFactory.tc.isDebugEnabled()) {
                                    Tr.debug(AdminClientFactory.tc, "Alternate cached admin client found");
                                }
                                try {
                                    var1_1.isAlive();
                                    if (AdminClientFactory.tc.isEntryEnabled()) {
                                        Tr.exit(AdminClientFactory.tc, "createAdminClient - alternate in cache");
                                    }
                                    return var1_1;
                                }
                                catch (Throwable var22_83) {
                                    if (!AdminClientFactory.tc.isDebugEnabled()) break block180;
                                    Tr.debug(AdminClientFactory.tc, "Alternate cached admin client is not available", var22_83);
                                }
                            }
                        }
                        var3_3 = var20_76;
                        if (AdminClientFactory.tc.isDebugEnabled()) {
                            Tr.debug(AdminClientFactory.tc, "Try to new up the com.ibm.ws.management.connector.ipc.IPCConnectorClient again, now with reversed secEnabled, after the 1st attempt failed with", var20_76);
                        }
                        var5_7 = var5_7 == false;
                        var0.setProperty("securityEnabled", String.valueOf(var5_7));
                        AdminClientFactory.showDebugInfo((Properties)var0);
                        var19_74 = var18_72.newInstance(new Object[]{var0});
                        if (!AdminClientFactory.tc.isDebugEnabled()) break block181;
                        Tr.debug(AdminClientFactory.tc, "IPCConnectorClient instance constructed (attempt 2): " + var19_74);
                    }
                }
                if (!SecurityContext.isServerProcess() && var5_7) {
                    var20_77 = (String)var0.get("loginsource");
                    if (var8_26 == null || var8_26.length() == 0 || var8_26.equalsIgnoreCase("BasicAuth")) {
                        if (var13_52 != null && var13_52.length() > 0 && var14_57 != null && var14_57.length() > 0) {
                            var21_79 /* !! */  = SubjectHelper.createBasicAuthSubject(null, (String)var13_52, (String)var14_57);
                            AdminDataHolder.setData((Object)"wsSubject", (Object)var21_79 /* !! */ );
                            if (AdminClientFactory.tc.isDebugEnabled()) {
                                Tr.debug(AdminClientFactory.tc, "Subject from uid/pw null? " + (var21_79 /* !! */  == null));
                            }
                        } else if (var20_77 != null && (var20_77.equals("stdin") || var20_77.equals("prompt"))) {
                            block182: {
                                if (AdminClientFactory.tc.isDebugEnabled()) {
                                    Tr.debug(AdminClientFactory.tc, "About to login using JAAS");
                                }
                                var21_79 /* !! */  = null;
                                var22_82 = null;
                                var23_85 = ContextManagerFactory.getInstance().getDefaultRealm();
                                try {
                                    var21_79 /* !! */  = AdminClientFactory.jaas_login(var8_26, (String)var20_77, var13_52, var14_57, var23_85, var9_32, var10_36);
                                    if (AdminClientFactory.tc.isDebugEnabled()) {
                                        Tr.debug(AdminClientFactory.tc, "IPC: calling setInvocationSubject: " + var21_79 /* !! */ );
                                    }
                                    SecurityContext.getContextManager().setInvocationSubject((Subject)var21_79 /* !! */ );
                                    if (var21_79 /* !! */  == null) break block182;
                                    AdminDataHolder.setData((Object)"wsSubject", (Object)var21_79 /* !! */ );
                                    var22_82 = SubjectHelper.getWSCredentialFromSubject((Subject)var21_79 /* !! */ );
                                    var13_52 = var22_82.getSecurityName();
                                    if (var13_52.startsWith(ContextManagerFactory.getInstance().getDefaultRealm())) {
                                        var13_52 = RealmSecurityName.getSecurityName((String)var13_52);
                                        if (AdminClientFactory.tc.isDebugEnabled()) {
                                            Tr.debug(AdminClientFactory.tc, "New username: " + var13_52);
                                        }
                                    }
                                    var14_57 = StringBytesConversion.getConvertedString((byte[])var22_82.getCredentialToken());
                                    var0.put("username", var13_52);
                                    var0.put("password", var14_57);
                                    var24_87 = var15_61.getDeclaredMethod("setUserAndPwd", new Class[]{String.class, String.class});
                                    var24_87.invoke(var19_74, new Object[]{var13_52, var14_57});
                                }
                                catch (WSLoginFailedException var24_89) {
                                    if (AdminClientFactory.tc.isDebugEnabled()) {
                                        Tr.debug(AdminClientFactory.tc, "WSLoginFailedException occurred: ", var24_89);
                                    }
                                    Manager.Ffdc.log((Throwable)var24_89, (Object)AdminClientFactory.thisClass, "com.ibm.websphere.management.AdminClientFactory.createAdminClient", "1330");
                                }
                                catch (Exception var24_90) {
                                    if (AdminClientFactory.tc.isDebugEnabled()) {
                                        Tr.debug(AdminClientFactory.tc, "Exception occurred during JAAS login: ", new Object[]{var24_90});
                                    }
                                    Manager.Ffdc.log((Throwable)var24_90, (Object)AdminClientFactory.thisClass, "com.ibm.websphere.management.AdminClientFactory.createAdminClient", "1336");
                                }
                            }
                            if (AdminClientFactory.tc.isDebugEnabled()) {
                                Tr.debug(AdminClientFactory.tc, "Subject from jaas_login null? " + (var21_79 /* !! */  == null));
                            }
                        }
                    }
                }
                var17_70[0] = Class.forName("com.ibm.ws.management.connector.AdminServiceProxy");
                var20_77 = var16_67.getConstructor(var17_70);
                if (AdminClientFactory.tc.isDebugEnabled()) {
                    Tr.debug(AdminClientFactory.tc, "AdminClientImpl constructor: " + var20_77);
                }
                var1_1 = (AdminClient)var20_77.newInstance(new Object[]{var19_74});
                if (!AdminClientFactory.tc.isDebugEnabled()) ** GOTO lbl513
                Tr.debug(AdminClientFactory.tc, "IPCConnectorClient is created");
            }
            catch (Exception var15_62) {
                if (var3_3 != null) {
                    // empty if block
                }
                throw new ConnectorException("Could not create IPC Connector to connect to port " + var0.getProperty("port") + ", due to " + var15_62);
            }
        } else {
            if (AdminClientFactory.tc.isEntryEnabled()) {
                Tr.exit(AdminClientFactory.tc, "createAdminClient");
            }
            throw new InvalidAdminClientTypeException();
        }
lbl513:
        // 9 sources

        var6_11 = new Boolean(var0.getProperty("cacheDisabled"));
        if (AdminClientFactory.tc.isDebugEnabled()) {
            Tr.debug(AdminClientFactory.tc, "cacheDisabled is set to " + var6_11);
        }
        if (var1_1 != null) {
            if (var6_11) {
                if (AdminClientFactory.tc.isDebugEnabled()) {
                    Tr.debug(AdminClientFactory.tc, "Caching disabled for this admin client");
                }
            } else {
                var4_4.setProperty("securityEnabled", var5_7 != false ? "true" : "false");
                var7_21 = AdminClientFactory.cachedClients;
                synchronized (var7_21) {
                    if (AdminClientFactory.tc.isDebugEnabled()) {
                        Tr.debug(AdminClientFactory.tc, "Client is being cached, and the properties is");
                    }
                    AdminClientFactory.showDebugInfo(var4_4);
                    AdminClientFactory.cachedClients.put(var4_4, var1_1);
                }
            }
        }
        if (AdminClientFactory.tc.isEntryEnabled()) {
            Tr.exit(AdminClientFactory.tc, "createAdminClient");
        }
        return var1_1;
    }

    private static AdminClient createNullConnectorClient(Properties properties) throws ConnectorException {
        properties.setProperty("cacheDisabled", "true");
        NullConnector nullConnector = new NullConnector(properties);
        return nullConnector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadPropertiesFromFile(String string) {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadPropertiesFromFile", string);
        }
        if (!string.startsWith("file:")) {
            string = "file:".concat(string);
        }
        InputStream inputStream = null;
        Properties properties = new Properties();
        try {
            object = new URL(string);
            inputStream = ((URL)object).openStream();
            properties.load(inputStream);
            properties = AdminClientFactory.decodePasswordsAndExpandVariables(properties);
        }
        catch (IOException iOException) {
            Manager.Ffdc.log((Throwable)iOException, (Object)thisClass, "com.ibm.websphere.management.AdminClientFactory.loadPropertiesFromFile", "313");
            Tr.warning(tc, "ADMC0046W", new Object[]{string});
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    Manager.Ffdc.log((Throwable)iOException, (Object)thisClass, "com.ibm.websphere.management.AdminClientFactory.loadPropertiesFromFile", "322");
                }
            }
        }
        if (!properties.isEmpty()) {
            String string2;
            String string3;
            String string4;
            String string5;
            String string6;
            String string7;
            String string8;
            String string9;
            if (properties.keySet().contains("com.ibm.SOAP.loginUserid")) {
                object = (String)properties.remove("com.ibm.SOAP.loginUserid");
                string9 = (String)properties.remove("com.ibm.SOAP.loginPassword");
                string8 = (String)properties.remove("com.ibm.SOAP.loginSource");
                string7 = (String)properties.remove("com.ibm.SOAP.securityEnabled");
                string6 = (String)properties.remove("com.ibm.SOAP.authenticationTarget");
                string5 = (String)properties.remove("com.ibm.SOAP.krb5CcacheFile");
                string4 = (String)properties.remove("com.ibm.SOAP.krb5ConfigFile");
                string3 = (String)properties.remove("com.ibm.SOAP.krb5Service");
                string2 = (String)properties.remove("com.ibm.SOAP.krb5RefreshingTicket");
            } else if (properties.keySet().contains("com.ibm.IPC.loginUserid")) {
                object = (String)properties.remove("com.ibm.IPC.loginUserid");
                string9 = (String)properties.remove("com.ibm.IPC.loginPassword");
                string8 = (String)properties.remove("com.ibm.IPC.loginSource");
                string7 = (String)properties.remove("com.ibm.IPC.securityEnabled");
                string6 = (String)properties.remove("com.ibm.IPC.authenticationTarget");
                string5 = (String)properties.remove("com.ibm.IPC.krb5CcacheFile");
                string4 = (String)properties.remove("com.ibm.IPC.krb5ConfigFile");
                string3 = (String)properties.remove("com.ibm.IPC.krb5Service");
                string2 = (String)properties.remove("com.ibm.IPC.krb5RefreshingTicket");
            } else {
                object = "";
                string9 = "";
                string8 = "";
                string7 = "";
                string6 = "";
                string5 = "";
                string4 = "";
                string3 = "";
                string2 = "";
            }
            if (string8 != null && string8.length() > 0) {
                properties.setProperty("loginsource", string8);
            }
            if (object != null) {
                properties.setProperty("username", (String)object);
            }
            if (string9 != null) {
                properties.setProperty("password", string9);
            }
            if (string7 != null) {
                properties.setProperty("securityEnabled", string7);
            }
            if (string6 != null) {
                properties.setProperty("authTarget", string6);
            } else {
                properties.setProperty("authTarget", "BasicAuth");
            }
            if (string5 != null) {
                properties.setProperty("krb5Ccache", string5);
            }
            if (string4 != null) {
                properties.setProperty("krb5Config", string4);
            }
            if (string3 != null) {
                properties.setProperty("krb5Service", string3);
            }
            if (string2 != null) {
                properties.setProperty("krb5RefreshingTicket", string2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadPropertisFromFile");
        }
        return properties;
    }

    private static Properties decodePasswordsAndExpandVariables(Properties properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "decodePasswords");
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            if (string2 != null && string2.indexOf("${USER_INSTALL_ROOT}") != -1) {
                string2 = KeyStoreManager.getInstance().expand(string2);
            }
            if (string.toLowerCase().indexOf("password") == -1 || string2 == null) continue;
            String string3 = SSLConfig.decodePassword((String)string2);
            properties.setProperty(string, string3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "decodePasswords");
        }
        return properties;
    }

    private static void showDebugInfo(Properties properties) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Client properties: ");
            for (String string : properties.keySet()) {
                if (string.equals("password") || string.endsWith("Password")) {
                    String string2 = properties.getProperty(string);
                    if (string2 != null && string2.length() > 0) {
                        Tr.debug(tc, "> " + string + "=*****");
                        continue;
                    }
                    Tr.debug(tc, "> " + string + "=");
                    continue;
                }
                Tr.debug(tc, "> " + string + "=" + properties.getProperty(string));
            }
        }
    }

    private static Properties getCacheKey(String string, Properties properties) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCacheKey");
        }
        Properties properties2 = new Properties();
        String string2 = properties.getProperty("authTarget");
        String string3 = properties.getProperty("krb5Ccache");
        String string4 = properties.getProperty("krb5Config");
        String string5 = properties.getProperty("krb5Service");
        String string6 = properties.getProperty("krb5RefreshingTicket");
        String string7 = properties.getProperty("host");
        String string8 = properties.getProperty("port");
        String string9 = properties.getProperty("loginsource");
        String string10 = properties.getProperty("securityEnabled");
        String string11 = properties.getProperty("autoAcceptSignerForThisConnectionOnly");
        String string12 = properties.getProperty("username");
        if (string12 != null && string12.startsWith(ContextManagerFactory.getInstance().getDefaultRealm())) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "In getCacheKey, stripping realm from username.");
            }
            string12 = RealmSecurityName.getSecurityName((String)string12);
            properties.setProperty("username", string12);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "In getCacheKey, new username: " + string12);
            }
        }
        String string13 = properties.getProperty("password");
        if (string7 == null) {
            throw new ConnectorException(connectorNLS.getString("ADMC0041E"));
        }
        String string14 = string7;
        try {
            string7 = InetAddress.getByName(string7).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            Manager.Ffdc.log((Throwable)unknownHostException, (Object)thisClass, "com.ibm.websphere.management.AdminClientFactory.getCacheKey", "432");
            string7 = string14;
        }
        if (string8 == null) {
            throw new ConnectorException(connectorNLS.getString("ADMC0042E"));
        }
        string8 = string8.trim();
        properties2.setProperty("type", string.toUpperCase());
        properties2.setProperty("host", string7);
        properties2.setProperty("port", string8);
        if (string10 != null) {
            properties2.setProperty("securityEnabled", string10);
        } else {
            properties2.setProperty("securityEnabled", "false");
        }
        if (string12 != null && string13 != null) {
            properties2.setProperty("username", string12);
            properties2.setProperty("password", string13);
        }
        if (string12 != null) {
            properties2.setProperty("username", string12);
        }
        if (string9 != null) {
            properties2.setProperty("loginsource", string9);
        }
        if (string2 != null) {
            properties2.setProperty("authTarget", string2);
        }
        if (string3 != null) {
            properties2.setProperty("krb5Ccache", string3);
        }
        if (string4 != null) {
            properties2.setProperty("krb5Config", string4);
        }
        if (string5 != null) {
            properties2.setProperty("krb5Service", string5);
        }
        if (string6 != null) {
            properties2.setProperty("krb5RefreshingTicket", string6);
        }
        if (string11 != null) {
            properties2.setProperty("autoAcceptSignerForThisConnectionOnly", string11);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCacheKey", DebugUtils.createPropertiesMaskPlainTextPassword((Properties)properties2));
        }
        return properties2;
    }

    public static Subject jaas_login(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws WSLoginFailedException {
        Object object;
        LoginContext loginContext;
        block27: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "jaas_login(" + string + ", " + string2 + " ..." + ")");
            }
            String string8 = "WSAdminClientLogin";
            if (string.equalsIgnoreCase("KRB5") || string.equalsIgnoreCase("Kerberos")) {
                string8 = "WSKRB5Login";
                AdminClientFactory.setKrbConfigProp(string7);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "authTarget: " + string);
                Tr.debug(tc, "loginSource: " + string2);
                Tr.debug(tc, "user: " + string3);
                Tr.debug(tc, "realm: " + string5);
                Tr.debug(tc, "krb5Ccache: " + string6);
                Tr.debug(tc, "krb5Config: " + string7);
                Tr.debug(tc, "loginModule: " + string8);
            }
            loginContext = null;
            CallbackHandler callbackHandler = null;
            try {
                if (string3 != null && string3.length() > 0 && string4 != null && string4.length() > 0) {
                    loginContext = new LoginContext(string8, (CallbackHandler)new NonPromptCallbackHandler(string5, string3, string4));
                    loginContext.login();
                    break block27;
                }
                if (string2 != null && string2.equalsIgnoreCase("krb5Ccache")) {
                    try {
                        object = "false";
                        if (string6 == null || string6.length() == 0) {
                            object = "true";
                        }
                        loginContext = new LoginContext(string8, (CallbackHandler)new WSCcacheCallBackHandlerImpl(string3, string5, string6, (String)object));
                        loginContext.login();
                        break block27;
                    }
                    catch (WSLoginFailedException wSLoginFailedException) {
                        throw wSLoginFailedException;
                    }
                    catch (LoginException loginException) {
                        Manager.Ffdc.log((Throwable)loginException, (Object)thisClass, "com.ibm.websphere.management.AdminClientFactory.jaas_login", "173");
                        if (loginException instanceof WSLoginFailedException) {
                            throw (WSLoginFailedException)loginException;
                        }
                        throw new WSLoginFailedException(loginException.getMessage(), loginException);
                    }
                }
                if (string2 != null && string2.equalsIgnoreCase("prompt")) {
                    try {
                        if (tc.isEntryEnabled()) {
                            Tr.entry(tc, "creating GraphicsEnvironment");
                        }
                        object = GraphicsEnvironment.getLocalGraphicsEnvironment();
                        JFrame jFrame = new JFrame();
                        if (!((GraphicsEnvironment)object).isHeadlessInstance()) {
                            callbackHandler = new WSGUICallbackHandlerImpl();
                        } else {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "GraphicsEnvironment is headless; go with stdin");
                            }
                            callbackHandler = new WSStdinCallbackHandlerImpl();
                        }
                    }
                    catch (Throwable throwable) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Failed to create GraphicsEnvironment; go with stdin");
                        }
                        callbackHandler = new WSStdinCallbackHandlerImpl();
                    }
                    loginContext = new LoginContext(string8, callbackHandler);
                    loginContext.login();
                    break block27;
                }
                if (string2 != null && string2.equalsIgnoreCase("stdin")) {
                    loginContext = new LoginContext(string8, new WSStdinCallbackHandlerImpl(string5));
                    loginContext.login();
                }
            }
            catch (WSLoginFailedException wSLoginFailedException) {
                throw wSLoginFailedException;
            }
            catch (LoginException loginException) {
                Manager.Ffdc.log((Throwable)loginException, (Object)thisClass, "com.ibm.websphere.management.AdminClientFactory.jaas_login", "152");
                if (loginException instanceof WSLoginFailedException) {
                    throw (WSLoginFailedException)loginException;
                }
                throw new WSLoginFailedException(loginException.getMessage(), loginException);
            }
            catch (SecurityException securityException) {
                Manager.Ffdc.log((Throwable)securityException, (Object)thisClass, "com.ibm.websphere.management.AdminClientFactory.jaas_login", "162");
                throw new WSLoginFailedException(securityException.getMessage(), securityException);
            }
        }
        object = loginContext.getSubject();
        if (object == null) {
            Tr.debug(tc, "Subject is null.", new Object[]{string, string2});
        } else {
            AdminDataHolder.setData((Object)"wsSubject", (Object)object);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "jaas_login(authTarget, loginSource, ...)");
        }
        return object;
    }

    private static Properties getAltCacheKey(Properties properties) {
        Properties properties2 = (Properties)properties.clone();
        if (properties.getProperty("securityEnabled").equals("true")) {
            properties2.setProperty("securityEnabled", "false");
        } else {
            properties2.setProperty("securityEnabled", "true");
        }
        return properties2;
    }

    public static void setKrbConfigProp(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setKrbConfigProp");
        }
        if (string != null && string.length() != 0) {
            final String string2 = string;
            String string3 = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    String string = System.getProperty("java.security.krb5.conf");
                    System.setProperty("java.security.krb5.conf", string2);
                    return string;
                }
            });
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "java.security.krb5.conf property previous: " + (string3 != null ? string3 : "<null>") + " and now: " + string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setKrbConfigProp");
        }
    }
}

