/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.ant.tasks;

import com.ibm.websphere.ant.tasks.Messages;
import com.ibm.ws.ant.utils.OsUtils;
import com.ibm.ws.ant.utils.ProjectUtils;
import com.ibm.ws.ant.utils.StrUtils;
import com.ibm.ws.ant.utils.WasUtils;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServerControl
extends Task {
    String server;
    String logFile;
    boolean replaceLog = false;
    boolean noWait = false;
    boolean quiet = false;
    boolean trace = false;
    String timeout;
    String statusPort;
    String username;
    String password;
    String profileName = null;
    String wasHome;
    String jvmMaxMemory = "256M";
    private boolean debug = false;
    boolean failonerror;
    String fileEncoding = null;
    WasUtils wasUtils = new WasUtils();

    @Override
    public void execute() throws BuildException {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.server == null && !this.getTaskName().equals("serverStatus")) {
            ProjectUtils.reportError((Project)this.getProject(), (boolean)this.failonerror, (String)Messages.getString("The_server_attribute_is_required_and_it_has_not_been_specified._1"));
            return;
        }
        if (this.wasHome == null) {
            this.wasHome = WasUtils.getDefaultWasInstallHome((Project)this.getProject());
            if (this.wasHome == null) {
                ProjectUtils.reportError((Project)this.getProject(), (boolean)this.failonerror, (String)Messages.getString("Unable_to_determine_WAS_Home_directory._Please_use_the_wasHome_task_attribute_or_set_the_was.root_System_property._2"));
                return;
            }
        }
        this.wasHome = StrUtils.cleanPath((String)this.wasHome, (boolean)true);
        if (this.profileName != null) {
            WasUtils.setProfileHome((String)this.profileName.toString(), (String)this.wasHome);
            if (WasUtils.getProfileHome() == null) {
                ProjectUtils.reportError((Project)this.getProject(), (boolean)this.failonerror, (String)("WSProfileException profileName=" + this.profileName));
                return;
            }
        }
        this.wasUtils.parseSetupCmdLine(this.wasHome, this.profileName, this.getProject(), this.failonerror);
        if (!this.getTaskName().equals("startServer") || !OsUtils.isOS400()) {
            arrayList.add(this.wasUtils.getSCLAttr("CONFIG_ROOT"));
            arrayList.add(this.wasUtils.getSCLAttr("WAS_CELL"));
            arrayList.add(this.wasUtils.getSCLAttr("WAS_NODE"));
        }
        if (this.server != null) {
            arrayList.add(this.server);
        }
        if (this.noWait) {
            arrayList.add("-nowait");
        }
        if (this.quiet) {
            arrayList.add("-quiet");
        }
        if (this.trace) {
            arrayList.add("-trace");
        }
        if (this.profileName != null) {
            arrayList.add("-profileName");
            arrayList.add(this.profileName);
        }
        if (this.timeout != null) {
            arrayList.add("-timeout");
            arrayList.add(this.timeout);
        }
        if (this.statusPort != null) {
            arrayList.add("-statusport");
            arrayList.add(this.statusPort);
        }
        if (this.logFile != null) {
            arrayList.add("-logfile");
            arrayList.add(this.logFile);
        }
        if (this.replaceLog) {
            arrayList.add("-replacelog");
        }
        if (this.username != null) {
            arrayList.add("-username");
            arrayList.add(this.username);
        }
        if (this.password != null) {
            arrayList.add("-password");
            arrayList.add(this.password);
        }
        this.addAdditionalArgs(arrayList);
        if (this.getTaskName().equals("startServer") && OsUtils.isOS400()) {
            String[] stringArray2 = new String[arrayList.size()];
            this.runScript(this.wasHome, this.getTaskName(), arrayList.toArray(stringArray2), this.getProject(), this.failonerror);
            return;
        }
        Java java = new Java();
        java.setProject(this.getProject());
        java.setTaskName(this.getTaskName());
        java.setOwningTarget(this.getOwningTarget());
        java.setLocation(this.getLocation());
        Path path = new Path(this.getProject(), this.wasUtils.getSCLAttr("WAS_CLASSPATH"));
        java.setClasspath(path);
        java.setClassname("com.ibm.wsspi.bootstrap.WSPreLauncher");
        java.setDir(new File(this.wasHome, "bin"));
        java.setFailonerror(this.failonerror);
        java.setFork(true);
        if (!OsUtils.isOS400()) {
            java.setMaxmemory(this.jvmMaxMemory);
        }
        this.addJvmArgs(java);
        this.wasUtils.addJVMArgs(java, this.wasHome, this.fileEncoding);
        Commandline.Argument argument = java.createArg();
        argument.setValue("-nosplash");
        argument = java.createArg();
        argument.setValue("-application");
        argument = java.createArg();
        argument.setValue("com.ibm.ws.bootstrap.WSLauncher");
        argument = java.createArg();
        argument.setValue(this.getMainClass());
        Iterator<String> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            stringArray = java.createArg();
            stringArray.setValue(iterator.next());
        }
        if (this.isDebug()) {
            stringArray = java.getCommandLine().getCommandline();
            for (int i = 0; i < stringArray.length; ++i) {
                System.out.println("jvm args > " + stringArray[i]);
            }
        }
        java.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runScript(String string, String string2, String[] stringArray, Project project, boolean bl) {
        String string3 = string + "bin" + File.separator + string2;
        if (OsUtils.getPlatform() == 1) {
            string3 = string3 + ".sh";
        } else if (OsUtils.getPlatform() == 0) {
            string3 = string3 + ".bat";
        }
        BufferedReader bufferedReader = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Execute execute = new Execute(new PumpStreamHandler(byteArrayOutputStream));
            String[] stringArray2 = new String[stringArray.length + 1];
            stringArray2[0] = string3;
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray2[i + 1] = stringArray[i];
            }
            execute.setCommandline(stringArray2);
            execute.setNewenvironment(true);
            execute.execute();
            String string4 = System.getProperty("char.encoding");
            if (string4 == null || string4.equals("")) {
                string4 = "Cp037";
            }
            bufferedReader = new BufferedReader(new StringReader(new String(byteArrayOutputStream.toString().getBytes(), string4)));
            String string5 = null;
            while ((string5 = bufferedReader.readLine()) != null) {
                System.out.println(string5);
            }
            if (execute.getExitValue() != 0) {
                ProjectUtils.reportError((Project)project, (boolean)bl, (String)(string2 + " : Failed"));
            }
        }
        catch (IOException iOException) {
            ProjectUtils.reportError((Project)project, (boolean)bl, (String)(Messages.getString("Unable_to_parse_setupCmdLine___17") + iOException.getMessage()));
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void setNoWait(boolean bl) {
        this.noWait = bl;
    }

    public void setQuiet(boolean bl) {
        this.quiet = bl;
    }

    public void setTrace(boolean bl) {
        this.trace = bl;
    }

    public void setTimeout(String string) {
        this.timeout = string;
    }

    public void setStatusPort(String string) {
        this.statusPort = string;
    }

    public void setServer(String string) {
        this.server = string;
    }

    public void setWasHome(String string) {
        this.wasHome = string;
    }

    public void setFailonerror(boolean bl) {
        this.failonerror = bl;
    }

    public abstract String getMainClass();

    public abstract void addAdditionalArgs(ArrayList<String> var1);

    public abstract void addJvmArgs(Java var1);

    @Override
    public abstract String getTaskName();

    public void setLogFile(String string) {
        this.logFile = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setReplaceLog(boolean bl) {
        this.replaceLog = bl;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public void setProfileName(String string) {
        this.profileName = string;
    }

    public void setJvmMaxMemory(String string) {
        this.jvmMaxMemory = string;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setFileEncoding(String string) {
        this.fileEncoding = string;
    }
}

