/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vap.converters.streams;

import com.ibm.vap.converters.streams.ContextObjectInputStream;
import com.ibm.vap.converters.streams.VapBinaryStreamToObjectConverter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.sql.Blob;
import javax.ejb.EJBObject;
import javax.ejb.Handle;

public class BinaryStreamToEJBObjectConverter
extends VapBinaryStreamToObjectConverter {
    static BinaryStreamToEJBObjectConverter singleton = null;
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 2001";

    public Object dataFrom(Object object) {
        if (object == null) {
            return null;
        }
        byte[] byArray = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            Handle handle = ((EJBObject)object).getHandle();
            objectOutputStream.writeObject(handle);
            objectOutputStream.flush();
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            RuntimeException runtimeException = new RuntimeException(exception.getMessage());
            runtimeException.fillInStackTrace();
            throw runtimeException;
        }
        return byArray;
    }

    public static String getTargetClassName() {
        return "javax.ejb.EJBObject";
    }

    public Object objectFrom(Object object) {
        if (object == null) {
            return null;
        }
        EJBObject eJBObject = null;
        try {
            InputStream inputStream = null;
            inputStream = object instanceof InputStream ? (InputStream)object : (object instanceof Blob ? ((Blob)object).getBinaryStream() : new ByteArrayInputStream((byte[])object));
            ContextObjectInputStream contextObjectInputStream = new ContextObjectInputStream(inputStream);
            eJBObject = ((Handle)contextObjectInputStream.readObject()).getEJBObject();
        }
        catch (Exception exception) {
            RuntimeException runtimeException = new RuntimeException(exception.getMessage());
            runtimeException.fillInStackTrace();
            throw runtimeException;
        }
        return eJBObject;
    }

    public static void reset() {
        singleton = null;
    }

    public static BinaryStreamToEJBObjectConverter singleton() {
        if (singleton == null) {
            singleton = new BinaryStreamToEJBObjectConverter();
        }
        return singleton;
    }
}

