/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras.server;

import com.ibm.ras.RASMessageCatalog;
import com.ibm.ras.RASUtil;
import com.ibm.ras.server.RASConnectionHandler;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;

public class RASLogServer
implements Runnable {
    private static final String s = "(C) Copyright IBM Corp. 1998.";
    private static final int DEFAULT_PORT = 9991;
    private boolean toFile = false;
    private int port = 9991;
    private PrintWriter pWriter = null;
    private RASMessageCatalog cat = new RASMessageCatalog("com.ibm.ras.server.RASLogServerMsgs");
    private String filename = null;

    public static void main(String[] args) {
        int port = 0;
        String filename = null;
        switch (args.length) {
            case 0: {
                port = 9991;
                break;
            }
            case 1: {
                port = Integer.valueOf(args[0]);
                break;
            }
            case 2: {
                port = Integer.valueOf(args[0]);
                filename = args[1];
                break;
            }
            default: {
                RASMessageCatalog cat = new RASMessageCatalog("com.ibm.ras.server.RASLogServerMsgs");
                RASUtil.errorMsg(cat.getMessage("USAGE"));
                System.exit(1);
            }
        }
        RASLogServer d = new RASLogServer(port, filename);
    }

    public RASLogServer(int port, String filename) {
        this.port = port;
        this.filename = filename;
        Thread thread = new Thread(this);
        thread.start();
    }

    public void run() {
        if (this.filename != null) {
            this.toFile = true;
            try {
                this.pWriter = new PrintWriter(new FileOutputStream(this.filename), true);
            }
            catch (IOException e) {
                RASUtil.errorMsg(this.cat.getMessage("ERR_OPEN_FILE", this.filename));
                e.printStackTrace();
            }
        } else {
            this.toFile = false;
        }
        try {
            this.write(this.cat.getMessage("START_SERVER"));
            this.write(this.cat.getMessage("CREATE_SOCKET", new Integer(this.port).toString()));
            if (this.toFile) {
                this.write(this.cat.getMessage("OUTPUT_TO_FILE", this.filename));
            } else {
                this.write(this.cat.getMessage("OUTPUT_TO_CONSOLE"));
            }
            ServerSocket serverSocket = new ServerSocket(this.port);
            while (true) {
                Socket socket = serverSocket.accept();
                RASConnectionHandler connectionHandler = new RASConnectionHandler(socket, this.toFile, this.pWriter);
                Thread thread = new Thread(connectionHandler);
                thread.start();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            return;
        }
    }

    private void write(String msg) {
        if (this.toFile) {
            this.pWriter.println(msg);
        }
        System.out.println(msg);
    }
}

