/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.marshall.util.bidi;

import com.ibm.etools.marshall.util.MarshallResource;
import com.ibm.etools.marshall.util.bidi.BidiFlag;
import java.util.StringTokenizer;

public class BidiFlagSet {
    private static final String copyright = "(c) Copyright IBM Corporation 2002,2005.";
    static final int TYPE_MASK = 0x3000000;
    static final int ITYPE_IMPLICIT = 0x1000000;
    static final int ITYPE_VISUAL = 0x3000000;
    static final int ORIENTATION_MASK = 0x700000;
    static final int IORIENTATION_LTR = 0x100000;
    static final int IORIENTATION_RTL = 0x300000;
    static final int IORIENTATION_CONTEXT_LTR = 0x500000;
    static final int IORIENTATION_CONTEXT_RTL = 0x700000;
    static final int SWAP_MASK = 196608;
    static final int ISWAP_YES = 65536;
    static final int ISWAP_NO = 196608;
    static final int NUMERALS_MASK = 1792;
    static final int INUMERALS_NOMINAL = 256;
    static final int INUMERALS_NATIONAL = 768;
    static final int INUMERALS_CONTEXTUAL = 1280;
    static final int INUMERALS_ANY = 1792;
    static final int TEXT_MASK = 15;
    static final int ITEXT_NOMINAL = 1;
    static final int ITEXT_SHAPED = 3;
    static final int ITEXT_INITIAL = 5;
    static final int ITEXT_MIDDLE = 7;
    static final int ITEXT_FINAL = 9;
    static final int ITEXT_ISOLATED = 11;
    static final int DEFAULT = 0x1110101;
    int value;

    public BidiFlagSet() {
        this.value = 0x1110101;
    }

    public BidiFlagSet(BidiFlagSet bidiFlagSet) {
        this.value = bidiFlagSet.value;
    }

    public BidiFlagSet(BidiFlag bidiFlag) {
        this.value = bidiFlag.value | 0x1110101;
    }

    public BidiFlagSet(BidiFlag bidiFlag, BidiFlag bidiFlag2) {
        this.value = bidiFlag.value;
        if ((this.value & bidiFlag2.value) != 0) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_BIDI_FLAG_NOT_VALID", Integer.toString(bidiFlag2.value)));
        }
        this.value |= bidiFlag2.value | 0x1110101;
    }

    public BidiFlagSet(BidiFlag bidiFlag, BidiFlag bidiFlag2, BidiFlag bidiFlag3) {
        this.value = bidiFlag.value;
        if ((this.value & bidiFlag2.value) != 0) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_BIDI_FLAG_NOT_VALID", Integer.toString(bidiFlag2.value)));
        }
        this.value |= bidiFlag2.value;
        if ((this.value & bidiFlag3.value) != 0) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_BIDI_FLAG_NOT_VALID", Integer.toString(bidiFlag3.value)));
        }
        this.value |= bidiFlag3.value | 0x1110101;
    }

    public BidiFlagSet(BidiFlag bidiFlag, BidiFlag bidiFlag2, BidiFlag bidiFlag3, BidiFlag bidiFlag4) {
        this.value = bidiFlag.value;
        if ((this.value & bidiFlag2.value) != 0) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_BIDI_FLAG_NOT_VALID", Integer.toString(bidiFlag2.value)));
        }
        this.value |= bidiFlag2.value;
        if ((this.value & bidiFlag3.value) != 0) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_BIDI_FLAG_NOT_VALID", Integer.toString(bidiFlag3.value)));
        }
        this.value |= bidiFlag3.value;
        if ((this.value & bidiFlag4.value) != 0) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_BIDI_FLAG_NOT_VALID", Integer.toString(bidiFlag4.value)));
        }
        this.value |= bidiFlag4.value | 0x1110101;
    }

    public BidiFlagSet(BidiFlag bidiFlag, BidiFlag bidiFlag2, BidiFlag bidiFlag3, BidiFlag bidiFlag4, BidiFlag bidiFlag5) {
        this.value = bidiFlag.value;
        if ((this.value & bidiFlag2.value) != 0) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_BIDI_FLAG_NOT_VALID", Integer.toString(bidiFlag2.value)));
        }
        this.value |= bidiFlag2.value;
        if ((this.value & bidiFlag3.value) != 0) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_BIDI_FLAG_NOT_VALID", Integer.toString(bidiFlag3.value)));
        }
        this.value |= bidiFlag3.value;
        if ((this.value & bidiFlag4.value) != 0) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_BIDI_FLAG_NOT_VALID", Integer.toString(bidiFlag4.value)));
        }
        this.value |= bidiFlag4.value;
        if ((this.value & bidiFlag5.value) != 0) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_BIDI_FLAG_NOT_VALID", Integer.toString(bidiFlag5.value)));
        }
        this.value |= bidiFlag5.value;
    }

    public BidiFlagSet(char[] cArray) {
        int n = 0x1110101;
        int n2 = cArray.length;
        if (n2 > 0) {
            if ('V' == cArray[0]) {
                n = n & 0xFCFFFFFF | 0x3000000;
            } else if ('I' == cArray[0]) {
                n = n & 0xFCFFFFFF | 0x1000000;
            }
            if (n2 > 1) {
                if ('L' == cArray[1]) {
                    n = n & 0xFF8FFFFF | 0x100000;
                } else if ('R' == cArray[1]) {
                    n = n & 0xFF8FFFFF | 0x300000;
                } else if ('C' == cArray[1]) {
                    n = n & 0xFF8FFFFF | 0x500000;
                } else if ('D' == cArray[1]) {
                    n = n & 0xFF8FFFFF | 0x700000;
                }
                if (n2 > 2) {
                    if ('Y' == cArray[2]) {
                        n = n & 0xFFFCFFFF | 0x10000;
                    } else if ('N' == cArray[2]) {
                        n = n & 0xFFFCFFFF | 0x30000;
                    }
                    if (n2 > 3) {
                        if ('N' == cArray[3]) {
                            n = n & 0xFFFFFFF0 | 1;
                        } else if ('S' == cArray[3]) {
                            n = n & 0xFFFFFFF0 | 3;
                        } else if ('I' == cArray[3]) {
                            n = n & 0xFFFFFFF0 | 5;
                        } else if ('M' == cArray[3]) {
                            n = n & 0xFFFFFFF0 | 7;
                        } else if ('F' == cArray[3]) {
                            n = n & 0xFFFFFFF0 | 9;
                        } else if ('B' == cArray[3]) {
                            n = n & 0xFFFFFFF0 | 0xB;
                        }
                        if (n2 > 4) {
                            if ('N' == cArray[4]) {
                                n = n & 0xFFFFF8FF | 0x100;
                            } else if ('H' == cArray[4]) {
                                n = n & 0xFFFFF8FF | 0x300;
                            } else if ('C' == cArray[4]) {
                                n = n & 0xFFFFF8FF | 0x500;
                            } else if ('A' == cArray[4]) {
                                n = n & 0xFFFFF8FF | 0x700;
                            }
                        }
                    }
                }
            }
        }
        this.value = n;
    }

    public BidiFlagSet(String string) throws IllegalArgumentException {
        int n = BidiFlagSet.parseBidiFlagSet(string);
        if (n < 0) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_BIDI_FLAG_STRING_NOT_VALID", string));
        }
        this.value = n;
    }

    public boolean equals(BidiFlagSet bidiFlagSet) {
        if (bidiFlagSet == null) {
            return false;
        }
        return this.value == bidiFlagSet.value;
    }

    public BidiFlag getNumerals() {
        switch (this.value & 0x700) {
            case 256: {
                return BidiFlag.NUMERALS_NOMINAL;
            }
            case 768: {
                return BidiFlag.NUMERALS_NATIONAL;
            }
            case 1280: {
                return BidiFlag.NUMERALS_CONTEXTUAL;
            }
            case 1792: {
                return BidiFlag.NUMERALS_ANY;
            }
        }
        return BidiFlag.NUMERALS_NOMINAL;
    }

    public BidiFlag getOrientation() {
        switch (this.value & 0x700000) {
            case 0x100000: {
                return BidiFlag.ORIENTATION_LTR;
            }
            case 0x300000: {
                return BidiFlag.ORIENTATION_RTL;
            }
            case 0x500000: {
                return BidiFlag.ORIENTATION_CONTEXT_LTR;
            }
            case 0x700000: {
                return BidiFlag.ORIENTATION_CONTEXT_RTL;
            }
        }
        return BidiFlag.ORIENTATION_LTR;
    }

    public BidiFlag getSwap() {
        switch (this.value & 0x30000) {
            case 65536: {
                return BidiFlag.SWAP_YES;
            }
            case 196608: {
                return BidiFlag.SWAP_NO;
            }
        }
        return BidiFlag.SWAP_YES;
    }

    public BidiFlag getText() {
        switch (this.value & 0xF) {
            case 1: {
                return BidiFlag.TEXT_NOMINAL;
            }
            case 3: {
                return BidiFlag.TEXT_SHAPED;
            }
            case 5: {
                return BidiFlag.TEXT_INITIAL;
            }
            case 7: {
                return BidiFlag.TEXT_MIDDLE;
            }
            case 9: {
                return BidiFlag.TEXT_FINAL;
            }
            case 11: {
                return BidiFlag.TEXT_ISOLATED;
            }
        }
        return BidiFlag.TEXT_NOMINAL;
    }

    public BidiFlag getType() {
        switch (this.value & 0x3000000) {
            case 0x1000000: {
                return BidiFlag.TYPE_IMPLICIT;
            }
            case 0x3000000: {
                return BidiFlag.TYPE_VISUAL;
            }
        }
        return BidiFlag.TYPE_IMPLICIT;
    }

    public int hashCode() {
        return this.value;
    }

    private static int parseBidiFlagSet(String string) {
        int n = 0;
        int n2 = 0;
        String string2 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t ,=");
        while (stringTokenizer.hasMoreElements()) {
            String string3 = stringTokenizer.nextToken();
            --n2;
            if (string3.equals("@ls")) continue;
            if (string3.equals("implicitalg") || string3.equals("checkmode") || string3.equals("shapcharset")) {
                string2 = "allowed";
                continue;
            }
            if (string3.equals("typeoftext") || string3.equals("orientation") || string3.equals("context") || string3.equals("swapping") || string3.equals("numerals") || string3.equals("shaping")) {
                string2 = string3;
                continue;
            }
            if (string3.equals("visual")) {
                if (!string2.equals("typeoftext")) {
                    return n2;
                }
                n = n & 0xFCFFFFFF | 0x3000000;
                continue;
            }
            if (string3.equals("implicit")) {
                if (!string2.equals("typeoftext")) {
                    return n2;
                }
                n = n & 0xFCFFFFFF | 0x1000000;
                continue;
            }
            if (string3.equals("ltr")) {
                if (string2.equals("orientation")) {
                    n = n & 0xFF8FFFFF | 0x100000;
                    continue;
                }
                if (string2.equals("context")) {
                    if ((n & 0x700000) == 0x100000 || (n & 0x700000) == 0x300000) continue;
                    n = n & 0xFF8FFFFF | 0x500000;
                    continue;
                }
                return n2;
            }
            if (string3.equals("rtl")) {
                if (string2.equals("orientation")) {
                    n = n & 0xFF8FFFFF | 0x300000;
                    continue;
                }
                if (string2.equals("context")) {
                    if ((n & 0x700000) == 0x100000 || (n & 0x700000) == 0x300000) continue;
                    n = n & 0xFF8FFFFF | 0x700000;
                    continue;
                }
                return n2;
            }
            if (string3.equals("contextual")) {
                if (string2.equals("orientation")) {
                    if ((n & 0x700000) == 0x700000) continue;
                    n = n & 0xFF8FFFFF | 0x500000;
                    continue;
                }
                if (string2.equals("numerals")) {
                    n = n & 0xFFFFF8FF | 0x500;
                    continue;
                }
                return n2;
            }
            if (string3.equals("yes")) {
                if (!string2.equals("swapping")) {
                    return n2;
                }
                n = n & 0xFFFCFFFF | 0x10000;
                continue;
            }
            if (string3.equals("no")) {
                if (!string2.equals("swapping")) {
                    return n2;
                }
                n = n & 0xFFFCFFFF | 0x30000;
                continue;
            }
            if (string3.equals("nominal")) {
                if (string2.equals("numerals")) {
                    n = n & 0xFFFFF8FF | 0x100;
                    continue;
                }
                if (string2.equals("shaping")) {
                    n = n & 0xFFFFFFF0 | 1;
                    continue;
                }
                return n2;
            }
            if (string3.equals("national")) {
                if (!string2.equals("numerals")) {
                    return n2;
                }
                n = n & 0xFFFFF8FF | 0x300;
                continue;
            }
            if (string3.equals("any")) {
                if (!string2.equals("numerals")) {
                    return n2;
                }
                n = n & 0xFFFFF8FF | 0x700;
                continue;
            }
            if (string3.equals("shaped")) {
                if (!string2.equals("shaping")) {
                    return n2;
                }
                n = n & 0xFFFFFFF0 | 3;
                continue;
            }
            if (string3.equals("shform1")) {
                if (!string2.equals("shaping")) {
                    return n2;
                }
                n = n & 0xFFFFFFF0 | 5;
                continue;
            }
            if (string3.equals("shform2")) {
                if (!string2.equals("shaping")) {
                    return n2;
                }
                n = n & 0xFFFFFFF0 | 7;
                continue;
            }
            if (string3.equals("shform3")) {
                if (!string2.equals("shaping")) {
                    return n2;
                }
                n = n & 0xFFFFFFF0 | 9;
                continue;
            }
            if (string3.equals("shform4")) {
                if (!string2.equals("shaping")) {
                    return n2;
                }
                n = n & 0xFFFFFFF0 | 0xB;
                continue;
            }
            if (string2.equals("allowed")) continue;
            return n2;
        }
        return n | 0x1110101;
    }

    public void setAllFlags(BidiFlagSet bidiFlagSet) {
        this.value = bidiFlagSet.value;
    }

    public void setAllFlags(String string) throws IllegalArgumentException {
        int n = BidiFlagSet.parseBidiFlagSet(string);
        if (n < 0) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_BIDI_FLAG_STRING_NOT_VALID", string));
        }
        this.value = n;
    }

    public static void set2AllFlags(BidiFlagSet bidiFlagSet, BidiFlagSet bidiFlagSet2, String string) throws IllegalArgumentException {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        StringBuffer stringBuffer2 = new StringBuffer(n);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t ,=:", true);
        int n2 = 0;
        boolean bl = false;
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals(" ") || string2.equals("\t")) {
                stringBuffer.append(string2);
                stringBuffer2.append(string2);
                continue;
            }
            if (string2.equals(",") || string2.equals("=")) {
                bl = false;
                stringBuffer.append(string2);
                stringBuffer2.append(string2);
                continue;
            }
            if (string2.equals(":")) {
                bl = true;
                stringBuffer2.setLength(n2);
                continue;
            }
            if (!bl) {
                stringBuffer.append(string2);
            }
            n2 = stringBuffer2.length();
            stringBuffer2.append(string2);
            bl = false;
        }
        bidiFlagSet.setAllFlags(stringBuffer.toString());
        bidiFlagSet2.setAllFlags(stringBuffer2.toString());
    }

    public void setOneFlag(BidiFlag bidiFlag) {
        this.value = this.value & ~bidiFlag.mask | bidiFlag.value;
    }

    public String toString() {
        return BidiFlagSet.toString(this.value);
    }

    static String toString(int n) {
        String[] stringArray = new String[]{"implicit", "visual"};
        String[] stringArray2 = new String[]{"ltr", "rtl", "contextual, context=ltr", "contextual, context=rtl"};
        String[] stringArray3 = new String[]{"yes", "no"};
        String[] stringArray4 = new String[]{"nominal", "national", "contextual", "any"};
        String[] stringArray5 = new String[]{"nominal", "shaped", "shform1", "shform2", "shform3", "shform4", "invalid", "invalid"};
        return "typeoftext=" + stringArray[(n & 0x3000000) >> 25] + ", " + "orientation=" + stringArray2[(n & 0x700000) >> 21] + ", " + "swapping=" + stringArray3[(n & 0x30000) >> 17] + ", " + "numerals=" + stringArray4[(n & 0x700) >> 9] + ", " + "shaping=" + stringArray5[(n & 0xF) >> 1];
    }
}

