/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.marshall.util;

import com.ibm.etools.marshall.util.ConversionUtils;
import com.ibm.etools.marshall.util.MarshallResource;
import java.io.IOException;
import java.math.BigDecimal;

public class MarshallFloatUtils {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    public static final int FLOAT_FORMAT_UNSPECIFIED = 0;
    public static final int FLOAT_FORMAT_IEEE_EXTENTED_INTEL = 1;
    public static final int FLOAT_FORMAT_IEEE_EXTENTED_AIX = 2;
    public static final int FLOAT_FORMAT_IEEE_EXTENTED_OS390 = 3;
    public static final int FLOAT_FORMAT_IEEE_EXTENTED_AS400 = 4;
    public static final int FLOAT_FORMAT_IEEE_NON_EXTENTED = 5;
    public static final int FLOAT_FORMAT_IBM_390_HEX = 6;
    public static final int FLOAT_FORMAT_IBM_400_HEX = 7;

    public static void marshallFloatIntoBuffer(BigDecimal bigDecimal, byte[] byArray, int n, boolean bl, int n2, int n3) throws IllegalArgumentException {
        switch (n3) {
            case 4: {
                float f = bigDecimal.floatValue();
                MarshallFloatUtils.marshallFloatIntoBuffer(f, byArray, n, bl, n2, n3);
                break;
            }
            case 8: {
                double d = bigDecimal.doubleValue();
                MarshallFloatUtils.marshallFloatIntoBuffer(d, byArray, n, bl, n2, n3);
                break;
            }
            case 16: {
                byte[] byArray2 = null;
                switch (n2) {
                    case 1: {
                        byArray2 = ConversionUtils.convertBigDecimalToIEEEExtendedIntel(bigDecimal);
                        break;
                    }
                    case 2: {
                        byArray2 = ConversionUtils.convertBigDecimalToIEEEExtendedAIX(bigDecimal);
                        break;
                    }
                    case 3: {
                        byArray2 = ConversionUtils.convertBigDecimalToIEEEExtendedOS390(bigDecimal);
                        break;
                    }
                    case 6: 
                    case 7: {
                        byArray2 = ConversionUtils.convertBigDecimalToIBM390HexExtended(bigDecimal);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_FP_16_NOT_SUPPORTED"));
                    }
                }
                if (!bl) {
                    ConversionUtils.endianSwap(byArray2);
                }
                System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                break;
            }
            default: {
                throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_FP_SIZE_NOT_VALID", Integer.toString(n3)));
            }
        }
    }

    public static void marshallFloatIntoBuffer(double d, byte[] byArray, int n, boolean bl, int n2, int n3) throws IllegalArgumentException {
        byte[] byArray2 = null;
        if (n3 != 8) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_FP_SIZE_NOT_VALID", Integer.toString(n3)));
        }
        if (n2 == 6 || n2 == 7) {
            try {
                long l = ConversionUtils.doubleToS390LongBits(d);
                byArray2 = ConversionUtils.convertToByte(l);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(iOException.getMessage());
            }
        } else {
            byArray2 = ConversionUtils.convertToByte(d);
        }
        if (!bl) {
            ConversionUtils.endianSwap(byArray2);
        }
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
    }

    public static void marshallFloatIntoBuffer(float f, byte[] byArray, int n, boolean bl, int n2, int n3) throws IllegalArgumentException {
        byte[] byArray2 = null;
        if (n3 != 4) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_FP_SIZE_NOT_VALID", Integer.toString(n3)));
        }
        if (n2 == 6 || n2 == 7) {
            try {
                int n4 = ConversionUtils.floatToS390IntBits(f);
                byArray2 = ConversionUtils.convertToByte(n4);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(iOException.getMessage());
            }
        } else {
            byArray2 = ConversionUtils.convertToByte(f);
        }
        if (!bl) {
            ConversionUtils.endianSwap(byArray2);
        }
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
    }

    public static BigDecimal unmarshallBigDecimalFromBuffer(byte[] byArray, int n, boolean bl, int n2, int n3) throws IllegalArgumentException {
        BigDecimal bigDecimal = null;
        switch (n3) {
            case 4: {
                float f = MarshallFloatUtils.unmarshallFloatFromBuffer(byArray, n, bl, n2, n3);
                bigDecimal = new BigDecimal(Float.toString(f));
                break;
            }
            case 8: {
                double d = MarshallFloatUtils.unmarshallDoubleFromBuffer(byArray, n, bl, n2, n3);
                bigDecimal = new BigDecimal(Double.toString(d));
                break;
            }
            case 16: {
                byte[] byArray2 = null;
                byArray2 = n2 == 1 ? new byte[10] : new byte[16];
                System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
                if (!bl) {
                    ConversionUtils.endianSwap(byArray2);
                }
                String string = null;
                switch (n2) {
                    case 1: {
                        string = ConversionUtils.convertIEEEExtendedIntelToString(byArray2);
                        break;
                    }
                    case 2: {
                        string = ConversionUtils.convertIEEEExtendedAIXToString(byArray2);
                        break;
                    }
                    case 3: {
                        string = ConversionUtils.convertIEEEExtendedOS390ToString(byArray2);
                        break;
                    }
                    case 6: 
                    case 7: {
                        string = ConversionUtils.convertIBM390HexExtendedToString(byArray2);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_FP_16_NOT_SUPPORTED"));
                    }
                }
                bigDecimal = new BigDecimal(string);
                break;
            }
            default: {
                throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_FP_SIZE_NOT_VALID", Integer.toString(n3)));
            }
        }
        return bigDecimal;
    }

    public static double unmarshallDoubleFromBuffer(byte[] byArray, int n, boolean bl, int n2, int n3) throws IllegalArgumentException {
        if (n3 != 8) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_FP_SIZE_NOT_VALID", Integer.toString(n3)));
        }
        byte[] byArray2 = new byte[8];
        System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
        if (!bl) {
            ConversionUtils.endianSwap(byArray2);
        }
        double d = 0.0;
        if (n2 == 6 || n2 == 7) {
            try {
                d = ConversionUtils.longS390BitsToDouble(ConversionUtils.convertFromByteToLong(byArray2));
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(iOException.getMessage());
            }
        } else {
            d = ConversionUtils.convertFromByteToDouble(byArray2);
        }
        return d;
    }

    public static float unmarshallFloatFromBuffer(byte[] byArray, int n, boolean bl, int n2, int n3) throws IllegalArgumentException {
        if (n3 != 4) {
            throw new IllegalArgumentException(MarshallResource.instance().getString("MARSHRT_FP_SIZE_NOT_VALID", Integer.toString(n3)));
        }
        byte[] byArray2 = new byte[4];
        System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
        if (!bl) {
            ConversionUtils.endianSwap(byArray2);
        }
        float f = 0.0f;
        if (n2 == 6 || n2 == 7) {
            try {
                f = ConversionUtils.intS390BitsToFloat(ConversionUtils.convertFromByteToInt(byArray2));
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(iOException.getMessage());
            }
        } else {
            f = ConversionUtils.convertFromByteToFloat(byArray2);
        }
        return f;
    }
}

