/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ctc.wsdl.extensions.physicalrep.properties;

import com.ibm.etools.ctc.physicalrep.PhysicalrepPlugin;
import com.ibm.etools.ctc.wsdl.extensions.physicalrep.properties.IPhysicalrepProperty;
import com.ibm.etools.ctc.wsdl.extensions.physicalrep.properties.RecognitionPropertyDescriptor;
import com.ibm.etools.ctc.wsdl.extensions.physicalrep.util.SchemaUtils;
import com.ibm.etools.typedescriptor.InstanceTDBase;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PhysicalrepRecognitionProperty
implements IPhysicalrepProperty {
    private static final String copyright = "Licensed Material - Property of IBM <<PART NUMBER - 5724-D15>> (C) Copyright IBM Corp. 2001, 2003 - All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.".intern();
    private XSDComponent xsd;
    private InstanceTDBase instanceTD;
    private static final String recognitionPropertyId = "recognition";
    private String schemaPrefix;
    private String schemaForSchemaNamespace;

    public PhysicalrepRecognitionProperty(XSDComponent xSDComponent, InstanceTDBase instanceTDBase) {
        this.xsd = xSDComponent;
        this.instanceTD = instanceTDBase;
        this.schemaForSchemaNamespace = xSDComponent.getSchema().getSchemaForSchemaNamespace();
        this.schemaPrefix = xSDComponent.getSchema().getSchemaForSchemaQNamePrefix();
        this.schemaPrefix = this.schemaPrefix == null ? "" : this.schemaPrefix + ":";
    }

    public String getId() {
        return recognitionPropertyId;
    }

    public boolean isPropertySet() {
        return true;
    }

    public Object readProperty() {
        String string = "";
        XSDAnnotation xSDAnnotation = this.getAnnotation(false);
        if (xSDAnnotation != null) {
            string = this.getRecognitionPattern(xSDAnnotation);
        }
        return string;
    }

    public boolean writeProperty(Object object) {
        XSDAnnotation xSDAnnotation;
        String string = null;
        if (!(object instanceof String)) {
            return false;
        }
        string = (String)object;
        if (string == null || string.trim().length() == 0) {
            xSDAnnotation = this.getAnnotation(false);
            if (xSDAnnotation != null) {
                this.removeRecognitionPattern(xSDAnnotation);
            }
        } else {
            xSDAnnotation = this.getAnnotation(true);
            this.setRecognitionPattern(xSDAnnotation, string);
        }
        this.resetAnnotation(xSDAnnotation);
        this.xsd.eResource().setModified(true);
        return true;
    }

    public PropertyDescriptor getPropertyDescriptor() {
        RecognitionPropertyDescriptor recognitionPropertyDescriptor = new RecognitionPropertyDescriptor(recognitionPropertyId, PhysicalrepPlugin.getResources().getMessage("%RECOGNITION"), this.xsd, this.instanceTD);
        return recognitionPropertyDescriptor;
    }

    private XSDAnnotation getAnnotation(boolean bl) {
        XSDParticleContent xSDParticleContent;
        XSDAnnotation xSDAnnotation = null;
        if (this.xsd instanceof XSDElementDeclaration) {
            xSDAnnotation = ((XSDElementDeclaration)this.xsd).getAnnotation();
            if (xSDAnnotation == null && bl) {
                xSDAnnotation = XSDPackage.eINSTANCE.getXSDFactory().createXSDAnnotation();
                ((XSDElementDeclaration)this.xsd).setAnnotation(xSDAnnotation);
            }
        } else if (this.xsd instanceof XSDParticle && (xSDParticleContent = ((XSDParticle)this.xsd).getContent()) != null && xSDParticleContent instanceof XSDElementDeclaration && (xSDAnnotation = ((XSDElementDeclaration)xSDParticleContent).getAnnotation()) == null && bl) {
            xSDAnnotation = XSDPackage.eINSTANCE.getXSDFactory().createXSDAnnotation();
            ((XSDElementDeclaration)xSDParticleContent).setAnnotation(xSDAnnotation);
        }
        return xSDAnnotation;
    }

    private void resetAnnotation(XSDAnnotation xSDAnnotation) {
        XSDParticleContent xSDParticleContent;
        if (this.xsd instanceof XSDElementDeclaration) {
            ((XSDElementDeclaration)this.xsd).setAnnotation(null);
            ((XSDElementDeclaration)this.xsd).setAnnotation(xSDAnnotation);
        } else if (this.xsd instanceof XSDParticle && (xSDParticleContent = ((XSDParticle)this.xsd).getContent()) != null && xSDParticleContent instanceof XSDElementDeclaration) {
            ((XSDElementDeclaration)xSDParticleContent).setAnnotation(null);
            ((XSDElementDeclaration)xSDParticleContent).setAnnotation(xSDAnnotation);
        }
    }

    private Element getAppInfoElement(XSDAnnotation xSDAnnotation, boolean bl) {
        Element element = null;
        Element element2 = xSDAnnotation.getElement();
        NodeList nodeList = element2.getElementsByTagName("appinfo");
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node instanceof Element && "http://www.wsadie.com/appinfo".equals(((Element)node).getAttribute("source"))) {
                element = (Element)node;
                break;
            }
            ++n;
        }
        if (element == null && bl) {
            element = element2.getOwnerDocument().createElementNS(this.schemaForSchemaNamespace, this.schemaPrefix + "appinfo");
            element.setAttribute("source", "http://www.wsadie.com/appinfo");
            element2.appendChild(element);
        }
        return element;
    }

    private String getRecognitionPattern(XSDAnnotation xSDAnnotation) {
        NodeList nodeList;
        String string = "";
        Element element = this.getAppInfoElement(xSDAnnotation, false);
        if (element != null && (nodeList = element.getElementsByTagName("recognitionDesc")).getLength() > 0) {
            string = ((Element)nodeList.item(0)).getAttribute("pattern");
            string = SchemaUtils.unEscapeUnicodeCharacters(string);
        }
        return string;
    }

    private void setRecognitionPattern(XSDAnnotation xSDAnnotation, String string) {
        string = SchemaUtils.fixStringForSchema(string);
        Element element = this.getAppInfoElement(xSDAnnotation, true);
        NodeList nodeList = element.getElementsByTagName("recognitionDesc");
        if (nodeList.getLength() > 0) {
            ((Element)nodeList.item(0)).setAttribute("pattern", string);
        } else {
            Element element2 = element.getOwnerDocument().createElementNS(this.schemaForSchemaNamespace, this.schemaPrefix + "recognitionDesc");
            element2.setAttribute("pattern", string);
            element.appendChild(element2);
        }
    }

    private void removeRecognitionPattern(XSDAnnotation xSDAnnotation) {
        Element element = this.getAppInfoElement(xSDAnnotation, false);
        NodeList nodeList = element.getElementsByTagName("recognitionDesc");
        if (nodeList.getLength() > 0) {
            element.removeChild(nodeList.item(0));
        }
    }
}

