/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util.cache;

import com.ibm.ejs.container.util.locking.LockTable;
import com.ibm.ejs.ras.Dumpable;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.MathUtil;
import com.ibm.ejs.util.cache.Bucket;
import com.ibm.ejs.util.cache.BucketImpl;
import com.ibm.ejs.util.cache.CacheElementEnumerator;
import com.ibm.ejs.util.cache.Element;
import com.ibm.ejs.util.cache.EvictionStrategy;
import com.ibm.ejs.util.cache.IllegalOperationException;
import com.ibm.ejs.util.cache.LimitStrategy;
import com.ibm.ejs.util.cache.NoSuchObjectException;
import com.ibm.ejs.util.cache.WrapperBucket;
import com.ibm.websphere.csi.DiscardException;
import com.ibm.websphere.csi.DiscardStrategy;
import com.ibm.websphere.csi.EJBCache;
import com.ibm.websphere.csi.FaultException;
import com.ibm.websphere.csi.FaultStrategy;
import com.ibm.websphere.csi.InsufficientCacheSpaceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.cache.DiscardWithLockStrategy;
import java.util.Enumeration;

public final class Cache
implements EJBCache,
Dumpable {
    protected FaultStrategy faultStrategy = null;
    protected LimitStrategy limitStrategy = null;
    protected EvictionStrategy evictionStrategy = null;
    protected DiscardStrategy discardStrategy = null;
    protected LockTable ivEvictionLocks = null;
    protected String ivName;
    protected Bucket[] buckets;
    protected int numBuckets;
    protected int numObjects = 0;
    private int numEvictionAttempts = 0;
    private int numEvictions = 0;
    protected long numSweeps = 0L;
    protected boolean dumped = false;
    private static final TraceComponent tc = Tr.register(Cache.class, "EJBCache", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.util.cache.Cache";

    public Cache(String name, int numBuckets, boolean wrappers) {
        numBuckets = MathUtil.findNextPrime((int)numBuckets);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init> (" + name + "," + numBuckets + "," + wrappers + ")");
        }
        this.ivName = name;
        this.numBuckets = numBuckets;
        this.buckets = new Bucket[numBuckets];
        if (wrappers) {
            for (int i = 0; i < numBuckets; ++i) {
                this.buckets[i] = new WrapperBucket(this);
            }
        } else {
            for (int i = 0; i < numBuckets; ++i) {
                this.buckets[i] = new BucketImpl();
            }
        }
        Tr.registerDumpable(tc, this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public Cache(String name, long numBuckets, boolean wrappers) {
        this(name, (int)numBuckets, wrappers);
    }

    public final int getSize() {
        return this.numObjects;
    }

    public final int getConfigSize() {
        return this.numBuckets;
    }

    public String getName() {
        return this.ivName;
    }

    public final void setFaultStrategy(FaultStrategy strategy) {
        this.faultStrategy = strategy;
    }

    public final void setLimitStrategy(LimitStrategy strategy) {
        this.limitStrategy = strategy;
    }

    public final void setEvictionStrategy(EvictionStrategy strategy) {
        this.evictionStrategy = strategy;
    }

    public final void setDiscardStrategy(DiscardStrategy strategy) {
        this.discardStrategy = strategy;
        if (strategy instanceof DiscardWithLockStrategy) {
            this.ivEvictionLocks = ((DiscardWithLockStrategy)strategy).getEvictionLockTable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object key) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "contains", key);
        }
        Bucket bucket = this.getBucketForKey(key);
        Element element = null;
        Bucket bucket2 = bucket;
        synchronized (bucket2) {
            element = bucket.findByKey(key);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "contains", new Boolean(element != null));
        }
        return element != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object find(Object key) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "find", key);
        }
        Bucket bucket = this.getBucketForKey(key);
        Object object = null;
        Bucket bucket2 = bucket;
        synchronized (bucket2) {
            Element element = bucket.findByKey(key);
            if (element != null) {
                ++element.pinned;
                object = element.object;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "find", object);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object findDontPinNAdjustPinCount(Object key, int adjustPinCount) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "findDontPinNAdjustPinCount", key + ", adujust pin count=" + adjustPinCount);
        }
        Bucket bucket = this.getBucketForKey(key);
        Object object = null;
        Bucket bucket2 = bucket;
        synchronized (bucket2) {
            Element element = bucket.findByKey(key);
            if (element != null) {
                element.accessed = true;
                element.sweepCount = 0;
                element.accessedSweep = this.numSweeps;
                object = element.object;
                element.pinned += adjustPinCount;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "findDontPinNAdjustPinCount", object);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object findAndFault(Object key) throws FaultException, InsufficientCacheSpaceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "findAndFault", key);
        }
        Bucket bucket = this.getBucketForKey(key);
        Object object = null;
        Object object2 = bucket;
        synchronized (object2) {
            Element element = bucket.findByKey(key);
            if (element != null) {
                element.accessed = true;
                element.sweepCount = 0;
                element.accessedSweep = this.numSweeps;
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "findAndFault : found in cache");
                }
                return element.object;
            }
            if (this.faultStrategy == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "findAndFault : not in cache : no FaultStrategy");
                }
                return null;
            }
            try {
                object = this.faultStrategy.faultOnKey(this, key);
                if (object != null) {
                    element = bucket.insertByKey(key, object);
                    element.accessed = true;
                    element.sweepCount = 0;
                    element.accessedSweep = this.numSweeps;
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.util.cache.Cache.findAndFault", (String)"417", (Object)this);
                throw new FaultException(e, key.toString());
            }
        }
        if (object != null) {
            object2 = this;
            synchronized (object2) {
                ++this.numObjects;
            }
        }
        this.trimCache();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "findAndFault : not in cache : faulted");
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object key, boolean dropRef) {
        Object object;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "remove", new Object[]{key, new Boolean(dropRef)});
        }
        Bucket bucket = this.getBucketForKey(key);
        Object object2 = bucket;
        synchronized (object2) {
            Element element = bucket.removeByKey(key, dropRef);
            object = element != null ? element.object : null;
        }
        if (object != null) {
            object2 = this;
            synchronized (object2) {
                --this.numObjects;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "remove", object);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removeAndDiscard(Object key, boolean dropRef) throws DiscardException {
        Object object;
        block16: {
            Cache cache;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "removeAndDiscard", new Object[]{key, new Boolean(dropRef)});
            }
            Bucket bucket = this.getBucketForKey(key);
            object = null;
            try {
                Bucket bucket2 = bucket;
                synchronized (bucket2) {
                    Element element = bucket.removeByKey(key, dropRef);
                    Object object2 = object = element != null ? element.object : null;
                    if (object != null && this.discardStrategy != null) {
                        try {
                            this.discardStrategy.discardObject(this, element.key, element.object);
                        }
                        catch (Exception ex) {
                            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.util.cache.Cache.removeAndDiscard", (String)"540", (Object)this);
                            Tr.warning(tc, "EXCEPTION_THROWN_BY_DISCARD_STRATEGY_CNTR0054W", new Object[]{element, ex});
                            element = null;
                            throw new DiscardException(ex, key);
                        }
                    }
                }
                Object var10_9 = null;
                if (object == null) break block16;
                cache = this;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (object != null) {
                    Cache cache2 = this;
                    synchronized (cache2) {
                        --this.numObjects;
                    }
                }
                throw throwable;
            }
            synchronized (cache) {
                --this.numObjects;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "removeAndDiscard", object);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(Object key, Object object) throws InsufficientCacheSpaceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "insert", new Object[]{key, object});
        }
        try {
            this.trimCache();
            Bucket bucket = this.getBucketForKey(key);
            Object object2 = bucket;
            synchronized (object2) {
                Element element = bucket.insertByKey(key, object);
                ++element.pinned;
            }
            object2 = this;
            synchronized (object2) {
                ++this.numObjects;
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "insert");
            }
            throw throwable;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "insert");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pin(Object key) {
        Bucket bucket;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "pin", key);
        }
        Bucket bucket2 = bucket = this.getBucketForKey(key);
        synchronized (bucket2) {
            Element element = bucket.findByKey(key);
            if (element == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "pin - throw NoSuchObjectException");
                }
                throw new NoSuchObjectException(key);
            }
            ++element.pinned;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "pin");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markEvictionIneligible(Object key) {
        Bucket bucket;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "markEvictionIneligible", key);
        }
        Bucket bucket2 = bucket = this.getBucketForKey(key);
        synchronized (bucket2) {
            Element element = bucket.findByKey(key);
            if (element == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "markEvictionIneligible - throw NoSuchObjectException");
                }
                throw new NoSuchObjectException(key);
            }
            element.ivEvictionIneligible = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "markEvictionIneligible");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pinOnce(Object key) {
        Bucket bucket;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "pinOnce", key);
        }
        boolean pinned = false;
        Bucket bucket2 = bucket = this.getBucketForKey(key);
        synchronized (bucket2) {
            Element element = bucket.findByKey(key);
            if (element != null && element.pinned == 0) {
                ++element.pinned;
                pinned = true;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "pinOnce : " + pinned);
        }
        return pinned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int unpin(Object key) {
        Bucket bucket;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "unpin", key);
        }
        int remaining = 0;
        Bucket bucket2 = bucket = this.getBucketForKey(key);
        synchronized (bucket2) {
            Element element = bucket.findByKey(key);
            if (element == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "unpin - throw NoSuchObjectException");
                }
                throw new NoSuchObjectException(key);
            }
            if (element.pinned < 1) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "unpin - throw IllegalOperationException");
                }
                throw new IllegalOperationException(key, element.pinned);
            }
            --element.pinned;
            remaining = element.pinned;
            element.accessed = true;
            element.sweepCount = 0;
            element.accessedSweep = this.numSweeps;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "unpin:" + remaining);
        }
        return remaining;
    }

    public void touch(Element element) {
        element.accessed = true;
        element.sweepCount = 0;
        element.accessedSweep = this.numSweeps;
    }

    public final Enumeration enumerateElements() {
        return new CacheElementEnumerator(this);
    }

    public final Bucket getBucketForKey(Object key) {
        return this.buckets[(key.hashCode() & Integer.MAX_VALUE) % this.buckets.length];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void trimCache() throws InsufficientCacheSpaceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "trimCache");
        }
        if (this.limitStrategy == null || this.evictionStrategy == null) {
            return;
        }
        while (this.limitStrategy.hardLimitReached(this)) {
            Object victimKey = this.evictionStrategy.getVictim(this);
            if (victimKey != null) {
                if (this.ivEvictionLocks != null) {
                    Object object = this.ivEvictionLocks.getLock(victimKey);
                    synchronized (object) {
                        this.evictObject(victimKey);
                        continue;
                    }
                }
                this.evictObject(victimKey);
                continue;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "trimCache - throw InsufficientCacheSpaceException");
            }
            throw new InsufficientCacheSpaceException();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "trimCache");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected boolean evictObject(Object key) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "evictObject", key);
        }
        Bucket bucket = this.getBucketForKey(key);
        Element element = null;
        Object object = this;
        // MONITORENTER : object
        ++this.numEvictionAttempts;
        // MONITOREXIT : object
        try {
            try {
                block19: {
                    block18: {
                        object = bucket;
                        // MONITORENTER : object
                        element = bucket.findByKey(key);
                        if (element == null || !this.evictionStrategy.canBeDiscarded(element)) break block18;
                        element = bucket.discardByKey(key);
                        if (element != null) {
                            Cache cache = this;
                            // MONITORENTER : cache
                            --this.numObjects;
                            ++this.numEvictions;
                            // MONITOREXIT : cache
                            if (this.discardStrategy != null) {
                                try {
                                    this.discardStrategy.discardObject(this, element.key, element.object);
                                }
                                catch (Exception ex) {
                                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.util.cache.Cache.evictObject", (String)"863", (Object)this);
                                    Tr.warning(tc, "EXCEPTION_THROWN_BY_DISCARD_STRATEGY_CNTR0054W", new Object[]{element, ex});
                                    element = null;
                                }
                            }
                        }
                        break block19;
                    }
                    element = null;
                }
                // MONITOREXIT : object
            }
            catch (IllegalOperationException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.util.cache.Cache.evictObject", (String)"878", (Object)this);
                element = null;
                Object var9_9 = null;
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "evictObject", new Boolean(element != null));
                }
            }
            Object var9_8 = null;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "evictObject", new Boolean(element != null));
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (!TraceComponent.isAnyTracingEnabled()) throw throwable;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "evictObject", new Boolean(element != null));
            throw throwable;
        }
        if (element == null) return false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump() {
        if (this.dumped) {
            return;
        }
        try {
            Tr.dump(tc, "-- Cache Dump -- ", this);
            Tr.dump(tc, "Name of Cache: " + this.ivName);
            Tr.dump(tc, "Number of buckets: " + this.numBuckets);
            Cache cache = this;
            synchronized (cache) {
                Tr.dump(tc, "Number of objects currently in cache: " + this.numObjects);
                Tr.dump(tc, "Number of evictions attempted (since last dump): " + this.numEvictionAttempts);
                Tr.dump(tc, "Number of evictions (since last dump): " + this.numEvictions);
            }
            Object var4_3 = null;
            this.dumped = true;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.dumped = true;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetDump() {
        this.dumped = false;
        Cache cache = this;
        synchronized (cache) {
            this.numEvictionAttempts = 0;
            this.numEvictions = 0;
        }
    }
}

