/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.RasException;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.io.File;
import java.io.InputStream;
import java.util.Properties;

class RasProperties {
    private static final String svActivityLogDefaultName = "activity.log";
    private static String svActivityLogName = null;
    private static int svActivityLogSize = 0x100000;
    private static int ACTIVITY_LOG_DEFAULT_SIZE = 0x100000;
    private static int ACTIVITY_LOG_MAX_SIZE = 0x40000000;
    private static int ACTIVITY_LOG_MIN_SIZE = 8096;
    private static String svDefaultLoggingDirectory = null;
    private static final String svLogDir = "logs";
    static boolean svUowEnabled = false;
    static int svFilterMessageLevel = 3;
    static int Error = 0;
    static int Warning = 1;
    static int Service = 2;
    static int Audit = 3;
    static String svTraceFormat = "basic";
    private static String svMessageFormat = "basic";
    private static boolean svInitialized = false;
    private static String svPropertiesFileName = "logging.properties";

    RasProperties() {
    }

    static String setTraceFormatProperty(String format) {
        if (format == null) {
            svTraceFormat = "basic";
            return svTraceFormat;
        }
        if (format.equalsIgnoreCase("loganalyzer")) {
            svTraceFormat = "loganalyzer";
            return svTraceFormat;
        }
        if (format.equalsIgnoreCase("advanced")) {
            svTraceFormat = "advanced";
            return svTraceFormat;
        }
        svTraceFormat = "basic";
        return svTraceFormat;
    }

    static String getTraceFormatProperty() {
        return svTraceFormat;
    }

    static String setMessageFormatProperty(String format) {
        if (format == null) {
            svMessageFormat = "basic";
            return svMessageFormat;
        }
        if (format.equalsIgnoreCase("advanced")) {
            svMessageFormat = "advanced";
            return svMessageFormat;
        }
        svMessageFormat = "basic";
        return svMessageFormat;
    }

    static String getMessageFormatProperty() {
        return svMessageFormat;
    }

    static void setMessageFilterLevelProperty(String format) {
        if (format == null) {
            svFilterMessageLevel = 3;
            return;
        }
        if (format.equalsIgnoreCase("WARNING")) {
            svFilterMessageLevel = 0;
            return;
        }
        if (format.equalsIgnoreCase("SERVICE")) {
            svFilterMessageLevel = 1;
            return;
        }
        if (format.equalsIgnoreCase("AUDIT")) {
            svFilterMessageLevel = 2;
            return;
        }
        svFilterMessageLevel = 3;
    }

    static String getMessageFilterLevelProperty() {
        if (svFilterMessageLevel == 3) {
            return "NONE";
        }
        if (svFilterMessageLevel == 2) {
            return "AUDIT";
        }
        if (svFilterMessageLevel == 1) {
            return "SERVICE";
        }
        if (svFilterMessageLevel == 0) {
            return "WARNING";
        }
        return "NONE";
    }

    static void setUnitOfWorkProperty(boolean enable) {
        svUowEnabled = enable;
    }

    static boolean getUnitOfWorkProperty() {
        return svUowEnabled;
    }

    static synchronized void setActivityLogName(String fileName) throws RasException {
        svActivityLogName = fileName;
    }

    static synchronized String getActivityLogName() throws RasException {
        if (svActivityLogName == null) {
            svActivityLogName = RasProperties.getDefaultLoggingDirectory() + File.separator + svActivityLogDefaultName;
        }
        return svActivityLogName;
    }

    static synchronized void setActivityLogSize(int size) {
        svActivityLogSize = size < ACTIVITY_LOG_MIN_SIZE ? ACTIVITY_LOG_MIN_SIZE : (size > ACTIVITY_LOG_MAX_SIZE ? ACTIVITY_LOG_MAX_SIZE : size);
    }

    static synchronized int getActivityLogSize() {
        return svActivityLogSize;
    }

    static synchronized String getDefaultLoggingDirectory() throws RasException {
        if (svDefaultLoggingDirectory == null) {
            String logDir = RasHelper.getSystemProperty("user.install.root");
            if (logDir == null) {
                throw new RasException("RasProperties - unable to obtain the install directory");
            }
            File directory = new File(logDir = logDir.endsWith(File.separator) ? logDir + svLogDir : logDir + File.separator + svLogDir);
            if (!RasHelper.fileExists(directory) && !RasHelper.makeDirectories(directory)) {
                throw new RasException("RasProperties - Unable to create directory  " + directory.getPath());
            }
            svDefaultLoggingDirectory = directory.getPath();
        }
        return svDefaultLoggingDirectory;
    }

    private static void createDirectoryIfNecessary(String fileName) throws RasException {
        File file = new File(fileName);
        int last = (fileName = file.getPath()).lastIndexOf(File.separator);
        if (last == -1) {
            throw new RasException("RasProperties File " + fileName + " is not a fully qualified name");
        }
        String directory = fileName.substring(0, last);
        file = new File(directory);
        if (!RasHelper.fileExists(file) && !RasHelper.makeDirectories(file)) {
            throw new RasException("Unable to create directory  " + directory);
        }
    }

    static synchronized void loadProperties() {
        if (svInitialized) {
            return;
        }
        try {
            Properties props = RasProperties.readProperties();
            svInitialized = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static synchronized void refreshRasProperties() {
        if (!svInitialized) {
            RasProperties.loadProperties();
        }
    }

    static boolean isUnitOfWorkEnabled() {
        return svUowEnabled;
    }

    static void debugDisplayProperties() {
        TraceComponent tc = Tr.register(RasProperties.class);
        Tr.uncondEvent(tc, "Activity Log Size = " + svActivityLogSize);
        Tr.uncondEvent(tc, "Unit of Work Enabled = " + svUowEnabled);
        Tr.uncondEvent(tc, "Message Filter Level = " + svFilterMessageLevel);
        Tr.uncondEvent(tc, "Trace Format = " + svTraceFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized Properties readProperties() {
        Properties propertiesToReturn = new Properties();
        InputStream stream = null;
        try {
            stream = RasHelper.getResourceAsStream(svPropertiesFileName);
            if (stream != null) {
                propertiesToReturn.load(stream);
            }
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (Exception e2) {}
        }
        return propertiesToReturn;
    }
}

