/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.logging.WsLevel;
import com.ibm.websphere.ras.RasMessage;
import com.ibm.ws.logging.LevelConstants;
import java.util.Locale;

public class RasMessageImpl2
implements RasMessage {
    static final long serialVersionUID = -3009779149389768840L;
    private long ivTimeStamp;
    private String ivThreadId;
    private String ivMessageSeverity;
    private String ivMessageKey;
    private String[] ivMessageParms;
    private String ivResourceBundleName;
    private String ivMessageOriginator;
    private String ivLocalizedMessage;
    private String ivLocalizedMessageLocale;
    private String ivDiagnosticProviderId;

    public RasMessageImpl2(long timeStamp, String threadId, String messageSeverity, String messageKey, Object[] messageParms, String resourceBundleName, String messageOriginator, String localizedMessage, String localizedMessageLocale, String diagnosticProviderId) {
        this.ivTimeStamp = timeStamp;
        this.ivThreadId = threadId;
        this.ivMessageSeverity = messageSeverity;
        if (messageParms != null) {
            this.ivMessageParms = new String[messageParms.length];
            for (int i = 0; i < messageParms.length; ++i) {
                if (messageParms[i] == null) continue;
                this.ivMessageParms[i] = messageParms[i].toString();
            }
        } else {
            this.ivMessageParms = new String[0];
        }
        this.ivMessageKey = messageKey;
        this.ivResourceBundleName = resourceBundleName;
        this.ivMessageOriginator = messageOriginator;
        this.ivLocalizedMessage = localizedMessage;
        this.ivLocalizedMessageLocale = localizedMessageLocale;
        this.ivDiagnosticProviderId = diagnosticProviderId;
    }

    public RasMessageImpl2() {
    }

    public long getTimeStamp() {
        return this.ivTimeStamp;
    }

    public String getThreadId() {
        return this.ivThreadId;
    }

    public String getMessageSeverity() {
        return this.ivMessageSeverity;
    }

    public String getMessageKey() {
        return this.ivMessageKey;
    }

    public String getResourceBundleName() {
        return this.ivResourceBundleName;
    }

    public String getMessageOriginator() {
        return this.ivMessageOriginator;
    }

    public String getLocalizedMessage(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (locale != null && this.ivLocalizedMessage != null && locale.toString().equals(this.ivLocalizedMessageLocale)) {
            return this.ivLocalizedMessage;
        }
        if (this.ivResourceBundleName == null) {
            return this.ivMessageKey;
        }
        String key = this.ivMessageKey.replace(' ', '.');
        if (this.ivMessageParms == null) {
            return TraceNLS.getStringFromBundle(this.ivResourceBundleName, key, locale, this.ivMessageKey);
        }
        return TraceNLS.getFormattedMessage(this.ivResourceBundleName, key, locale, this.ivMessageParms, this.ivMessageKey);
    }

    public String getDiagnosticProviderId() {
        return this.ivDiagnosticProviderId;
    }

    public static String convertSeverity(int level) {
        if (level == WsLevel.LEVEL_VALUES[LevelConstants.DISTINCT_LEVELS[15]]) {
            return "Fatal";
        }
        if (level == WsLevel.LEVEL_VALUES[LevelConstants.DISTINCT_LEVELS[13]]) {
            return "Error";
        }
        if (level == WsLevel.LEVEL_VALUES[LevelConstants.DISTINCT_LEVELS[12]]) {
            return "Warning";
        }
        if (level == WsLevel.LEVEL_VALUES[LevelConstants.DISTINCT_LEVELS[11]]) {
            return "Audit";
        }
        if (level == WsLevel.LEVEL_VALUES[LevelConstants.DISTINCT_LEVELS[10]]) {
            return "Informational";
        }
        if (level == WsLevel.LEVEL_VALUES[LevelConstants.DISTINCT_LEVELS[9]]) {
            return "Informational";
        }
        if (level == WsLevel.LEVEL_VALUES[LevelConstants.DISTINCT_LEVELS[8]]) {
            return "Informational";
        }
        return "Unknown";
    }
}

