/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.oa.pool;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.WorkUnit;
import com.ibm.ejs.oa.pool.PooledThread;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.ObjectPool;

public class ThreadPool
implements com.ibm.CORBA.iiop.ThreadPool {
    private static final TraceComponent tc = Tr.register(ThreadPool.class, "ObjectAdapter", "com.ibm.ws.runtime.runtime");
    public static final int DEFAULT_MIN_SIZE = 2;
    public static final int DEFAULT_MAX_SIZE = 20;
    protected ObjectPool workerPool;
    protected com.ibm.ws.util.ThreadPool threadPool;
    private long timeoutInMillis;

    public ThreadPool(com.ibm.ws.util.ThreadPool tp) {
        this(tp, 0L);
    }

    public ThreadPool(com.ibm.ws.util.ThreadPool tp, long timeoutInMillis) {
        this.threadPool = tp;
        this.timeoutInMillis = timeoutInMillis;
        this.workerPool = new ObjectPool("ORB thread pool", tp.getMaximumPoolSize()){

            protected Object createObject() {
                return new PooledThread(this);
            }
        };
    }

    public void cleanup() {
    }

    public void init(ORB orb) {
    }

    public void startWorkerThread(WorkUnit workUnit) {
        PooledThread req = (PooledThread)this.workerPool.remove();
        req.handleRequest(workUnit);
        Runnable result = null;
        try {
            result = this.threadPool.execute((Runnable)req, this.timeoutInMillis);
        }
        catch (InterruptedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.oa.pool.ThreadPool.startWorkerThread", (String)"83", (Object)this);
        }
        catch (RuntimeException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.oa.pool.ThreadPool.startWorkerThread", (String)"85", (Object)this);
            throw e;
        }
        catch (Error e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.oa.pool.ThreadPool.startWorkerThread", (String)"88", (Object)this);
            throw e;
        }
        if (result == null) {
            Tr.warning(tc, "WSVR0627W", new Long(this.timeoutInMillis));
            throw new RuntimeException("ThreadPool queue is full");
        }
    }
}

