/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.util;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.BeanO;
import com.ibm.ejs.container.ContainerException;
import com.ibm.ejs.container.UncheckedException;
import com.ibm.ejs.persistence.EJSPersistenceException;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cpi.CPIException;
import com.ibm.websphere.cpmi.CPMIException;
import com.ibm.websphere.csi.CSIException;
import com.ibm.websphere.csi.EJBMethodInfo;
import com.ibm.ws.exception.WsEJBException;
import com.ibm.ws.exception.WsNestedException;
import com.ibm.ws.javax.ejb.ActivityCompletedLocalException;
import com.ibm.ws.javax.ejb.ActivityRequiredLocalException;
import com.ibm.ws.javax.ejb.InvalidActivityLocalException;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.injectionengine.RecursiveInjectionException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import javax.ejb.AccessLocalException;
import javax.ejb.EJBException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.TransactionRequiredLocalException;
import javax.ejb.TransactionRolledbackLocalException;
import javax.naming.NamingException;
import org.omg.CORBA.portable.UnknownException;

public class ExceptionUtil {
    private static TraceComponent tc = Tr.register(ExceptionUtil.class, "EJBContainer", "com.ibm.ejs.container.container");

    public static final String throwableToString(Throwable t) {
        StringWriter s = new StringWriter();
        PrintWriter p = new PrintWriter(s);
        ExceptionUtil.printStackTrace(t, p);
        return s.toString();
    }

    public static final void logException(Throwable t, EJBMethodInfo m, BeanO bean) {
        ExceptionUtil.logException(tc, t, m, bean);
    }

    private static final boolean hasBeenLogged(Throwable t) {
        boolean hasBeenLogged = false;
        Throwable lastCause = null;
        for (Throwable cause = t; cause != null && cause != lastCause; cause = cause.getCause()) {
            if (cause instanceof RecursiveInjectionException) {
                if (((RecursiveInjectionException)cause).ivLogged) {
                    hasBeenLogged = true;
                    break;
                }
                ((RecursiveInjectionException)cause).ivLogged = true;
                hasBeenLogged = false;
                break;
            }
            lastCause = cause;
        }
        return hasBeenLogged;
    }

    public static final void logException(TraceComponent compTc, Throwable t, EJBMethodInfo m, BeanO bean) {
        if (ExceptionUtil.hasBeenLogged(t)) {
            return;
        }
        BeanId beanId = null;
        if (bean != null) {
            beanId = bean.getId();
        }
        if (m == null) {
            if (beanId == null) {
                Tr.error(compTc, "NON_APPLICATION_EXCEPTION_CNTR0018E", t);
            } else {
                Tr.error(compTc, "NON_APPLICATION_EXCEPTION_ON_BEAN_CNTR0021E", new Object[]{t, beanId});
            }
        } else {
            String methodName = m.getMethodName();
            if (beanId == null) {
                Tr.error(compTc, "NON_APPLICATION_EXCEPTION_METHOD_CNTR0019E", new Object[]{t, methodName});
            } else {
                Tr.error(compTc, "NON_APPLICATION_EXCEPTION_METHOD_ON_BEAN_CNTR0020E", new Object[]{t, methodName, beanId});
            }
        }
    }

    public static void logException(Throwable t) {
        ExceptionUtil.logException(tc, t, null, null);
    }

    private static final void printStackTrace(Throwable t, PrintWriter p) {
        t.printStackTrace(p);
    }

    public static Throwable findRootCause(Throwable throwable) {
        Throwable root;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "findRootCause: " + throwable);
        }
        Throwable next = root = throwable;
        while (next != null) {
            root = next;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "finding cause of: " + root.getClass().getName());
            }
            if (root instanceof RemoteException) {
                next = ((RemoteException)root).detail;
                continue;
            }
            if (root instanceof WsNestedException) {
                next = ((WsNestedException)((Object)root)).getCause();
                continue;
            }
            if (root instanceof TransactionRolledbackLocalException) {
                next = ((TransactionRolledbackLocalException)root).getCause();
                continue;
            }
            if (root instanceof AccessLocalException) {
                next = ((AccessLocalException)root).getCause();
                continue;
            }
            if (root instanceof NoSuchObjectLocalException) {
                next = ((NoSuchObjectLocalException)root).getCause();
                continue;
            }
            if (root instanceof TransactionRequiredLocalException) {
                next = ((TransactionRequiredLocalException)root).getCause();
                continue;
            }
            if (root instanceof InvalidActivityLocalException) {
                root = ((InvalidActivityLocalException)root).getCause();
                continue;
            }
            if (root instanceof ActivityRequiredLocalException) {
                root = ((ActivityRequiredLocalException)root).getCause();
                continue;
            }
            if (root instanceof ActivityCompletedLocalException) {
                next = ((ActivityCompletedLocalException)root).getCause();
                continue;
            }
            if (root instanceof NamingException) {
                next = ((NamingException)root).getRootCause();
                continue;
            }
            if (root instanceof InvocationTargetException) {
                next = ((InvocationTargetException)root).getTargetException();
                continue;
            }
            if (root instanceof UnknownException) {
                next = ((UnknownException)root).originalEx;
                continue;
            }
            if (root instanceof InjectionException) {
                next = root.getCause();
                continue;
            }
            next = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "findRootCause returning: " + root);
        }
        return root;
    }

    public static Throwable findCause(Throwable throwable) {
        Throwable cause;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "findCause: " + throwable);
        }
        if ((cause = throwable.getCause()) == null && throwable instanceof EJBException) {
            cause = ((EJBException)throwable).getCausedByException();
        }
        if (cause != null) {
            while (cause instanceof ContainerException || cause instanceof UncheckedException || cause instanceof EJSPersistenceException || cause instanceof CPIException || cause instanceof CPMIException || cause instanceof CSIException || cause instanceof InjectionException || cause instanceof WsEJBException) {
                Throwable nextCause = cause.getCause();
                if (nextCause == null) {
                    StackTraceElement[] stackTrace = cause.getStackTrace();
                    cause = new EJBException(cause.getMessage());
                    cause.setStackTrace(stackTrace);
                    continue;
                }
                cause = nextCause;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "findCause: " + cause);
        }
        return cause;
    }

    public static EJBException EJBException(Throwable cause) {
        return ExceptionUtil.EJBException("See nested exception", cause);
    }

    public static EJBException EJBException(String message, Throwable cause) {
        EJBException ejbex = null;
        if (cause == null) {
            ejbex = new EJBException(message);
        }
        while (cause != null && !(cause instanceof RecursiveInjectionException) && (cause instanceof ContainerException || cause instanceof UncheckedException || cause instanceof EJSPersistenceException || cause instanceof CPIException || cause instanceof CPMIException || cause instanceof CSIException || cause instanceof InjectionException || cause instanceof WsEJBException)) {
            Throwable nextCause = cause.getCause();
            if (nextCause == null) {
                ejbex = new EJBException(cause.getMessage());
                ejbex.setStackTrace(cause.getStackTrace());
            }
            cause = nextCause;
        }
        if (ejbex == null) {
            if (cause instanceof EJBException) {
                ejbex = (EJBException)cause;
                if ((cause = ejbex.getCausedByException()) != null && ejbex.getCause() == null) {
                    ejbex.initCause(cause);
                }
            } else {
                if (cause instanceof Exception) {
                    ejbex = new EJBException(message, (Exception)cause);
                } else {
                    Exception wrappedCause = new Exception("See nested Throwable", cause);
                    wrappedCause.setStackTrace(new StackTraceElement[0]);
                    ejbex = new EJBException(message, wrappedCause);
                }
                ejbex.initCause(cause);
                ejbex.setStackTrace(new StackTraceElement[0]);
            }
        }
        return ejbex;
    }

    public static RemoteException RemoteException(Throwable cause) {
        return ExceptionUtil.RemoteException("See nested exception", cause);
    }

    public static RemoteException RemoteException(String message, Throwable cause) {
        RemoteException remote = null;
        if (cause == null) {
            remote = new RemoteException(message);
        }
        while (cause != null && (cause instanceof ContainerException || cause instanceof UncheckedException || cause instanceof EJSPersistenceException || cause instanceof CPIException || cause instanceof CPMIException || cause instanceof CSIException || cause instanceof InjectionException || cause instanceof WsEJBException)) {
            Throwable nextCause = cause.getCause();
            if (nextCause == null) {
                remote = new RemoteException(cause.getMessage());
                remote.setStackTrace(cause.getStackTrace());
            }
            cause = nextCause;
        }
        if (remote == null) {
            if (cause instanceof RemoteException) {
                remote = (RemoteException)cause;
            } else {
                remote = new RemoteException(message, cause);
                remote.setStackTrace(new StackTraceElement[0]);
            }
        }
        return remote;
    }

    public static String getBaseMessage(Throwable exception) {
        String message = null;
        if (exception instanceof RemoteException) {
            RemoteException rex = (RemoteException)exception;
            Throwable detail = rex.detail;
            rex.detail = null;
            message = rex.getMessage();
            rex.detail = detail;
        } else if (exception != null && (message = exception.getMessage()) != null) {
            if (message.startsWith("nested exception is:")) {
                message = null;
            } else {
                int nestIndex = message.indexOf("; nested exception is:");
                if (nestIndex > -1) {
                    message = message.substring(0, nestIndex);
                }
            }
        }
        return message;
    }
}

