/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.util;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.EJSHome;
import com.ibm.ejs.container.EJSWrapperBase;
import com.ibm.ejs.container.EJSWrapperCommon;
import com.ibm.ejs.container.WrapperId;
import com.ibm.ejs.container.WrapperInterface;
import com.ibm.ejs.container.WrapperManager;
import com.ibm.ejs.container.util.ByteArray;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.util.EJBSerializer;
import java.io.IOException;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.rmi.CORBA.Stub;

public class EJBSerializerImpl
extends EJBSerializer {
    private static final String CLASS_NAME = EJBSerializerImpl.class.getName();
    private static final TraceComponent tc = Tr.register(CLASS_NAME, "EJBContainer", "com.ibm.ejs.container.container");

    public Object deserialize(byte[] idBytes) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "deserialize");
        }
        EJSContainer container2 = EJSContainer.getDefaultContainer();
        Object retObj = null;
        WrapperManager wm = container2.getWrapperManager();
        if (idBytes[0] == -84) {
            ByteArray byteArray = new ByteArray(idBytes);
            BeanId beanId = BeanId.getBeanId(byteArray, container2);
            retObj = wm.getWrapper(beanId).getLocalWrapper();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "deserialized a BeanId = " + beanId + ", component wrapper = " + retObj);
            }
        } else if (idBytes[0] == -83) {
            WrapperId wrapperId = new WrapperId(idBytes);
            int index = wrapperId.ivInterfaceIndex;
            String interfaceName = wrapperId.ivInterfaceClassName;
            ByteArray byteArray = wrapperId.getBeanIdArray();
            BeanId beanId = BeanId.getBeanId(byteArray, container2);
            BeanMetaData bmd = beanId.getBeanMetaData();
            Tr.debug(tc, "deserialized a WrapperId for BeanId = " + beanId + ", primary key = " + beanId.getPrimaryKey());
            Class[] bInterfaces = bmd.ivBusinessLocalInterfaceClasses;
            int numberOfLocalInterfaces = bInterfaces.length;
            String wrapperInterfaceName = null;
            if (index < numberOfLocalInterfaces) {
                wrapperInterfaceName = bInterfaces[index].getName();
            }
            if (wrapperInterfaceName == null || !wrapperInterfaceName.equals(interfaceName)) {
                for (int i = 0; i < numberOfLocalInterfaces; ++i) {
                    wrapperInterfaceName = bmd.ivBusinessLocalInterfaceClasses[i].getName();
                    if (!wrapperInterfaceName.equals(interfaceName)) continue;
                    index = i;
                    break;
                }
            }
            if (index < numberOfLocalInterfaces) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "deserialized a BusinessLocalWrapper, WrapperId = " + (Object)((Object)wrapperId));
                }
                EJSHome home = bmd.getHome();
                EJSWrapperCommon wc = home.internalCreateWrapper(beanId);
                retObj = wc.getBusinessObject(bmd.ivBusinessLocalInterfaceClasses[index]);
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "deserialized a BusinessRemoteWrapper, WrapperId = " + (Object)((Object)wrapperId));
                }
                retObj = wm.keyToObject(idBytes);
            }
        } else {
            throw new IOException("First byte of header not recognized");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "deserialize returning: " + retObj);
        }
        return retObj;
    }

    public EJBSerializer.ObjectType getObjectType(Object theObject) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getObjectType: " + theObject.getClass());
        }
        EJBSerializer.ObjectType objectType = EJBSerializer.ObjectType.NOT_AN_EJB;
        if (theObject instanceof Stub) {
            objectType = theObject instanceof EJBObject ? EJBSerializer.ObjectType.EJB_OBJECT : (theObject instanceof EJBHome ? EJBSerializer.ObjectType.EJB_HOME : EJBSerializer.ObjectType.CORBA_STUB);
        } else if (theObject instanceof EJSWrapperBase) {
            EJSWrapperBase wrapper = (EJSWrapperBase)theObject;
            WrapperInterface wInterface = wrapper.ivInterface;
            if (wInterface == WrapperInterface.BUSINESS_LOCAL) {
                objectType = EJBSerializer.ObjectType.EJB_BUSINESS_LOCAL;
            } else if (wInterface == WrapperInterface.LOCAL) {
                objectType = EJBSerializer.ObjectType.EJB_LOCAL_OBJECT;
            } else if (wInterface == WrapperInterface.LOCAL_HOME) {
                objectType = EJBSerializer.ObjectType.EJB_LOCAL_HOME;
            } else if (wInterface == WrapperInterface.BUSINESS_REMOTE) {
                objectType = EJBSerializer.ObjectType.EJB3_BUSINESS_REMOTE;
            } else if (wInterface == WrapperInterface.BUSINESS_RMI_REMOTE) {
                objectType = EJBSerializer.ObjectType.EJB3_BUSINESS_REMOTE;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "ObjectType = " + (Object)((Object)objectType));
        }
        return objectType;
    }

    public byte[] serialize(Object theObject) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "serialize = " + theObject.getClass());
        }
        byte[] idBytes = null;
        EJSWrapperBase wrapper = null;
        if (!(theObject instanceof EJSWrapperBase)) {
            throw new IllegalArgumentException(" theObject parameter must be a EJB_LOCAL, EJB_LOCAL_HOME, EJB_BUSINESS_LOCAL, or EJB_BUSINESS_REMOTE ObjectType. Use the getObjectType to obtain the ObjectType.");
        }
        wrapper = (EJSWrapperBase)theObject;
        BeanId beanId = wrapper.beanId;
        WrapperInterface wrapperInterface = wrapper.ivInterface;
        BeanMetaData bmd = wrapper.bmd;
        if (wrapperInterface == WrapperInterface.BUSINESS_LOCAL) {
            int interfaceIndex = wrapper.ivBusinessInterfaceIndex;
            Class biClass = bmd.ivBusinessLocalInterfaceClasses[interfaceIndex];
            String interfaceName = biClass.getName();
            WrapperId wrapperId = new WrapperId(beanId.getByteArrayBytes(), interfaceName, interfaceIndex);
            idBytes = wrapperId.getBytes();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "serialized a WrapperId for BeanId = " + beanId + ", local business interface = " + interfaceName);
            }
        } else if (wrapperInterface == WrapperInterface.BUSINESS_REMOTE) {
            int interfaceIndex = wrapper.ivBusinessInterfaceIndex;
            Class biClass = bmd.ivBusinessRemoteInterfaceClasses[interfaceIndex];
            String interfaceName = biClass.getName();
            WrapperId wrapperId = new WrapperId(beanId.getByteArrayBytes(), interfaceName, interfaceIndex);
            idBytes = wrapperId.getBytes();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "serialized a WrapperId for BeanId = " + beanId + ", remote business interface = " + interfaceName);
            }
        } else if (wrapperInterface == WrapperInterface.BUSINESS_RMI_REMOTE) {
            int interfaceIndex = wrapper.ivBusinessInterfaceIndex;
            Class biClass = bmd.ivBusinessRemoteInterfaceClasses[interfaceIndex];
            String interfaceName = biClass.getName();
            WrapperId wrapperId = new WrapperId(beanId.getByteArrayBytes(), interfaceName, interfaceIndex);
            idBytes = wrapperId.getBytes();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "serialized a WrapperId for BeanId = " + beanId + ", RMI remote business interface = " + interfaceName);
            }
        } else {
            idBytes = beanId.getByteArrayBytes();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "serialized a BeanId = " + beanId);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "serialize");
        }
        return idBytes;
    }
}

