/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.interceptors;

import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.EJSDeployedSupport;
import com.ibm.ejs.container.interceptors.InterceptorProxy;
import com.ibm.ejs.container.util.ExceptionUtil;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.ejb.ApplicationException;
import javax.ejb.EJBException;
import javax.interceptor.InvocationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvocationContextImpl
implements InvocationContext {
    private static final String CLASS_NAME = InvocationContextImpl.class.getName();
    private static final TraceComponent tc = Tr.register(CLASS_NAME, "EJB3Interceptors", "com.ibm.ejs.container.container");
    private Method ivMethod;
    private Object ivBean;
    private Object[] ivParameters = new Object[0];
    private Map<String, Object> ivContextMap;
    private InterceptorProxy[] ivInterceptorProxies;
    private int ivNextIndex;
    private int ivNumberOfInterceptors;
    private Object[] ivInterceptors;
    private boolean ivParametersModified = false;
    private EJSDeployedSupport ivEJSDeployedSupport;
    private EJSContainer ivContainer = EJSContainer.getDefaultContainer();

    public void initialize(Object bean, Object[] interceptors) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "initialize for bean = " + bean + ", interceptors = " + interceptors);
        }
        this.ivInterceptors = interceptors;
        this.ivBean = bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object doAroundInvoke(InterceptorProxy[] proxies, Method businessMethod, Object[] parameters, EJSDeployedSupport s) throws Exception {
        Object object;
        this.ivMethod = businessMethod;
        this.ivParameters = parameters;
        this.ivInterceptorProxies = proxies;
        this.ivNextIndex = 0;
        this.ivNumberOfInterceptors = this.ivInterceptorProxies.length;
        this.ivParametersModified = false;
        this.ivEJSDeployedSupport = s;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "doAroundInvoke for business method: " + businessMethod.getName());
        }
        try {
            this.ivContextMap = s.getWSMessageContext();
            if (this.ivContextMap == null) {
                this.ivContextMap = new HashMap<String, Object>();
            }
            object = this.proceed();
            Object var7_6 = null;
            this.ivMethod = null;
            this.ivParameters = null;
            this.ivContextMap = null;
        }
        catch (Throwable throwable) {
            block5: {
                Object var7_7 = null;
                this.ivMethod = null;
                this.ivParameters = null;
                this.ivContextMap = null;
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEntryEnabled()) break block5;
                Tr.exit(tc, "doAroundInvoke for business method: " + businessMethod.getName());
            }
            throw throwable;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "doAroundInvoke for business method: " + businessMethod.getName());
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doLifeCycle(InterceptorProxy[] proxies, HashMap<String, Boolean> appExceptionMap) {
        this.ivMethod = null;
        this.ivParameters = null;
        this.ivInterceptorProxies = proxies;
        this.ivNumberOfInterceptors = this.ivInterceptorProxies.length;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "doLifeCycle, number of interceptors = " + this.ivNumberOfInterceptors);
        }
        if (this.ivNumberOfInterceptors <= 0) return;
        this.ivNextIndex = 0;
        try {
            try {
                this.ivContextMap = new HashMap<String, Object>();
                this.proceed();
            }
            catch (Throwable t) {
                this.lifeCycleExceptionHandler(t, appExceptionMap);
                Object var5_4 = null;
                this.ivContextMap = null;
                if (!TraceComponent.isAnyTracingEnabled()) return;
                if (!tc.isEntryEnabled()) return;
                Tr.exit(tc, "doLifeCycle");
                return;
            }
            Object var5_3 = null;
            this.ivContextMap = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.ivContextMap = null;
            if (!TraceComponent.isAnyTracingEnabled()) throw throwable;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "doLifeCycle");
            throw throwable;
        }
        if (!TraceComponent.isAnyTracingEnabled()) return;
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "doLifeCycle");
    }

    private void lifeCycleExceptionHandler(Throwable t, HashMap<String, Boolean> appExceptionMap) {
        if (t instanceof RuntimeException) {
            RuntimeException rtex = (RuntimeException)t;
            if (this.isApplicationException(rtex, appExceptionMap)) {
                InterceptorProxy w = this.ivInterceptorProxies[this.ivNextIndex - 1];
                String lifeCycle = w.getMethodGenericString();
                EJBException ex = ExceptionUtil.EJBException(lifeCycle + " is not allowed to throw an application exception", rtex);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "lifeCycleExceptionHandler throwing EJBException", ex);
                }
                throw ex;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "lifeCycleExceptionHandler is rethrowing RuntimeException from lifecycle callback method: " + t, t);
            }
            throw rtex;
        }
        if (t instanceof Error) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "lifeCycleExceptionHandler is rethrowing Error from lifecycle callback method: " + t, t);
            }
            throw (Error)t;
        }
        InterceptorProxy w = this.ivInterceptorProxies[this.ivNextIndex - 1];
        String lifeCycle = w.getMethodGenericString();
        EJBException ex = ExceptionUtil.EJBException(lifeCycle + " is not allowed to throw a checked exception", t);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "lifeCycleExceptionHandler throwing EJBException", ex);
        }
        throw ex;
    }

    private boolean isApplicationException(RuntimeException rtex, HashMap<String, Boolean> appExceptionMap) {
        Class<?> exClass = rtex.getClass();
        if (appExceptionMap != null && appExceptionMap.containsKey(exClass.getName())) {
            return true;
        }
        return exClass.getAnnotation(ApplicationException.class) != null;
    }

    @Override
    public Object getTarget() {
        return this.ivBean;
    }

    @Override
    public Method getMethod() {
        return this.ivMethod;
    }

    @Override
    public Object[] getParameters() {
        if (this.ivMethod == null) {
            throw new IllegalStateException("InvocationContext.getParameter can not be called by lifecycle callback methods");
        }
        return this.ivParameters;
    }

    @Override
    public void setParameters(Object[] args) {
        if (this.ivMethod == null) {
            throw new IllegalStateException("InvocationContext.setParameter can not be called by lifecycle callback methods");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setParameters for business method: " + this.ivMethod.getName());
        }
        Class<?>[] parmTypes = this.ivMethod.getParameterTypes();
        int n = parmTypes.length;
        if (args == null) {
            if (n > 0) {
                throw new IllegalArgumentException("null not valid as argument for setParameters method.");
            }
        } else {
            if (args.length != n) {
                throw new IllegalArgumentException("wrong number of parameters for method being invoked.");
            }
            for (int i = 0; i < n; ++i) {
                Class<?> parmType = parmTypes[i];
                if (!parmType.isPrimitive()) {
                    if (parmType.isInstance(args[i])) continue;
                    throw new IllegalArgumentException("wrong data type for parameter " + (i + 1));
                }
                if (parmType == Integer.TYPE && !(args[i] instanceof Integer)) {
                    throw new IllegalArgumentException("parameter " + (i + 1) + " is a " + args[i].getClass().getName() + ", but it is required to be a Integer");
                }
                if (parmType == Long.TYPE && !(args[i] instanceof Long)) {
                    throw new IllegalArgumentException("parameter " + (i + 1) + " is a " + args[i].getClass().getName() + ", but it is required to be a Long");
                }
                if (parmType == Short.TYPE && !(args[i] instanceof Short)) {
                    throw new IllegalArgumentException("parameter " + (i + 1) + " is a " + args[i].getClass().getName() + ", but it is required to be a Short");
                }
                if (parmType == Boolean.TYPE && !(args[i] instanceof Boolean)) {
                    throw new IllegalArgumentException("parameter " + (i + 1) + " is a " + args[i].getClass().getName() + ", but it is required to be a Boolean");
                }
                if (parmType == Byte.TYPE && !(args[i] instanceof Byte)) {
                    throw new IllegalArgumentException("parameter " + (i + 1) + " is a " + args[i].getClass().getName() + ", but it is required to be a Byte");
                }
                if (parmType == Character.TYPE && !(args[i] instanceof Character)) {
                    throw new IllegalArgumentException("parameter " + (i + 1) + " is a " + args[i].getClass().getName() + ", but it is required to be a Character");
                }
                if (parmType == Float.TYPE && !(args[i] instanceof Float)) {
                    throw new IllegalArgumentException("parameter " + (i + 1) + " is a " + args[i].getClass().getName() + ", but it is required to be a Float");
                }
                if (parmType != Double.TYPE || args[i] instanceof Double) continue;
                throw new IllegalArgumentException("parameter " + (i + 1) + " is a " + args[i].getClass().getName() + ", but it is required to be a Double");
            }
            this.ivParameters = args;
            this.ivParametersModified = true;
        }
    }

    @Override
    public Map<String, Object> getContextData() {
        return this.ivContextMap;
    }

    @Override
    public Object proceed() throws Exception {
        Object returnValue = null;
        try {
            if (this.ivNextIndex < this.ivNumberOfInterceptors) {
                InterceptorProxy w = this.ivInterceptorProxies[this.ivNextIndex];
                if (w.ivRequiresInvocationContext) {
                    ++this.ivNextIndex;
                    returnValue = w.invokeInterceptor(this.ivBean, this, this.ivInterceptors);
                } else {
                    while (w != null) {
                        ++this.ivNextIndex;
                        returnValue = w.invokeInterceptor(this.ivBean, this, this.ivInterceptors);
                        w = this.ivNextIndex < this.ivNumberOfInterceptors ? this.ivInterceptorProxies[this.ivNextIndex] : null;
                    }
                }
            } else if (this.ivMethod != null) {
                returnValue = this.ivContainer.invokeProceed(this.ivEJSDeployedSupport, this.ivMethod, this.ivBean, this.ivParameters, this.ivParametersModified);
            }
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "proceed unwrappering InvocationTargetException: " + t, t);
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw (Exception)t;
        }
        return returnValue;
    }
}

