/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.interceptors;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.dopriv.SetAccessiblePrivilegedAction;
import com.ibm.ws.ffdc.FFDCFilter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import javax.interceptor.InvocationContext;

public class InterceptorProxy {
    private static final String CLASS_NAME = InterceptorProxy.class.getName();
    private static final TraceComponent tc = Tr.register(CLASS_NAME, "EJBContainer", "com.ibm.ejs.container.container");
    private static final Object[] NO_ARGS = new Object[0];
    public final Method ivInterceptorMethod;
    final int ivInterceptorIndex;
    private final boolean ivBeanInterceptor;
    final boolean ivRequiresInvocationContext;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InterceptorProxy(Method m, int interceptorIndex) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "InterceptorProxy");
        }
        this.ivInterceptorIndex = interceptorIndex;
        this.ivInterceptorMethod = m;
        this.ivBeanInterceptor = interceptorIndex < 0;
        this.ivRequiresInvocationContext = m.getParameterTypes().length > 0;
        SetAccessiblePrivilegedAction priviledgedAction = new SetAccessiblePrivilegedAction();
        priviledgedAction.setParameters((AccessibleObject)m, true);
        try {
            try {
                AccessController.doPrivileged(priviledgedAction);
            }
            catch (PrivilegedActionException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".<init>"), (String)"178", (Object)this);
                SecurityException ex = (SecurityException)e.getException();
                throw ex;
            }
            Object var7_4 = null;
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            if (!TraceComponent.isAnyTracingEnabled()) throw throwable;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, this.toString());
            throw throwable;
        }
        if (!TraceComponent.isAnyTracingEnabled()) return;
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, this.toString());
    }

    public final Object invokeInterceptor(Object bean, InvocationContext inv, Object[] interceptors) throws Exception {
        Object interceptorInstance;
        Object object = interceptorInstance = this.ivBeanInterceptor ? bean : interceptors[this.ivInterceptorIndex];
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "invoking " + this);
            Tr.debug(tc, "interceptor instance = " + interceptorInstance);
        }
        if (this.ivRequiresInvocationContext) {
            Object[] args = new Object[]{inv};
            return this.ivInterceptorMethod.invoke(interceptorInstance, args);
        }
        return this.ivInterceptorMethod.invoke(interceptorInstance, NO_ARGS);
    }

    public String toString() {
        return "InterceptorProxy(" + this.ivInterceptorIndex + "): " + this.ivInterceptorMethod.toGenericString();
    }

    public String getMethodGenericString() {
        return this.ivInterceptorMethod.toGenericString();
    }
}

