/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.drs;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.drs.SfDRSCacheEntry;
import com.ibm.ejs.container.drs.SfDRSCacheMsgListener;
import com.ibm.ejs.container.drs.SfDRSKey;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.FastHashtable;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.drs.DRSDataXfer;
import com.ibm.wsspi.drs.DRSEventObject;
import java.util.Enumeration;

public final class SfDRSClient {
    private static final String CLASS_NAME = "com.ibm.ejs.container.drs.SfDRSClient";
    private static final TraceComponent tc = Tr.register("com.ibm.ejs.container.drs.SfDRSClient", "EJBDRSCache", "com.ibm.ejs.container.container");
    private DRSDataXfer ivBaseDataXfer = null;
    private String ivInstanceId;
    private FastHashtable<BeanId, SfDRSCacheEntry> ivCache = new FastHashtable(97);
    SfDRSCacheMsgListener ivSfDRSCacheMsgListener;

    public SfDRSClient(DRSDataXfer baseDRSDataXfer, String id, SfDRSCacheMsgListener ml) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "SfDRSClient CTOR for ID = " + id);
        }
        this.ivInstanceId = id;
        this.ivBaseDataXfer = baseDRSDataXfer;
        this.ivSfDRSCacheMsgListener = ml;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "SfDRSClient CTOR for ID = " + id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activated(BeanId beanId, long lastAccessTime) {
        SfDRSCacheEntry cacheEntry;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "activated, beanId is: " + beanId);
        }
        if ((cacheEntry = (SfDRSCacheEntry)this.ivCache.get((Object)beanId)) != null) {
            beanId.getByteArray();
            SfDRSCacheEntry sfDRSCacheEntry = cacheEntry;
            synchronized (sfDRSCacheEntry) {
                ++cacheEntry.ivSequenceNumber;
                cacheEntry.ivPassivated = false;
                cacheEntry.ivLastAccessTime = lastAccessTime;
                cacheEntry.replicate(this.ivBaseDataXfer);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "activated, beanId is: " + beanId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void passivated(BeanId beanId, byte[] data, long lastAccessTime) {
        SfDRSCacheEntry cacheEntry;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "passivated, beanId is: " + beanId);
        }
        if ((cacheEntry = (SfDRSCacheEntry)this.ivCache.get((Object)beanId)) != null) {
            beanId.getByteArray();
            SfDRSCacheEntry sfDRSCacheEntry = cacheEntry;
            synchronized (sfDRSCacheEntry) {
                ++cacheEntry.ivSequenceNumber;
                cacheEntry.ivPassivated = true;
                cacheEntry.ivLastAccessTime = lastAccessTime;
                cacheEntry.ivData = data;
                cacheEntry.replicate(this.ivBaseDataXfer);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "passivated, beanId is: " + beanId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createEntry(BeanId beanId, long timeout) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createEntry beanId is: " + beanId);
        }
        SfDRSCacheEntry cacheEntry = new SfDRSCacheEntry(beanId, timeout);
        Object object = this.ivCache;
        synchronized (object) {
            this.ivCache.put((Object)beanId, (Object)cacheEntry);
        }
        object = cacheEntry;
        synchronized (object) {
            ++cacheEntry.ivSequenceNumber;
            cacheEntry.replicate(this.ivBaseDataXfer);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createEntry ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createEntry(BeanId beanId, SfDRSCacheEntry cacheEntry) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createEntry bean ID is: " + beanId);
        }
        Object object = this.ivCache;
        synchronized (object) {
            this.ivCache.put((Object)beanId, (Object)cacheEntry);
        }
        object = cacheEntry;
        synchronized (object) {
            cacheEntry.replicate(this.ivBaseDataXfer);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createEntry ");
        }
    }

    public void event(DRSEventObject eventObject) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "eventObject = " + eventObject);
        }
        int event2 = eventObject.getEvent();
        switch (event2) {
            case 1: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "received event REPLICATION_UP.");
                }
                this.retryReplication();
                break;
            }
            case 2: {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                Tr.debug(tc, "received event REPLICATION_DOWN.");
                break;
            }
            case 3: {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                Tr.debug(tc, "received event IS_CONGESTED.");
                break;
            }
            case 4: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "received event NOT_CONGESTED.");
                }
                this.retryReplication();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "eventObject = " + eventObject);
        }
    }

    public SfDRSCacheEntry getEntry(BeanId beanId) {
        SfDRSCacheEntry entry;
        block5: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "getEntry beanId is: " + beanId);
            }
            entry = null;
            try {
                SfDRSKey key = beanId.getDRSKey();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "getEntry key: " + key);
                }
                entry = (SfDRSCacheEntry)this.ivBaseDataXfer.getEntry((Object)key);
            }
            catch (Throwable t) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "getEntry failed for entryKey = " + beanId);
                Tr.debug(tc, "caught Throwable: ", t);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getEntry ");
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntry(BeanId beanId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "removeEntry beanId is: " + beanId);
        }
        SfDRSCacheEntry cacheEntry = null;
        FastHashtable<BeanId, SfDRSCacheEntry> fastHashtable = this.ivCache;
        synchronized (fastHashtable) {
            cacheEntry = (SfDRSCacheEntry)this.ivCache.remove((Object)beanId);
        }
        try {
            if (cacheEntry != null) {
                ++cacheEntry.ivSequenceNumber;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "removing DRS entry, " + cacheEntry);
                }
                this.ivBaseDataXfer.removeEntry((Object)cacheEntry.ivKey);
            }
        }
        catch (Throwable t) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "removeEntry(BeanId) failure, using removeLocalEntry to recover from failure", t);
            }
            this.removeLocalEntry(cacheEntry.ivKey);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "removeEntry ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retryReplication() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "retryReplication", this);
        }
        FastHashtable<BeanId, SfDRSCacheEntry> fastHashtable = this.ivCache;
        synchronized (fastHashtable) {
            Enumeration e = this.ivCache.elements();
            while (e.hasMoreElements()) {
                SfDRSCacheEntry cacheEntry = (SfDRSCacheEntry)e.nextElement();
                if (cacheEntry == null) continue;
                SfDRSCacheEntry sfDRSCacheEntry = cacheEntry;
                synchronized (sfDRSCacheEntry) {
                    if (cacheEntry.ivDRSState != 0L) {
                        cacheEntry.replicate(this.ivBaseDataXfer);
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "retryReplication");
        }
    }

    public boolean entryIDExists(BeanId beanId) {
        boolean entry;
        block5: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "entryIDExists beanId is: " + beanId);
            }
            entry = false;
            try {
                SfDRSKey key = beanId.getDRSKey();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "entryIDExists key: " + key);
                }
                entry = this.ivBaseDataXfer.entryIDExists((Object)key);
            }
            catch (Throwable t) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "entryIDExists failed for entryKey = " + beanId);
                Tr.debug(tc, "caught Throwable: ", t);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "entryIDExists returning " + entry);
        }
        return entry;
    }

    public Identity getWLMIdentity(BeanId beanId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getWLMIdentity, beanId is: " + beanId);
        }
        SfDRSKey key = beanId.getDRSKey();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getWLMIdentity key: " + key);
        }
        Identity clusterId = this.ivBaseDataXfer.getWLMIdentity((Object)key, true);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getWLMIdentity returning WLM Identity: " + clusterId);
        }
        return clusterId;
    }

    public String toString() {
        return "SfDRSClient for ID: " + this.ivInstanceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stickyUOW(BeanId beanId, boolean isActive) {
        SfDRSCacheEntry cacheEntry;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "stickyUOW, state is " + isActive);
        }
        if ((cacheEntry = (SfDRSCacheEntry)this.ivCache.get((Object)beanId)) != null) {
            beanId.getByteArray();
            SfDRSCacheEntry sfDRSCacheEntry = cacheEntry;
            synchronized (sfDRSCacheEntry) {
                ++cacheEntry.ivSequenceNumber;
                cacheEntry.ivStickyUOW = isActive;
                cacheEntry.replicate(this.ivBaseDataXfer);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "stickyUOW");
        }
    }

    Identity getWLMIdentity(SfDRSKey key) {
        return this.ivBaseDataXfer.getWLMIdentity((Object)key, false);
    }

    void removeEntry(SfDRSKey key) {
        try {
            this.ivBaseDataXfer.removeEntry((Object)key);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "removeEntry( SfDRSKey ) removed DRS entry key = " + key);
            }
        }
        catch (Throwable t) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "removeEntry(SfDRSKey) failure, using removeLocalEntry to recover from failure", t);
            }
            this.removeLocalEntry(key);
        }
    }

    public void removeLocalEntry(SfDRSKey key) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "removeLocalEntry for key = " + key);
        }
        this.ivBaseDataXfer.removeLocalEntry((Object)key);
    }
}

