/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.drs;

import com.ibm.ejs.container.drs.SfDRSCache;
import com.ibm.ejs.container.drs.SfDRSCacheEntry;
import com.ibm.ejs.container.drs.SfDRSClient;
import com.ibm.ejs.container.drs.SfDRSKey;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.drs.DRSCacheMsg;
import com.ibm.wsspi.drs.DRSCacheMsgListener;
import com.ibm.wsspi.drs.DRSEventObject;
import java.util.Collections;
import java.util.EventObject;
import java.util.Map;
import java.util.WeakHashMap;

public class SfDRSCacheMsgListener
implements DRSCacheMsgListener {
    private static final TraceComponent tc = Tr.register(SfDRSCacheMsgListener.class, "EJBDRSCache", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.container.drs.SfDRSCacheMsgListener";
    private final SfDRSCache ivStatefulDRSCache;
    private SfDRSClient ivSfDRSClient;
    private Map<Identity, Long> ivNowThePrimaryMap = Collections.synchronizedMap(new WeakHashMap());

    public SfDRSCacheMsgListener(SfDRSCache drsCache) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "SfDRSCacheMsgListener CTOR", drsCache);
        }
        this.ivStatefulDRSCache = drsCache;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "SfDRSCacheMsgListener CTOR");
        }
    }

    void setSfDRSClient(SfDRSClient drsClient) {
        this.ivSfDRSClient = drsClient;
    }

    public void createEntry(Object entryKey, Object value) {
        SfDRSKey key;
        block4: {
            key = null;
            try {
                key = (SfDRSKey)entryKey;
                SfDRSCacheEntry cacheEntry = (SfDRSCacheEntry)value;
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.entry(tc, "createEntry, key = " + key + ", " + cacheEntry);
                }
                this.ivStatefulDRSCache.addCacheEntry(key, cacheEntry, this);
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ejs.container.drs.SfDRSCacheMsgListener.createEntry", (String)"135", (Object)this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "createEntry caught Throwable", t);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createEntry, key = " + key);
        }
    }

    public Object getEntry(Object entryKey) {
        SfDRSCacheEntry entry;
        block4: {
            entry = null;
            SfDRSKey key = null;
            try {
                key = (SfDRSKey)entryKey;
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.entry(tc, "getEntry, key = " + key);
                }
                entry = this.ivStatefulDRSCache.getCacheEntry(key);
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ejs.container.drs.SfDRSCacheMsgListener.getEntry", (String)"173", (Object)this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "getEntry caught Throwable", t);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getEntry, " + entry);
        }
        return entry;
    }

    public boolean entryIDExists(Object entryKey) {
        SfDRSKey key;
        boolean exists;
        block4: {
            exists = false;
            key = null;
            try {
                key = (SfDRSKey)entryKey;
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.entry(tc, "entryIDExists, key = " + key);
                }
                exists = this.ivStatefulDRSCache.beanExists(key);
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ejs.container.drs.SfDRSCacheMsgListener.entryIDExists", (String)"211", (Object)this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "entryIDExists failed", t);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "entryIDExists returning " + exists + " for key = " + key);
        }
        return exists;
    }

    public void event(DRSEventObject eventObject) {
        if (this.ivSfDRSClient == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "event: not ready to recieve events : ", eventObject);
            }
        } else {
            this.ivSfDRSClient.event(eventObject);
        }
    }

    public void removeEntry(Object entryKey) {
        SfDRSKey key;
        block4: {
            key = null;
            try {
                key = (SfDRSKey)entryKey;
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.entry(tc, "removeEntry, key = " + key);
                }
                this.ivStatefulDRSCache.removeCacheEntry(key);
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ejs.container.drs.SfDRSCacheMsgListener.removeEntry", (String)"260", (Object)this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "removeEntry failed", t);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "removeEntry, key = " + key);
        }
    }

    public void updateEntry(Object entryKey, Object value) {
        SfDRSKey key;
        block4: {
            key = null;
            try {
                key = (SfDRSKey)entryKey;
                SfDRSCacheEntry cacheEntry = (SfDRSCacheEntry)value;
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.entry(tc, "updateEntry, key = " + key + ", " + cacheEntry);
                }
                this.ivStatefulDRSCache.updateCacheEntry(key, cacheEntry, this);
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ejs.container.drs.SfDRSCacheMsgListener.updateEntry", (String)"300", (Object)this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "updateEntry failed", t);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "updateEntry, key = " + key);
        }
    }

    public void createEntryProp(Object entryKey, Object propKey, Object value) {
    }

    public void removeEntryProp(Object entryKey, Object propKey, Object value) {
    }

    public void nowThePrimary(long partitionId) {
    }

    public void nowThePrimary(Identity id) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "nowThePrimary call for WLM Identity: " + id);
        }
        this.ivNowThePrimaryMap.put(id, System.currentTimeMillis());
    }

    public Object broadcast(Object key) {
        return null;
    }

    public void processDRSCacheMsgEvent(EventObject obj) {
    }

    public void response(Object response) {
    }

    public void asyncAck(DRSCacheMsg in, DRSCacheMsg out) {
    }

    public void updateEntryProp(Object entryKey, Object propKey, Object value) {
    }

    public Object getEntryProp(Object entryKey, Object propKey) {
        return null;
    }

    void removeIfPrimary(SfDRSKey key) {
        Identity id = this.ivSfDRSClient.getWLMIdentity(key);
        if (id == null || this.ivNowThePrimaryMap.containsKey(id)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "removeIfPrimary removing DRS entry for key = " + key + " id = " + id);
            }
            this.ivSfDRSClient.removeEntry(key);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "removeIfPrimary - not the primary, so removeLocalEntry is being invoked for key = " + key + " id = " + id);
            }
            this.ivSfDRSClient.removeLocalEntry(key);
        }
    }
}

