/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.drs;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.drs.SfDRSKey;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.drs.DRSDataXfer;
import com.ibm.wsspi.drs.exception.DRSCongestedException;
import com.ibm.wsspi.drs.exception.DRSNotReadyException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

class SfDRSCacheEntry
implements Serializable {
    private static final long serialVersionUID = 4929853033094911926L;
    private static final TraceComponent tc = Tr.register(SfDRSCacheEntry.class, "EJBDRSCache", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.container.drs.SfDRSCacheEntry";
    private static final long LATENCY_TIME = 120000L;
    static final int NUMBER_OF_BUCKETS = 97;
    short ivVersionId = 1;
    long ivSequenceNumber;
    final long ivTimeoutValue;
    boolean ivPassivated;
    boolean ivStickyUOW;
    long ivLastAccessTime;
    transient byte[] ivData;
    transient boolean ivCreateEntry = true;
    transient long ivDRSState = 0L;
    static final byte STATE_DRS_READY = 0;
    static final byte STATE_DRS_CONGESTED = 1;
    static final byte STATE_DRS_NOT_READY = 2;
    final transient SfDRSKey ivKey;

    public SfDRSCacheEntry(BeanId beanId, long timeout) {
        this.ivKey = beanId.getDRSKey();
        this.ivTimeoutValue = timeout + 120000L;
        this.ivLastAccessTime = System.currentTimeMillis();
    }

    public SfDRSCacheEntry(SfDRSKey key, long timeout) {
        this.ivKey = key;
        this.ivTimeoutValue = timeout;
    }

    boolean replicate(DRSDataXfer drsDataXfer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "replicate " + this);
        }
        boolean noExceptionOccurred = false;
        try {
            if (this.ivCreateEntry) {
                drsDataXfer.createEntry((Object)this.ivKey, (Object)this);
                this.ivCreateEntry = false;
            } else {
                drsDataXfer.updateEntry((Object)this.ivKey, (Object)this);
            }
            this.ivDRSState = 0L;
            noExceptionOccurred = true;
        }
        catch (DRSNotReadyException e) {
            this.ivDRSState = 2L;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "replicate caught DRS is NOT ready");
            }
        }
        catch (DRSCongestedException e) {
            this.ivDRSState = 1L;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "replicate caught DRS is congested");
            }
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ejs.container.drs.SfDRSCacheEntry.replicate", (String)"258", (Object)this);
            Tr.warning(tc, "IGNORING_UNEXPECTED_EXCEPTION_CNTR0033E", t);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "replicate returning: " + noExceptionOccurred);
        }
        return noExceptionOccurred;
    }

    public String toString() {
        if (this.ivKey != null) {
            return "key = " + this.ivKey.toString() + ", sequence = " + this.ivSequenceNumber + ", passivated = " + this.ivPassivated + ", sticky UOW = " + this.ivStickyUOW;
        }
        return "sequence = " + this.ivSequenceNumber + ", passivated = " + this.ivPassivated + ", sticky UOW = " + this.ivStickyUOW;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int n = in.readInt();
        if (n == 0) {
            this.ivData = null;
        } else {
            this.ivData = new byte[n];
            int bytesRead = 0;
            for (int offset = 0; offset < n; offset += bytesRead) {
                bytesRead = in.read(this.ivData, offset, n - offset);
                if (bytesRead != -1) continue;
                throw new IOException("end of input stream while reading SFSB data");
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.ivData == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.ivData.length);
            out.write(this.ivData);
        }
    }
}

