/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.activator;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.BeanO;
import com.ibm.ejs.container.ContainerAS;
import com.ibm.ejs.container.ContainerTx;
import com.ibm.ejs.container.SessionBeanTimeoutException;
import com.ibm.ejs.container.StatefulBeanO;
import com.ibm.ejs.container.activator.Activator;
import com.ibm.ejs.container.activator.ActivatorCacheFullException;
import com.ibm.ejs.container.activator.MasterKey;
import com.ibm.ejs.container.activator.StatefulActivateTranActivationStrategy;
import com.ibm.ejs.container.drs.SfDRSCache;
import com.ibm.ejs.container.util.EJSPlatformHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.IllegalOperationException;
import com.ibm.websphere.csi.InsufficientCacheSpaceException;
import com.ibm.websphere.csi.PassivationPolicy;
import com.ibm.ws.ffdc.FFDCFilter;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.Date;
import javax.transaction.InvalidTransactionException;
import javax.transaction.TransactionRolledbackException;

public class StatefulASActivationStrategy
extends StatefulActivateTranActivationStrategy {
    private TraceComponent tc = Tr.register(StatefulASActivationStrategy.class, "EJBContainer", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.container.activator.StatefulASActivationStrategy";

    public StatefulASActivationStrategy(Activator activator, PassivationPolicy policy, SfDRSCache drsCache) {
        super(activator, policy, drsCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    BeanO atCreate(ContainerTx tx, BeanO bean) throws RemoteException {
        block24: {
            ContainerAS as;
            if (TraceComponent.isAnyTracingEnabled() && this.tc.isEntryEnabled()) {
                Tr.entry(this.tc, "atCreate", new Object[]{tx, bean});
            }
            if ((as = tx.getContainerAS()) == null) {
                bean = super.atCreate(tx, bean);
                if (!TraceComponent.isAnyTracingEnabled()) return bean;
                if (!this.tc.isEntryEnabled()) return bean;
                Tr.exit(this.tc, "atCreate", bean);
                return bean;
            }
            BeanId beanId = bean.getId();
            MasterKey key = new MasterKey(beanId);
            boolean inserted = false;
            boolean exception = false;
            BeanO existingBean = null;
            try {
                block23: {
                    try {
                        Object object = this.locks.getLock(key);
                        // MONITORENTER : object
                        existingBean = (BeanO)this.cache.find(key);
                        if (existingBean != null) {
                            this.cache.unpin(key);
                            ContainerTx prevTx = existingBean.getContainerTx();
                            if (prevTx != tx) {
                                if (prevTx != null && prevTx.isTransactionGlobal() && tx.isTransactionGlobal()) {
                                    Tr.error(this.tc, "SESSIONAL_CONCURRENT_TRANSACTION_ERROR_CNTR0064E", ((Object)beanId.getJ2EEName()).toString());
                                    throw new InvalidTransactionException("EJB attempted to become involved with concurrent global transactions within an activity session");
                                }
                                bean.setContainerTx(tx);
                            }
                            if (TraceComponent.isAnyTracingEnabled() && this.tc.isEntryEnabled()) {
                                Tr.exit(this.tc, "atCreate: found bean in cache", existingBean);
                            }
                            BeanO beanO = existingBean;
                            // MONITOREXIT : object
                            Object var14_15 = null;
                            if (!exception) return beanO;
                            bean.destroy();
                            if (!inserted) return beanO;
                            Object object2 = this.locks.getLock(key);
                            // MONITORENTER : object2
                            this.cache.remove(key, true);
                            bean.ivCacheKey = null;
                            // MONITOREXIT : object2
                            as.delist(bean);
                            this.reaper.remove(beanId);
                            return beanO;
                        }
                        this.cache.insert(key, bean);
                        bean.ivCacheKey = key;
                        inserted = true;
                        // MONITOREXIT : object
                        if (!bean.enlist(tx)) {
                            this.cache.unpin(key);
                        }
                        bean.setContainerTx(tx);
                        if (as.enlist(bean)) {
                            this.cache.pin(key);
                        }
                        if (TraceComponent.isAnyTracingEnabled() && this.tc.isDebugEnabled()) {
                            Tr.debug(this.tc, "Adding beanO to reaper list");
                        }
                        StatefulBeanO statefulBeanO = (StatefulBeanO)bean;
                        this.reaper.add(beanId, statefulBeanO.getSessionTimeoutInMilliSeconds());
                        if (existingBean != null || !statefulBeanO.sfsbFailoverEnabled()) break block23;
                        statefulBeanO.createDRSEntry();
                    }
                    catch (InsufficientCacheSpaceException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.container.activator.StatefulASActivationStrategy.atCreate", (String)"129", (Object)this);
                        exception = true;
                        throw new ActivatorCacheFullException();
                    }
                    catch (RemoteException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.container.activator.StatefulASActivationStrategy.atCreate", (String)"135", (Object)this);
                        exception = true;
                        Tr.event(this.tc, "Exception raised", e);
                        throw e;
                    }
                    catch (RuntimeException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.container.activator.StatefulASActivationStrategy.atCreate", (String)"142", (Object)this);
                        exception = true;
                        Tr.event(this.tc, "atCreate", e);
                        throw e;
                    }
                }
                Object var14_16 = null;
                if (!exception) break block24;
                bean.destroy();
                if (inserted) {
                    Object object = this.locks.getLock(key);
                    // MONITORENTER : object
                    this.cache.remove(key, true);
                    bean.ivCacheKey = null;
                    // MONITOREXIT : object
                    as.delist(bean);
                    this.reaper.remove(beanId);
                }
            }
            catch (Throwable throwable) {
                Object var14_17 = null;
                if (!exception) throw throwable;
                bean.destroy();
                if (!inserted) throw throwable;
                Object object = this.locks.getLock(key);
                // MONITORENTER : object
                this.cache.remove(key, true);
                bean.ivCacheKey = null;
                // MONITOREXIT : object
                as.delist(bean);
                this.reaper.remove(beanId);
                throw throwable;
            }
        }
        if (!TraceComponent.isAnyTracingEnabled()) return null;
        if (!this.tc.isEntryEnabled()) return null;
        Tr.exit(this.tc, "atCreate", null);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    BeanO atActivate(ContainerTx tx, BeanId beanId) throws RemoteException {
        BeanO beanO;
        block37: {
            if (TraceComponent.isAnyTracingEnabled() && this.tc.isEntryEnabled()) {
                Tr.entry(this.tc, "atActivate (" + beanId + ")", tx);
            }
            beanO = null;
            ContainerAS as = tx.getContainerAS();
            if (as == null) {
                beanO = super.atActivate(tx, beanId);
                if (!TraceComponent.isAnyTracingEnabled()) return beanO;
                if (!this.tc.isEntryEnabled()) return beanO;
                Tr.exit(this.tc, "atActivate", beanO);
                return beanO;
            }
            Exception exception = null;
            MasterKey key = new MasterKey(beanId);
            boolean activate = false;
            boolean enlist = false;
            boolean found = false;
            StatefulBeanO statefulBeanO = null;
            Object object = this.locks.getLock(key);
            synchronized (object) {
                try {
                    block36: {
                        try {
                            beanO = (BeanO)this.cache.find(key);
                            if (beanO == null) {
                                boolean timedOut;
                                if (TraceComponent.isAnyTracingEnabled() && this.tc.isDebugEnabled()) {
                                    Tr.debug(this.tc, "Bean not in cache");
                                }
                                if (timedOut = EJSPlatformHelper.isZOS() ? this.reaper.beanExistsAndTimedOut(beanId) : this.reaper.beanDoesNotExistOrHasTimedOut(beanId)) {
                                    if (this.reaper.beanExistsAndTimedOut(beanId)) {
                                        if (!TraceComponent.isAnyTracingEnabled()) throw new SessionBeanTimeoutException("Stateful bean " + beanId + " timed out.");
                                        if (!this.tc.isDebugEnabled()) throw new SessionBeanTimeoutException("Stateful bean " + beanId + " timed out.");
                                        Tr.debug(this.tc, "Bean " + beanId + " in passivated filesystem or SfDRSCache, " + " but timed out.");
                                        throw new SessionBeanTimeoutException("Stateful bean " + beanId + " timed out.");
                                    }
                                    if (!TraceComponent.isAnyTracingEnabled()) throw new NoSuchObjectException("Stateful bean " + beanId + " was removed or timed out.");
                                    if (!this.tc.isDebugEnabled()) throw new NoSuchObjectException("Stateful bean " + beanId + " was removed or timed out.");
                                    Tr.debug(this.tc, "Bean " + beanId + " not in the passivated filesystem either.");
                                    throw new NoSuchObjectException("Stateful bean " + beanId + " was removed or timed out.");
                                }
                                beanO = beanId.getHome().createBeanO(beanId, tx);
                                this.cache.insert(key, beanO);
                                beanO.ivCacheKey = key;
                                activate = true;
                                enlist = true;
                                statefulBeanO = (StatefulBeanO)beanO;
                            } else {
                                if (TraceComponent.isAnyTracingEnabled() && this.tc.isDebugEnabled()) {
                                    Tr.debug(this.tc, "Found bean in cache");
                                }
                                found = true;
                                statefulBeanO = (StatefulBeanO)beanO;
                                this.cache.unpin(key);
                                ContainerTx prevTx = beanO.getContainerTx();
                                if (prevTx == null) {
                                    enlist = true;
                                } else if (prevTx != tx) {
                                    Tr.error(this.tc, "SESSIONAL_CONCURRENT_TRANSACTION_ERROR_CNTR0064E", ((Object)beanId.getJ2EEName()).toString());
                                    throw new InvalidTransactionException("EJB attempted to become involved with concurrent transactions within an activity session");
                                }
                                if (tx != null) {
                                    tx.ivCallbackBeanO = beanO;
                                    if (TraceComponent.isAnyTracingEnabled() && this.tc.isDebugEnabled()) {
                                        Tr.debug(this.tc, "CallbackBeanO = " + beanO);
                                    }
                                }
                            }
                            if (activate) {
                                beanO.activate(beanId, tx);
                                if (!this.reaper.beanExists(beanId) || this.passivationPolicy.equals(PassivationPolicy.ON_DEMAND)) {
                                    this.reaper.add(beanId, statefulBeanO.getSessionTimeoutInMilliSeconds());
                                    long lastaccess = statefulBeanO.getLastAccessTime();
                                    this.reaper.setLastAccessTime(beanId, lastaccess);
                                    if (TraceComponent.isAnyTracingEnabled() && this.tc.isDebugEnabled()) {
                                        Tr.debug(this.tc, "Bean last access: " + new Date(lastaccess).toString());
                                    }
                                } else {
                                    this.reaper.setActive(beanId);
                                }
                                if (statefulBeanO.sfsbFailoverEnabled()) {
                                    statefulBeanO.updateDRSSetActiveProp();
                                }
                                as.enlist(beanO);
                            }
                            if (statefulBeanO.timedOut(this.reaper)) {
                                throw new SessionBeanTimeoutException("Stateful bean " + beanO + " timed out");
                            }
                            if (!enlist) break block36;
                            if (beanO.enlist(tx)) {
                                this.cache.pin(key);
                            }
                            beanO.setContainerTx(tx);
                        }
                        catch (InsufficientCacheSpaceException e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.container.activator.StatefulASActivationStrategy.atActivate", (String)"258", (Object)this);
                            exception = e;
                            throw new ActivatorCacheFullException();
                        }
                        catch (RemoteException e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.container.activator.StatefulASActivationStrategy.atActivate", (String)"264", (Object)this);
                            exception = e;
                            throw e;
                        }
                        catch (RuntimeException e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.container.activator.StatefulASActivationStrategy.atActivate", (String)"270", (Object)this);
                            exception = e;
                            throw e;
                        }
                    }
                    Object var15_18 = null;
                    if (exception != null) {
                        Tr.event(this.tc, "atActivation: exception raised", exception);
                    }
                    if (exception == null || beanO == null) break block37;
                    if (activate || found) {
                        try {
                            this.cache.remove(key, true);
                            beanO.ivCacheKey = null;
                            this.reaper.remove(beanId);
                            as.delist(beanO);
                            beanO.destroy();
                        }
                        catch (IllegalOperationException ex) {
                            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.container.activator.StatefulASActivationStrategy.atActivate", (String)"201", (Object)this);
                            this.cache.unpin(key);
                        }
                    } else {
                        beanO.destroy();
                    }
                }
                catch (Throwable throwable) {
                    Object var15_19 = null;
                    if (exception != null) {
                        Tr.event(this.tc, "atActivation: exception raised", exception);
                    }
                    if (exception == null) throw throwable;
                    if (beanO == null) throw throwable;
                    if (!activate && !found) {
                        beanO.destroy();
                        throw throwable;
                    }
                    try {}
                    catch (IllegalOperationException ex) {
                        FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.container.activator.StatefulASActivationStrategy.atActivate", (String)"201", (Object)this);
                        this.cache.unpin(key);
                        throw throwable;
                    }
                    this.cache.remove(key, true);
                    beanO.ivCacheKey = null;
                    this.reaper.remove(beanId);
                    as.delist(beanO);
                    beanO.destroy();
                    throw throwable;
                }
            }
        }
        if (!TraceComponent.isAnyTracingEnabled()) return beanO;
        if (!this.tc.isEntryEnabled()) return beanO;
        Tr.exit(this.tc, "atActivate", beanO);
        return beanO;
    }

    void atCommit(ContainerTx tx, BeanO bean) {
        ContainerAS as;
        if (TraceComponent.isAnyTracingEnabled() && this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "atCommit", new Object[]{tx, bean});
        }
        if ((as = ContainerAS.getContainerAS(tx)) == null) {
            super.atCommit(tx, bean);
            if (TraceComponent.isAnyTracingEnabled() && this.tc.isEntryEnabled()) {
                Tr.exit(this.tc, "atCommit");
            }
            return;
        }
        this.resetBeanOContainerTx(bean);
        if (TraceComponent.isAnyTracingEnabled() && this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, "atCommit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetBeanOContainerTx(BeanO bean) {
        Object key = bean.ivCacheKey;
        Object object = this.locks.getLock(key);
        synchronized (object) {
            BeanO beanO = (BeanO)this.cache.find(key);
            if (beanO != null) {
                this.cache.unpin(key);
                this.cache.unpin(key);
                beanO.setContainerTx(null);
            }
        }
    }

    void atRollback(ContainerTx tx, BeanO bean) {
        ContainerAS as;
        if (TraceComponent.isAnyTracingEnabled() && this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "atRollback", new Object[]{tx, bean});
        }
        if ((as = ContainerAS.getContainerAS(tx)) == null) {
            super.atRollback(tx, bean);
            if (TraceComponent.isAnyTracingEnabled() && this.tc.isEntryEnabled()) {
                Tr.exit(this.tc, "atRollback");
            }
            return;
        }
        this.resetBeanOContainerTx(bean);
        if (TraceComponent.isAnyTracingEnabled() && this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, "atRollback");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void atPostInvoke(ContainerTx tx, BeanO bean) {
        ContainerAS as;
        if (TraceComponent.isAnyTracingEnabled() && this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "atPostInvoke", new Object[]{tx, bean});
        }
        if ((as = ContainerAS.getContainerAS(tx)) == null) {
            super.atPostInvoke(tx, bean);
            if (TraceComponent.isAnyTracingEnabled() && this.tc.isEntryEnabled()) {
                Tr.exit(this.tc, "atPostInvoke");
            }
            return;
        }
        BeanId id = bean.getId();
        Object key = bean.ivCacheKey;
        this.reaper.setLastAccessTime(id);
        Object object = this.locks.getLock(key);
        synchronized (object) {
            bean = (BeanO)this.cache.find(key);
            if (bean != null) {
                this.cache.unpin(key);
                if (bean.isRemoved() || bean.isDiscarded()) {
                    this.cache.unpin(key);
                    if (tx != null) {
                        try {
                            tx.delist(bean);
                        }
                        catch (TransactionRolledbackException ex) {
                            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.container.activator.StatefulASActivationStrategy.atPostInvoke", (String)"258", (Object)this);
                            Tr.debug(this.tc, "atPostInvoke : transaction has rolledback");
                        }
                    }
                    bean.setContainerTx(null);
                    as.delist(bean);
                    ((BeanO)this.cache.remove(key, true)).destroy();
                    bean.ivCacheKey = null;
                    this.reaper.remove(id);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, "atPostInvoke");
        }
    }

    void atDiscard(BeanO bean) throws RemoteException {
        ContainerAS as;
        if (TraceComponent.isAnyTracingEnabled() && this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "atDiscard", bean);
        }
        if ((as = ContainerAS.getCurrentContainerAS()) == null) {
            super.atDiscard(bean);
            if (TraceComponent.isAnyTracingEnabled() && this.tc.isEntryEnabled()) {
                Tr.exit(this.tc, "atDiscard");
            }
            return;
        }
        try {
            BeanId beanId = ((StatefulBeanO)bean).getId();
            StatefulBeanO statefulBeanO = (StatefulBeanO)bean;
            if (!this.reaper.beanDoesNotExistOrHasTimedOut(beanId)) {
                as.delist(bean);
                bean.setContainerTx(null);
                bean.ivCacheKey = null;
                long lastAccessTime = this.reaper.getLastAccessTime(beanId);
                statefulBeanO.setLastAccessTime(lastAccessTime);
                if (TraceComponent.isAnyTracingEnabled() && this.tc.isDebugEnabled()) {
                    Tr.debug(this.tc, "StatefulBeanO last access time set to: " + lastAccessTime);
                }
                bean.passivate();
                this.reaper.setPassivated(beanId);
                statefulBeanO.destroyNotRemove();
            } else {
                Tr.event(this.tc, "Discarding session bean", bean);
                this.reaper.remove(beanId);
                statefulBeanO.destroy();
                bean.ivCacheKey = null;
            }
        }
        catch (RemoteException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.container.activator.StatefulASActivationStrategy.atDiscard", (String)"484", (Object)this);
            Tr.warning(this.tc, "UNABLE_TO_PASSIVATE_EJB_CNTR0005W", new Object[]{bean, this, e});
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, "atDiscard");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void atUnitOfWorkEnd(ContainerAS as, BeanO bean) {
        if (TraceComponent.isAnyTracingEnabled() && this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "atUnitOfWorkEnd", new Object[]{as, bean});
        }
        if (as == null) {
            super.atUnitOfWorkEnd(as, bean);
            if (TraceComponent.isAnyTracingEnabled() && this.tc.isEntryEnabled()) {
                Tr.exit(this.tc, "atUnitOfWorkEnd");
            }
            return;
        }
        BeanId id = bean.getId();
        Object key = bean.ivCacheKey;
        Object object = this.locks.getLock(key);
        synchronized (object) {
            bean = (BeanO)this.cache.find(key);
            if (bean != null) {
                this.cache.unpin(key);
                try {
                    if (!bean.isRemoved()) {
                        this.cache.remove(key, true);
                        bean.ivCacheKey = null;
                        bean.setContainerTx(null);
                        StatefulBeanO statefulBeanO = (StatefulBeanO)bean;
                        long lastAccessTime = this.reaper.getLastAccessTime(id);
                        statefulBeanO.setLastAccessTime(lastAccessTime);
                        if (TraceComponent.isAnyTracingEnabled() && this.tc.isDebugEnabled()) {
                            Tr.debug(this.tc, "StatefulBeanO last access time set to: " + lastAccessTime);
                        }
                        bean.passivate();
                        this.reaper.setPassivated(id);
                        statefulBeanO.destroyNotRemove();
                    }
                }
                catch (RemoteException ex) {
                    FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.container.activator.StatefulASActivationStrategy.atUnitOfWorkEnd", (String)"64", (Object)this);
                    Tr.warning(this.tc, "UNABLE_TO_PASSIVATE_EJB_CNTR0005W", new Object[]{bean, this, ex});
                }
            } else if (TraceComponent.isAnyTracingEnabled() && this.tc.isDebugEnabled()) {
                Tr.debug(this.tc, "Bean not found in cache");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, "atUnitOfWorkEnd");
        }
    }
}

