/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.BeanO;
import com.ibm.ejs.container.ContainerTx;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.EJSHome;
import com.ibm.ejs.container.TimerImpl;
import com.ibm.ejs.container.TimerServiceException;
import com.ibm.ejs.container.util.ByteArray;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.scheduler.Scheduler;
import com.ibm.websphere.scheduler.TaskInvalid;
import com.ibm.websphere.scheduler.TaskStatus;
import com.ibm.ws.ejb.portable.Constants;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.ejb.EJBException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.Timer;
import javax.ejb.TimerHandle;

public final class TimerHandleImpl
implements TimerHandle,
Serializable {
    private static final TraceComponent tc = Tr.register(TimerHandleImpl.class, "EJBContainer", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.container.TimerHandleImpl";
    private static final long serialVersionUID = -7720620493313660153L;
    private static final byte[] EYECATCHER = Constants.TIMER_HANDLE_EYE_CATCHER;
    private static final short PLATFORM = 1;
    private static final short VERSION_ID = 1;
    private transient String ivTaskId;
    private transient BeanId ivBeanId;
    private transient int ivHashCode;
    private transient boolean isTimer;

    TimerHandleImpl(BeanId beanId, String taskId, int hashcode, boolean timer) {
        this.ivBeanId = beanId;
        this.ivTaskId = taskId;
        this.ivHashCode = hashcode;
        this.isTimer = timer;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, this.toString());
        }
    }

    public Timer getTimer() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        TimerImpl timer;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getTimer: " + this);
        }
        this.checkTimerAccess();
        try {
            EJSHome home = (EJSHome)this.ivBeanId.home;
            Scheduler scheduler = home.container.ivScheduler;
            TaskStatus taskStatus = scheduler.getStatus(this.ivTaskId);
            timer = new TimerImpl(this.ivBeanId, this.ivTaskId, this.ivHashCode);
        }
        catch (TaskInvalid invalid) {
            FFDCFilter.processException((Throwable)invalid, (String)"com.ibm.ejs.container.TimerHandleImpl.getTimer", (String)"97", (Object)this);
            NoSuchObjectLocalException nsoe = new NoSuchObjectLocalException(this.toString(), invalid);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getTimer: " + nsoe);
            }
            throw nsoe;
        }
        catch (Throwable th) {
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ejs.container.TimerHandleImpl.getTimer", (String)"109", (Object)this);
            TimerServiceException tse = new TimerServiceException(this.toString(), th);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getTimer: " + tse);
            }
            throw tse;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getTimer: " + timer);
        }
        return timer;
    }

    private void checkTimerAccess() throws IllegalStateException {
        IllegalStateException ise;
        BeanO beanO;
        block6: {
            beanO = null;
            EJSHome home = null;
            ContainerTx tx = null;
            ise = null;
            try {
                home = (EJSHome)this.ivBeanId.home;
                tx = home.container.getCurrentTx(false);
                if (tx != null) {
                    beanO = tx.ivCallbackBeanO;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "checkTimerAccess: checking callback  beanO from current tx: " + beanO);
                    }
                }
            }
            catch (Throwable th) {
                FFDCFilter.processException((Throwable)th, (String)"com.ibm.ejs.container.TimerHandleImpl.checkTimerAccess", (String)"244", (Object)this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "Exception ignored : " + th);
            }
        }
        if (beanO == null) {
            ise = new IllegalStateException("TimerHandle: Timer methods not allowed - no active EJB");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "checkTimerAccess: " + ise);
            }
            throw ise;
        }
        beanO.checkTimerServiceAccess();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "writeObject: " + this);
        }
        out.defaultWriteObject();
        out.write(EYECATCHER);
        out.writeShort(1);
        out.writeShort(1);
        out.writeBoolean(this.isTimer);
        out.writeUTF(this.ivTaskId);
        out.writeInt(this.ivHashCode);
        out.writeObject(this.ivBeanId.getByteArrayBytes());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "writeObject");
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "readObject");
        }
        in.defaultReadObject();
        byte[] eyeCatcher = new byte[EYECATCHER.length];
        int bytesRead = 0;
        for (int offset = 0; offset < EYECATCHER.length; offset += bytesRead) {
            bytesRead = in.read(eyeCatcher, offset, EYECATCHER.length - offset);
            if (bytesRead != -1) continue;
            throw new IOException("end of input stream while reading eye catcher");
        }
        for (int i = 0; i < EYECATCHER.length; ++i) {
            if (EYECATCHER[i] == eyeCatcher[i]) continue;
            String eyeCatcherString = new String(eyeCatcher);
            throw new IOException("Invalid eye catcher '" + eyeCatcherString + "' in TimerHandle input stream");
        }
        short incoming_platform = in.readShort();
        short incoming_vid = in.readShort();
        if (incoming_vid != 1) {
            throw new InvalidObjectException("EJB TimerHandle data stream is not of the correct version, this client should be updated.");
        }
        this.isTimer = in.readBoolean();
        this.ivTaskId = in.readUTF();
        this.ivHashCode = in.readInt();
        byte[] bytes = (byte[])in.readObject();
        ByteArray byteArray = new ByteArray(bytes);
        EJSContainer container2 = EJSContainer.getDefaultContainer();
        this.ivBeanId = BeanId.getBeanId(byteArray, container2);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "readObject: " + this);
        }
    }

    public Object getSerializedObject() {
        if (this.isTimer) {
            TimerImpl timer = new TimerImpl(this.ivBeanId, this.ivTaskId, this.ivHashCode);
            return timer;
        }
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TimerHandleImpl) {
            TimerHandleImpl timerHandle = (TimerHandleImpl)obj;
            if (this.ivHashCode == timerHandle.ivHashCode && this.ivTaskId.equals(timerHandle.ivTaskId)) {
                return true;
            }
        }
        return false;
    }

    public boolean equals(TimerHandleImpl timerHandle) {
        return timerHandle != null && this.ivHashCode == timerHandle.ivHashCode && this.ivTaskId.equals(timerHandle.ivTaskId);
    }

    public int hashCode() {
        return this.ivHashCode;
    }

    public String toString() {
        return "TimerHandleImpl(" + this.ivTaskId + ", " + this.ivBeanId + ")";
    }
}

