/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.ws.util.WsObjectInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;

class ExternalizedBeanId
extends BeanId
implements Externalizable {
    private static final long serialVersionUID = -7733353009012455282L;
    private static final TraceComponent tc = Tr.register(ExternalizedBeanId.class, "EJBContainer", "com.ibm.ejs.container.container");
    private static final byte IF_HOME = 0;
    private static final byte IF_REMOTE = 1;
    private static final String EXTERNAL_CODEPAGE = "ISO8859_1";
    private static final String HOME_OF_HOMES_NAME = "__homeOfHomes";
    private static final short EXTERNAL_MAGIC = -21332;
    private static final short MAJOR_VERSION = 1;
    private static final short MINOR_VERSION = 1;

    public ExternalizedBeanId() {
        this.pkey = null;
        this._isHome = false;
    }

    public ExternalizedBeanId(Serializable pkey, J2EEName j2eeName, boolean isHome) {
        this.pkey = pkey;
        this._isHome = isHome;
        this.j2eeName = j2eeName;
        this.j2eeNameBytes = j2eeName.getBytes();
        this.hashValue = ExternalizedBeanId.computeHashValue(j2eeName, pkey, this._isHome);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "readExternal");
        }
        try {
            short magic = in.readShort();
            short majorVersion = in.readShort();
            short minorVersion = in.readShort();
            if (magic != -21332) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Magic Number absent, trying default Java deserialization");
                }
                throw new IOException("Bean ID externalized stream format error");
            }
            if (majorVersion != 1 || minorVersion != 1) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "BeanID Version mismatch", new Object[]{new Short(majorVersion), new Short(minorVersion)});
                }
                throw new IOException("BeanID version mismatch");
            }
            byte ifType = in.readByte();
            this._isHome = ifType == 0;
            this.j2eeNameBytes = this.readExternalJ2EEName(in);
            this.pkey = this.readExternalPKey(in);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "readExternal");
            }
            throw throwable;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "readExternal");
        }
    }

    private byte[] readExternalJ2EEName(ObjectInput in) throws IOException {
        int nameLength = in.readInt();
        byte[] name = new byte[nameLength];
        int bytesRead = 0;
        for (int offset = 0; offset < nameLength; offset += bytesRead) {
            bytesRead = in.read(name, offset, nameLength - offset);
            if (bytesRead != -1) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "readExternalJ2EEName encountered end of stream");
            }
            throw new IOException("end of input stream while reading J2EEName");
        }
        return name;
    }

    private Serializable readExternalPKey(ObjectInput in) throws IOException, ClassNotFoundException {
        int pkeyLength = in.readInt();
        byte[] pkeyBytes = new byte[pkeyLength];
        int bytesRead = 0;
        for (int offset = 0; offset < pkeyLength; offset += bytesRead) {
            bytesRead = in.read(pkeyBytes, offset, pkeyLength - offset);
            if (bytesRead != -1) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "readExternalKey encountered end of stream");
            }
            throw new IOException("end of input stream while reading primary key");
        }
        J2EEName j2eeName = EJSContainer.getJ2EENameFactory().create(this.j2eeNameBytes);
        ByteArrayInputStream bais = new ByteArrayInputStream(pkeyBytes);
        WsObjectInputStream pkeyStream = new WsObjectInputStream((InputStream)bais, EJSContainer.getClassLoader(j2eeName));
        Serializable key = (Serializable)pkeyStream.readObject();
        return key;
    }

    public String toString() {
        return "BeanId(" + this.j2eeName + ", " + this.pkey + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(ObjectOutput out) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "writeExternal");
        }
        try {
            out.writeShort(-21332);
            out.writeShort(1);
            out.writeShort(1);
            if (this._isHome) {
                out.writeByte(0);
            } else {
                out.writeByte(1);
            }
            this.writeExternalJ2EEName(out);
            this.writeExternalPKey(out);
            out.flush();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "writeExternal");
            }
            throw throwable;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "writeExternal");
        }
    }

    private void writeExternalJ2EEName(ObjectOutput out) throws IOException {
        out.writeInt(this.j2eeNameBytes.length);
        out.write(this.j2eeNameBytes);
    }

    private void writeExternalPKey(ObjectOutput out) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream pkeyStream = new ObjectOutputStream(baos);
        pkeyStream.writeObject(this.pkey);
        pkeyStream.flush();
        pkeyStream.close();
        byte[] pkeyBytes = baos.toByteArray();
        out.writeInt(pkeyBytes.length);
        out.write(pkeyBytes);
    }
}

