/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.EJSDeployedSupport;
import com.ibm.ejs.container.util.ExceptionUtil;
import com.ibm.ejs.csi.EJBModuleMetaDataImpl;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.CSIException;
import com.ibm.websphere.csi.CSITransactionRolledbackException;
import com.ibm.websphere.csi.ExceptionType;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import javax.ejb.ApplicationException;

public abstract class ExceptionMappingStrategy {
    private static final TraceComponent tc = Tr.register(ExceptionMappingStrategy.class, "EJBContainer", "com.ibm.ejs.container.container");
    ExceptionType exType;
    Throwable ivException;
    Throwable root;
    Exception exceptionToBeThrown = null;
    EJSDeployedSupport thisStrategiesOwner = null;

    public abstract Throwable setUncheckedException(Throwable var1);

    public abstract Exception mapCSITransactionRolledBackException(CSITransactionRolledbackException var1) throws CSIException;

    public ExceptionMappingStrategy(EJSDeployedSupport owner) {
        this.thisStrategiesOwner = owner;
        this.exType = ExceptionType.NO_EXCEPTION;
    }

    public void initializeInstanceData() {
        this.exType = ExceptionType.NO_EXCEPTION;
        this.ivException = null;
        this.root = null;
        this.exceptionToBeThrown = null;
    }

    public Throwable findRootCause(Throwable throwable) {
        return ExceptionUtil.findRootCause(throwable);
    }

    public final void setCheckedException(Exception ex) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "setting checked exception", ex);
        }
        this.exType = ExceptionType.CHECKED_EXCEPTION;
        this.ivException = ex;
        this.root = this.findRootCause(ex);
        Boolean applicationExceptionRollback = this.getApplicationExceptionRollback(ex);
        if (applicationExceptionRollback == Boolean.TRUE) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "ApplicationException with rollback set to true, setting rollback only", ex);
            }
            this.thisStrategiesOwner.currentTx.setRollbackOnly();
        }
    }

    public final Throwable getException() {
        return this.ivException;
    }

    public final Throwable getRootCause() {
        return this.root;
    }

    protected Boolean getApplicationExceptionRollback(Throwable t) {
        ApplicationException ae;
        ComponentMetaData cmd = this.thisStrategiesOwner.getComponentMetaData();
        EJBModuleMetaDataImpl mmd = (EJBModuleMetaDataImpl)cmd.getModuleMetaData();
        Boolean rollback = mmd.getApplicationExceptionRollback(t);
        if (rollback == null && (ae = t.getClass().getAnnotation(ApplicationException.class)) != null) {
            rollback = ae.rollback() ? Boolean.TRUE : Boolean.FALSE;
        }
        return rollback;
    }
}

