/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import sun.io.ByteToCharConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;

public abstract class ByteToCharDoubleByte
extends ByteToCharConverter {
    protected byte savedByte = 0;
    protected short[] index1;
    protected String[] index2;
    protected int start;
    protected int end;
    protected final char[] charMap;
    static char[] JapanSingle = new char[]{'\u0000', '\u007f', '\u0000', '\u00a1', '\u00df', '\uff61'};
    protected static final char REPLACE_CHAR = '\ufffd';

    public String getType() {
        return "dbcs";
    }

    public short[] getIndex() {
        return this.index1;
    }

    public Object getObjectData() {
        return this.index2;
    }

    public byte[] getByteData() {
        byte[] byArray = new byte[259];
        for (int i = 0; i < 256; ++i) {
            byte by = (byte)(i + 0);
            char c = this.convSingleByte(by);
            byArray[i] = (byte)(c >= '\ufffd' && this.isLeadByte(by) ? 1 : 0);
        }
        byArray[256] = (byte)(this.convSingleByte(64) == '\ufffd' ? 1 : 0);
        byArray[257] = (byte)this.start;
        byArray[258] = (byte)this.end;
        return byArray;
    }

    public char[] getCharData() {
        if (this.convSingleByte(-95) == '\uff61') {
            return JapanSingle;
        }
        return null;
    }

    public ByteToCharDoubleByte() {
        this.charMap = null;
    }

    protected ByteToCharDoubleByte(char[] cArray) {
        this.charMap = cArray;
    }

    public int flush(char[] cArray, int n, int n2) throws MalformedInputException {
        if (this.savedByte != 0) {
            this.reset();
            this.badInputLength = 0;
            throw new MalformedInputException();
        }
        this.reset();
        return 0;
    }

    public int convert(byte[] byArray, int n, int n2, char[] cArray, int n3, int n4) throws UnknownCharacterException, MalformedInputException, ConversionBufferFullException {
        int n5 = 65533;
        int n6 = 0;
        this.charOff = n3;
        this.byteOff = n;
        while (this.byteOff < n2) {
            int n7;
            if (this.savedByte == 0) {
                n7 = byArray[this.byteOff];
                n6 = 1;
            } else {
                n7 = this.savedByte;
                this.savedByte = 0;
                n6 = 0;
            }
            n5 = this.convSingleByte(n7);
            if (n5 >= 65533 && this.isLeadByte(n7)) {
                if (this.byteOff + n6 >= n2) {
                    this.savedByte = (byte)n7;
                    this.byteOff += n6;
                    break;
                }
                int n8 = byArray[this.byteOff + n6] & 0xFF;
                ++n6;
                n5 = this.getUnicode(n7 &= 0xFF, n8);
            }
            if (n5 >= 65533) {
                if (n5 == 65534) {
                    throw new MalformedInputException();
                }
                if (this.subMode) {
                    n5 = this.subChars[0];
                } else {
                    this.badInputLength = n6;
                    throw new UnknownCharacterException();
                }
            }
            if (this.charOff >= n4) {
                throw new ConversionBufferFullException();
            }
            cArray[this.charOff++] = n5;
            this.byteOff += n6;
        }
        return this.charOff - n3;
    }

    public void reset() {
        this.charOff = 0;
        this.byteOff = 0;
        this.savedByte = 0;
    }

    protected char convSingleByte(int n) {
        if (n >= 0) {
            return (char)n;
        }
        return '\ufffd';
    }

    protected boolean isLeadByte(int n) {
        return n < 0;
    }

    protected char getUnicode(int n, int n2) {
        if (this.charMap != null) {
            int n3 = n * 256 + n2;
            if (n3 >= 0 && n3 < this.charMap.length) {
                char c = this.charMap[n3];
                return c != '\u0000' ? c : (char)'\ufffd';
            }
            return '\ufffd';
        }
        if (n < 0 || n > this.index1.length || n2 < this.start || n2 > this.end) {
            return '\ufffd';
        }
        int n4 = (this.index1[n] & 0xF) * (this.end - this.start + 1) + (n2 - this.start);
        return this.index2[this.index1[n] >> 4].charAt(n4);
    }

    public static char[] expandCharMap(short[] sArray, String[] stringArray, int n, int n2, int n3) {
        char[] cArray = new char[65536];
        int n4 = n3 - n2 + 1;
        for (int i = 0; i < 256; ++i) {
            short s = sArray[i];
            if (s == n) continue;
            int n5 = (s & 0xF) * n4;
            int n6 = i * 256 + n2;
            stringArray[s >> 4].getChars(n5, n5 + n4, cArray, n6);
        }
        return cArray;
    }
}

