/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.beans;

import java.beans.XMLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import org.apache.harmony.beans.Command;
import org.apache.harmony.beans.internal.nls.Messages;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Handler
extends DefaultHandler {
    private Vector<Object> result;
    private Vector<Command> commands;
    private XMLDecoder decoder;
    private Map<String, Command> references;
    private Stack<Command> stack;
    private int tabCount;

    public Handler(XMLDecoder xMLDecoder, Vector<Object> vector) {
        this.decoder = xMLDecoder;
        this.result = vector;
        this.commands = new Vector();
        this.references = new HashMap<String, Command>();
        this.stack = new Stack();
    }

    @Override
    public void startDocument() {
        this.references.clear();
        this.tabCount = 0;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Command.printAttrs(this.tabCount, string3, attributes);
        Command command = string3.equals("java") ? new Command(this.decoder, string3, Command.parseAttrs(string3, attributes)) : new Command(string3, Command.parseAttrs(string3, attributes));
        this.stack.push(command);
        ++this.tabCount;
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string;
        if (n2 > 0 && (string = String.valueOf(cArray, n, n2).replace('\n', ' ').replace('\t', ' ').trim()).length() > 0) {
            Command.prn(this.tabCount, this.tabCount + ">setting data=" + string + "<EOL>");
            Command command = this.stack.peek();
            command.setData(string);
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        Command command = this.stack.pop();
        if (!this.stack.isEmpty()) {
            Command command2 = this.stack.peek();
            command2.addChild(command);
        }
        if (this.stack.size() == 1 && command.isExecutable()) {
            this.commands.add(command);
        }
        if (command.hasAttr("id")) {
            this.references.put(command.getAttr("id"), command);
        }
        try {
            command.exec(this.references);
        }
        catch (Exception exception) {
            SAXException sAXException = new SAXException(exception.getMessage());
            sAXException.initCause(exception);
            throw sAXException;
        }
        if (--this.tabCount < 0) {
            this.tabCount = 0;
        }
        Command.prn(this.tabCount, this.tabCount + ">...<" + string3 + "> end");
    }

    @Override
    public void endDocument() throws SAXException {
        Command command;
        int n;
        for (n = 0; n < this.commands.size(); ++n) {
            command = this.commands.elementAt(n);
            try {
                command.backtrack(this.references);
                continue;
            }
            catch (Exception exception) {
                throw new SAXException(Messages.getString("beans.0B"));
            }
        }
        for (n = 0; n < this.commands.size(); ++n) {
            command = this.commands.elementAt(n);
            this.result.add(command.getResultValue());
        }
    }
}

