/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.beans;

import java.beans.BeanInfo;
import java.beans.Expression;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.Statement;
import java.beans.XMLDecoder;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.harmony.beans.Argument;
import org.apache.harmony.beans.internal.nls.Messages;
import org.xml.sax.Attributes;

public class Command {
    private static final int INITIALIZED = 0;
    private static final int CHILDREN_FILTERED = 1;
    private static final int COMMAND_EXECUTED = 2;
    private static final int CHILDREN_PROCESSED = 3;
    private String tagName;
    private Map<String, String> attrs;
    private String data;
    private Vector<Command> commands = new Vector();
    private Vector<Command> arguments = new Vector();
    private Vector<Command> operations = new Vector();
    private Vector<Argument> auxArguments = new Vector();
    private Argument result;
    private Object target;
    private String methodName;
    private Command ctx;
    private int status;
    private XMLDecoder decoder;
    private static final String[] objectAttrNames = new String[]{"id", "idref", "class", "field", "method", "property", "index"};
    private static final String[] voidAttrNames = new String[]{"id", "class", "method", "property", "index"};
    private static final String[] arrayAttrNames = new String[]{"id", "class", "length"};
    private static final String[] javaAttrNames = new String[]{"version", "class"};

    public Command(String string, Map<String, String> map) {
        this.tagName = string;
        this.attrs = map;
        this.status = Command.initializeStatus(string);
    }

    public Command(XMLDecoder xMLDecoder, String string, Map<String, String> map) {
        this.decoder = xMLDecoder;
        this.tagName = string;
        this.attrs = map;
        this.status = Command.initializeStatus(string);
    }

    public void setData(String string) {
        this.data = string;
    }

    public void setContext(Command command) {
        this.ctx = command;
    }

    public void addChild(Command command) {
        if (command != null) {
            command.setContext(this);
            this.commands.add(command);
        }
    }

    public void removeChild(Command command) {
        if (command != null && this.commands.remove(command)) {
            command.setContext(null);
        }
    }

    public int getStatus() {
        return this.status;
    }

    private boolean isResolved() {
        Command command;
        int n;
        if (this.getStatus() < 3) {
            return false;
        }
        for (n = 0; n < this.arguments.size(); ++n) {
            command = this.arguments.elementAt(n);
            if (command.isResolved()) continue;
            return false;
        }
        for (n = 0; n < this.operations.size(); ++n) {
            command = this.operations.elementAt(n);
            if (command.isResolved()) continue;
            return false;
        }
        return true;
    }

    public int exec(Map<String, Command> map) throws Exception {
        if (this.status < 3) {
            if (this.status < 2) {
                if (this.status < 1) {
                    this.status = this.doBeforeRun(map);
                }
                if (this.status == 1) {
                    this.status = this.doRun(map);
                }
            }
            if (this.status == 2) {
                this.status = this.doAfterRun(map);
            }
        }
        return this.status;
    }

    public boolean backtrack(Map<String, Command> map) throws Exception {
        Command command;
        int n;
        for (n = 0; n < this.arguments.size(); ++n) {
            command = this.arguments.elementAt(n);
            command.backtrack(map);
        }
        for (n = 0; n < this.operations.size(); ++n) {
            command = this.operations.elementAt(n);
            command.backtrack(map);
        }
        if (this.status == 1) {
            this.status = this.doRun(map);
        }
        if (this.status == 2) {
            this.status = this.doAfterRun(map);
            return this.getStatus() == 3;
        }
        return false;
    }

    private int doBeforeRun(Map<String, Command> map) throws Exception {
        if (this.status == 0) {
            for (int i = 0; i < this.commands.size(); ++i) {
                Command command = this.commands.elementAt(i);
                if (command.isExecutable()) {
                    this.arguments.add(command);
                    continue;
                }
                this.operations.add(command);
            }
            return 1;
        }
        return this.status;
    }

    private int doRun(Map<String, Command> map) throws Exception {
        if (this.status == 1) {
            if (this.isRoot()) {
                this.result = new Argument(this.decoder);
                return 2;
            }
            if (this.isNull()) {
                this.result = new Argument(null);
                return 2;
            }
            if (this.ctx != null && this.ctx.isArray() && this.ctx.getResultValue() == null && !this.isExecutable()) {
                return this.status;
            }
            Object object = this.getTarget(map);
            if (object == null) {
                return this.status;
            }
            if (this.isReference()) {
                this.result = this.getReferencedArgument(map);
            } else {
                String string = this.getMethodName(map);
                Argument[] argumentArray = this.getArguments();
                if (argumentArray == null) {
                    return this.status;
                }
                Expression expression = new Expression(object, string, this.getArgumentsValues());
                this.result = new Argument(expression.getValue());
                if (Command.isPrimitiveClassName(this.getTagName())) {
                    this.result.setType(Command.getPrimitiveClass(this.tagName));
                }
            }
            return 2;
        }
        return this.status;
    }

    private int doAfterRun(Map<String, Command> map) throws Exception {
        if (this.status == 2) {
            Vector<Command> vector = new Vector<Command>();
            try {
                Statement[] statementArray = null;
                for (int i = 0; i < this.operations.size(); ++i) {
                    Command command = this.operations.elementAt(i);
                    if (command.isArrayElement()) {
                        if (command.isResolved()) {
                            if (statementArray == null) {
                                statementArray = new Statement[this.operations.size()];
                            }
                            statementArray[i] = new Statement(this.getResultValue(), "set", new Object[]{new Integer(i), command.getResultValue()});
                            if (i + 1 != this.operations.size()) continue;
                            for (int j = 0; j < this.operations.size(); ++j) {
                                statementArray[j].execute();
                            }
                            vector.addAll(this.operations);
                            continue;
                        }
                    } else {
                        if (!this.isArray()) {
                            command.setTarget(this.getResultValue());
                        }
                        command.exec(map);
                        if (command.isResolved()) {
                            vector.add(command);
                            continue;
                        }
                    }
                    break;
                }
            }
            catch (Exception exception) {
                throw new Exception(exception);
            }
            finally {
                this.operations.removeAll(vector);
            }
            return this.operations.size() == 0 ? 3 : this.status;
        }
        return this.status;
    }

    public Argument getResult() {
        return this.result;
    }

    public Object getResultValue() {
        return this.result != null ? this.result.getValue() : null;
    }

    public Class<?> getResultType() throws ClassNotFoundException {
        return this.result != null ? this.result.getType() : null;
    }

    public boolean hasAttr(String string) {
        return this.attrs.get(string) != null;
    }

    public String getAttr(String string) {
        return this.attrs.get(string);
    }

    public boolean isTag(String string) {
        return this.tagName.equals(string);
    }

    public boolean hasAttr(String string, String string2) {
        return string2.equals(this.attrs.get(string));
    }

    public String getTagName() {
        return this.tagName;
    }

    private boolean isPrimitive() {
        return Command.isPrimitiveClassName(this.tagName);
    }

    private boolean isConstructor() {
        return this.isPrimitive() || !this.isStaticMethod() && !this.isMethod() && !this.isProperty() && !this.isField() && !this.isArray() && !this.isReference();
    }

    private boolean isStaticMethod() {
        return this.isTag("object") && this.hasAttr("method") || this.isTag("class");
    }

    private boolean isMethod() {
        return this.isTag("void") && (this.hasAttr("method") || this.hasAttr("index"));
    }

    private boolean isProperty() {
        return this.isTag("void") && this.hasAttr("property");
    }

    private boolean isField() {
        return this.isTag("object") && this.hasAttr("field");
    }

    private boolean isArray() {
        return this.isTag("array");
    }

    private boolean isArrayElement() {
        return this.ctx != null && this.ctx.isArray() && this.isExecutable();
    }

    private boolean isReference() {
        return this.hasAttr("idref");
    }

    private boolean isRoot() {
        return this.isTag("java");
    }

    private boolean isNull() {
        return this.isTag("null");
    }

    public boolean isExecutable() {
        boolean bl = this.isTag("object") || this.isTag("void") && this.hasAttr("class") && this.hasAttr("method") || this.isTag("array") || this.isPrimitive() || this.isTag("class") || this.isTag("null");
        return bl;
    }

    private Argument getReferencedArgument(Map<String, Command> map) {
        return map.get(this.getAttr("idref")).getResult();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object getTarget(Map<String, Command> map) throws Exception {
        if (this.target != null) return this.target;
        if (this.isReference()) {
            Command command = map.get(this.getAttr("idref"));
            this.target = command != null ? command.getResultValue() : null;
            return this.target;
        }
        if (this.isExecutable()) {
            Object object;
            String string = null;
            if (this.isPrimitive()) {
                string = this.getPrimitiveClassName(this.tagName);
            } else if (this.isTag("class")) {
                string = this.getPrimitiveClassName(this.tagName);
            } else if (this.isConstructor() || this.isStaticMethod() || this.isField()) {
                string = this.getAttr("class");
            } else if (this.isArray()) {
                string = this.getAttr("class");
                object = Command.isPrimitiveClassName(string) ? Command.getPrimitiveClass(string) : Class.forName(string, true, Thread.currentThread().getContextClassLoader());
                string = Array.newInstance(object, 0).getClass().getName();
            }
            if (string == null) throw new Exception(Messages.getString("beans.42", string));
            try {
                this.target = Class.forName(string, true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.target = Class.forName(string);
            }
            if (!this.isField()) return this.target;
            object = this.getAttr("field");
            this.target = ((Class)this.target).getField((String)object);
            return this.target;
        }
        if (!this.ctx.isArray()) return this.target;
        this.target = Class.forName("java.lang.reflect.Array");
        return this.target;
    }

    private void setTarget(Object object) {
        this.target = object;
    }

    private String getMethodName(Map<String, Command> map) throws NoSuchMethodException, IntrospectionException, Exception {
        if (this.methodName == null) {
            String string = null;
            if (this.isTag("class")) {
                this.addArgument(new Argument(String.class, this.data), 0);
                string = "forName";
            } else if (this.isPrimitive()) {
                if (this.isTag("char")) {
                    if (this.data.length() != 1) {
                        throw new IntrospectionException(Messages.getString("beans.43", this.data));
                    }
                    this.addArgument(new Argument(Character.TYPE, new Character(this.data.charAt(0))), 0);
                } else {
                    this.addArgument(new Argument(String.class, this.data), 0);
                }
                string = "new";
            } else if (this.isConstructor() || this.hasAttr("method", "new")) {
                string = "new";
            } else if (this.isArray()) {
                string = "new";
                int n = this.hasAttr("length") ? Integer.parseInt(this.getAttr("length")) : this.getArgumentsNumber();
                this.copyArgumentsToCommands();
                this.addArgument(new Argument(Integer.TYPE, new Integer(n)), 0);
            } else if (this.hasAttr("property")) {
                String string2 = this.getAttr("property");
                if (this.hasAttr("index")) {
                    this.addArgument(new Argument(Integer.TYPE, new Integer(this.getAttr("index"))), 0);
                }
                BeanInfo beanInfo = Introspector.getBeanInfo(this.getTarget(map).getClass());
                PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
                boolean bl = false;
                Method method = null;
                for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray) {
                    IndexedPropertyDescriptor indexedPropertyDescriptor;
                    if (!string2.equals(propertyDescriptor.getName())) continue;
                    int n = this.getArgumentsNumber();
                    if (this.hasAttr("index")) {
                        indexedPropertyDescriptor = (IndexedPropertyDescriptor)propertyDescriptor;
                        if (n == 1) {
                            method = indexedPropertyDescriptor.getIndexedReadMethod();
                        } else if (n == 0) {
                            method = indexedPropertyDescriptor.getReadMethod();
                        }
                    } else {
                        method = propertyDescriptor.getReadMethod();
                    }
                    if (method != null) {
                        bl = this.matchMethodParams(method, map);
                    }
                    if (!bl) {
                        if (this.hasAttr("index")) {
                            indexedPropertyDescriptor = (IndexedPropertyDescriptor)propertyDescriptor;
                            if (n == 2) {
                                method = indexedPropertyDescriptor.getIndexedWriteMethod();
                            } else if (n == 1) {
                                method = indexedPropertyDescriptor.getWriteMethod();
                            }
                        } else {
                            method = propertyDescriptor.getWriteMethod();
                        }
                    }
                    if (method == null) continue;
                    bl = this.matchMethodParams(method, map);
                }
                if (method == null) {
                    throw new NoSuchMethodException(Messages.getString("beans.44", string2));
                }
                string = method.getName();
            } else if (this.hasAttr("method")) {
                if (this.hasAttr("index")) {
                    this.addArgument(new Argument(Integer.TYPE, Integer.valueOf(this.getAttr("index"))), 0);
                }
                string = this.getAttr("method");
            } else if (this.hasAttr("index")) {
                this.addArgument(new Argument(Integer.TYPE, Integer.valueOf(this.getAttr("index"))), 0);
                String string3 = string = this.getArgumentsNumber() > 1 ? "set" : "get";
                if (this.ctx.isArray()) {
                    this.addArgument(this.ctx.getResult(), 0);
                }
            } else if (this.hasAttr("field")) {
                this.addArgument(new Argument(Class.forName(this.getAttr("class"), true, Thread.currentThread().getContextClassLoader())), 0);
                string = "get";
            } else {
                throw new Exception(Messages.getString("beans.45"));
            }
            this.methodName = string;
        }
        return this.methodName;
    }

    private Argument[] getArguments() {
        int n;
        Argument[] argumentArray = new Argument[this.auxArguments.size() + this.arguments.size()];
        for (n = 0; n < this.auxArguments.size(); ++n) {
            argumentArray[n] = this.auxArguments.elementAt(n);
        }
        for (n = 0; n < this.arguments.size(); ++n) {
            Command command = this.arguments.elementAt(n);
            if (command.getStatus() < 2) {
                argumentArray = null;
                break;
            }
            argumentArray[this.auxArguments.size() + n] = command.getResult();
        }
        return argumentArray;
    }

    private Object[] getArgumentsValues() {
        Argument[] argumentArray = this.getArguments();
        Object[] objectArray = new Object[argumentArray.length];
        for (int i = 0; i < argumentArray.length; ++i) {
            objectArray[i] = argumentArray[i].getValue();
        }
        return objectArray;
    }

    private void copyArgumentsToCommands() {
        for (Command command : this.arguments) {
            command.status = 1;
            this.operations.add(command);
        }
        this.arguments.clear();
    }

    private int getArgumentsNumber() {
        return this.auxArguments.size() + this.arguments.size();
    }

    private void addArgument(Argument argument, int n) {
        this.auxArguments.insertElementAt(argument, n);
    }

    public static boolean isPrimitiveClassName(String string) {
        return string.equalsIgnoreCase("boolean") || string.equalsIgnoreCase("byte") || string.equalsIgnoreCase("char") || string.equalsIgnoreCase("short") || string.equalsIgnoreCase("int") || string.equalsIgnoreCase("long") || string.equalsIgnoreCase("float") || string.equalsIgnoreCase("double") || string.equalsIgnoreCase("string");
    }

    private String getPrimitiveClassName(String string) {
        String string2 = null;
        string2 = string.equals("int") ? "Integer" : (string.equals("char") ? "Character" : string.substring(0, 1).toUpperCase() + string.substring(1, string.length()));
        return "java.lang." + string2;
    }

    public static Class<?> getPrimitiveClass(String string) {
        Class<Object> clazz = null;
        if (string.equals("boolean")) {
            clazz = Boolean.TYPE;
        } else if (string.equals("byte")) {
            clazz = Byte.TYPE;
        } else if (string.equals("char")) {
            clazz = Character.TYPE;
        } else if (string.equals("short")) {
            clazz = Short.TYPE;
        } else if (string.equals("int")) {
            clazz = Integer.TYPE;
        } else if (string.equals("long")) {
            clazz = Long.TYPE;
        } else if (string.equals("float")) {
            clazz = Float.TYPE;
        } else if (string.equals("double")) {
            clazz = Double.TYPE;
        } else if (string.equals("string")) {
            clazz = String.class;
        }
        return clazz;
    }

    private boolean matchMethodParams(Method method, Map<String, Command> map) {
        Class<?>[] classArray = method.getParameterTypes();
        Argument[] argumentArray = this.getArguments();
        if (argumentArray == null) {
            return false;
        }
        boolean bl = true;
        if (classArray.length == argumentArray.length) {
            for (int i = 0; i < classArray.length; ++i) {
                boolean bl2;
                boolean bl3 = argumentArray[i].getType() == null ? !classArray[i].isPrimitive() : (bl2 = classArray[i].isAssignableFrom(argumentArray[i].getType()));
                if (bl2) continue;
                bl = false;
                break;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public static Map<String, String> parseAttrs(String string, Attributes attributes) {
        HashMap<String, String> hashMap;
        block5: {
            block7: {
                block6: {
                    block4: {
                        hashMap = new HashMap<String, String>();
                        if (!string.equals("object")) break block4;
                        for (String string2 : objectAttrNames) {
                            String string3 = attributes.getValue(string2);
                            if (string3 == null) continue;
                            hashMap.put(string2, string3);
                        }
                        break block5;
                    }
                    if (!string.equals("void")) break block6;
                    for (String string4 : voidAttrNames) {
                        String string5 = attributes.getValue(string4);
                        if (string5 == null) continue;
                        hashMap.put(string4, string5);
                    }
                    break block5;
                }
                if (!string.equals("array")) break block7;
                for (String string6 : arrayAttrNames) {
                    String string7 = attributes.getValue(string6);
                    if (string7 == null) continue;
                    hashMap.put(string6, string7);
                }
                break block5;
            }
            if (!string.equals("java")) break block5;
            for (String string8 : javaAttrNames) {
                String string9 = attributes.getValue(string8);
                if (string9 == null) continue;
                hashMap.put(string8, string9);
            }
        }
        return hashMap;
    }

    public static void pr(String string) {
    }

    public static void pr(int n, String string) {
        String string2 = "";
        for (int i = 0; i < n; ++i) {
            string2 = string2 + '\t';
        }
        string2 = string2 + string;
    }

    public static void prn(String string) {
    }

    public static void prn(int n, String string) {
        String string2 = "";
        for (int i = 0; i < n; ++i) {
            string2 = string2 + '\t';
        }
        string2 = string2 + string;
    }

    public static void printAttrs(int n, String string, Attributes attributes) {
        Command.pr(n, n + ">in <" + string);
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string2 = attributes.getQName(i);
            String string3 = attributes.getValue(i);
            Command.pr(" " + string2 + "=" + string3);
        }
        Command.prn(">");
    }

    private static int initializeStatus(String string) {
        return 0;
    }
}

