/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.PropertyEditor;
import java.util.HashMap;
import java.util.Map;

public class PropertyEditorManager {
    private static String[] path = new String[]{"org.apache.harmony.beans.editors"};
    private static final Map<Class<?>, Class<?>> registeredEditors = new HashMap();

    static Class getDefaultEditorClass(String string) {
        for (String string2 : path) {
            String string3 = string2 + "." + string;
            try {
                Class<?> clazz = Class.forName(string3);
                clazz.asSubclass(PropertyEditor.class);
                return clazz;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public static void registerEditor(Class<?> clazz, Class<?> clazz2) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPropertiesAccess();
        }
        if (clazz2 != null) {
            registeredEditors.put(clazz, clazz2);
        } else {
            registeredEditors.remove(clazz);
        }
    }

    public static synchronized PropertyEditor findEditor(Class<?> clazz) {
        String string;
        if (clazz == null) {
            throw new NullPointerException();
        }
        Class<?> clazz2 = null;
        PropertyEditor propertyEditor = null;
        clazz2 = registeredEditors.get(clazz);
        if (clazz2 != null) {
            try {
                propertyEditor = (PropertyEditor)clazz2.newInstance();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (propertyEditor == null && (propertyEditor = PropertyEditorManager.loadEditor(clazz, string = clazz.getName() + "Editor")) == null) {
            String string2;
            String string3 = string.substring(string.lastIndexOf(".") + 1);
            if (clazz.isPrimitive()) {
                string3 = string3.substring(0, 1).toUpperCase() + string3.substring(1);
            }
            String[] stringArray = path;
            int n = stringArray.length;
            for (int i = 0; i < n && (propertyEditor = PropertyEditorManager.loadEditor(clazz, string = (string2 = stringArray[i]) + "." + string3)) == null; ++i) {
            }
        }
        return propertyEditor;
    }

    private static PropertyEditor loadEditor(Class<?> clazz, String string) {
        Class<?> clazz2 = null;
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader != null) {
            try {
                clazz2 = Class.forName(string, true, classLoader);
                clazz2.asSubclass(PropertyEditor.class);
                return (PropertyEditor)clazz2.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        classLoader = ClassLoader.getSystemClassLoader();
        try {
            clazz2 = Class.forName(string, true, classLoader);
            clazz2.asSubclass(PropertyEditor.class);
            return (PropertyEditor)clazz2.newInstance();
        }
        catch (Exception exception) {
            classLoader = Thread.currentThread().getContextClassLoader();
            try {
                clazz2 = Class.forName(string, true, classLoader);
                clazz2.asSubclass(PropertyEditor.class);
                return (PropertyEditor)clazz2.newInstance();
            }
            catch (Exception exception2) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setEditorSearchPath(String[] stringArray) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPropertiesAccess();
        }
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        Class<PropertyEditorManager> clazz = PropertyEditorManager.class;
        synchronized (PropertyEditorManager.class) {
            path = stringArray;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static synchronized String[] getEditorSearchPath() {
        return (String[])path.clone();
    }

    static {
        registeredEditors.put(Long.TYPE, PropertyEditorManager.getDefaultEditorClass("LongEditor"));
        registeredEditors.put(Boolean.TYPE, PropertyEditorManager.getDefaultEditorClass("BooleanEditor"));
        registeredEditors.put(Short.TYPE, PropertyEditorManager.getDefaultEditorClass("ShortEditor"));
        registeredEditors.put(Float.TYPE, PropertyEditorManager.getDefaultEditorClass("FloatEditor"));
        registeredEditors.put(Double.TYPE, PropertyEditorManager.getDefaultEditorClass("DoubleEditor"));
        registeredEditors.put(Byte.TYPE, PropertyEditorManager.getDefaultEditorClass("ByteEditor"));
        registeredEditors.put(Integer.TYPE, PropertyEditorManager.getDefaultEditorClass("IntEditor"));
    }
}

