/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.asn1;

import java.io.IOException;
import org.apache.harmony.security.asn1.ASN1StringType;
import org.apache.harmony.security.asn1.BerInputStream;
import org.apache.harmony.security.asn1.BerOutputStream;

public class ASN1OctetString
extends ASN1StringType {
    private static final ASN1OctetString ASN1 = new ASN1OctetString();

    public ASN1OctetString() {
        super(4);
    }

    public static ASN1OctetString getInstance() {
        return ASN1;
    }

    @Override
    public Object decode(BerInputStream berInputStream) throws IOException {
        berInputStream.readOctetString();
        if (berInputStream.isVerify) {
            return null;
        }
        return this.getDecodedObject(berInputStream);
    }

    @Override
    public Object getDecodedObject(BerInputStream berInputStream) throws IOException {
        byte[] byArray = new byte[berInputStream.length];
        System.arraycopy(berInputStream.buffer, berInputStream.contentOffset, byArray, 0, berInputStream.length);
        return byArray;
    }

    @Override
    public void encodeContent(BerOutputStream berOutputStream) {
        berOutputStream.encodeOctetString();
    }

    @Override
    public void setEncodingContent(BerOutputStream berOutputStream) {
        berOutputStream.length = ((byte[])berOutputStream.content).length;
    }
}

