/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.asn1;

import java.io.IOException;
import org.apache.harmony.security.asn1.ASN1Constructured;
import org.apache.harmony.security.asn1.ASN1Exception;
import org.apache.harmony.security.asn1.ASN1Type;
import org.apache.harmony.security.asn1.BerInputStream;
import org.apache.harmony.security.asn1.BerOutputStream;
import org.apache.harmony.security.internal.nls.Messages;

public final class ASN1Explicit
extends ASN1Constructured {
    public final ASN1Type type;

    public ASN1Explicit(int n, ASN1Type aSN1Type) {
        this(128, n, aSN1Type);
    }

    public ASN1Explicit(int n, int n2, ASN1Type aSN1Type) {
        super(n, n2);
        this.type = aSN1Type;
    }

    @Override
    public Object decode(BerInputStream berInputStream) throws IOException {
        if (this.constrId != berInputStream.tag) {
            throw new ASN1Exception(Messages.getString("security.13F", new Object[]{berInputStream.tagOffset, Integer.toHexString(this.constrId), Integer.toHexString(berInputStream.tag)}));
        }
        berInputStream.next();
        berInputStream.content = this.type.decode(berInputStream);
        if (berInputStream.isVerify) {
            return null;
        }
        return this.getDecodedObject(berInputStream);
    }

    @Override
    public void encodeContent(BerOutputStream berOutputStream) {
        berOutputStream.encodeExplicit(this);
    }

    @Override
    public void setEncodingContent(BerOutputStream berOutputStream) {
        berOutputStream.getExplicitLength(this);
    }

    @Override
    public String toString() {
        return super.toString() + " for type " + this.type;
    }
}

